/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.dialog;

import java.util.ArrayList;
import org.eclipse.acceleo.internal.ide.ui.dialog.TreeSelectionComposite;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ResourceSelectionDialog
extends SelectionDialog {
    private static final String EMPTY_STRING = "";
    protected Label statusMessage;
    protected ISelectionValidator validator;
    protected TreeSelectionComposite selection;
    private IResource initialSelection;
    private ITreeContentProvider contentProvider;

    public ResourceSelectionDialog(Shell parentShell, IResource initialSelection, String message) {
        super(parentShell);
        this.initialSelection = initialSelection;
        if (message != null) {
            this.setMessage(message);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (ResourceSelectionDialog.this.statusMessage != null && ResourceSelectionDialog.this.validator != null) {
                    String errorMsg = ResourceSelectionDialog.this.validator.isValid((Object)ResourceSelectionDialog.this.selection.getResourceFullPath());
                    if (errorMsg == null || errorMsg.equals(ResourceSelectionDialog.EMPTY_STRING)) {
                        ResourceSelectionDialog.this.statusMessage.setText(ResourceSelectionDialog.EMPTY_STRING);
                        ResourceSelectionDialog.this.getOkButton().setEnabled(true);
                    } else {
                        ResourceSelectionDialog.this.statusMessage.setText(errorMsg);
                        ResourceSelectionDialog.this.getOkButton().setEnabled(false);
                    }
                }
            }
        };
        this.selection = new TreeSelectionComposite(area, this.contentProvider, listener, true, this.getMessage());
        if (this.initialSelection != null) {
            this.selection.setSelectedResource(this.initialSelection);
        }
        this.statusMessage = new Label(area, 64);
        this.statusMessage.setLayoutData((Object)new GridData(768));
        this.statusMessage.setText(" \n ");
        this.statusMessage.setFont(parent.getFont());
        return this.dialogArea;
    }

    protected void okPressed() {
        ArrayList<IPath> chosenResourcePathList = new ArrayList<IPath>();
        IPath returnValue = this.selection.getResourceFullPath();
        if (returnValue != null) {
            chosenResourcePathList.add(returnValue);
        }
        this.setResult(chosenResourcePathList);
        super.okPressed();
    }

    public void setValidator(ISelectionValidator validator) {
        this.validator = validator;
    }

    public void setContentProvider(ITreeContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }
}

