/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.internal.utils;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyEPackageDescriptor
implements EPackage.Descriptor {
    private String name;
    private String nsURI;
    private String nsPrefix;
    private URI resourceURI;
    private List<LazyEPackageDescriptor> subPackages = Lists.newArrayList();
    private Optional<EPackage> alreadyLoaded = Optional.absent();
    private URIConverter converter;
    private EPackage.Registry registryToPopulate;
    private Optional<ResourceSet> setToPopulate;

    LazyEPackageDescriptor(String nsURI, String nsPrefix, String name, URI resourceURI, ResourceSet set, EPackage.Registry registryToPopulate) {
        this.nsURI = nsURI;
        this.name = name;
        this.nsPrefix = nsPrefix;
        this.converter = set.getURIConverter();
        this.resourceURI = this.converter.normalize(resourceURI);
        this.setToPopulate = Optional.of((Object)set);
        this.registryToPopulate = registryToPopulate;
    }

    LazyEPackageDescriptor(EPackage instance, URIConverter converter, EPackage.Registry registryToPopulate) {
        this.nsURI = instance.getNsURI();
        this.nsPrefix = instance.getNsPrefix();
        this.name = instance.getName();
        this.resourceURI = converter.normalize(instance.eResource().getURI());
        this.alreadyLoaded = Optional.of((Object)instance);
        this.converter = converter;
        this.registryToPopulate = registryToPopulate;
    }

    public String getName() {
        return this.name;
    }

    public String getNsURI() {
        return this.nsURI;
    }

    public String getNsPrefix() {
        return this.nsPrefix;
    }

    public void addESubpackage(LazyEPackageDescriptor child) {
        this.subPackages.add(child);
    }

    public URI getResourceURI() {
        return this.resourceURI;
    }

    public List<LazyEPackageDescriptor> getESubpackages() {
        return this.subPackages;
    }

    public EPackage getEPackage() {
        if (this.alreadyLoaded.isPresent()) {
            return (EPackage)this.alreadyLoaded.get();
        }
        EPackage result = null;
        if (this.setToPopulate.isPresent()) {
            Resource res = ((ResourceSet)this.setToPopulate.get()).getResource(this.getResourceURI(), true);
            EcoreUtil.resolveAll((Resource)res);
            if (res.getContents().size() > 0 && res.getContents().get(0) instanceof EPackage) {
                EPackage ePackage = (EPackage)res.getContents().get(0);
                this.alreadyLoaded = Optional.fromNullable((Object)ePackage);
                for (Resource resource : ((ResourceSet)this.setToPopulate.get()).getResources()) {
                    TreeIterator allContents = resource.getAllContents();
                    while (allContents.hasNext()) {
                        EObject next = (EObject)allContents.next();
                        if (!(next instanceof EPackage)) continue;
                        this.registerEcorePackageHierarchy((EPackage)next, this.registryToPopulate);
                    }
                }
                result = ePackage;
            }
        }
        return result;
    }

    private void registerEcorePackageHierarchy(EPackage ePackage, EPackage.Registry registry) {
        if (!(ePackage.getNsURI() == null || "mtl".equals(ePackage.getNsPrefix()) || "mtlnonstdlib".equals(ePackage.getNsPrefix()) || "mtlstdlib".equals(ePackage.getNsPrefix()) || "oclstdlib".equals(ePackage.getNsPrefix()))) {
            registry.put((Object)ePackage.getNsURI(), (Object)ePackage);
        }
        for (EPackage subPackage : ePackage.getESubpackages()) {
            this.registerEcorePackageHierarchy(subPackage, registry);
        }
    }

    public EFactory getEFactory() {
        return this.getEPackage().getEFactoryInstance();
    }

    public static LazyEPackageDescriptor create(EPackage loadedEPackage, EPackage.Registry registry) {
        ExtensibleURIConverterImpl converter = null;
        if (loadedEPackage.eResource() != null && loadedEPackage.eResource().getResourceSet() != null) {
            converter = loadedEPackage.eResource().getResourceSet().getURIConverter();
        }
        if (converter == null) {
            converter = new ExtensibleURIConverterImpl();
        }
        LazyEPackageDescriptor current = new LazyEPackageDescriptor(loadedEPackage, (URIConverter)converter, registry);
        for (EPackage child : loadedEPackage.getESubpackages()) {
            current.addESubpackage(LazyEPackageDescriptor.create(child, registry));
        }
        return current;
    }

    public static LazyEPackageDescriptor create(URI metaURI, ResourceSet set, EPackage.Registry registry) {
        LazyEPackageDescriptor result;
        block14: {
            result = null;
            InputStream is = null;
            try {
                try {
                    is = set.getURIConverter().createInputStream(metaURI, Collections.EMPTY_MAP);
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    InputSource input = new InputSource(is);
                    SAXParser saxParser = factory.newSAXParser();
                    EcoreEPackageSAXHandler lazyEPackageDescriptorSAXHandler = new EcoreEPackageSAXHandler(set, metaURI, registry);
                    saxParser.parse(input, (DefaultHandler)lazyEPackageDescriptorSAXHandler);
                    is.close();
                    result = lazyEPackageDescriptorSAXHandler.getRootDescriptor();
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    private static class EcoreEPackageSAXHandler
    extends DefaultHandler {
        private static final String NAME_ATTR = "name";
        private static final String NS_PREFIX_ATTR = "nsPrefix";
        private static final String NS_URI_ATTR = "nsURI";
        private static final String E_SUBPACKAGES = "eSubpackages";
        private static final String ECORE_E_PACKAGE = "ecore:EPackage";
        private URI resourceURI;
        private LazyEPackageDescriptor rootDescriptor;
        private Stack<LazyEPackageDescriptor> currentDescriptor;
        private ResourceSet set;
        private EPackage.Registry registry;

        public EcoreEPackageSAXHandler(ResourceSet set, URI resourceURI, EPackage.Registry registry) {
            this.set = set;
            this.registry = registry;
            this.resourceURI = resourceURI;
            this.currentDescriptor = new Stack();
        }

        public LazyEPackageDescriptor getRootDescriptor() {
            return this.rootDescriptor;
        }

        public void startElement(String saxURI, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(saxURI, localName, qName, attributes);
            if (ECORE_E_PACKAGE.equals(qName)) {
                String nsURI = attributes.getValue(NS_URI_ATTR);
                String nsPrefix = attributes.getValue(NS_PREFIX_ATTR);
                String name = attributes.getValue(NAME_ATTR);
                LazyEPackageDescriptor newOne = new LazyEPackageDescriptor(nsURI, nsPrefix, name, this.resourceURI, this.set, this.registry);
                if (this.rootDescriptor == null) {
                    this.rootDescriptor = newOne;
                    this.currentDescriptor.push(newOne);
                }
            } else if (E_SUBPACKAGES.equals(qName)) {
                String nsURI = attributes.getValue(NS_URI_ATTR);
                String nsPrefix = attributes.getValue(NS_PREFIX_ATTR);
                String name = attributes.getValue(NAME_ATTR);
                LazyEPackageDescriptor newOne = new LazyEPackageDescriptor(nsURI, nsPrefix, name, this.resourceURI, this.set, this.registry);
                this.currentDescriptor.peek().addESubpackage(newOne);
                this.currentDescriptor.push(newOne);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if (ECORE_E_PACKAGE.equals(qName) && this.currentDescriptor.size() > 0) {
                this.currentDescriptor.pop();
            } else if (E_SUBPACKAGES.equals(qName) && this.currentDescriptor.size() > 0) {
                this.currentDescriptor.pop();
            }
        }
    }
}

