/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.completeocl.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import org.eclipse.acceleo.ui.interpreter.InterpreterPlugin;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.ConstraintElement;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.ConstraintResult;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.EvaluationResultFactory;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.OCLElement;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.OCLResult;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.OperationElement;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.Severity;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationResult;
import org.eclipse.acceleo.ui.interpreter.ocl.AbstractOCLEvaluator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.ConstraintEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteOCLEvaluator
extends AbstractOCLEvaluator {
    private final MetaModelManager metaModelManager;

    public CompleteOCLEvaluator(MetaModelManager metaModelManager) {
        this.metaModelManager = metaModelManager;
    }

    protected MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EvaluationResult evaluateCompleteOCLElement(Element pivotElement, Notifier evaluationTarget) {
        OCLElement oclElement;
        if (pivotElement instanceof Root) {
            oclElement = this.createOCLElement((EObject)pivotElement);
            for (Package pack : ((Root)pivotElement).getNestedPackage()) {
                this.checkCancelled();
                oclElement.getChildren().add((Object)this.evaluateCompleteOCLExpression(pack, null, evaluationTarget));
            }
            return new EvaluationResult((Object)oclElement);
        } else if (pivotElement instanceof Package) {
            oclElement = this.evaluateCompleteOCLExpression((Package)pivotElement, null, evaluationTarget);
            return new EvaluationResult((Object)oclElement);
        } else if (pivotElement instanceof Type) {
            Package packaje = ((Type)pivotElement).getPackage();
            OCLElement packageElement = this.evaluateCompleteOCLExpression(packaje, (Type)pivotElement, evaluationTarget);
            oclElement = (OCLElement)packageElement.getChildren().get(0);
            return new EvaluationResult((Object)oclElement);
        } else if (pivotElement instanceof Constraint) {
            if (!(evaluationTarget instanceof EObject) || !this.checkType((Constraint)pivotElement, (EObject)evaluationTarget)) return new EvaluationResult((IStatus)new Status(1, "org.eclipse.acceleo.ui.interpreter.completeocl", "Cannot evaluate " + pivotElement + " on the selected Notifier."));
            oclElement = EvaluationResultFactory.eINSTANCE.createConstraintElement();
            oclElement.setElement((EObject)pivotElement);
            ConstraintResult result = this.evaluateExpression((Constraint)pivotElement, (EObject)evaluationTarget);
            ((ConstraintElement)oclElement).getConstraintResults().add((Object)result);
            return new EvaluationResult((Object)oclElement);
        } else {
            if (!(pivotElement instanceof Operation)) return new EvaluationResult((IStatus)new Status(4, "org.eclipse.acceleo.ui.interpreter.completeocl", "Unknown error evaluating expression."));
            if (!(evaluationTarget instanceof EObject) || ((Operation)pivotElement).getParameterTypes().get().length != 0 || !this.checkType(((Operation)pivotElement).getOwningType(), (EObject)evaluationTarget)) return new EvaluationResult((IStatus)new Status(1, "org.eclipse.acceleo.ui.interpreter.completeocl", "Cannot evaluate " + pivotElement + " on the selected Notifier."));
            EvaluationResult result = this.evaluateExpression(((Operation)pivotElement).getBodyExpression().getExpressionInOCL(), (EObject)evaluationTarget);
            oclElement = EvaluationResultFactory.eINSTANCE.createOperationElement();
            oclElement.setElement((EObject)pivotElement);
            ((OperationElement)oclElement).getEvaluationResults().add((Object)this.parseOperationResult((EObject)evaluationTarget, result));
        }
        return new EvaluationResult((Object)oclElement);
    }

    private boolean checkType(Constraint constraint, EObject target) {
        Namespace namespace = constraint.getContext();
        return namespace instanceof Type && this.checkType((Type)namespace, target);
    }

    private boolean checkType(Type type, EObject target) {
        Type targetType;
        try {
            targetType = (Type)this.metaModelManager.getPivotOf(Type.class, (EObject)target.eClass());
        }
        catch (ParserException e) {
            InterpreterPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ui.interpreter.completeocl", e.getMessage(), (Throwable)e));
            return false;
        }
        return this.metaModelManager.conformsTo(targetType, type, null);
    }

    private Map<Type, Set<Type>> getRelatedTypes(Package packaje) {
        LinkedHashMap<Type, Set<Type>> types = new LinkedHashMap<Type, Set<Type>>();
        for (Type type : packaje.getOwnedType()) {
            Type key = this.metaModelManager.getTypeServer((DomainType)type).getPivotType();
            LinkedHashSet<Type> relatedTypes = (LinkedHashSet<Type>)types.get(key);
            if (relatedTypes == null) {
                relatedTypes = new LinkedHashSet<Type>();
                types.put(key, relatedTypes);
            }
            relatedTypes.add(type);
        }
        return types;
    }

    private Map<Type, Set<Type>> getRelatedTypes(Type type) {
        Package packaje = type.getPackage();
        if (packaje == null) {
            return Collections.singletonMap(type, Collections.singleton(type));
        }
        Type key = this.metaModelManager.getTypeServer((DomainType)type).getPivotType();
        LinkedHashMap<Type, Set<Type>> types = new LinkedHashMap<Type, Set<Type>>();
        for (Type candidate : packaje.getOwnedType()) {
            Type candidateKey = this.metaModelManager.getTypeServer((DomainType)candidate).getPivotType();
            if (key != candidateKey) continue;
            LinkedHashSet<Type> relatedTypes = (LinkedHashSet<Type>)types.get(key);
            if (relatedTypes == null) {
                relatedTypes = new LinkedHashSet<Type>();
                types.put(key, relatedTypes);
            }
            relatedTypes.add(candidate);
        }
        return types;
    }

    private OCLElement evaluateCompleteOCLExpression(Package compiledExpression, Type type, Notifier evaluationTarget) {
        OCLElement oclElement = this.createOCLElement((EObject)compiledExpression);
        Map<Type, Set<Type>> types = type != null ? this.getRelatedTypes(type) : this.getRelatedTypes(compiledExpression);
        this.checkCancelled();
        Iterable<Object> candidates = evaluationTarget instanceof EObject ? Collections.singleton((EObject)evaluationTarget) : (evaluationTarget instanceof Resource ? new AllContentsIterable((Resource)evaluationTarget) : Collections.emptyList());
        for (Map.Entry<Type, Set<Type>> entry : types.entrySet()) {
            this.checkCancelled();
            oclElement.getChildren().add((Object)this.checkTypeAndEvaluate(entry, candidates));
        }
        return oclElement;
    }

    private OCLElement checkTypeAndEvaluate(Map.Entry<Type, Set<Type>> relatedTypes, Iterable<EObject> targetCandidates) {
        OCLElement typeElement = this.createOCLElement((EObject)relatedTypes.getKey());
        ArrayList<EObject> conformingTargets = new ArrayList<EObject>();
        for (EObject candidate : targetCandidates) {
            this.checkCancelled();
            if (!this.checkType(relatedTypes.getKey(), candidate)) continue;
            conformingTargets.add(candidate);
        }
        typeElement.getChildren().addAll(this.evaluateCompleteOCLExpression(relatedTypes, conformingTargets));
        return typeElement;
    }

    private OCLElement createOCLElement(EObject expression) {
        OCLElement element = EvaluationResultFactory.eINSTANCE.createOCLElement();
        element.setElement(expression);
        return element;
    }

    private List<OCLElement> evaluateCompleteOCLExpression(Map.Entry<Type, Set<Type>> relatedTypes, List<EObject> conformTargets) {
        ArrayList<OCLElement> childrenResult = new ArrayList<OCLElement>();
        for (Type type : relatedTypes.getValue()) {
            ArrayList<OCLResult> results;
            this.checkCancelled();
            for (Constraint constraint : type.getOwnedInvariant()) {
                this.checkCancelled();
                results = new ArrayList<OCLResult>(conformTargets.size());
                for (EObject target : conformTargets) {
                    results.add(this.evaluateExpression(constraint, target));
                }
                if (results.isEmpty()) continue;
                ConstraintElement constraintElement = EvaluationResultFactory.eINSTANCE.createConstraintElement();
                constraintElement.setElement((EObject)constraint);
                constraintElement.getConstraintResults().addAll(results);
                childrenResult.add(constraintElement);
            }
            for (Operation operation : type.getOwnedOperation()) {
                this.checkCancelled();
                if (operation.getParameterTypes().get().length != 0) continue;
                results = new ArrayList(conformTargets.size());
                for (EObject target : conformTargets) {
                    EvaluationResult childResult = this.evaluateExpression(operation.getBodyExpression().getExpressionInOCL(), target);
                    results.add(this.parseOperationResult(target, childResult));
                }
                if (results.isEmpty()) continue;
                OperationElement operationElement = EvaluationResultFactory.eINSTANCE.createOperationElement();
                operationElement.setElement((EObject)operation);
                operationElement.getEvaluationResults().addAll(results);
                childrenResult.add(operationElement);
            }
        }
        return childrenResult;
    }

    private ConstraintResult evaluateExpression(Constraint constraint, EObject evaluationTarget) {
        ExpressionInOCL expressionInOCL = constraint.getSpecification().getExpressionInOCL();
        OCLExpression expression = CompleteOCLEvaluator.getConstraintExpression(expressionInOCL);
        EvaluationResult result = this.internalEvaluateExpression(expression, evaluationTarget);
        return new OCLConstraintParser(expressionInOCL).parse(evaluationTarget, result);
    }

    private OCLResult parseOperationResult(EObject evaluationTarget, EvaluationResult result) {
        OCLResult operationResult = EvaluationResultFactory.eINSTANCE.createOCLResult();
        operationResult.setEvaluationTarget(evaluationTarget);
        operationResult.setInterpreterResult(result);
        return operationResult;
    }

    private void checkCancelled() {
        if (Thread.currentThread().isInterrupted()) {
            throw new CancellationException();
        }
    }

    private static OCLExpression getConstraintExpression(ExpressionInOCL constraintSpecification) {
        Property referredProperty;
        OCLExpression body = constraintSpecification.getBodyExpression();
        if (body instanceof PropertyCallExp && (referredProperty = ((PropertyCallExp)body).getReferredProperty()) != null && referredProperty.getOwningType() instanceof TupleType && "status".equals(referredProperty.getName())) {
            return ((PropertyCallExp)body).getSource();
        }
        return body;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AllContentsIterable
    implements Iterable<EObject> {
        private Resource resource;

        public AllContentsIterable(Resource resource) {
            this.resource = resource;
        }

        @Override
        public Iterator<EObject> iterator() {
            return this.resource.getAllContents();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OCLConstraintParser
    extends ConstraintEvaluator<ConstraintResult> {
        public OCLConstraintParser(ExpressionInOCL expression) {
            super(expression);
        }

        public ConstraintResult parse(EObject evaluationTarget, EvaluationResult result) {
            ConstraintResult constraintResult = EvaluationResultFactory.eINSTANCE.createConstraintResult();
            constraintResult.setEvaluationTarget(evaluationTarget);
            Object evaluationResult = result.getEvaluationResult();
            if (evaluationResult instanceof Value) {
                constraintResult.setInterpreterResult(new EvaluationResult(CompleteOCLEvaluator.this.unwrap((Value)evaluationResult)));
            } else {
                constraintResult.setInterpreterResult(result);
            }
            if (this.getConstraintResultStatus(evaluationResult)) {
                constraintResult.setSeverity(Severity.OK);
            } else {
                switch (this.getConstraintResultSeverity(evaluationResult)) {
                    case 1: {
                        constraintResult.setSeverity(Severity.INFO);
                        break;
                    }
                    case 2: {
                        constraintResult.setSeverity(Severity.WARNING);
                        break;
                    }
                    case 4: {
                        constraintResult.setSeverity(Severity.ERROR);
                        break;
                    }
                    default: {
                        constraintResult.setSeverity(Severity.ERROR);
                    }
                }
                constraintResult.setMessage(this.getConstraintResultMessage(evaluationResult));
            }
            return constraintResult;
        }

        protected String getObjectLabel() {
            return null;
        }

        protected ConstraintResult handleExceptionResult(Exception e) {
            return null;
        }

        protected ConstraintResult handleFailureResult(Object result) {
            return null;
        }

        protected ConstraintResult handleInvalidResult(InvalidValueException e) {
            return null;
        }

        protected ConstraintResult handleSuccessResult() {
            return null;
        }
    }
}

