/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.completeocl.internal.action;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.acceleo.ui.interpreter.completeocl.IEvaluationExporter;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.OCLElement;
import org.eclipse.acceleo.ui.interpreter.completeocl.internal.CompleteOCLEvaluator;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationResult;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;

public class ExportCompleteOCLEvaluationResultAction
extends Action {
    private final XtextResource resource;
    private final Resource target;
    private final MetaModelManager metaModelManager;

    public ExportCompleteOCLEvaluationResultAction(XtextResource resource, Resource target, MetaModelManager metaModelManager) {
        super("Export Evaluation Result", 1);
        this.setToolTipText("Evaluate the current compilation result against the currently selected resource");
        this.resource = resource;
        this.target = target;
        this.metaModelManager = metaModelManager;
    }

    public void run() {
        FileDialog fileDialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
        String selectedPath = fileDialog.open();
        if (selectedPath != null) {
            Element pivotElement;
            IEvaluationExporter exporter = new IEvaluationExporter(){

                public void export(String outputPath, OCLElement resultRoot) {
                    XMIResourceImpl res = new XMIResourceImpl(URI.createFileURI((String)outputPath));
                    res.getContents().add((Object)resultRoot);
                    try {
                        res.save(new HashMap());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            IParseResult parseResult = this.resource.getParseResult();
            EvaluationResult evalutionResult = null;
            if (parseResult != null && parseResult.getRootASTElement() instanceof Pivotable && (pivotElement = ((Pivotable)parseResult.getRootASTElement()).getPivot()) instanceof Root) {
                evalutionResult = new CompleteOCLEvaluator(this.metaModelManager).evaluateCompleteOCLElement(pivotElement, (Notifier)this.target);
            }
            if (evalutionResult != null && (evalutionResult.getStatus() == null || evalutionResult.getStatus().isOK()) && evalutionResult.getEvaluationResult() instanceof OCLElement) {
                exporter.export(selectedPath, (OCLElement)evalutionResult.getEvaluationResult());
            }
        }
    }

    public boolean isEnabled() {
        return this.resource != null && !this.resource.getParseResult().hasSyntaxErrors() && this.target != null;
    }
}

