/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.equinox.internal;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.acceleo.equinox.internal.AcceleoEquinoxLauncherPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class WorkspaceHandler {
    private static final String DOT_PROJECT = ".project";

    public void clearWorkspace(Monitor monitor) {
        IWorkspaceRoot root = EcorePlugin.getWorkspaceRoot();
        if (root != null) {
            IProject[] iProjectArray = root.getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject prj = iProjectArray[n2];
                try {
                    prj.delete(false, true, BasicMonitor.toIProgressMonitor((Monitor)monitor));
                }
                catch (CoreException e) {
                    AcceleoEquinoxLauncherPlugin.INSTANCE.log((Object)e);
                }
                ++n2;
            }
        }
    }

    public void importProjectsInWorkspace(String rootFolder, Monitor monitor) {
        File folder = new File(rootFolder);
        if (!this.hasProjectDescriptor(folder)) {
            File[] children = folder.listFiles();
            if (children != null) {
                this.recursiveImport(children, monitor);
            }
        } else {
            this.importExistingProject(folder, monitor);
        }
    }

    private void recursiveImport(File[] children, Monitor monitor) {
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (this.hasProjectDescriptor(child)) {
                this.importExistingProject(child, monitor);
            } else if (child.listFiles() != null) {
                this.recursiveImport(child.listFiles(), monitor);
            }
            ++n2;
        }
    }

    private void importExistingProject(File folder, Monitor monitor) {
        IWorkspaceRoot root = EcorePlugin.getWorkspaceRoot();
        if (root != null) {
            try {
                Path projectDescriptionFile = new Path(String.valueOf(folder.getAbsolutePath()) + "/.project");
                monitor.subTask("Importing project based on file : " + projectDescriptionFile.toOSString());
                IProjectDescription desc = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)projectDescriptionFile);
                IProject prj = root.getProject(desc.getName());
                prj.create(desc, BasicMonitor.toIProgressMonitor((Monitor)monitor));
                prj.open(BasicMonitor.toIProgressMonitor((Monitor)monitor));
            }
            catch (CoreException e) {
                AcceleoEquinoxLauncherPlugin.INSTANCE.log((Object)e);
            }
        }
    }

    private boolean hasProjectDescriptor(File folder) {
        String[] projectDescriptorFile = folder.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return WorkspaceHandler.DOT_PROJECT.equals(name);
            }
        });
        return projectDescriptorFile != null && projectDescriptorFile.length > 0;
    }
}

