/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.completeocl.internal;

import java.util.Iterator;
import java.util.concurrent.Callable;
import org.eclipse.acceleo.ui.interpreter.completeocl.internal.CompleteOCLCompilationTask;
import org.eclipse.acceleo.ui.interpreter.completeocl.internal.CompleteOCLEvaluationTask;
import org.eclipse.acceleo.ui.interpreter.completeocl.internal.CompleteOCLExpressionSplittingTask;
import org.eclipse.acceleo.ui.interpreter.completeocl.internal.action.HTMLExportCompleteOCLEvaluationResultAction;
import org.eclipse.acceleo.ui.interpreter.completeocl.internal.action.ImportCompleteOCLResourceAction;
import org.eclipse.acceleo.ui.interpreter.completeocl.internal.action.ModelExportCompleteOCLEvaluationResultAction;
import org.eclipse.acceleo.ui.interpreter.language.AbstractLanguageInterpreter;
import org.eclipse.acceleo.ui.interpreter.language.CompilationResult;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationContext;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationResult;
import org.eclipse.acceleo.ui.interpreter.language.InterpreterContext;
import org.eclipse.acceleo.ui.interpreter.language.SplitExpression;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.ocl.examples.xtext.console.xtfo.EmbeddedXtextEditor;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.xtext.completeocl.ui.internal.CompleteOCLActivator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;

public class CompleteOCLInterpreter
extends AbstractLanguageInterpreter {
    protected EmbeddedXtextEditor editor;
    protected Resource lastTargetResource;

    public Callable<CompilationResult> getCompilationTask(InterpreterContext context) {
        return new CompleteOCLCompilationTask(context, this.editor);
    }

    public Callable<EvaluationResult> getEvaluationTask(EvaluationContext context) {
        this.lastTargetResource = this.findTargetResource(context);
        return new CompleteOCLEvaluationTask(context, this.editor.getEnvironmentFactory());
    }

    public Callable<SplitExpression> getExpressionSplittingTask(EvaluationContext context) {
        return new CompleteOCLExpressionSplittingTask(context, this.editor.getEnvironmentFactory());
    }

    public SourceViewer createSourceViewer(Composite parent) {
        this.editor = new EmbeddedXtextEditor(parent, CompleteOCLActivator.getInstance().getInjector("org.eclipse.ocl.xtext.completeocl.CompleteOCL"), 2816);
        XtextSourceViewer viewer = this.editor.getViewer();
        this.addLoadResourceActionToMenu((TextViewer)viewer);
        viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CompleteOCLInterpreter.this.editor.getResource().unload();
                CompleteOCLInterpreter.this.editor = null;
            }
        });
        return viewer;
    }

    private void addLoadResourceActionToMenu(TextViewer viewer) {
        MenuManager manager;
        Menu menu = viewer.getTextWidget().getMenu();
        boolean createMenu = true;
        if (menu != null && (manager = (MenuManager)menu.getData("org.eclipse.jface.action.MenuManager.managerKey")) != null) {
            manager.addMenuListener(this.createExpressionMenuListener(viewer));
            createMenu = false;
        }
        if (createMenu) {
            MenuManager menuManager = new MenuManager(null);
            menuManager.setRemoveAllWhenShown(true);
            menuManager.addMenuListener(this.createExpressionMenuListener(viewer));
            menu = menuManager.createContextMenu((Control)viewer.getTextWidget());
            viewer.getTextWidget().setMenu(menu);
        }
    }

    private IMenuListener createExpressionMenuListener(final TextViewer viewer) {
        return new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new ImportCompleteOCLResourceAction(viewer));
                OCL ocl = CompleteOCLInterpreter.this.editor.getOCL();
                MenuManager submenuManager = new MenuManager("Export Evaluation Result");
                submenuManager.add((IAction)new HTMLExportCompleteOCLEvaluationResultAction(CompleteOCLInterpreter.this.editor.getResource(), CompleteOCLInterpreter.this.lastTargetResource, ocl));
                submenuManager.add((IAction)new ModelExportCompleteOCLEvaluationResultAction(CompleteOCLInterpreter.this.editor.getResource(), CompleteOCLInterpreter.this.lastTargetResource, ocl));
                manager.add((IContributionItem)submenuManager);
            }
        };
    }

    private Resource findTargetResource(EvaluationContext context) {
        Resource target = null;
        Iterator notifiers = context.getTargetNotifiers().iterator();
        while (notifiers.hasNext() && target == null) {
            Notifier next = (Notifier)notifiers.next();
            if (next instanceof EObject) {
                target = ((EObject)next).eResource();
                continue;
            }
            if (!(next instanceof Resource)) continue;
            target = (Resource)next;
        }
        return target;
    }
}

