/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.builders.runner;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.common.internal.utils.AcceleoPackageRegistry;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoPackage;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleowizardmodelFactory;
import org.eclipse.acceleo.internal.ide.ui.builders.AcceleoMarkerUtils;
import org.eclipse.acceleo.internal.ide.ui.generators.AcceleoUIGenerator;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.MtlPackage;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.TypedModel;
import org.eclipse.acceleo.model.mtl.resource.AcceleoResourceSetImpl;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.expressions.ExpressionsPackage;

public class CreateRunnableAcceleoOperation
implements IWorkspaceRunnable {
    private AcceleoProject acceleoProject;
    private List<IFile> files;

    public CreateRunnableAcceleoOperation(AcceleoProject acceleoProject, List<IFile> files) {
        this.acceleoProject = acceleoProject;
        this.files = files;
    }

    /*
     * Unable to fully structure code
     */
    public void run(IProgressMonitor monitor) throws CoreException {
        block14: {
            try {
                filesIt = this.files.iterator();
                if (!filesIt.hasNext()) break block14;
                resolvedClasspath = new ArrayList<String>();
                entries = this.acceleoProject.getResolvedClasspath().iterator();
                eclipseWorkspace = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                eclipseHome = new Path(Platform.getInstallLocation().getURL().getPath());
                while (entries.hasNext()) {
                    path = entries.next();
                    if (eclipseWorkspace.isPrefixOf(path)) {
                        resolvedClasspath.add("${ECLIPSE_WORKSPACE}/" + path.toString().substring(eclipseWorkspace.toString().length()));
                        continue;
                    }
                    if (!eclipseHome.isPrefixOf(path)) continue;
                    resolvedClasspath.add("${ECLIPSE_HOME}/" + path.toString().substring(eclipseHome.toString().length()));
                }
                while (filesIt.hasNext()) {
                    fileAcceleo = filesIt.next();
                    packageName = this.acceleoProject.getPackageName(fileAcceleo);
                    manifest = fileAcceleo.getProject().getFile("/META-INF/MANIFEST.MF");
                    if (manifest.exists() && FileContent.getFileContent((File)manifest.getLocation().toFile()).indexOf(packageName) == -1) {
                        AcceleoMarkerUtils.createMarkerOnFile("org.eclipse.acceleo.ide.ui.problem", fileAcceleo, 0, 0, 0, AcceleoUIMessages.getString("CreateRunnableAcceleoOperation.MissingExport", new Object[]{packageName}));
                    }
                    moduleURI = URI.createPlatformResourceURI((String)this.acceleoProject.getOutputFilePath(fileAcceleo).toString(), (boolean)true);
                    resourceSet = new AcceleoResourceSetImpl();
                    resourceSet.setPackageRegistry((EPackage.Registry)AcceleoPackageRegistry.INSTANCE);
                    try {
                        this.registerPackages((ResourceSet)resourceSet);
                        packages = new ArrayList<AcceleoPackage>();
                        module = ModelUtils.load((URI)moduleURI, (ResourceSet)resourceSet);
                        if (module instanceof Module) {
                            typedModelIt = ((Module)module).getInput().iterator();
                            while (typedModelIt.hasNext()) {
                                for (EPackage ePackage : ((TypedModel)typedModelIt.next()).getTakesTypesFrom()) {
                                    mClass = this.getMetamodelPackageClass(ePackage);
                                    if (mClass == null || ePackage.eResource() == null) continue;
                                    acceleoPackage = AcceleowizardmodelFactory.eINSTANCE.createAcceleoPackage();
                                    acceleoPackage.setClass(mClass);
                                    acceleoPackage.setPath(ePackage.eResource().getURI().toString());
                                    packages.add(acceleoPackage);
                                }
                            }
                        }
                        classShortName = new Path(String.valueOf(Character.toUpperCase(fileAcceleo.getName().charAt(0))) + fileAcceleo.getName().substring(1)).removeFileExtension().lastSegment();
                        mainTemplateNames = new ArrayList<String>();
                        this.computesMainTemplateNames(mainTemplateNames, module);
                        if (mainTemplateNames.size() <= 0) ** break block15
                        acceleoMainClass = AcceleowizardmodelFactory.eINSTANCE.createAcceleoMainClass();
                        acceleoMainClass.setBasePackage(packageName);
                        acceleoMainClass.setClassShortName(classShortName);
                        moduleFilePath = this.computeRelativeModuleFilePath(fileAcceleo);
                        moduleFileShortName = moduleFilePath.removeFileExtension().toString();
                        acceleoMainClass.setModuleFileShortName(moduleFileShortName);
                        acceleoMainClass.setProjectName(fileAcceleo.getProject().getName());
                        packagesList = acceleoMainClass.getPackages();
                        packagesList.addAll(packages);
                        classPath = acceleoMainClass.getResolvedClassPath();
                        classPath.addAll(resolvedClasspath);
                        templateNames = acceleoMainClass.getTemplateNames();
                        templateNames.addAll(mainTemplateNames);
                        AcceleoUIGenerator.getDefault().generateJavaClass(acceleoMainClass, fileAcceleo.getParent());
                        antFolder = fileAcceleo.getProject().getFolder("tasks");
                        antFile = antFolder.getFile(String.valueOf(acceleoMainClass.getModuleFileShortName()) + ".xml");
                        if (!antFolder.exists()) break block16;
                        if (!antFile.exists()) {
                            workspacePathRelativeToFile = CreateRunnableAcceleoOperation.computeWorkspacePath();
                            eclipsePathRelativeToFile = CreateRunnableAcceleoOperation.computeEclipsePath();
                            moduleFileShortName = moduleFilePath.removeFileExtension().lastSegment().toString();
                            acceleoMainClass.setModuleFileShortName(moduleFileShortName);
                            AcceleoUIGenerator.getDefault().generateAntFiles(acceleoMainClass, AcceleoProject.makeRelativeTo(eclipsePathRelativeToFile, antFolder.getLocation()).toString(), AcceleoProject.makeRelativeTo(workspacePathRelativeToFile, antFolder.getLocation()).toString(), (IContainer)antFolder);
                        }
                        break block17;
                    }
                    finally {
                        resources = resourceSet.getResources().iterator();
                        if (true) ** GOTO lbl87
                    }
                    {
                        block17: {
                            block16: {
                            }
                        }
                    }
                    do {
                        ((Resource)resources.next()).unload();
lbl87:
                        // 2 sources

                    } while (resources.hasNext());
                }
            }
            catch (IOException e) {
                AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
            }
        }
    }

    private IPath computeRelativeModuleFilePath(IFile file) {
        IPath fullPath;
        Object moduleFilePath = fullPath = file.getFullPath();
        AcceleoProject project = new AcceleoProject(file.getProject());
        List<IPath> sourceFolders = project.getSourceFolders();
        for (IPath sourceFolderPath : sourceFolders) {
            if (!sourceFolderPath.isPrefixOf(fullPath)) continue;
            moduleFilePath = AcceleoProject.makeRelativeTo(fullPath, sourceFolderPath);
        }
        moduleFilePath = moduleFilePath.equals((Object)file.getFullPath()) ? new Path(moduleFilePath.lastSegment()) : new Path("").addTrailingSeparator().append(moduleFilePath);
        return moduleFilePath;
    }

    public static IPath computeWorkspacePath() {
        return new Path(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
    }

    public static IPath computeEclipsePath() {
        URL fileURL = Platform.getInstallLocation().getURL();
        try {
            String filepath = FileLocator.toFileURL((URL)fileURL).getFile();
            File file = new File(filepath);
            return new Path(file.getAbsolutePath().toString());
        }
        catch (IOException e) {
            AcceleoUIActivator.log(e, true);
            return null;
        }
    }

    private void registerPackages(ResourceSet resourceSet) {
        resourceSet.getPackageRegistry().put((Object)EcorePackage.eINSTANCE.getNsURI(), (Object)EcorePackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)ExpressionsPackage.eINSTANCE.getNsURI(), (Object)ExpressionsPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)MtlPackage.eINSTANCE.getNsURI(), (Object)MtlPackage.eINSTANCE);
    }

    private String getMetamodelPackageClass(EPackage metamodel) {
        if (!EPackage.class.getName().equals(metamodel.getClass().getName()) && !EPackageImpl.class.getName().equals(metamodel.getClass().getName())) {
            String name = metamodel.getClass().getName();
            if (metamodel.getClass().getInterfaces().length > 1) {
                Class<?>[] classArray = metamodel.getClass().getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> clazz = classArray[n2];
                    if (metamodel.getClass().getSimpleName().equals(String.valueOf(clazz.getSimpleName()) + "Impl")) {
                        name = clazz.getName();
                        break;
                    }
                    ++n2;
                }
            } else if (metamodel.getClass().getInterfaces().length == 1 && metamodel.getClass().getSimpleName().startsWith(metamodel.getClass().getInterfaces()[0].getSimpleName())) {
                name = metamodel.getClass().getInterfaces()[0].getName();
            }
            return name;
        }
        return null;
    }

    private void computesMainTemplateNames(List<String> mainTemplateNames, EObject eObject) {
        if (eObject instanceof Template) {
            Template eTemplate = (Template)eObject;
            if (eTemplate.isMain() && !mainTemplateNames.contains(eTemplate.getName())) {
                mainTemplateNames.add(eTemplate.getName());
            }
        } else if (eObject != null) {
            for (EObject eContent : eObject.eContents()) {
                this.computesMainTemplateNames(mainTemplateNames, eContent);
            }
        }
    }
}

