/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename;

import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.AbstractRefactoringAction;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.AcceleoRefactoringUtils;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoPositionedQuery;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoPositionedTemplate;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoPositionedVariable;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameModuleRefactoring;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameModuleWizard;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameQueryRefactoring;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameQueryWizard;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameTemplateRefactoring;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameTemplateWizard;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameTextRefactoring;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameTextWizard;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameVariableRefactoring;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameVariableWizard;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.OpenDeclarationUtils;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ocl.ecore.LiteralExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;

public class AcceleoRenameAction
extends AbstractRefactoringAction {
    public AcceleoRenameAction() {
        super(false);
    }

    @Override
    protected void launchRefactoring() {
        this.name = AcceleoUIMessages.getString("AcceleoEditorRenameRefactoring.RefactoringTitle");
        if (this.fWindow != null && AcceleoRefactoringUtils.allResourceSaved() && !this.editor.isDirty()) {
            EObject object = OpenDeclarationUtils.findResolvedDeclaration(this.editor);
            if (object instanceof Template) {
                this.launchRefactoringRenameTemplate((Template)object);
            } else if (object instanceof Query) {
                this.launchRefactoringRenameQuery((Query)object);
            } else if (object instanceof Variable) {
                this.launchRefactoringRenameVariable((Variable)object);
            } else if (object instanceof VariableExp) {
                this.launchRefactoringRenameVariable((VariableExp)object);
            } else if (object instanceof Module) {
                this.launchRefactoringRenameModule((Module)object);
            } else {
                ISelection iSelection = this.editor.getSelectionProvider().getSelection();
                if (iSelection instanceof ITextSelection && ((ITextSelection)iSelection).getLength() > 0) {
                    this.launchRefactorRenameTextOccurrences((ITextSelection)iSelection);
                } else {
                    this.launchRefactorRenameTemplate();
                }
            }
        }
    }

    private void launchRefactorRenameTemplate() {
        this.launchRefactoringRenameTemplate(null);
    }

    private void launchRefactoringRenameTemplate(Template template) {
        AcceleoRenameTemplateRefactoring refactoring = new AcceleoRenameTemplateRefactoring();
        refactoring.setFileName(this.editor.getFile().getName());
        AcceleoPositionedTemplate.setAcceleoEditor(this.editor);
        AcceleoPositionedTemplate.computePartialInput(template);
        AcceleoPositionedTemplate[] array = AcceleoPositionedTemplate.getInput();
        if (array.length > 0) {
            refactoring.setTemplate(array[0]);
            if (template != null) {
                AcceleoPositionedTemplate[] acceleoPositionedTemplateArray = array;
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    AcceleoPositionedTemplate acceleoPositionedTemplate = acceleoPositionedTemplateArray[n2];
                    if (template.getName().equals(acceleoPositionedTemplate.getTemplateName()) && this.checkEquals((EList<Variable>)template.getParameter(), (EList<Variable>)acceleoPositionedTemplate.getTemplate().getParameter())) {
                        refactoring.setTemplate(acceleoPositionedTemplate);
                    }
                    ++n2;
                }
            }
            this.runWizard(new AcceleoRenameTemplateWizard(refactoring, this.name), this.fWindow.getShell(), this.name);
        }
    }

    private void launchRefactoringRenameQuery(Query query) {
        AcceleoRenameQueryRefactoring refactoring = new AcceleoRenameQueryRefactoring();
        refactoring.setFileName(this.editor.getFile().getName());
        AcceleoPositionedQuery.setAcceleoEditor(this.editor);
        AcceleoPositionedQuery.computePartialInput(query);
        AcceleoPositionedQuery[] array = AcceleoPositionedQuery.getInput();
        if (array.length > 0) {
            refactoring.setQuery(array[0]);
            AcceleoPositionedQuery[] acceleoPositionedQueryArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                AcceleoPositionedQuery acceleoPositionedQuery = acceleoPositionedQueryArray[n2];
                if (query.getName().equals(acceleoPositionedQuery.getQueryName()) && this.checkEquals((EList<Variable>)query.getParameter(), (EList<Variable>)acceleoPositionedQuery.getQuery().getParameter())) {
                    refactoring.setQuery(acceleoPositionedQuery);
                }
                ++n2;
            }
            this.runWizard(new AcceleoRenameQueryWizard(refactoring, this.name), this.fWindow.getShell(), this.name);
        }
    }

    private void launchRefactoringRenameVariable(Variable variable) {
        AcceleoRenameVariableRefactoring refactoring = new AcceleoRenameVariableRefactoring();
        refactoring.setFileName(this.editor.getFile().getName());
        AcceleoPositionedVariable apv = new AcceleoPositionedVariable(variable, this.editor);
        refactoring.setVariable(apv);
        this.runWizard(new AcceleoRenameVariableWizard(refactoring, this.name), this.fWindow.getShell(), this.name);
    }

    private void launchRefactoringRenameVariable(VariableExp variable) {
        AcceleoRenameVariableRefactoring refactoring = new AcceleoRenameVariableRefactoring();
        AcceleoPositionedVariable apv = new AcceleoPositionedVariable(variable, this.editor);
        refactoring.setVariable(apv);
        this.runWizard(new AcceleoRenameVariableWizard(refactoring, this.name), this.fWindow.getShell(), this.name);
    }

    private boolean checkEquals(EList<Variable> paramList1, EList<Variable> paramList2) {
        boolean result = true;
        if (paramList1.size() == paramList2.size()) {
            int i = 0;
            while (i < paramList1.size()) {
                Variable var1 = (Variable)paramList1.get(i);
                Variable var2 = (Variable)paramList2.get(i);
                if (var1.getName().equals(var2.getName())) {
                    if (var1.getType() != null && var2.getType() != null && !((EClassifier)var1.getType()).getName().equals(((EClassifier)var2.getType()).getName())) {
                        result = false;
                        break;
                    }
                } else {
                    result = false;
                    break;
                }
                ++i;
            }
        } else {
            result = false;
        }
        return result;
    }

    private void launchRefactoringRenameModule(Module module) {
        IFile file = this.editor.getFile();
        if (file == null || !file.exists()) {
            return;
        }
        IFile javaFile = AcceleoRefactoringUtils.getJavaFileFromModuleFile(this.editor.getFile().getProject(), file);
        if (javaFile != null && javaFile.exists()) {
            try {
                IMarker[] markers = javaFile.findMarkers("org.eclipse.jdt.core.problem", true, 2);
                if (markers.length > 0) {
                    MessageBox box = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                    box.setMessage(AcceleoUIMessages.getString("AcceleoEditorRenameRefactoring.ErrorInFile", javaFile.getName()));
                    box.open();
                    return;
                }
            }
            catch (CoreException e) {
                AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
            }
        }
        AcceleoRenameModuleRefactoring refactoring = new AcceleoRenameModuleRefactoring();
        refactoring.setModule(module);
        refactoring.setFile(file);
        refactoring.setProject(file.getProject());
        this.runWizard(new AcceleoRenameModuleWizard(refactoring, this.name), this.fWindow.getShell(), this.name);
    }

    private void launchRefactorRenameTextOccurrences(ITextSelection selection) {
        ASTNode astNode = this.editor.getContent().getASTNode(selection.getOffset() + selection.getLength(), selection.getOffset() + selection.getLength());
        if (selection.getLength() > 0 && astNode instanceof LiteralExp) {
            Template template = (Template)this.editor.getContent().getASTParent(astNode, Template.class);
            IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
            String text = document.get();
            if (template != null && template.getEndPosition() > -1 && template.getEndPosition() <= text.length()) {
                AcceleoRenameTextRefactoring refactoring = new AcceleoRenameTextRefactoring();
                refactoring.setParent((ModuleElement)template);
                refactoring.setSourceContent(this.editor.getContent());
                refactoring.setSelection(selection);
                this.runWizard(new AcceleoRenameTextWizard(refactoring, this.name), this.fWindow.getShell(), this.name);
            }
        }
    }
}

