/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.newfile.main;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.utils.CompactHashSet;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.main.FileBlocksContentProvider;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.main.FileBlocksLabelProvider;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.main.FileBlocksProjectHandler;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBlocksWizardPage
extends WizardPage
implements IEditingDomainProvider {
    private AdapterFactoryEditingDomain editingDomain;
    private ComposedAdapterFactory adapterFactory;
    private CheckboxTreeViewer templatesViewer;
    private Set<ResourceSet> toUnload = new CompactHashSet();
    private IProject project;
    private boolean browseNotAccessibleTemplates;

    public FileBlocksWizardPage(IProject project, boolean browseNotAccessibleTemplates) {
        super(AcceleoUIMessages.getString("FileBlocksWizardPage.Name"));
        this.setTitle(AcceleoUIMessages.getString("FileBlocksWizardPage.Title1"));
        this.setDescription(AcceleoUIMessages.getString("FileBlocksWizardPage.Description"));
        this.setImageDescriptor(AcceleoUIActivator.getImageDescriptor("icons/AcceleoWizard.gif"));
        this.project = project;
        this.browseNotAccessibleTemplates = browseNotAccessibleTemplates;
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(factories);
        BasicCommandStack commandStack = new BasicCommandStack();
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void createControl(Composite parent) {
        Composite rootContainer = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        gridData.verticalIndent = 1;
        rootContainer.setLayoutData((Object)gridData);
        GridLayout rootContainerLayout = new GridLayout();
        rootContainer.setLayout((Layout)rootContainerLayout);
        this.createFileTemplatesViewer(rootContainer);
        this.setControl((Control)rootContainer);
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                FileBlocksWizardPage.this.update(monitor);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(create, null);
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
        }
    }

    private void createFileTemplatesViewer(Composite parent) {
        GridData data = new GridData(1808);
        data.heightHint = 100;
        this.templatesViewer = new CheckboxTreeViewer(parent, 2048);
        this.templatesViewer.getTree().setLayoutData((Object)data);
        this.templatesViewer.getTree().setFont(parent.getFont());
        this.templatesViewer.setContentProvider((IContentProvider)new FileBlocksContentProvider((AdapterFactory)this.adapterFactory));
        this.templatesViewer.setLabelProvider((IBaseLabelProvider)new FileBlocksLabelProvider((AdapterFactory)this.adapterFactory));
        this.templatesViewer.addCheckStateListener(new ICheckStateListener(){
            private boolean active;

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (!this.active) {
                    this.active = true;
                    try {
                        if (event.getElement() instanceof FileBlocksProjectHandler) {
                            FileBlocksProjectHandler handler = (FileBlocksProjectHandler)event.getElement();
                            FileBlocksWizardPage.this.templatesViewer.expandToLevel((Object)handler, 1);
                            Module[] moduleArray = handler.getModules();
                            int n = moduleArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Module eModule = moduleArray[n2];
                                FileBlocksWizardPage.this.templatesViewer.expandToLevel((Object)eModule, 1);
                                FileBlocksWizardPage.this.templatesViewer.setChecked((Object)eModule, event.getChecked());
                                FileBlocksWizardPage.this.checkStateTemplate(eModule, event.getChecked());
                                ++n2;
                            }
                        } else if (event.getElement() instanceof Module) {
                            Module eModule = (Module)event.getElement();
                            FileBlocksWizardPage.this.checkStateTemplate(eModule, event.getChecked());
                        }
                    }
                    finally {
                        this.active = false;
                    }
                }
            }
        });
    }

    private void update(IProgressMonitor monitor) {
        if (this.project != null) {
            CompactHashSet newResourceSet = new CompactHashSet();
            AcceleoProject acceleoProject = new AcceleoProject(this.project);
            ArrayList<FileBlocksProjectHandler> projects = new ArrayList<FileBlocksProjectHandler>();
            ResourceSet resourceSet = acceleoProject.loadAccessibleOutputFiles(monitor);
            newResourceSet.add(resourceSet);
            this.computeFileBlocksProjectHandlers(resourceSet, true, projects);
            if (!monitor.isCanceled() && this.browseNotAccessibleTemplates) {
                resourceSet = acceleoProject.loadNotAccessibleOutputFiles(monitor);
                newResourceSet.add(resourceSet);
                this.computeFileBlocksProjectHandlers(resourceSet, false, projects);
            }
            if (!monitor.isCanceled()) {
                this.update(projects);
                if (this.toUnload.size() > 0) {
                    for (ResourceSet resourceSetToUnload : this.toUnload) {
                        this.unloadResourceSet(resourceSetToUnload);
                    }
                    this.toUnload.clear();
                }
                this.toUnload.addAll((Collection<ResourceSet>)newResourceSet);
            } else {
                for (ResourceSet resourceSetToUnload : newResourceSet) {
                    this.unloadResourceSet(resourceSetToUnload);
                }
            }
        } else {
            ArrayList<FileBlocksProjectHandler> projects = new ArrayList<FileBlocksProjectHandler>();
            ResourceSet resourceSet = AcceleoProject.loadAllPlatformOutputFiles(monitor);
            if (!monitor.isCanceled()) {
                this.computeFileBlocksProjectHandlers(resourceSet, false, projects);
                this.update(projects);
                if (this.toUnload.size() > 0) {
                    for (ResourceSet resourceSetToUnload : this.toUnload) {
                        this.unloadResourceSet(resourceSetToUnload);
                    }
                    this.toUnload.clear();
                }
                this.toUnload.add(resourceSet);
            } else {
                this.unloadResourceSet(resourceSet);
            }
        }
    }

    private void update(List<FileBlocksProjectHandler> projects) {
        Object[] checkedElements = this.templatesViewer.getCheckedElements();
        this.templatesViewer.setInput((Object)projects.toArray());
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            EObject eObject;
            URI fileURI;
            Object checkedElement = objectArray[n2];
            if (checkedElement instanceof EObject && ((EObject)checkedElement).eResource() != null && (fileURI = (eObject = (EObject)checkedElement).eResource().getURI()) != null) {
                String eObjectFragmentURI = eObject.eResource().getURIFragment(eObject);
                EObject newEObject = this.expandFragment(fileURI, eObjectFragmentURI);
                this.templatesViewer.setChecked((Object)newEObject, true);
            }
            ++n2;
        }
    }

    private void unloadResourceSet(ResourceSet resourceSetToUnload) {
        for (Resource resource : resourceSetToUnload.getResources()) {
            if (!resource.isLoaded()) continue;
            resource.unload();
        }
    }

    private void computeFileBlocksProjectHandlers(ResourceSet emtlResourceSet, boolean isResolved, List<FileBlocksProjectHandler> projects) {
        if (emtlResourceSet != null) {
            HashMap<String, ArrayList<Module>> project2emtl = new HashMap<String, ArrayList<Module>>();
            for (Resource emtlResource : emtlResourceSet.getResources()) {
                if (emtlResource.getContents().size() <= 0 || !(emtlResource.getContents().get(0) instanceof Module)) continue;
                Module eModule = (Module)emtlResource.getContents().get(0);
                String projectName = this.getModuleProjectName(eModule);
                ArrayList<Module> toFill = (ArrayList<Module>)project2emtl.get(projectName);
                if (toFill == null) {
                    toFill = new ArrayList<Module>();
                    project2emtl.put(projectName, toFill);
                }
                toFill.add(eModule);
            }
            for (Map.Entry entry : project2emtl.entrySet()) {
                String projectName = (String)entry.getKey();
                List eModules = (List)entry.getValue();
                FileBlocksProjectHandler projectHanlder = new FileBlocksProjectHandler(projectName, eModules.toArray(new Module[eModules.size()]), isResolved);
                if (this.project != null && projectName.equals(this.project.getName())) {
                    projects.add(0, projectHanlder);
                    continue;
                }
                projects.add(projectHanlder);
            }
        }
    }

    private String getModuleProjectName(Module eModule) {
        String result;
        Resource resource = eModule.eResource();
        if (resource != null) {
            String prefix;
            URI uri = resource.getURI();
            String path = uri.toString();
            if (path.startsWith(prefix = "platform:/resource/")) {
                path = path.substring(prefix.length());
            } else {
                prefix = "platform:/plugin/";
                if (path.startsWith(prefix)) {
                    path = path.substring(prefix.length());
                }
            }
            Path relativePath = new Path(path);
            result = relativePath.segmentCount() > 1 ? (uri.isPlatformPlugin() ? String.valueOf(relativePath.segment(0)) + " [plugin]" : relativePath.segment(0)) : "[others]";
        } else {
            result = "[others]";
        }
        return result;
    }

    public void dispose() {
        if (this.toUnload.size() > 0) {
            for (ResourceSet resourceSet : this.toUnload) {
                this.unloadResourceSet(resourceSet);
            }
            this.toUnload.clear();
        }
        super.dispose();
    }

    private EObject expandFragment(URI eObjectFileURI, String eObjectFragmentURI) {
        if (eObjectFileURI != null && eObjectFragmentURI != null && this.templatesViewer.getInput() instanceof Object[]) {
            Object[] inputs;
            Object[] objectArray = inputs = (Object[])this.templatesViewer.getInput();
            int n = inputs.length;
            int n2 = 0;
            while (n2 < n) {
                Object input = objectArray[n2];
                if (input instanceof FileBlocksProjectHandler) {
                    FileBlocksProjectHandler projectHandler = (FileBlocksProjectHandler)input;
                    Module[] moduleArray = projectHandler.getModules();
                    int n3 = moduleArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Module eModule = moduleArray[n4];
                        EObject newEObject = eModule.eResource() != null && eModule.eResource().getURI().equals((Object)eObjectFileURI) ? eModule.eResource().getEObject(eObjectFragmentURI) : null;
                        if (newEObject instanceof ModuleElement) {
                            this.templatesViewer.setExpandedState((Object)projectHandler, true);
                            this.templatesViewer.setExpandedState((Object)newEObject.eContainer(), true);
                            this.templatesViewer.setSelection((ISelection)new StructuredSelection((Object)newEObject), true);
                        } else if (newEObject instanceof Module) {
                            this.templatesViewer.setExpandedState((Object)projectHandler, true);
                            this.templatesViewer.setSelection((ISelection)new StructuredSelection((Object)newEObject), true);
                        }
                        if (newEObject != null) {
                            return newEObject;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private synchronized void checkStateTemplate(Module eModule, boolean state) {
        for (ModuleElement eModuleElement : eModule.getOwnedModuleElement()) {
            this.templatesViewer.expandToLevel((Object)eModuleElement, 1);
            this.templatesViewer.setChecked((Object)eModuleElement, state);
        }
    }

    public Template[] getSelectedTemplates() {
        ArrayList<Template> result = new ArrayList<Template>();
        Object[] templateCheckedElements = this.templatesViewer.getCheckedElements();
        if (templateCheckedElements.length > 0) {
            int i = 0;
            while (i < templateCheckedElements.length) {
                Object templateCheckedElement = templateCheckedElements[i];
                if (templateCheckedElement instanceof Template) {
                    result.add((Template)templateCheckedElement);
                }
                ++i;
            }
        }
        return result.toArray(new Template[result.size()]);
    }
}

