/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.environment;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.acceleo.common.AcceleoServicesRegistry;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.acceleo.common.utils.CompactLinkedHashSet;
import org.eclipse.acceleo.common.utils.IAcceleoCrossReferenceProvider;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.internal.environment.AcceleoEvaluationEnvironment;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.util.Bag;
import org.eclipse.ocl.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoLibraryOperationVisitor {
    private static final Object OPERATION_CALL_FAILED = new Object();
    private static final Map<String, Class<?>> PRIMITIVE_TYPES;
    private static final String TEMPORARY_CONTEXT_VAR_PREFIX = "context$";
    private static final Map<String, StringTokenizer> TOKENIZERS;
    private static EcoreUtil.CrossReferencer referencer;

    static {
        TOKENIZERS = new HashMap<String, StringTokenizer>();
        PRIMITIVE_TYPES = new HashMap();
        PRIMITIVE_TYPES.put("boolean", Boolean.TYPE);
        PRIMITIVE_TYPES.put("byte", Byte.TYPE);
        PRIMITIVE_TYPES.put("char", Character.TYPE);
        PRIMITIVE_TYPES.put("short", Short.TYPE);
        PRIMITIVE_TYPES.put("int", Integer.TYPE);
        PRIMITIVE_TYPES.put("long", Long.TYPE);
        PRIMITIVE_TYPES.put("float", Float.TYPE);
        PRIMITIVE_TYPES.put("double", Double.TYPE);
    }

    private AcceleoLibraryOperationVisitor() {
    }

    public static Object callNonStandardOperation(AcceleoEvaluationEnvironment env, EOperation operation, Object source, Object ... args) {
        Object result = OPERATION_CALL_FAILED;
        String operationName = operation.getName();
        if ("+".equals(operationName)) {
            assert (source instanceof String || args[0] instanceof String);
            result = String.valueOf(AcceleoLibraryOperationVisitor.toString(source)) + AcceleoLibraryOperationVisitor.toString(args[0]);
        } else if ("toString".equals(operationName)) {
            result = AcceleoLibraryOperationVisitor.toString(source);
        } else if ("invoke".equals(operationName)) {
            if (args.length == 3) {
                URI uri = operation.eResource().getURI();
                uri = URI.createURI((String)URI.decode((String)uri.toString()));
                result = AcceleoLibraryOperationVisitor.invoke(uri, source, args);
            }
        } else if ("current".equals(operationName)) {
            if (args.length == 1) {
                result = AcceleoLibraryOperationVisitor.getContext(env, args);
            }
        } else if ("getProperty".equals(operationName)) {
            if (args.length == 1) {
                result = AcceleoLibraryOperationVisitor.getProperty(env, (String)args[0]);
            } else if (args.length == 2 && args[1] instanceof String) {
                result = AcceleoLibraryOperationVisitor.getProperty(env, (String)args[0], (String)args[1]);
            } else if (args.length == 2) {
                result = AcceleoLibraryOperationVisitor.getProperty(env, (String)args[0], ((List)args[1]).toArray());
            } else if (args.length == 3) {
                result = AcceleoLibraryOperationVisitor.getProperty(env, (String)args[0], (String)args[1], ((List)args[2]).toArray());
            }
        } else if ("lineSeparator".equals(operationName)) {
            result = EMFPlugin.IS_ECLIPSE_RUNNING ? AcceleoPreferences.getLineSeparator() : System.getProperty("line.separator");
        } else if (source instanceof String) {
            result = AcceleoLibraryOperationVisitor.callNonStandardStringOperation(operation, (String)source, args);
        } else if (source instanceof EObject) {
            result = AcceleoLibraryOperationVisitor.callNonStandardEObjectOperation(operation, (EObject)source, args);
        } else if (source instanceof Collection) {
            result = AcceleoLibraryOperationVisitor.callNonStandardCollectionOperation(operation, (Collection)source, args);
        }
        if (result != OPERATION_CALL_FAILED) {
            return result;
        }
        throw AcceleoLibraryOperationVisitor.getExceptionOperationCallFailed(operation, source, args);
    }

    public static Object callStandardOperation(AcceleoEvaluationEnvironment env, EOperation operation, Object source, Object ... args) {
        Object result = OPERATION_CALL_FAILED;
        if (source instanceof String) {
            String sourceValue = (String)source;
            if ("substitute".equals(operation.getName())) {
                result = AcceleoLibraryOperationVisitor.substitute(sourceValue, (String)args[0], (String)args[1], false);
            } else if ("index".equals(operation.getName())) {
                result = sourceValue.indexOf((String)args[0]) + 1;
                if (result.equals(0)) {
                    result = -1;
                }
            } else if ("first".equals(operation.getName())) {
                int endIndex = (Integer)args[0];
                result = endIndex < 0 ? env.getInvalidResult() : (endIndex > sourceValue.length() ? sourceValue : sourceValue.substring(0, endIndex));
            } else if ("last".equals(operation.getName())) {
                int charCount = (Integer)args[0];
                result = charCount < 0 ? env.getInvalidResult() : (charCount > sourceValue.length() ? sourceValue : sourceValue.substring(sourceValue.length() - charCount, sourceValue.length()));
            } else if ("strstr".equals(operation.getName())) {
                result = sourceValue.contains((String)args[0]);
            } else if ("strtok".equals(operation.getName())) {
                result = AcceleoLibraryOperationVisitor.strtok(sourceValue, (String)args[0], (Integer)args[1]);
            } else if ("strcmp".equals(operation.getName())) {
                result = sourceValue.compareTo((String)args[0]);
            } else if ("isAlpha".equals(operation.getName())) {
                result = AcceleoLibraryOperationVisitor.isAlpha(sourceValue);
            } else if ("isAlphanum".equals(operation.getName())) {
                result = AcceleoLibraryOperationVisitor.isAlphanumeric(sourceValue);
            } else if ("toUpperFirst".equals(operation.getName())) {
                result = sourceValue.length() == 0 ? sourceValue : (sourceValue.length() == 1 ? sourceValue.toUpperCase() : String.valueOf(Character.toUpperCase(sourceValue.charAt(0))) + sourceValue.substring(1));
            } else if ("toLowerFirst".equals(operation.getName())) {
                result = sourceValue.length() == 0 ? sourceValue : (sourceValue.length() == 1 ? sourceValue.toLowerCase() : String.valueOf(Character.toLowerCase(sourceValue.charAt(0))) + sourceValue.substring(1));
            }
        } else if (source instanceof Integer || source instanceof Long) {
            if ("toString".equals(operation.getName())) {
                result = source.toString();
            }
        } else if ((source instanceof Double || source instanceof Float) && "toString".equals(operation.getName())) {
            result = source.toString();
        }
        if (result != OPERATION_CALL_FAILED) {
            return result;
        }
        throw AcceleoLibraryOperationVisitor.getExceptionOperationCallFailed(operation, source, args);
    }

    public static void dispose() {
        TOKENIZERS.clear();
        if (referencer != null) {
            referencer.clear();
            referencer = null;
        }
    }

    private static Object callNonStandardCollectionOperation(EOperation operation, Collection<?> source, Object ... args) {
        ArrayList arg;
        ArrayList temp;
        int indexOfSubList;
        Object result = OPERATION_CALL_FAILED;
        String operationName = operation.getName();
        if ("sep".equals(operationName)) {
            result = AcceleoLibraryOperationVisitor.sep(source, args);
        } else if ("filter".equals(operationName)) {
            Object temp2 = source instanceof Bag ? CollectionUtil.createNewBag() : (source instanceof HashSet && !(source instanceof LinkedHashSet) ? CollectionUtil.createNewSet() : (source instanceof Set ? CollectionUtil.createNewOrderedSet() : CollectionUtil.createNewSequence()));
            for (Object next : source) {
                if (!((EClassifier)args[0]).isInstance(next)) continue;
                temp2.add(next);
            }
            result = temp2;
        } else if ("reverse".equals(operationName)) {
            CompactLinkedHashSet temp3 = new ArrayList(source);
            Collections.reverse(temp3);
            if (source instanceof LinkedHashSet) {
                CompactLinkedHashSet reversedSet = new CompactLinkedHashSet(temp3);
                result = reversedSet;
            } else {
                result = temp3;
            }
        } else if ("lastIndexOf".equals(operationName)) {
            ArrayList temp4 = new ArrayList(source);
            result = temp4.lastIndexOf(args[0]) + 1;
            if (result.equals(0)) {
                result = -1;
            }
        } else if ("addAll".equals(operationName)) {
            if (args.length == 1 && args[0] instanceof Collection) {
                result = AcceleoLibraryOperationVisitor.addAll(source, (Collection)args[0]);
            }
        } else if ("removeAll".equals(operationName)) {
            if (args.length == 1 && args[0] instanceof Collection) {
                result = AcceleoLibraryOperationVisitor.removeAll(source, (Collection)args[0]);
            }
        } else if ("drop".equals(operationName)) {
            if (args.length == 1 && args[0] instanceof Integer) {
                ArrayList temp5 = new ArrayList(source);
                int index = (Integer)args[0];
                if (index <= temp5.size()) {
                    result = temp5.subList(index, temp5.size());
                }
            }
        } else if ("dropRight".equals(operationName)) {
            if (args.length == 1 && args[0] instanceof Integer) {
                ArrayList temp6 = new ArrayList(source);
                int index = (Integer)args[0];
                if (index <= temp6.size()) {
                    result = temp6.subList(0, temp6.size() - index);
                }
            }
        } else if ("startsWith".equals(operationName)) {
            if (args.length == 1 && args[0] instanceof Collection) {
                ArrayList temp7 = new ArrayList(source);
                ArrayList arg2 = new ArrayList((Collection)args[0]);
                result = Boolean.FALSE;
                if (temp7.size() >= arg2.size()) {
                    List subTemp = temp7.subList(0, arg2.size());
                    result = subTemp.equals(arg2);
                }
            }
        } else if ("endsWith".equals(operationName)) {
            if (args.length == 1 && args[0] instanceof Collection) {
                ArrayList temp8 = new ArrayList(source);
                ArrayList arg3 = new ArrayList((Collection)args[0]);
                result = Boolean.FALSE;
                if (temp8.size() >= arg3.size()) {
                    List subTemp = temp8.subList(temp8.size() - arg3.size(), temp8.size());
                    result = subTemp.equals(arg3);
                }
            }
        } else if ("indexOfSlice".equals(operationName)) {
            ArrayList arg4;
            ArrayList temp9;
            int indexOfSubList2;
            if (args.length == 1 && args[0] instanceof Collection && (result = Integer.valueOf((indexOfSubList2 = Collections.indexOfSubList(temp9 = new ArrayList(source), arg4 = new ArrayList((Collection)args[0]))) + 1)).equals(0)) {
                result = -1;
            }
        } else if ("lastIndexOfSlice".equals(operationName) && args.length == 1 && args[0] instanceof Collection && (result = Integer.valueOf((indexOfSubList = Collections.lastIndexOfSubList(temp = new ArrayList(source), arg = new ArrayList((Collection)args[0]))) + 1)).equals(0)) {
            result = -1;
        }
        return result;
    }

    private static Object sep(Collection<?> source, Object[] args) {
        ArrayList<Object> result = OPERATION_CALL_FAILED;
        if (args.length == 1) {
            ArrayList<Object> temp = new ArrayList<Object>(source.size() << 1);
            Iterator<?> sourceIterator = source.iterator();
            while (sourceIterator.hasNext()) {
                temp.add(sourceIterator.next());
                if (!sourceIterator.hasNext()) continue;
                temp.add(args[0]);
            }
            result = temp;
        } else if (args.length == 3) {
            ArrayList<Object> temp = new ArrayList<Object>(source.size() << 1);
            temp.add(args[0]);
            Iterator<?> sourceIterator = source.iterator();
            while (sourceIterator.hasNext()) {
                temp.add(sourceIterator.next());
                if (!sourceIterator.hasNext()) continue;
                temp.add(args[1]);
            }
            temp.add(args[2]);
            result = temp;
        }
        return result;
    }

    private static Object addAll(Collection<?> source, Collection<?> arg) {
        Bag result = OPERATION_CALL_FAILED;
        if (source instanceof LinkedHashSet) {
            LinkedHashSet temp = new LinkedHashSet(source);
            temp.addAll(arg);
            result = temp;
        } else if (source instanceof Set) {
            HashSet temp = new HashSet(source);
            temp.addAll(arg);
            result = temp;
        } else if (source instanceof List) {
            ArrayList temp = new ArrayList(source);
            temp.addAll(arg);
            result = temp;
        } else if (source instanceof Bag) {
            Bag temp = CollectionUtil.createNewBag(source);
            temp.addAll(arg);
            result = temp;
        }
        return result;
    }

    private static Object removeAll(Collection<?> source, Collection<?> arg) {
        Bag result = OPERATION_CALL_FAILED;
        if (source instanceof LinkedHashSet) {
            LinkedHashSet temp = new LinkedHashSet(source);
            temp.removeAll(arg);
            result = temp;
        } else if (source instanceof Set) {
            HashSet temp = new HashSet(source);
            temp.removeAll(arg);
            result = temp;
        } else if (source instanceof List) {
            ArrayList temp = new ArrayList(source);
            temp.removeAll(arg);
            result = temp;
        } else if (source instanceof Bag) {
            Bag bag;
            ArrayList temp = new ArrayList(source);
            temp.removeAll(arg);
            result = bag = CollectionUtil.createNewBag(temp);
        }
        return result;
    }

    private static Object callNonStandardEObjectOperation(EOperation operation, EObject source, Object ... args) {
        Collection<EObject> result = OPERATION_CALL_FAILED;
        String operationName = operation.getName();
        if ("eAllContents".equals(operationName)) {
            if (args.length == 0) {
                result = AcceleoLibraryOperationVisitor.eAllContents(source, null);
            } else if (args.length == 1 && args[0] instanceof EClassifier) {
                result = AcceleoLibraryOperationVisitor.eAllContents(source, (EClassifier)args[0]);
            }
        } else if ("ancestors".equals(operationName)) {
            if (args.length == 0) {
                result = AcceleoLibraryOperationVisitor.ancestors(source, null);
            } else if (args.length == 1 && args[0] instanceof EClassifier) {
                result = AcceleoLibraryOperationVisitor.ancestors(source, (EClassifier)args[0]);
            }
        } else if ("siblings".equals(operationName)) {
            if (args.length == 0) {
                result = AcceleoLibraryOperationVisitor.siblings(source, null);
            } else if (args.length == 1 && args[0] instanceof EClassifier) {
                result = AcceleoLibraryOperationVisitor.siblings(source, (EClassifier)args[0]);
            }
        } else if ("precedingSiblings".equals(operationName)) {
            if (args.length == 0) {
                result = AcceleoLibraryOperationVisitor.siblings(source, null, true);
            } else if (args.length == 1 && args[0] instanceof EClassifier) {
                result = AcceleoLibraryOperationVisitor.siblings(source, (EClassifier)args[0], true);
            }
        } else if ("followingSiblings".equals(operationName)) {
            if (args.length == 0) {
                result = AcceleoLibraryOperationVisitor.siblings(source, null, false);
            } else if (args.length == 1 && args[0] instanceof EClassifier) {
                result = AcceleoLibraryOperationVisitor.siblings(source, (EClassifier)args[0], false);
            }
        } else if ("eInverse".equals(operationName)) {
            if (args.length == 0) {
                result = AcceleoLibraryOperationVisitor.eInverse(source, null);
            } else if (args.length == 1 && args[0] instanceof EClassifier) {
                result = AcceleoLibraryOperationVisitor.eInverse(source, (EClassifier)args[0]);
            }
        } else if ("eGet".equals(operationName)) {
            result = AcceleoLibraryOperationVisitor.eGet(source, (String)args[0]);
        } else if ("eContainer".equals(operationName)) {
            result = AcceleoLibraryOperationVisitor.eContainer(source, (EClassifier)args[0]);
        } else if ("eContents".equals(operationName)) {
            result = AcceleoLibraryOperationVisitor.eContents(source, (EClassifier)args[0]);
        }
        return result;
    }

    private static Object callNonStandardStringOperation(EOperation operation, String source, Object ... args) {
        Object result = OPERATION_CALL_FAILED;
        String operationName = operation.getName();
        if ("substituteAll".equals(operationName)) {
            result = AcceleoLibraryOperationVisitor.substitute(source, (String)args[0], (String)args[1], true);
        } else if ("replace".equals(operationName)) {
            result = source.replaceFirst((String)args[0], (String)args[1]);
        } else if ("replaceAll".equals(operationName)) {
            result = source.replaceAll((String)args[0], (String)args[1]);
        } else if ("endsWith".equals(operationName)) {
            result = source.endsWith((String)args[0]);
        } else if ("equalsIgnoreCase".equals(operationName)) {
            result = source.equalsIgnoreCase((String)args[0]);
        } else if ("startsWith".equals(operationName)) {
            result = source.startsWith((String)args[0]);
        } else if ("trim".equals(operationName)) {
            result = source.trim();
        } else if ("tokenize".equals(operationName)) {
            if (args.length == 1) {
                result = AcceleoLibraryOperationVisitor.tokenize(source, (String)args[0]);
            } else if (args.length == 0) {
                result = AcceleoLibraryOperationVisitor.tokenize(source);
            }
        } else if ("contains".equals(operationName)) {
            result = source.contains((String)args[0]);
        } else if ("matches".equals(operationName)) {
            result = source.matches((String)args[0]);
        } else if ("lastIndex".equals(operationName)) {
            if (args.length == 1) {
                result = source.lastIndexOf((String)args[0]) + 1;
                if (result.equals(0)) {
                    result = -1;
                }
            } else if (args.length == 2 && (result = Integer.valueOf(source.lastIndexOf((String)args[0], (int)((Integer)args[1])) + 1)).equals(0)) {
                result = -1;
            }
        } else if ("substring".equals(operationName)) {
            try {
                result = source.substring((Integer)args[0] - 1);
            }
            catch (IndexOutOfBoundsException e) {
                AcceleoEnginePlugin.log(new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoLibraryOperationVisitor.IndexOutOfBoundsSubstring", source, args[0]), e), true);
            }
        } else if ("index".equals(operationName)) {
            if (args.length == 2 && (result = Integer.valueOf(source.indexOf((String)args[0], (int)((Integer)args[1])) + 1)).equals(0)) {
                result = -1;
            }
        } else if ("tokenizeLine".equals(operationName)) {
            if (source.contains("\r\n")) {
                result = AcceleoLibraryOperationVisitor.tokenize(source, "\r\n");
            } else if (source.contains("\n")) {
                result = AcceleoLibraryOperationVisitor.tokenize(source, "\n");
            } else if (source.contains("\r")) {
                result = AcceleoLibraryOperationVisitor.tokenize(source, "\r");
            } else {
                ArrayList<String> temp = new ArrayList<String>();
                temp.add(source);
                result = temp;
            }
        } else if ("prefix".equals(operationName) && args.length == 1 && args[0] instanceof String) {
            String prefix = (String)args[0];
            result = String.valueOf(prefix) + source;
        }
        return result;
    }

    private static List<EObject> ancestors(EObject source, EClassifier filter) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        EObject container = source.eContainer();
        while (container != null) {
            if (filter == null || filter.isInstance((Object)container)) {
                result.add(container);
            }
            container = container.eContainer();
        }
        return result;
    }

    private static List<EObject> eAllContents(EObject source, EClassifier filter) {
        TreeIterator contentIterator = source.eAllContents();
        ArrayList<EObject> result = new ArrayList<EObject>();
        while (contentIterator.hasNext()) {
            EObject next = (EObject)contentIterator.next();
            if (filter != null && !filter.isInstance((Object)next)) continue;
            result.add(next);
        }
        return result;
    }

    private static Object eContainer(EObject source, EClassifier filter) {
        EObject container = source.eContainer();
        while (container != null && !filter.isInstance((Object)container)) {
            container = container.eContainer();
        }
        return container;
    }

    private static List<EObject> eContents(EObject source, EClassifier filter) {
        Iterator contentIterator = source.eContents().iterator();
        ArrayList<EObject> result = new ArrayList<EObject>();
        while (contentIterator.hasNext()) {
            EObject next = (EObject)contentIterator.next();
            if (filter != null && !filter.isInstance((Object)next)) continue;
            result.add(next);
        }
        return result;
    }

    private static Object eGet(EObject source, String featureName) {
        Object result = null;
        for (EStructuralFeature feature : source.eClass().getEAllStructuralFeatures()) {
            if (!feature.getName().equals(featureName)) continue;
            result = source.eGet(feature);
        }
        return result;
    }

    private static Set<EObject> eInverse(EObject target, EClassifier filter) {
        CompactLinkedHashSet result = new CompactLinkedHashSet();
        IAcceleoCrossReferenceProvider crossReferenceProvider = AcceleoLibraryOperationVisitor.getCrossReferencerAdapter(target);
        if (crossReferenceProvider != null) {
            if (filter != null) {
                result.addAll(crossReferenceProvider.getInverseReferences(target, filter));
            } else {
                result.addAll(crossReferenceProvider.getInverseReferences(target));
            }
        } else {
            Collection settings;
            if (referencer == null) {
                AcceleoLibraryOperationVisitor.createEInverseCrossreferencer(target);
            }
            if ((settings = (Collection)referencer.get((Object)target)) == null) {
                return Collections.emptySet();
            }
            for (EStructuralFeature.Setting setting : settings) {
                if (filter != null && !filter.isInstance((Object)setting.getEObject())) continue;
                result.add(setting.getEObject());
            }
        }
        return result;
    }

    private static Method findInvokeMethod(Class<?> serviceClass, String methodSignature) throws NoSuchMethodException, ClassNotFoundException {
        int openParenthesisIndex = methodSignature.indexOf(40);
        Method method = null;
        if (openParenthesisIndex == -1) {
            method = serviceClass.getMethod(methodSignature, new Class[0]);
        } else {
            String methodName = methodSignature.substring(0, openParenthesisIndex);
            int closeParenthesisIndex = methodSignature.indexOf(41);
            if (closeParenthesisIndex - openParenthesisIndex <= 1) {
                method = serviceClass.getMethod(methodName, new Class[0]);
            } else {
                int parameterIndex;
                String parameterType;
                String parameterTypesString = methodSignature.substring(openParenthesisIndex + 1, closeParenthesisIndex);
                ArrayList parameterTypes = new ArrayList();
                int nextCommaIndex = parameterTypesString.indexOf(44);
                int previousComma = 0;
                while (nextCommaIndex != -1) {
                    parameterType = parameterTypesString.substring(previousComma, nextCommaIndex).trim();
                    parameterIndex = parameterType.indexOf(60);
                    if (parameterIndex != -1) {
                        parameterType = parameterType.substring(parameterIndex + 1, parameterType.indexOf(62));
                    }
                    if (PRIMITIVE_TYPES.containsKey(parameterType)) {
                        parameterTypes.add(PRIMITIVE_TYPES.get(parameterType));
                    } else if (serviceClass.getClassLoader() != null) {
                        parameterTypes.add(serviceClass.getClassLoader().loadClass(parameterType));
                    } else {
                        parameterTypes.add(Class.forName(parameterType));
                    }
                    previousComma = nextCommaIndex + 1;
                    nextCommaIndex = parameterTypesString.indexOf(44, previousComma);
                }
                parameterType = parameterTypesString.substring(previousComma, parameterTypesString.length()).trim();
                parameterIndex = parameterType.indexOf(60);
                if (parameterIndex != -1) {
                    parameterType = parameterType.substring(parameterIndex + 1, parameterType.indexOf(62));
                }
                if (PRIMITIVE_TYPES.containsKey(parameterType)) {
                    parameterTypes.add(PRIMITIVE_TYPES.get(parameterType));
                } else if (serviceClass.getClassLoader() != null) {
                    parameterTypes.add(serviceClass.getClassLoader().loadClass(parameterType));
                } else {
                    parameterTypes.add(Class.forName(parameterType));
                }
                method = serviceClass.getMethod(methodName, parameterTypes.toArray(new Class[parameterTypes.size()]));
            }
        }
        return method;
    }

    private static void createEInverseCrossreferencer(EObject target) {
        Resource res = null;
        ResourceSet rs = null;
        if (target.eResource() != null) {
            res = target.eResource();
        }
        if (res != null && res.getResourceSet() != null) {
            rs = res.getResourceSet();
        }
        if (rs != null) {
            Resource ecoreResource = EcorePackage.eINSTANCE.getEClass().eResource();
            ArrayList<Resource> notifiers = new ArrayList<Resource>();
            for (Resource crossReferenceResource : rs.getResources()) {
                if ("emtl".equals(crossReferenceResource.getURI().fileExtension())) continue;
                notifiers.add(crossReferenceResource);
            }
            notifiers.add(ecoreResource);
            referencer = new EcoreUtil.CrossReferencer(notifiers){
                private static final long serialVersionUID = 1L;
                {
                    this.crossReference();
                    this.done();
                }
            };
        } else if (res != null) {
            referencer = new EcoreUtil.CrossReferencer(res){
                private static final long serialVersionUID = 1L;
                {
                    this.crossReference();
                    this.done();
                }
            };
        } else {
            EObject targetObject = EcoreUtil.getRootContainer((EObject)target);
            referencer = new EcoreUtil.CrossReferencer(targetObject){
                private static final long serialVersionUID = 1L;
                {
                    this.crossReference();
                    this.done();
                }
            };
        }
    }

    private static Object getContext(AcceleoEvaluationEnvironment env, Object[] args) {
        Object soughtValue;
        ArrayList<Object> allIterators = new ArrayList<Object>();
        int index = 0;
        Object value = env.getValueOf(TEMPORARY_CONTEXT_VAR_PREFIX + index++);
        while (value != null) {
            allIterators.add(value);
            value = env.getValueOf(TEMPORARY_CONTEXT_VAR_PREFIX + index++);
        }
        if (args[0] instanceof Integer) {
            int soughtIndex = (Integer)args[0];
            soughtValue = soughtIndex > allIterators.size() - 1 ? allIterators.get(0) : allIterators.get(allIterators.size() - soughtIndex - 1);
        } else {
            EClassifier filter = (EClassifier)args[0];
            int i = allIterators.size() - 1;
            while (i >= 0) {
                if (filter.isInstance(allIterators.get(i))) {
                    value = allIterators.get(i);
                    break;
                }
                --i;
            }
            soughtValue = value;
        }
        return soughtValue;
    }

    private static IAcceleoCrossReferenceProvider getCrossReferencerAdapter(EObject eObject) {
        Object adapted;
        IAcceleoCrossReferenceProvider provider = null;
        if (EMFPlugin.IS_ECLIPSE_RUNNING && (adapted = Platform.getAdapterManager().getAdapter((Object)eObject, IAcceleoCrossReferenceProvider.class)) instanceof IAcceleoCrossReferenceProvider) {
            provider = (IAcceleoCrossReferenceProvider)adapted;
        }
        return provider;
    }

    private static UnsupportedOperationException getExceptionOperationCallFailed(EOperation operation, Object source, Object ... args) {
        StringBuilder argErrorMsg = new StringBuilder();
        int i = 0;
        while (i < args.length) {
            argErrorMsg.append(args[i].getClass().getSimpleName());
            if (i < args.length - 1) {
                argErrorMsg.append(", ");
            }
            ++i;
        }
        String sourceName = source == null ? "null" : source.getClass().getName();
        return new UnsupportedOperationException(AcceleoEngineMessages.getString("AcceleoEvaluationEnvironment.UndefinedOperation", operation.getName(), argErrorMsg.toString(), sourceName));
    }

    private static String getProperty(AcceleoEvaluationEnvironment env, String key) {
        String propertyValue = env.getPropertiesLookup().getProperty(key);
        if (propertyValue != null) {
            propertyValue = MessageFormat.format(propertyValue, new Object[0]);
        }
        return propertyValue;
    }

    private static String getProperty(AcceleoEvaluationEnvironment env, String key, Object[] arguments) {
        String propertyValue = env.getPropertiesLookup().getProperty(key);
        if (propertyValue != null) {
            propertyValue = MessageFormat.format(propertyValue, arguments);
        }
        return propertyValue;
    }

    private static String getProperty(AcceleoEvaluationEnvironment env, String propertiesFileName, String key) {
        String propertyValue = env.getPropertiesLookup().getProperty(propertiesFileName, key);
        if (propertyValue != null) {
            propertyValue = MessageFormat.format(propertyValue, new Object[0]);
        }
        return propertyValue;
    }

    private static String getProperty(AcceleoEvaluationEnvironment env, String propertiesFileName, String key, Object[] arguments) {
        String propertyValue = env.getPropertiesLookup().getProperty(propertiesFileName, key);
        if (propertyValue != null) {
            propertyValue = MessageFormat.format(propertyValue, arguments);
        }
        return propertyValue;
    }

    private static Object invoke(URI moduleURI, Object source, Object[] args) {
        Object result = null;
        Class serviceClass = AcceleoServicesRegistry.INSTANCE.addServiceClass(moduleURI, (String)args[0]);
        if (serviceClass == null) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationEnvironment.ClassNotFound", args[0], moduleURI.lastSegment()));
        }
        String methodSignature = (String)args[1];
        try {
            Method method = AcceleoLibraryOperationVisitor.findInvokeMethod(serviceClass, methodSignature);
            List invocationArguments = (List)args[2];
            if (method.getParameterTypes().length == 0) {
                result = Modifier.isStatic(method.getModifiers()) ? method.invoke(null, new Object[0]) : (serviceClass.isInstance(source) ? (invocationArguments.size() == 0 ? method.invoke(source, new Object[0]) : method.invoke(invocationArguments.get(0), new Object[0])) : method.invoke(AcceleoServicesRegistry.INSTANCE.getServiceInstance(serviceClass), new Object[0]));
            } else {
                if (method.getParameterTypes().length - invocationArguments.size() == 1) {
                    invocationArguments.add(0, source);
                }
                if (Modifier.isStatic(method.getModifiers())) {
                    result = method.invoke(null, invocationArguments.toArray(new Object[invocationArguments.size()]));
                } else if (method.getParameterTypes().length - invocationArguments.size() == -1) {
                    Object swappedSource = invocationArguments.remove(0);
                    result = method.invoke(swappedSource, invocationArguments.toArray(new Object[invocationArguments.size()]));
                } else {
                    result = method.invoke(AcceleoServicesRegistry.INSTANCE.getServiceInstance(serviceClass), invocationArguments.toArray(new Object[invocationArguments.size()]));
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationEnvironment.NoSuchMethod", methodSignature, args[0]), e);
        }
        catch (IllegalArgumentException e) {
            throw new AcceleoEvaluationException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationEnvironment.RestrictedMethod", methodSignature, args[0]), e);
        }
        catch (InvocationTargetException e) {
            throw new AcceleoEvaluationException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationEnvironment.ParameterClassNotFound", methodSignature, args[0]), e);
        }
        return result;
    }

    private static boolean isAlpha(String s) {
        char[] chars;
        char[] cArray = chars = s.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isLetter(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isAlphanumeric(String s) {
        char[] chars;
        char[] cArray = chars = s.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isLetterOrDigit(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static List<EObject> siblings(EObject source, EClassifier filter) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        EObject container = source.eContainer();
        if (container != null) {
            for (EObject child : AcceleoLibraryOperationVisitor.getContents(container)) {
                if (child == source || filter != null && !filter.isInstance((Object)child)) continue;
                result.add(child);
            }
        }
        return result;
    }

    private static List<EObject> siblings(EObject source, EClassifier filter, boolean preceding) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        EObject container = source.eContainer();
        if (container != null) {
            List<EObject> siblings = AcceleoLibraryOperationVisitor.getContents(container);
            int startIndex = 0;
            int endIndex = siblings.size();
            if (preceding) {
                endIndex = siblings.indexOf(source);
            } else {
                startIndex = siblings.indexOf(source) + 1;
            }
            int i = startIndex;
            while (i < endIndex) {
                EObject child = siblings.get(i);
                if (filter == null || filter.isInstance((Object)child)) {
                    result.add(child);
                }
                ++i;
            }
        }
        return result;
    }

    private static String strtok(String source, String delimiters, Integer flag) {
        if (flag == 0) {
            StringTokenizer tokenizer = new StringTokenizer(source, delimiters);
            TOKENIZERS.put(source, tokenizer);
            return tokenizer.nextToken();
        }
        if (flag == 1) {
            StringTokenizer tokenizer = TOKENIZERS.get(source);
            if (tokenizer == null) {
                tokenizer = new StringTokenizer(source, delimiters);
                TOKENIZERS.put(source, tokenizer);
            }
            String token = "";
            if (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
            }
            return token;
        }
        throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationEnvironment.IllegalTokenizerFlag", flag));
    }

    private static String substitute(String source, String substring, String replacement, boolean substituteAll) {
        if (substring == null || replacement == null) {
            throw new NullPointerException();
        }
        if (substituteAll) {
            return Pattern.compile(substring, 16).matcher(source).replaceAll(Matcher.quoteReplacement(replacement));
        }
        return Pattern.compile(substring, 16).matcher(source).replaceFirst(Matcher.quoteReplacement(replacement));
    }

    private static List<String> tokenize(String source, String delim) {
        StringTokenizer tokenizer = new StringTokenizer(source, delim);
        ArrayList<String> result = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    private static List<String> tokenize(String source) {
        StringTokenizer tokenizer = new StringTokenizer(source);
        ArrayList<String> result = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    private static String toString(Object object) {
        StringBuffer buffer = new StringBuffer();
        if (object instanceof Collection) {
            Iterator childrenIterator = ((Collection)object).iterator();
            while (childrenIterator.hasNext()) {
                buffer.append(AcceleoLibraryOperationVisitor.toString(childrenIterator.next()));
            }
        } else if (object != null) {
            buffer.append(object.toString());
        }
        return buffer.toString();
    }

    private static List<EObject> getContents(EObject eObject) {
        ArrayList<EObject> result = new ArrayList<EObject>((Collection<EObject>)eObject.eContents());
        for (EReference reference : eObject.eClass().getEAllReferences()) {
            if (!reference.isContainment() || !reference.isDerived()) continue;
            Object value = eObject.eGet((EStructuralFeature)reference);
            if (value instanceof Collection) {
                for (Object newValue : (Collection)value) {
                    if (result.contains(newValue) || !(newValue instanceof EObject)) continue;
                    result.add((EObject)newValue);
                }
                continue;
            }
            if (result.contains(value) || !(value instanceof EObject)) continue;
            result.add((EObject)value);
        }
        return result;
    }
}

