/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaServicesUtils {
    private static final String LS = System.getProperty("line.separator");

    private JavaServicesUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAcceleoJavaServicesClass(ICompilationUnit iCompilationUnit) {
        try {
            IType[] types;
            IType[] iTypeArray = types = iCompilationUnit.getTypes();
            int n = types.length;
            int n2 = 0;
            while (true) {
                String javadoc;
                if (n2 >= n) {
                    return false;
                }
                IType iType = iTypeArray[n2];
                ISourceRange javadocRange = iType.getJavadocRange();
                if (javadocRange != null && (javadoc = iCompilationUnit.getOpenable().getBuffer().getText(javadocRange.getOffset(), javadocRange.getLength())) != null && javadoc.contains("@nsURI")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    public static void generateAcceleoServicesModule(ICompilationUnit iCompilationUnit, IProgressMonitor monitor) {
        ArrayList<String> nsURIs = new ArrayList<String>();
        try {
            IType[] types;
            IType[] iTypeArray = types = iCompilationUnit.getTypes();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType iType = iTypeArray[n2];
                ISourceRange javadocRange = iType.getJavadocRange();
                if (javadocRange != null) {
                    String javadoc = iCompilationUnit.getOpenable().getBuffer().getText(javadocRange.getOffset(), javadocRange.getLength());
                    Scanner scanner = new Scanner(javadoc);
                    while (scanner.hasNextLine()) {
                        int index;
                        String line = scanner.nextLine();
                        if (javadoc == null || (index = line.indexOf("@nsURI")) == -1) continue;
                        String trimmed = line.substring(index + "@nsURI".length()).trim();
                        nsURIs.add(trimmed);
                    }
                }
                ++n2;
            }
            IResource resource = iCompilationUnit.getResource();
            if (resource instanceof IFile) {
                IFile javaFile = (IFile)resource;
                String moduleName = javaFile.getName();
                if (moduleName.endsWith(".java")) {
                    moduleName = moduleName.substring(0, moduleName.length() - ".java".length());
                }
                String fileName = moduleName;
                moduleName = String.valueOf(moduleName) + '.' + "mtl";
                IContainer parent = javaFile.getParent();
                IFile file = parent.getFile((IPath)new Path(String.valueOf(moduleName.substring(0, 1).toLowerCase()) + moduleName.substring(1)));
                String content = JavaServicesUtils.getFileContent(iCompilationUnit, fileName, nsURIs);
                ByteArrayInputStream source = new ByteArrayInputStream(content.getBytes());
                if (file.exists()) {
                    file.setContents((InputStream)source, true, false, monitor);
                } else {
                    file.create((InputStream)source, true, monitor);
                }
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (CoreException e) {
            AcceleoUIActivator.log((Exception)((Object)e), true);
        }
    }

    private static String getFileContent(ICompilationUnit iCompilationUnit, String fileName, List<String> nsURIs) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[comment encoding=UTF-8/]" + LS);
        buffer.append("[**" + LS);
        buffer.append(" * Generated by Acceleo." + LS);
        buffer.append(" */]" + LS);
        buffer.append("[module " + fileName.substring(0, 1).toLowerCase() + fileName.substring(1) + "('");
        int count = 1;
        for (String nsURI : nsURIs) {
            buffer.append(nsURI);
            if (count < nsURIs.size()) {
                buffer.append("', '");
            } else {
                buffer.append("')");
            }
            ++count;
        }
        buffer.append("/]" + LS);
        buffer.append(LS);
        try {
            IType[] types;
            IType[] iTypeArray = types = iCompilationUnit.getTypes();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod[] methods;
                IType iType = iTypeArray[n2];
                IMethod[] iMethodArray = methods = iType.getMethods();
                int n3 = methods.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMethod iMethod = iMethodArray[n4];
                    buffer.append(JavaServicesUtils.createQuery(iType, iMethod, true));
                    ++n4;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return buffer.toString();
    }

    public static String createQuery(IType type, IMethod javaMethod, boolean withDocumentation) {
        StringBuilder buffer = new StringBuilder();
        try {
            String[][] resolvedType;
            int i;
            String[] javaParameters = javaMethod.getParameterTypes();
            if (withDocumentation) {
                buffer.append("[**\n * The documentation of the query\n");
                i = 0;
                while (i < javaParameters.length) {
                    buffer.append(" * @param arg");
                    buffer.append(i);
                    buffer.append("\n");
                    ++i;
                }
                buffer.append(" */]\n");
            }
            buffer.append("[query public ");
            buffer.append(javaMethod.getElementName());
            buffer.append("(");
            if (javaParameters.length == 0) {
                buffer.append("anOclAny: OclAny");
            } else {
                i = 0;
                while (i < javaParameters.length) {
                    if (i > 0) {
                        buffer.append(',');
                        buffer.append(' ');
                    }
                    buffer.append("arg");
                    buffer.append(i);
                    buffer.append(" : ");
                    resolvedType = JavaServicesUtils.javaClassToOclType(type, Signature.getTypeErasure((String)Signature.toString((String)javaParameters[i])));
                    buffer.append((String)resolvedType);
                    ++i;
                }
            }
            buffer.append(") : ");
            buffer.append(JavaServicesUtils.javaClassToOclType(type, Signature.getTypeErasure((String)Signature.getSignatureSimpleName((String)javaMethod.getReturnType()))));
            buffer.append("\n\t= invoke('");
            buffer.append(type.getFullyQualifiedName());
            buffer.append("', '");
            buffer.append(javaMethod.getElementName());
            buffer.append("(");
            i = 0;
            while (i < javaParameters.length) {
                if (i > 0) {
                    buffer.append(',');
                    buffer.append(' ');
                }
                if ((resolvedType = type.resolveType(Signature.getTypeErasure((String)Signature.toString((String)javaParameters[i])))) != null) {
                    String[][] stringArray = resolvedType;
                    int n = resolvedType.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String[] strings = stringArray[n2];
                        int j = 0;
                        while (j < strings.length) {
                            buffer.append(strings[j]);
                            if (j < strings.length - 1) {
                                buffer.append(".");
                            }
                            ++j;
                        }
                        ++n2;
                    }
                }
                ++i;
            }
            buffer.append(")', Sequence{");
            i = 0;
            while (i < javaParameters.length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append("arg");
                buffer.append(i);
                ++i;
            }
            buffer.append("})\n/]\n\n");
        }
        catch (JavaModelException e) {
            AcceleoUIActivator.log((Exception)((Object)e), true);
        }
        return buffer.toString();
    }

    private static String javaClassToOclType(IType type, String typeName) {
        String result;
        String qualifiedType = typeName;
        if (!"void".equals(qualifiedType)) {
            try {
                StringBuffer buffer = new StringBuffer();
                String[][] resolveType = type.resolveType(qualifiedType);
                if (resolveType != null) {
                    String[][] stringArray = resolveType;
                    int n = resolveType.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String[] strings = stringArray[n2];
                        int i = 0;
                        while (i < strings.length) {
                            buffer.append(strings[i]);
                            if (i < strings.length - 1) {
                                buffer.append('.');
                            }
                            ++i;
                        }
                        ++n2;
                    }
                }
                if (buffer.toString().length() > 0) {
                    qualifiedType = buffer.toString();
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        if ("java.math.BigDecimal".equals(qualifiedType) || "java.lang.Double".equals(qualifiedType) || "double".equals(qualifiedType)) {
            result = "Real";
        } else if ("java.math.BigInteger".equals(qualifiedType) || "java.lang.Integer".equals(qualifiedType) || "int".equals(qualifiedType)) {
            result = "Integer";
        } else if ("java.lang.Short".equals(qualifiedType) || "short".equals(qualifiedType)) {
            result = "Integer";
        } else if ("java.lang.Boolean".equals(qualifiedType) || "boolean".equals(qualifiedType)) {
            result = "Boolean";
        } else if ("java.lang.String".equals(qualifiedType)) {
            result = "String";
        } else if ("java.util.List".equals(qualifiedType) || "java.util.ArrayList".equals(qualifiedType) || "java.util.LinkedList".equals(qualifiedType)) {
            result = "Sequence(OclAny)";
        } else if ("java.util.Set".equals(qualifiedType) || "java.util.HashSet".equals(qualifiedType)) {
            result = "Set(OclAny)";
        } else if ("java.util.LinkedHashSet".equals(qualifiedType)) {
            result = "OrderedSet(OclAny)";
        } else if ("java.util.Collection".equals(qualifiedType)) {
            result = "Collection(OclAny)";
        } else if ("java.lang.Object".equals(qualifiedType)) {
            result = "OclAny";
        } else if ("void".equals(qualifiedType)) {
            result = "OclVoid";
        } else {
            result = qualifiedType;
            int lastDot = result.lastIndexOf(46);
            if (lastDot > -1) {
                result = result.substring(lastDot + 1);
            }
            if (result.endsWith(";")) {
                result = result.substring(0, result.length() - 1);
            }
        }
        return result;
    }
}

