/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.classpath;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoClasspathContainer
implements IClasspathContainer {
    public static final String ACCELEO_CLASSPATH_CONTAINER = "org.eclipse.acceleo.ide.ui.ACCELEO_RUNTIME";
    public static final IPath ACCELEO_CLASSPATH_CONTAINER_PATH_ENGINE = new Path("org.eclipse.acceleo.ide.ui.ACCELEO_RUNTIME").append("ENGINE");
    public static final IPath ACCELEO_CLASSPATH_CONTAINER_PATH_PARSER = new Path("org.eclipse.acceleo.ide.ui.ACCELEO_RUNTIME").append("PARSER");
    public static final IPath ACCELEO_CLASSPATH_CONTAINER_PATH_RUNTIME = new Path("org.eclipse.acceleo.ide.ui.ACCELEO_RUNTIME").append("RUNTIME");
    private IPath path;

    public AcceleoClasspathContainer(IPath path, IJavaProject project) {
        this.path = path;
    }

    public IClasspathEntry[] getClasspathEntries() {
        IClasspathEntry[] entries = new IClasspathEntry[]{};
        if (ACCELEO_CLASSPATH_CONTAINER_PATH_ENGINE.equals((Object)this.path)) {
            ArrayList<IClasspathEntry> entriesList = new ArrayList<IClasspathEntry>();
            entriesList.addAll(AcceleoClasspathContainer.getAcceleoEngineLibraryEntry());
            entries = entriesList.toArray(new IClasspathEntry[entriesList.size()]);
        } else if (ACCELEO_CLASSPATH_CONTAINER_PATH_PARSER.equals((Object)this.path)) {
            ArrayList<IClasspathEntry> entriesList = new ArrayList<IClasspathEntry>();
            entriesList.addAll(AcceleoClasspathContainer.getAcceleoParserLibraryEntry());
            entries = entriesList.toArray(new IClasspathEntry[entriesList.size()]);
        } else if (ACCELEO_CLASSPATH_CONTAINER_PATH_RUNTIME.equals((Object)this.path)) {
            HashSet<IClasspathEntry> entriesSet = new HashSet<IClasspathEntry>();
            entriesSet.addAll(AcceleoClasspathContainer.getAcceleoEngineLibraryEntry());
            entriesSet.addAll(AcceleoClasspathContainer.getAcceleoParserLibraryEntry());
            entries = entriesSet.toArray(new IClasspathEntry[entriesSet.size()]);
        }
        return entries;
    }

    public String getDescription() {
        String description = AcceleoUIMessages.getString("AcceleoClasspathContainer.RuntimeDescription");
        if (ACCELEO_CLASSPATH_CONTAINER_PATH_ENGINE.equals((Object)this.path)) {
            description = AcceleoUIMessages.getString("AcceleoClasspathContainer.EngineDescription");
        } else if (ACCELEO_CLASSPATH_CONTAINER_PATH_PARSER.equals((Object)this.path)) {
            description = AcceleoUIMessages.getString("AcceleoClasspathContainer.ParserDescription");
        }
        return description;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }

    public static List<IClasspathEntry> getAcceleoParserLibraryEntry() {
        ArrayList<IClasspathEntry> libraryEntries = new ArrayList<IClasspathEntry>();
        IClasspathEntry classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.acceleo.parser");
        if (classpathEntry != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.acceleo.common")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.acceleo.model")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.emf.ecore")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.emf.ecore.xmi")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.emf.common")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.ocl.ecore")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.ocl")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("lpg.runtime.java")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.core.runtime")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.osgi")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.equinox.common")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.core.jobs")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.equinox.registry")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.equinox.preferences")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.core.contenttype")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.equinox.app")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.apache.ant")) != null) {
            libraryEntries.add(classpathEntry);
        }
        return libraryEntries;
    }

    public static List<IClasspathEntry> getAcceleoEngineLibraryEntry() {
        ArrayList<IClasspathEntry> libraryEntries = new ArrayList<IClasspathEntry>();
        IClasspathEntry classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.acceleo.engine");
        if (classpathEntry != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.acceleo.profiler")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.acceleo.common")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.acceleo.model")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.emf.ecore")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.emf.ecore.xmi")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.emf.common")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.ocl.ecore")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("org.eclipse.ocl")) != null) {
            libraryEntries.add(classpathEntry);
        }
        if ((classpathEntry = AcceleoClasspathContainer.computeEntryFromClass("lpg.runtime.java")) != null) {
            libraryEntries.add(classpathEntry);
        }
        return libraryEntries;
    }

    private static IClasspathEntry computeEntryFromClass(String name) {
        try {
            Bundle bundle = Platform.getBundle((String)name);
            if (bundle != null && bundle.getResource("/") != null) {
                String bundlePath = FileLocator.resolve((URL)bundle.getResource("/")).toString();
                if (bundlePath.startsWith("jar:file:")) {
                    bundlePath = bundlePath.substring("jar:file:".length());
                } else if (bundlePath.startsWith("file:")) {
                    bundlePath = bundlePath.substring("file:".length());
                }
                if (bundlePath.endsWith("!/")) {
                    bundlePath = bundlePath.substring(0, bundlePath.length() - "!/".length());
                }
                return JavaCore.newLibraryEntry((IPath)new Path(bundlePath), null, null, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])new IClasspathAttribute[0], (boolean)false);
            }
        }
        catch (IOException e) {
            AcceleoUIActivator.log(e, true);
        }
        return null;
    }
}

