/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.environment;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.emf.common.EMFPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoPropertiesLookup {
    private final List<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
    private final Map<String, List<ResourceBundle>> bundlesByFileName = new HashMap<String, List<ResourceBundle>>();
    private final Properties customProperties = new Properties();

    public void addProperties(PropertyResourceBundle resourceBundle, String fileName) {
        List<ResourceBundle> nameSakes = this.bundlesByFileName.get(fileName);
        if (nameSakes == null) {
            nameSakes = new ArrayList<ResourceBundle>();
            this.bundlesByFileName.put(fileName, nameSakes);
        }
        nameSakes.add(resourceBundle);
        this.bundles.add(resourceBundle);
    }

    public void addProperties(Map<String, String> customProps) {
        this.customProperties.putAll(customProps);
    }

    public void addProperties(String propertiesHolder) throws MissingResourceException {
        ResourceBundle bundle = EMFPlugin.IS_ECLIPSE_RUNNING ? AcceleoWorkspaceUtil.INSTANCE.getResourceBundle(propertiesHolder) : ResourceBundle.getBundle(propertiesHolder);
        String fileName = propertiesHolder;
        if (fileName.lastIndexOf(46) != -1) {
            fileName = fileName.substring(fileName.lastIndexOf(46) + 1);
        }
        fileName = String.valueOf(fileName) + ".properties";
        this.bundles.add(bundle);
        List<ResourceBundle> nameSakes = this.bundlesByFileName.get(fileName);
        if (nameSakes == null) {
            nameSakes = new ArrayList<ResourceBundle>();
            this.bundlesByFileName.put(fileName, nameSakes);
        }
        nameSakes.add(bundle);
    }

    public String getProperty(String key) {
        if (this.customProperties.containsKey(key)) {
            return this.customProperties.getProperty(key);
        }
        ResourceBundle bundle = null;
        for (ResourceBundle candidate : this.bundles) {
            if (!this.containsKey(candidate, key)) continue;
            bundle = candidate;
            break;
        }
        String value = null;
        if (bundle != null) {
            value = bundle.getString(key);
        }
        if (value == null) {
            if (EMFPlugin.IS_ECLIPSE_RUNNING && AcceleoPreferences.isDebugMessagesEnabled()) {
                AcceleoEnginePlugin.log(AcceleoEngineMessages.getString("AcceleoPropertiesLookup.PropertiesNotFound", key), false);
            }
            value = "";
        }
        return value;
    }

    public String getProperty(String propertiesFileName, String key) {
        if (this.customProperties.containsKey(key)) {
            return this.customProperties.getProperty(key);
        }
        String soughtPropertiesFile = propertiesFileName;
        String propertiesExtension = ".properties";
        if (!propertiesFileName.endsWith(propertiesExtension)) {
            soughtPropertiesFile = String.valueOf(soughtPropertiesFile) + propertiesExtension;
        }
        List<ResourceBundle> candidates = this.bundlesByFileName.get(soughtPropertiesFile);
        ResourceBundle bundle = null;
        if (candidates != null) {
            for (ResourceBundle candidate : candidates) {
                if (!this.containsKey(candidate, key)) continue;
                bundle = candidate;
                break;
            }
        }
        String value = null;
        if (bundle != null) {
            value = bundle.getString(key);
        }
        if (value == null) {
            if (EMFPlugin.IS_ECLIPSE_RUNNING && AcceleoPreferences.isDebugMessagesEnabled()) {
                AcceleoEnginePlugin.log(AcceleoEngineMessages.getString("AcceleoPropertiesLookup.PropertiesNotFound", key), false);
            }
            value = "";
        }
        return value;
    }

    private boolean containsKey(ResourceBundle bundle, String lookup) {
        Enumeration<String> enumeration = bundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            if (!key.equals(lookup)) continue;
            return true;
        }
        return false;
    }
}

