/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.newfile.main;

import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class AcceleoNewMainTemplateWizardPage
extends WizardPage {
    private static final String DEFAULT_MAIN_TEMPLATE_NAME = "main";
    private Text templateContainer;
    private Text templateName;
    private String selectedContainer;

    public AcceleoNewMainTemplateWizardPage(String selectedContainer) {
        super(AcceleoUIMessages.getString("AcceleoNewMainTemplateWizardPage.Name"));
        this.selectedContainer = selectedContainer;
        this.setTitle(AcceleoUIMessages.getString("AcceleoNewMainTemplateWizardPage.Title1"));
        this.setDescription(AcceleoUIMessages.getString("AcceleoNewMainTemplateWizardPage.Description", "mtl"));
        this.setImageDescriptor(AcceleoUIActivator.getImageDescriptor("icons/AcceleoWizard.gif"));
    }

    public void createControl(Composite parent) {
        Composite rootContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootContainer.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 128;
        gridData = new GridData(1808);
        gridData.heightHint = 420;
        rootContainer.setLayoutData((Object)gridData);
        this.createTemplateGroup(rootContainer);
        this.setControl((Control)rootContainer);
        this.dialogChanged();
    }

    private void createTemplateGroup(Composite rootContainer) {
        Composite templateGroup = new Composite(rootContainer, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        templateGroup.setLayout((Layout)layout);
        templateGroup.setLayoutData((Object)new GridData(1808));
        this.createTemplateContainerComposite(templateGroup);
        this.createTemplateContainerName(templateGroup);
    }

    private void createTemplateContainerName(Composite templateGroup) {
        GridData gridData = new GridData(768);
        Label nameLabel = new Label(templateGroup, 0);
        nameLabel.setText(String.valueOf(AcceleoUIMessages.getString("AcceleoNewMainTemplateWizardPage.TemplateName")) + ':');
        this.templateName = new Text(templateGroup, 2052);
        this.templateName.setText(DEFAULT_MAIN_TEMPLATE_NAME);
        gridData = new GridData(768);
        gridData.widthHint = 270;
        gridData.horizontalSpan = 2;
        this.templateName.setLayoutData((Object)gridData);
        this.templateName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoNewMainTemplateWizardPage.this.dialogChanged();
            }
        });
    }

    private void createTemplateContainerComposite(Composite templateGroup) {
        Label label = new Label(templateGroup, 0);
        label.setText(String.valueOf(AcceleoUIMessages.getString("AcceleoNewMainTemplateWizardPage.TemplateContainer")) + ':');
        this.templateContainer = new Text(templateGroup, 2052);
        GridData gd = new GridData(768);
        this.templateContainer.setLayoutData((Object)gd);
        this.templateContainer.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoNewMainTemplateWizardPage.this.dialogChanged();
            }
        });
        if (this.selectedContainer != null) {
            this.templateContainer.setText(this.selectedContainer);
        }
        Button button = new Button(templateGroup, 8);
        button.setText(AcceleoUIMessages.getString("AcceleoNewMainTemplateWizardPage.Browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcceleoNewMainTemplateWizardPage.this.handleBrowseWorkspace();
            }
        });
    }

    private void handleBrowseWorkspace() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, AcceleoUIMessages.getString("AcceleoNewMainTemplateWizardPage.ContainerSelection"));
        IResource current = null;
        Path path = new Path(this.getTemplateContainer());
        while (current == null && path.segmentCount() > 0) {
            current = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (current != null) continue;
            path = path.removeLastSegments(1);
        }
        if (current != null) {
            dialog.setInitialSelections(new Object[]{current});
        }
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.templateContainer.setText(((Path)result[0]).toString());
        }
    }

    public void dialogChanged() {
        Path containerPath = new Path(this.getTemplateContainer());
        String fileName = this.getTemplateName();
        if (containerPath.segmentCount() == 0) {
            this.updateStatus(AcceleoUIMessages.getString("AcceleoNewMainTemplateWizardPage.Error.MissingContainer"));
        } else if (ResourcesPlugin.getWorkspace().getRoot().getProject(containerPath.segment(0)).exists() && !ResourcesPlugin.getWorkspace().getRoot().getProject(containerPath.segment(0)).isAccessible()) {
            this.updateStatus(AcceleoUIMessages.getString("AcceleoNewMainTemplateWizardPage.Error.ReadOnly"));
        } else if (fileName.length() == 0) {
            this.updateStatus(AcceleoUIMessages.getString("AcceleoNewMainTemplateWizardPage.Error.MissingFileName"));
        } else if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus(AcceleoUIMessages.getString("AcceleoNewMainTemplateWizardPage.Error.InvalidFileName"));
        } else if (ResourcesPlugin.getWorkspace().getRoot().exists(containerPath.append(fileName).addFileExtension("mtl"))) {
            this.updateStatus(AcceleoUIMessages.getString("AcceleoNewMainTemplateWizardPage.Error.ExistingFile", fileName));
        } else {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(containerPath.append(fileName));
            if (file.getProject().isAccessible() && new AcceleoProject(file.getProject()).getOutputFilePath(file) == null) {
                this.updateStatus(AcceleoUIMessages.getString("AcceleoNewMainTemplateWizardPage.Error.JavaFolder"));
            } else {
                this.updateStatus(null);
            }
        }
    }

    public void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getTemplateContainer() {
        if (this.templateContainer != null && this.templateContainer.getText() != null) {
            return this.templateContainer.getText();
        }
        return "";
    }

    public String getTemplateName() {
        if (this.templateName != null && this.templateName.getText() != null) {
            return this.templateName.getText();
        }
        return "";
    }
}

