/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.rules;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.ISequenceRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class KeywordSequenceRule
implements ISequenceRule {
    private static final String ANY_WORD = "*";
    private String keyword;
    private String[] precedingDelimiters;
    private String precedingDelimiter;
    private String[] followingDelimiters;
    private String followingDelimiter;
    private final IToken token;

    public KeywordSequenceRule(String keyword, IToken token) {
        this.keyword = keyword;
        this.token = token;
    }

    public KeywordSequenceRule(String precedingDelimiter, String keyword, String followingDelimiter, IToken token) {
        this(keyword, token);
        this.precedingDelimiter = precedingDelimiter;
        this.followingDelimiter = followingDelimiter;
    }

    public KeywordSequenceRule(String[] precedingDelimiters, String keyword, String[] followingDelimiters, IToken token) {
        this(keyword, token);
        this.precedingDelimiters = precedingDelimiters;
        this.followingDelimiters = followingDelimiters;
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        if (this.read(scanner) > 0) {
            return this.token;
        }
        return Token.UNDEFINED;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.evaluate(scanner);
    }

    public int read(ICharacterScanner scanner) {
        int n;
        boolean result = true;
        int shift = 0;
        ArrayList<String> actualDelimiters = new ArrayList<String>();
        if (this.precedingDelimiters != null) {
            String[] stringArray = this.precedingDelimiters;
            n = this.precedingDelimiters.length;
            int n2 = 0;
            while (n2 < n) {
                String preceding = stringArray[n2];
                actualDelimiters.add(preceding);
                ++n2;
            }
        }
        if (this.precedingDelimiter != null) {
            actualDelimiters.add(this.precedingDelimiter);
        }
        Collections.reverse(actualDelimiters);
        for (String delim : actualDelimiters) {
            shift -= this.unreadWhitespace(scanner);
            if (ANY_WORD.equals(delim)) {
                int c = this.unreadChar(scanner);
                --shift;
                while (c != -1 && Character.isJavaIdentifierPart(c) && scanner.getColumn() > 0) {
                    c = this.unreadChar(scanner);
                    --shift;
                }
                continue;
            }
            int i = 0;
            while (result && i < delim.length()) {
                --shift;
                int c = this.unreadChar(scanner);
                char at = delim.charAt(delim.length() - i - 1);
                if (c == -1 || c != at) {
                    result = false;
                }
                ++i;
            }
        }
        while (shift < 0) {
            scanner.read();
            ++shift;
        }
        if (result) {
            shift += this.readWhitespace(scanner);
        }
        int i = 0;
        while (result && i < this.keyword.length()) {
            ++shift;
            int c2 = scanner.read();
            char at = this.keyword.charAt(i);
            if (c2 == -1 || c2 != at) {
                result = false;
            }
            ++i;
        }
        if (result) {
            actualDelimiters = new ArrayList();
            if (this.followingDelimiters != null) {
                String[] c = this.followingDelimiters;
                n = this.followingDelimiters.length;
                int c2 = 0;
                while (c2 < n) {
                    String preceding = c[c2];
                    actualDelimiters.add(preceding);
                    ++c2;
                }
            }
            if (this.followingDelimiter != null) {
                actualDelimiters.add(this.followingDelimiter);
            }
            if (actualDelimiters.size() > 0 && !this.isWhitespace((String)actualDelimiters.get(0))) {
                shift += this.readWhitespace(scanner);
            }
            int followingShift = 0;
            for (String delim : actualDelimiters) {
                if (ANY_WORD.equals(delim)) {
                    int c = scanner.read();
                    ++followingShift;
                    while (c != -1 && Character.isJavaIdentifierPart(c) && scanner.getColumn() > 0) {
                        c = scanner.read();
                        ++followingShift;
                    }
                    continue;
                }
                int i2 = 0;
                while (result && i2 < delim.length()) {
                    int c = scanner.read();
                    ++followingShift;
                    char at = delim.charAt(i2);
                    if (c == -1 || c != at) {
                        result = false;
                    }
                    ++i2;
                }
            }
            while (followingShift > 0) {
                scanner.unread();
                --followingShift;
            }
        }
        if (!result) {
            while (shift > 0) {
                scanner.unread();
                --shift;
            }
        }
        return shift;
    }

    private int unreadChar(ICharacterScanner scanner) {
        scanner.unread();
        int c = scanner.read();
        scanner.unread();
        return c;
    }

    private int unreadWhitespace(ICharacterScanner scanner) {
        int c = this.unreadChar(scanner);
        int n = 0;
        while (c != -1 && Character.isWhitespace(c)) {
            ++n;
            c = this.unreadChar(scanner);
        }
        scanner.read();
        return n;
    }

    private int readWhitespace(ICharacterScanner scanner) {
        int c = scanner.read();
        int n = 0;
        while (c != -1 && Character.isWhitespace(c)) {
            ++n;
            c = scanner.read();
        }
        scanner.unread();
        return n;
    }

    private boolean isWhitespace(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isWhitespace(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

