/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.acceleo.common.AcceleoCommonMessages;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.acceleo.common.internal.utils.AcceleoDynamicMetamodelResourceSetImpl;
import org.eclipse.acceleo.common.internal.utils.AcceleoPackageRegistry;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelUtils {
    private static final String ENCODING_PROPERTY = "file.encoding";
    private static final String LOADING_ERROR_KEY = "ModelUtils.LoadingError";

    private ModelUtils() {
    }

    public static Resource attachResource(URI resourceURI, EObject root) {
        if (root == null || resourceURI == null) {
            throw new NullPointerException(AcceleoCommonMessages.getString("ModelUtils.NullRoot"));
        }
        Resource newResource = ModelUtils.createResource(resourceURI);
        newResource.getContents().add((Object)root);
        return newResource;
    }

    public static Resource attachResource(URI resourceURI, ResourceSet resourceSet, EObject root) {
        if (root == null || resourceURI == null) {
            throw new NullPointerException(AcceleoCommonMessages.getString("ModelUtils.NullRoot"));
        }
        Resource newResource = ModelUtils.createResource(resourceURI, resourceSet);
        newResource.getContents().add((Object)root);
        return newResource;
    }

    public static Resource createResource(URI modelURI) {
        return ModelUtils.createResource(modelURI, (ResourceSet)new ResourceSetImpl());
    }

    public static Resource createResource(URI modelURI, ResourceSet resourceSet) {
        ModelUtils.ensureResourceFactoryPresent(resourceSet);
        return resourceSet.createResource(modelURI, "org.eclipse.acceleo.model.content.emtl.xmi");
    }

    public static Resource createBinaryResource(URI modelURI, ResourceSet resourceSet) {
        ModelUtils.ensureResourceFactoryPresent(resourceSet);
        return resourceSet.createResource(modelURI, "org.eclipse.acceleo.model.content.emtl.binary");
    }

    public static List<EObject> getModelsFrom(File directory, ResourceSet resourceSet) throws IOException {
        return ModelUtils.getModelsFrom(directory, null, resourceSet);
    }

    public static List<EObject> getModelsFrom(File directory, String extension, ResourceSet resourceSet) throws IOException {
        ArrayList<EObject> models = new ArrayList<EObject>();
        String fileExtension = extension != null ? extension : "";
        Object theResourceSet = resourceSet == null ? new ResourceSetImpl() : resourceSet;
        if (directory.exists() && directory.isDirectory() && directory.listFiles() != null) {
            File[] files = directory.listFiles();
            int i = 0;
            while (i < files.length) {
                File aFile = files[i];
                if (!aFile.isDirectory() && aFile.getName().matches("[^.].*?\\Q" + fileExtension + "\\E")) {
                    models.add(ModelUtils.load(aFile, theResourceSet));
                }
                ++i;
            }
        }
        return models;
    }

    public static EObject load(File file, ResourceSet resourceSet) throws IOException {
        return ModelUtils.load(URI.createFileURI((String)file.getPath()), resourceSet);
    }

    public static EObject load(InputStream stream, String fileName, ResourceSet resourceSet) throws IOException {
        if (stream == null) {
            throw new NullPointerException(AcceleoCommonMessages.getString("ModelUtils.NullInputStream"));
        }
        EObject result = null;
        Resource modelResource = ModelUtils.createResource(URI.createURI((String)fileName), resourceSet);
        modelResource.load(stream, Collections.emptyMap());
        if (modelResource.getContents().size() > 0) {
            result = (EObject)modelResource.getContents().get(0);
        }
        EList errors = modelResource.getErrors();
        for (Resource.Diagnostic diagnostic : errors) {
            if (diagnostic == null) continue;
            String errorMessage = AcceleoCommonMessages.getString(LOADING_ERROR_KEY, fileName);
            errorMessage = String.valueOf(errorMessage) + '\n' + ModelUtils.diagnosticString(diagnostic);
            AcceleoCommonPlugin.log(errorMessage, false);
        }
        return result;
    }

    public static EObject load(String path, ResourceSet resourceSet) throws IOException {
        EObject result;
        if (path == null || "".equals(path)) {
            throw new IllegalArgumentException(AcceleoCommonMessages.getString("ModelUtils.NullPath"));
        }
        if (path.startsWith("platform")) {
            result = ModelUtils.load(URI.createURI((String)path), resourceSet);
        } else {
            EObject temp = null;
            try {
                temp = ModelUtils.load(URI.createPlatformPluginURI((String)path, (boolean)true), resourceSet);
            }
            catch (IOException iOException) {
                try {
                    temp = ModelUtils.load(URI.createPlatformResourceURI((String)path, (boolean)true), resourceSet);
                }
                catch (IOException iOException2) {}
            }
            result = temp;
        }
        if (result == null) {
            throw new IOException(AcceleoCommonMessages.getString("ModelUtils.LoadFailure", path));
        }
        if (result.eResource() != null) {
            EList errors = result.eResource().getErrors();
            for (Resource.Diagnostic diagnostic : errors) {
                if (diagnostic == null) continue;
                String errorMessage = AcceleoCommonMessages.getString(LOADING_ERROR_KEY, path);
                errorMessage = String.valueOf(errorMessage) + '\n' + ModelUtils.diagnosticString(diagnostic);
                AcceleoCommonPlugin.log(errorMessage, false);
            }
        }
        return result;
    }

    public static EObject load(URI modelURI, ResourceSet resourceSet) throws IOException {
        return ModelUtils.load(modelURI, resourceSet, false);
    }

    public static EObject load(URI modelURI, ResourceSet resourceSet, boolean resolve) throws IOException {
        Resource modelResource;
        ModelUtils.ensureResourceFactoryPresent(resourceSet);
        String fileExtension = modelURI.fileExtension();
        ModelUtils.ensureDefaultResourceFactoryPresent(resourceSet, fileExtension);
        EObject result = null;
        if (resolve) {
            modelResource = resourceSet.getResource(modelURI, false);
            if (!modelResource.isLoaded()) {
                modelResource.load(resourceSet.getLoadOptions());
                EcoreUtil.resolveAll((Resource)modelResource);
            }
        } else {
            modelResource = resourceSet.getResource(modelURI, true);
        }
        if (modelResource.getContents().size() > 0) {
            result = (EObject)modelResource.getContents().get(0);
        }
        EList errors = modelResource.getErrors();
        for (Resource.Diagnostic diagnostic : errors) {
            if (diagnostic == null) continue;
            String errorMessage = AcceleoCommonMessages.getString(LOADING_ERROR_KEY, modelURI.toString());
            errorMessage = String.valueOf(errorMessage) + '\n' + ModelUtils.diagnosticString(diagnostic);
            AcceleoCommonPlugin.log(errorMessage, false);
        }
        return result;
    }

    private static String diagnosticString(Resource.Diagnostic diagnostic) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(AcceleoCommonMessages.getString("ModelUtils.DiagnosticMessage", diagnostic.getMessage()));
        buffer.append('\n');
        buffer.append(AcceleoCommonMessages.getString("ModelUtils.DiagnosticLocation", diagnostic.getLocation(), diagnostic.getLine(), diagnostic.getColumn()));
        return buffer.toString();
    }

    public static void save(EObject root, String path) throws IOException {
        if (root == null) {
            throw new NullPointerException(AcceleoCommonMessages.getString("ModelUtils.NullSaveRoot"));
        }
        Resource newModelResource = ModelUtils.createResource(URI.createFileURI((String)path));
        newModelResource.getContents().add((Object)root);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", System.getProperty(ENCODING_PROPERTY));
        newModelResource.save(options);
    }

    public static String serialize(EObject root) throws IOException {
        if (root == null) {
            throw new NullPointerException(AcceleoCommonMessages.getString("ModelUtils.NullSaveRoot"));
        }
        EObject copyRoot = EcoreUtil.copy((EObject)root);
        ModelUtils.attachResource(URI.createFileURI((String)"resource.xml"), copyRoot);
        StringWriter writer = new StringWriter();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", System.getProperty(ENCODING_PROPERTY));
        ((XMLResource)copyRoot.eResource()).save((Writer)writer, options);
        String result = writer.toString();
        writer.flush();
        return result;
    }

    public static EPackage getEPackage(String nsURI) {
        try {
            return AcceleoPackageRegistry.INSTANCE.getEPackage(nsURI);
        }
        catch (WrappedException wrappedException) {
            return null;
        }
    }

    public static Object getEPackageOrDescriptor(String nsURI) {
        try {
            Object found = AcceleoPackageRegistry.INSTANCE.get(nsURI);
            if (found == null) {
                found = AcceleoPackageRegistry.INSTANCE.getEPackage(nsURI);
            }
            return found;
        }
        catch (WrappedException wrappedException) {
            return null;
        }
    }

    @Deprecated
    public static String registerEcorePackages(String pathName) {
        return AcceleoPackageRegistry.INSTANCE.registerEcorePackages(pathName, AcceleoDynamicMetamodelResourceSetImpl.DYNAMIC_METAMODEL_RESOURCE_SET);
    }

    @Deprecated
    public static String getRegisteredEcorePackagePath(String nsURI) {
        return AcceleoPackageRegistry.INSTANCE.getRegisteredEcorePackagePath(nsURI);
    }

    private static void ensureDefaultResourceFactoryPresent(ResourceSet resourceSet, String extension) {
        Object resourceFactory;
        if ("emtl".equals(extension)) {
            return;
        }
        String fileExtension = extension;
        if (fileExtension == null || fileExtension.length() == 0) {
            fileExtension = "*";
        }
        if ((resourceFactory = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().get(fileExtension)) == null) {
            resourceFactory = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().get(fileExtension);
            if (resourceFactory != null) {
                resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, resourceFactory);
            } else {
                resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, new XMIResourceFactoryImpl());
            }
        }
    }

    private static void ensureResourceFactoryPresent(ResourceSet resourceSet) {
        if (resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap().get("org.eclipse.acceleo.model.content.emtl.xmi") == null || resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap().get("org.eclipse.acceleo.model.content.emtl.binary") == null) {
            Object xmiFactory;
            Object binaryFactory = Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap().get("org.eclipse.acceleo.model.content.emtl.binary");
            if (binaryFactory == null) {
                Object binaryResourceFactory = Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap().get("org.eclipse.acceleo.model.content.emtl.binary");
                resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap().put("org.eclipse.acceleo.model.content.emtl.binary", binaryResourceFactory);
            }
            if ((xmiFactory = Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap().get("org.eclipse.acceleo.model.content.emtl.xmi")) == null) {
                Object xmiResourceFactory = Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap().get("org.eclipse.acceleo.model.content.emtl.xmi");
                resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap().put("org.eclipse.acceleo.model.content.emtl.xmi", xmiResourceFactory);
            }
        }
        if (resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().get("xmi") == null) {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        }
    }
}

