/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.environment;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.internal.utils.workspace.BundleURLConverter;
import org.eclipse.acceleo.common.utils.AcceleoCollections;
import org.eclipse.acceleo.common.utils.CircularArrayDeque;
import org.eclipse.acceleo.common.utils.CompactHashSet;
import org.eclipse.acceleo.common.utils.CompactLinkedHashSet;
import org.eclipse.acceleo.common.utils.Deque;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.internal.environment.AcceleoPropertiesLookup;
import org.eclipse.acceleo.engine.internal.environment.DynamicModulesURIConverter;
import org.eclipse.acceleo.engine.service.AcceleoDynamicTemplatesRegistry;
import org.eclipse.acceleo.engine.service.AcceleoModulePropertiesAdapter;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ecore.AnyType;
import org.eclipse.ocl.ecore.BagType;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.EcoreEvaluationEnvironment;
import org.eclipse.ocl.ecore.OrderedSetType;
import org.eclipse.ocl.ecore.SequenceType;
import org.eclipse.ocl.ecore.SetType;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.options.EvaluationOptions;
import org.eclipse.ocl.util.Bag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoEvaluationEnvironment
extends EcoreEvaluationEnvironment {
    private static final Object NULL_ARGUMENT = new Object();
    private static final String TEMPORARY_CONTEXT_VAR_PREFIX = "context$";
    private static final String TEMPORARY_INVOCATION_ARG_PREFIX = "temporaryInvocationVariable$";
    private final Set<Module> currentModules = new CompactHashSet();
    private final SetMultimap<Template, Template> dynamicOverrides = AcceleoCollections.newCompactLinkedHashSetMultimap();
    private final SetMultimap<Template, Template> overridingTemplates = AcceleoCollections.newCompactLinkedHashSetMultimap();
    private AcceleoPropertiesLookup propertiesLookup;
    private final SetMultimap<String, Template> templates = AcceleoCollections.newCompactLinkedHashSetMultimap();
    private final Deque<ListMultimap<String, Object>> scopedVariableMap = new CircularArrayDeque();
    private final ListMultimap<String, Object> globalVariableMap = AcceleoCollections.newCircularArrayDequeMultimap();

    public AcceleoEvaluationEnvironment(EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> parent, Module module, AcceleoPropertiesLookup properties) {
        super(parent);
        this.scopedVariableMap.add((Object)AcceleoCollections.newCircularArrayDequeMultimap());
        this.mapAllTemplates(module);
        AcceleoModulePropertiesAdapter adapter = (AcceleoModulePropertiesAdapter)EcoreUtil.getAdapter((List)module.eAdapters(), AcceleoModulePropertiesAdapter.class);
        if (adapter == null || !adapter.getProperties().contains("DISABLE_DYNAMIC_MODULES")) {
            this.mapDynamicOverrides();
        }
        this.setOption(EvaluationOptions.LAX_NULL_HANDLING, Boolean.FALSE);
        this.propertiesLookup = properties;
    }

    public AcceleoEvaluationEnvironment(Module module, AcceleoPropertiesLookup properties) {
        this.scopedVariableMap.add((Object)AcceleoCollections.newCircularArrayDequeMultimap());
        this.mapAllTemplates(module);
        AcceleoModulePropertiesAdapter adapter = (AcceleoModulePropertiesAdapter)EcoreUtil.getAdapter((List)module.eAdapters(), AcceleoModulePropertiesAdapter.class);
        if (adapter == null || !adapter.getProperties().contains("DISABLE_DYNAMIC_MODULES")) {
            this.mapDynamicOverrides();
        }
        this.setOption(EvaluationOptions.LAX_NULL_HANDLING, Boolean.FALSE);
        this.propertiesLookup = properties;
    }

    private static <V> V getLast(List<V> values) {
        ListIterator<V> iterator = values.listIterator(values.size());
        return iterator.previous();
    }

    private static <V> V removeLast(List<V> values) {
        ListIterator<V> iterator = values.listIterator(values.size());
        V last = iterator.previous();
        iterator.remove();
        return last;
    }

    public void add(String name, Object value) {
        ListMultimap variableMap = name.startsWith(TEMPORARY_CONTEXT_VAR_PREFIX) || name.startsWith(TEMPORARY_INVOCATION_ARG_PREFIX) ? this.globalVariableMap : (ListMultimap)this.scopedVariableMap.getLast();
        variableMap.put((Object)name, value);
    }

    public Object callOperation(EOperation operation, int opcode, Object source, Object[] args) {
        Object result = null;
        result = operation.getEType() == EcorePackage.eINSTANCE.getEJavaObject() ? this.callOperationWorkaround287052(operation, opcode, source, args) : super.callOperation(operation, opcode, source, args);
        return result;
    }

    private Object callOperationWorkaround287052(EOperation operation, int opcode, Object source, Object[] args) throws IllegalArgumentException {
        Object noResult;
        if (this.getParent() != null) {
            return this.getParent().callOperation((Object)operation, opcode, source, args);
        }
        Method method = this.getJavaMethodFor(operation, source);
        Object result = noResult = new Object();
        if (method != null) {
            try {
                Class<?>[] parmTypes = method.getParameterTypes();
                int i = 0;
                while (i < parmTypes.length) {
                    if (EList.class.isAssignableFrom(parmTypes[i])) {
                        if (args[i] == null) {
                            args[i] = ECollections.EMPTY_ELIST;
                        } else if (!(args[i] instanceof Collection)) {
                            BasicEList.FastCompare list = new BasicEList.FastCompare(1);
                            list.add(args[i]);
                            args[i] = list;
                        } else if (!(args[i] instanceof EList)) {
                            args[i] = new BasicEList.FastCompare((Collection)args[i]);
                        }
                    }
                    ++i;
                }
                result = method.invoke(source, args);
            }
            catch (Exception e) {
                AcceleoEnginePlugin.log(e, false);
                result = this.getInvalidResult();
            }
        }
        if (result == noResult) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public void clear() {
        super.clear();
        this.scopedVariableMap.clear();
        this.globalVariableMap.clear();
    }

    public void createVariableScope() {
        this.scopedVariableMap.add((Object)AcceleoCollections.newCircularArrayDequeMultimap());
    }

    public List<Template> getAllCandidates(Module origin, Template call, Object[] arguments) {
        ArrayList<Object> argumentTypes = new ArrayList<Object>(arguments.length);
        int i = 0;
        while (i < arguments.length) {
            if (arguments[i] instanceof EObject) {
                argumentTypes.add(((EObject)arguments[i]).eClass());
            } else if (arguments[i] != null) {
                argumentTypes.add(arguments[i].getClass());
            } else {
                argumentTypes.add(NULL_ARGUMENT);
            }
            ++i;
        }
        List<Template> orderedNamesakes = this.reorderCandidatesPriority(origin, this.getAllCandidateNamesakes(origin, call, argumentTypes));
        List<Template> dynamicOverriding = this.reorderDynamicOverrides(this.getAllDynamicCandidateOverriding(orderedNamesakes, argumentTypes));
        List<Template> overriding = this.getAllCandidateOverriding(origin, orderedNamesakes, argumentTypes);
        return Lists.newArrayList((Iterable)Iterables.concat(dynamicOverriding, overriding, orderedNamesakes));
    }

    /*
     * Unable to fully structure code
     */
    public Template getMostSpecificTemplate(Iterable<Template> candidates, Object[] arguments) {
        candidateIterator = candidates.iterator();
        mostSpecific = candidateIterator.next();
        if (candidateIterator.hasNext()) ** GOTO lbl6
        return mostSpecific;
lbl-1000:
        // 1 sources

        {
            mostSpecific = this.mostSpecificTemplate(mostSpecific, candidateIterator.next(), arguments);
lbl6:
            // 2 sources

            ** while (candidateIterator.hasNext())
        }
lbl7:
        // 1 sources

        return mostSpecific;
    }

    public AcceleoPropertiesLookup getPropertiesLookup() {
        return this.propertiesLookup;
    }

    public Map<String, Object> getCurrentVariables() {
        ListMultimap variableMap = (ListMultimap)this.scopedVariableMap.getLast();
        HashMap<String, Object> availableVariables = new HashMap<String, Object>();
        for (String key : variableMap.keys()) {
            List values = variableMap.get((Object)key);
            availableVariables.put(key, AcceleoEvaluationEnvironment.getLast(values));
        }
        return availableVariables;
    }

    public Object getInvalidResult() {
        return super.getInvalidResult();
    }

    public Object getValueOf(String name) {
        Object value = null;
        ListMultimap variableMap = (ListMultimap)this.scopedVariableMap.getLast();
        if (variableMap.containsKey((Object)name)) {
            value = AcceleoEvaluationEnvironment.getLast(variableMap.get((Object)name));
        } else if (this.globalVariableMap.containsKey((Object)name)) {
            value = AcceleoEvaluationEnvironment.getLast(this.globalVariableMap.get((Object)name));
        }
        return value;
    }

    public Object remove(String name) {
        ListMultimap<String, Object> variableMap;
        if (((ListMultimap)this.scopedVariableMap.getLast()).containsKey((Object)name)) {
            variableMap = (ListMultimap<String, Object>)this.scopedVariableMap.getLast();
        } else if (this.globalVariableMap.containsKey((Object)name)) {
            variableMap = this.globalVariableMap;
        } else {
            return null;
        }
        return AcceleoEvaluationEnvironment.removeLast(variableMap.get((Object)name));
    }

    public Map<String, Collection<Object>> removeVariableScope() {
        return ((ListMultimap)this.scopedVariableMap.removeLast()).asMap();
    }

    public void replace(String name, Object value) {
        ListMultimap variableMap = name.startsWith(TEMPORARY_CONTEXT_VAR_PREFIX) || name.startsWith(TEMPORARY_INVOCATION_ARG_PREFIX) ? this.globalVariableMap : (ListMultimap)this.scopedVariableMap.getLast();
        if (variableMap.containsKey((Object)name)) {
            AcceleoEvaluationEnvironment.removeLast(variableMap.get((Object)name));
        }
        this.add(name, value);
    }

    public String toString() {
        ListMultimap variableMap = (ListMultimap)this.scopedVariableMap.getLast();
        return variableMap.toString();
    }

    private Set<Template> applicableTemplates(Set<Template> candidates, final List<Object> argumentTypes) {
        Predicate<Template> argumentSizeMatch = new Predicate<Template>(){

            public boolean apply(Template input) {
                EList parameters = input.getParameter();
                return parameters.size() == argumentTypes.size() || parameters.isEmpty() && argumentTypes.size() == 1;
            }
        };
        Predicate<Template> argumentsMatch = new Predicate<Template>(){

            public boolean apply(Template input) {
                EList parameters = input.getParameter();
                if (parameters.isEmpty() && argumentTypes.size() == 1) {
                    return true;
                }
                boolean argumentMatch = true;
                int i = 0;
                while (i < argumentTypes.size() && argumentMatch) {
                    Variable param = (Variable)parameters.get(i);
                    Object parameterType = param.getType();
                    argumentMatch = AcceleoEvaluationEnvironment.this.isApplicableArgument(parameterType, argumentTypes.get(i));
                    ++i;
                }
                return argumentMatch;
            }
        };
        return Sets.filter(candidates, (Predicate)Predicates.and((Predicate)argumentSizeMatch, (Predicate)argumentsMatch));
    }

    private Set<Template> getAllCandidateNamesakes(Module origin, Template call, List<Object> argumentTypes) {
        CompactLinkedHashSet namesakes = new CompactLinkedHashSet();
        Set candidates = this.templates.get((Object)call.getName());
        int candidateSize = candidates.size();
        if (candidateSize == 0) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationEnvironment.ModuleResolutionError"));
        }
        Sets.SetView scope = Sets.union(Collections.singleton(origin), this.getScopeOf(origin));
        for (Template candidate : candidates) {
            if (!scope.contains(candidate.eContainer())) continue;
            namesakes.add(candidate);
        }
        if (namesakes.size() == 1) {
            return namesakes;
        }
        namesakes.retainAll(this.applicableTemplates((Set<Template>)namesakes, argumentTypes));
        return namesakes;
    }

    private Set<Module> getScopeOf(Module module) {
        CompactHashSet scope = new CompactHashSet();
        if (module.getExtends().size() > 0) {
            Module extended = (Module)module.getExtends().get(0);
            scope.add(extended);
            scope = Sets.union((Set)scope, this.getExtendedScope(extended));
        }
        EList imports = module.getImports();
        int i = 0;
        while (i < imports.size()) {
            Module importedModule = (Module)imports.get(i);
            scope = Sets.union((Set)scope, Collections.singleton(importedModule));
            scope = Sets.union((Set)scope, this.getExtendedScope(importedModule));
            ++i;
        }
        return scope;
    }

    private Set<Module> getExtendedScope(Module module) {
        CompactHashSet scope = new CompactHashSet();
        if (module.getExtends().size() > 0) {
            Module extended = (Module)module.getExtends().get(0);
            scope.add(extended);
            scope = Sets.union((Set)scope, this.getExtendedScope(extended));
        }
        return scope;
    }

    private List<Template> getAllCandidateOverriding(Module origin, List<Template> overridenTemplates, List<Object> argumentTypes) {
        ArrayList<Template> candidateOverriding = new ArrayList<Template>();
        int i = 0;
        while (i < overridenTemplates.size()) {
            Set candidates = this.overridingTemplates.get((Object)overridenTemplates.get(i));
            if (candidates != null) {
                Set<Template> applicableCandidates = this.applicableTemplates(candidates, argumentTypes);
                for (Template template : applicableCandidates) {
                    EObject eContainer = template.eContainer();
                    if (!(eContainer instanceof Module) || !this.getScopeOf(origin).contains(eContainer) && !eContainer.equals(origin)) continue;
                    candidateOverriding.add(template);
                }
                candidateOverriding.addAll(this.getAllCandidateOverriding(origin, new ArrayList<Template>(applicableCandidates), argumentTypes));
            }
            ++i;
        }
        Collections.reverse(candidateOverriding);
        return candidateOverriding;
    }

    private Set<Template> getAllDynamicCandidateOverriding(List<Template> overridenTemplates, List<Object> argumentTypes) {
        CompactLinkedHashSet dynamicOverriding = new CompactLinkedHashSet();
        int i = 0;
        while (i < overridenTemplates.size()) {
            Set candidates = this.dynamicOverrides.get((Object)overridenTemplates.get(i));
            if (candidates != null && !candidates.isEmpty()) {
                Set<Template> applicableCandidates = this.applicableTemplates(candidates, argumentTypes);
                dynamicOverriding.addAll(applicableCandidates);
            }
            ++i;
        }
        return dynamicOverriding;
    }

    Set<Module> getCurrentModules() {
        return new CompactHashSet(this.currentModules);
    }

    private boolean isApplicableArgument(Object expectedType, Object argumentType) {
        boolean isApplicable = false;
        if (argumentType == NULL_ARGUMENT) {
            isApplicable = true;
        } else if (expectedType == argumentType) {
            isApplicable = true;
        } else if (expectedType instanceof EClass && argumentType instanceof EClass) {
            isApplicable = expectedType == argumentType || this.isSubTypeOf(expectedType, argumentType);
        } else if (expectedType instanceof Class && argumentType instanceof Class) {
            isApplicable = ((Class)expectedType).isAssignableFrom((Class)argumentType);
        } else if (expectedType instanceof EDataType && argumentType instanceof Class) {
            if (expectedType instanceof BagType && argumentType instanceof Class) {
                Class clazz = (Class)argumentType;
                isApplicable = Bag.class.isAssignableFrom(clazz);
            } else if (expectedType instanceof OrderedSetType && argumentType instanceof Class) {
                Class clazz = (Class)argumentType;
                isApplicable = Set.class.isAssignableFrom(clazz);
            } else if (expectedType instanceof SetType && argumentType instanceof Class) {
                Class clazz = (Class)argumentType;
                isApplicable = Set.class.isAssignableFrom(clazz);
            } else if (expectedType instanceof SequenceType && argumentType instanceof Class) {
                Class clazz = (Class)argumentType;
                isApplicable = List.class.isAssignableFrom(clazz);
            } else if (expectedType instanceof CollectionType && argumentType instanceof Class) {
                Class clazz = (Class)argumentType;
                isApplicable = Collection.class.isAssignableFrom(clazz);
            } else {
                isApplicable = ((EDataType)expectedType).getInstanceClass() == argumentType;
            }
        } else {
            isApplicable = expectedType instanceof EEnum && argumentType instanceof EClass ? argumentType.equals(EcorePackage.eINSTANCE.getEEnumLiteral()) : (expectedType instanceof AnyType ? true : expectedType.getClass().isInstance(argumentType));
        }
        return isApplicable;
    }

    private boolean isSubTypeOf(Object superType, Object eClass) {
        boolean result = false;
        if (superType instanceof EClass && eClass instanceof EClass) {
            for (EClass candidate : ((EClass)eClass).getEAllSuperTypes()) {
                if (candidate != superType) continue;
                result = true;
                break;
            }
        } else if (superType instanceof AnyType) {
            result = true;
        }
        return result;
    }

    private Set<Module> loadDynamicModules() {
        CompactLinkedHashSet dynamicModuleFiles = new CompactLinkedHashSet();
        CompactLinkedHashSet dynamicModules = new CompactLinkedHashSet();
        ResourceSet resourceSet = null;
        for (Module module : this.currentModules) {
            if (module.eResource() == null || module.eResource().getResourceSet() == null) continue;
            resourceSet = module.eResource().getResourceSet();
            break;
        }
        if (resourceSet == null) {
            AcceleoEnginePlugin.log(AcceleoEngineMessages.getString("AcceleoEvaluationEnvironment.DynamicModulesLoadingFailure"), true);
            return dynamicModules;
        }
        if (!(resourceSet.getURIConverter() instanceof DynamicModulesURIConverter)) {
            resourceSet.setURIConverter((URIConverter)new DynamicModulesURIConverter(resourceSet.getURIConverter(), this));
        }
        EList resources = resourceSet.getResources();
        for (Resource resource : resources) {
            BundleURLConverter converter;
            URI uri = resource.getURI();
            String generatorID = uri.toString();
            if (uri.isPlatformPlugin() && uri.segments().length > 2) {
                generatorID = uri.segment(1);
            } else if (uri.isPlatformResource() && uri.segments().length > 2) {
                generatorID = uri.segment(1);
            } else if (uri.isPlatform() && uri.segments().length > 2) {
                generatorID = uri.segment(1);
            } else if ((uri.isFile() || generatorID.startsWith("jar:file:")) && (generatorID = (converter = new BundleURLConverter(generatorID)).resolveAsPlatformPlugin()) != null && generatorID.startsWith("platform:/plugin/") && URI.createURI((String)generatorID).segments().length > 2) {
                URI tmpURI = URI.createURI((String)generatorID);
                generatorID = tmpURI.segment(1);
            }
            Set<File> dynamicAcceleoModulesFiles = AcceleoDynamicTemplatesRegistry.INSTANCE.getRegisteredModules(generatorID);
            dynamicModuleFiles.addAll(dynamicAcceleoModulesFiles);
        }
        for (File moduleFile : dynamicModuleFiles) {
            if ((!moduleFile.exists() || !moduleFile.canRead()) && !moduleFile.getPath().startsWith("jar:file:")) continue;
            try {
                Resource res = ModelUtils.load((File)moduleFile, (ResourceSet)resourceSet).eResource();
                for (EObject root : res.getContents()) {
                    if (!(root instanceof Module)) continue;
                    dynamicModules.add((Module)root);
                }
            }
            catch (IOException e) {
                AcceleoEnginePlugin.log(e, false);
            }
        }
        return dynamicModules;
    }

    private void mapAllTemplates(Module module) {
        if (this.currentModules.contains(module)) {
            return;
        }
        this.currentModules.add(module);
        for (ModuleElement elem : module.getOwnedModuleElement()) {
            if (!(elem instanceof Template)) continue;
            this.templates.put((Object)elem.getName(), (Object)((Template)elem));
            this.mapOverridingTemplate((Template)elem);
        }
        for (Module extended : module.getExtends()) {
            this.mapAllTemplates(extended);
        }
        for (Module imported : module.getImports()) {
            this.mapAllTemplates(imported);
        }
    }

    private void mapDynamicModule(Module module, Set<Module> dynamicModules) {
        boolean map = false;
        CompactLinkedHashSet unMappedRequiredModules = new CompactLinkedHashSet();
        for (Module extended : module.getExtends()) {
            if (dynamicModules.contains(extended)) {
                this.mapDynamicModule(extended, dynamicModules);
            }
            if (this.currentModules.contains(extended)) {
                map = true;
                continue;
            }
            unMappedRequiredModules.add(extended);
        }
        if (!map) {
            return;
        }
        for (Module imported : module.getImports()) {
            if (this.currentModules.contains(imported)) continue;
            unMappedRequiredModules.add(imported);
        }
        for (Module required : unMappedRequiredModules) {
            this.mapAllTemplates(required);
        }
        for (ModuleElement elem : module.getOwnedModuleElement()) {
            if (!(elem instanceof Template)) continue;
            Template ownedTemplate = (Template)elem;
            for (Template overriden : ownedTemplate.getOverrides()) {
                Template match = null;
                Iterator templateIterator = this.templates.get((Object)overriden.getName()).iterator();
                while (match == null && templateIterator.hasNext()) {
                    Template template = (Template)templateIterator.next();
                    if (!EcoreUtil.equals((EObject)template, (EObject)overriden)) continue;
                    match = template;
                }
                if (match == null) continue;
                this.dynamicOverrides.put(match, (Object)ownedTemplate);
            }
            this.templates.put((Object)ownedTemplate.getName(), (Object)ownedTemplate);
        }
        this.currentModules.add(module);
    }

    private void mapDynamicOverrides() {
        if (AcceleoDynamicTemplatesRegistry.INSTANCE.getRegisteredModules().isEmpty()) {
            return;
        }
        Set<Module> dynamicModules = this.loadDynamicModules();
        for (Module module : dynamicModules) {
            this.mapDynamicModule(module, dynamicModules);
        }
    }

    private void mapOverridingTemplate(Template elem) {
        for (Template overriden : elem.getOverrides()) {
            this.overridingTemplates.put((Object)overriden, (Object)elem);
        }
    }

    private Template mostSpecificTemplate(Template template1, Template template2, Object[] actualArgumentTypes) {
        int template1SpecificArgumentCount = 0;
        int template2SpecificArgumentCount = 0;
        int i = 0;
        while (i < actualArgumentTypes.length) {
            EClassifier template2Type;
            EClassifier template1Type;
            Object actualArgumentType = actualArgumentTypes[i];
            if ((template1.getParameter().size() != 0 || template2.getParameter().size() != 0) && (template1Type = (EClassifier)((Variable)template1.getParameter().get(i)).getType()) != (template2Type = (EClassifier)((Variable)template2.getParameter().get(i)).getType())) {
                if (actualArgumentType instanceof EObject) {
                    if (this.isSubTypeOf(template1Type, template2Type)) {
                        ++template2SpecificArgumentCount;
                    } else {
                        ++template1SpecificArgumentCount;
                    }
                } else if (actualArgumentType instanceof Collection) {
                    ++template1SpecificArgumentCount;
                } else {
                    throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.ArgumentNotEObjectOrCollection", actualArgumentType));
                }
            }
            ++i;
        }
        Template mostSpecific = template1SpecificArgumentCount >= template2SpecificArgumentCount ? template1 : template2;
        return mostSpecific;
    }

    private List<Template> reorderCandidatesPriority(Module origin, Set<Template> candidates) {
        Template candidate;
        ArrayList<Template> reorderedList = new ArrayList<Template>(candidates.size());
        Iterator<Template> candidateIterator = candidates.iterator();
        while (candidateIterator.hasNext()) {
            candidate = candidateIterator.next();
            boolean isOverridingCandidate = false;
            Module module = (Module)candidate.eContainer();
            while (!isOverridingCandidate && module != null && module.getExtends().size() > 0) {
                if (module.getExtends().get(0) == origin) {
                    reorderedList.add(candidate);
                    candidateIterator.remove();
                    isOverridingCandidate = true;
                }
                module = (Module)module.getExtends().get(0);
            }
        }
        candidateIterator = candidates.iterator();
        while (candidateIterator.hasNext()) {
            candidate = candidateIterator.next();
            if (candidate.eContainer() != origin) continue;
            reorderedList.add(candidate);
            candidateIterator.remove();
        }
        candidateIterator = candidates.iterator();
        while (candidateIterator.hasNext()) {
            candidate = candidateIterator.next();
            for (Module extended : origin.getExtends()) {
                if (candidate.eContainer() != extended) continue;
                reorderedList.add(candidate);
                candidateIterator.remove();
            }
        }
        candidateIterator = candidates.iterator();
        while (candidateIterator.hasNext()) {
            candidate = candidateIterator.next();
            for (Module imported : origin.getImports()) {
                if (candidate.eContainer() != imported) continue;
                reorderedList.add(candidate);
                candidateIterator.remove();
            }
        }
        candidateIterator = candidates.iterator();
        block7: while (candidateIterator.hasNext()) {
            candidate = candidateIterator.next();
            Iterator iterator = origin.getImports().iterator();
            while (iterator.hasNext()) {
                Module imported;
                Module myImportedModule = imported = (Module)iterator.next();
                boolean shouldBreak = false;
                while (myImportedModule.getExtends().size() > 0) {
                    if (myImportedModule.getExtends().get(0) == candidate.eContainer()) {
                        reorderedList.add(candidate);
                        candidateIterator.remove();
                        shouldBreak = true;
                    }
                    myImportedModule = (Module)myImportedModule.getExtends().get(0);
                }
                if (shouldBreak) continue block7;
            }
        }
        return reorderedList;
    }

    private List<Template> reorderDynamicOverrides(Set<Template> candidates) {
        Template[] array = candidates.toArray(new Template[candidates.size()]);
        Arrays.sort(array, new TemplateComparator());
        return Arrays.asList(array);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TemplateComparator
    implements Comparator<Template> {
        private TemplateComparator() {
        }

        @Override
        public int compare(Template o1, Template o2) {
            Template currentLevel1 = o1;
            Template currentLevel2 = o2;
            boolean no1Override = currentLevel1.getOverrides().isEmpty();
            boolean no2Override = currentLevel2.getOverrides().isEmpty();
            while (!no1Override && !no2Override) {
                currentLevel1 = (Template)currentLevel1.getOverrides().get(0);
                currentLevel2 = (Template)currentLevel2.getOverrides().get(0);
                no1Override = currentLevel1.getOverrides().isEmpty();
                no2Override = currentLevel2.getOverrides().isEmpty();
            }
            int result = 0;
            if (no1Override && no2Override) {
                result = o1.getName().compareTo(o2.getName());
            } else if (no1Override) {
                result = 1;
            } else if (no2Override) {
                result = -1;
            }
            return result;
        }
    }
}

