/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoPositionedTemplate;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameTemplateDescriptor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferenceEntry;
import org.eclipse.acceleo.internal.parser.cst.utils.Region;
import org.eclipse.acceleo.internal.parser.cst.utils.Sequence;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.search.ui.text.Match;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoRenameTemplateRefactoring
extends Refactoring {
    private static final String TEMPLATE = "template";
    private static final String NEWNAME = "newName";
    private static final String REFERENCES = "references";
    protected AcceleoPositionedTemplate fTemplate;
    protected String fNewTemplateName;
    protected boolean fUpdateReferences = true;
    private final String title = AcceleoUIMessages.getString("AcceleoEditorRenameTemplateRefactoring.RenameTemplateTitle");
    private Map<IFile, TextFileChange> fChanges;
    private String fileName;

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask(AcceleoUIMessages.getString("AcceleoEditorRenameRefactoring.CheckingPreconditions"), 1);
            if (this.fTemplate == null) {
                status.merge(RefactoringStatus.createErrorStatus((String)AcceleoUIMessages.getString("AcceleoEditorRenameTemplateRefactoring.NoTemplateSpecified")));
            }
            this.fTemplate.computeOccurrencesOfTemplate();
            this.fChanges = new LinkedHashMap<IFile, TextFileChange>();
            if (this.fUpdateReferences) {
                this.putChangesNotInTheCurrentFile();
            }
            this.putChangesOfTheCurrentFile();
        }
        finally {
            monitor.done();
        }
        return status;
    }

    private void putChangesNotInTheCurrentFile() {
        for (Match match : this.fTemplate.getTemplateMatches()) {
            ReferenceEntry entry;
            if (!(match.getElement() instanceof ReferenceEntry) || (entry = (ReferenceEntry)match.getElement()).getTemplateFile().getName().equals(this.fileName)) continue;
            IFile file = entry.getTemplateFile();
            TextFileChange tfc = null;
            MultiTextEdit edit = null;
            if (this.fChanges.containsKey(file) && this.fChanges.get(file).getEdit() instanceof MultiTextEdit) {
                tfc = this.fChanges.get(file);
                edit = (MultiTextEdit)this.fChanges.get(file).getEdit();
            } else {
                tfc = new TextFileChange(this.title, file);
                edit = new MultiTextEdit();
                tfc.setEdit((TextEdit)edit);
                tfc.setTextType("mtl");
            }
            String str = ((ReferenceEntry)match.getElement()).getMessage();
            int offset = str.lastIndexOf(this.fTemplate.getTemplateName());
            StringBuffer buf = new StringBuffer(str);
            int offsetTmp = this.computeOffset(buf);
            if (offset != 0 && offsetTmp != 0) {
                offset = offsetTmp;
            }
            edit.addChild((TextEdit)new ReplaceEdit(match.getOffset() + offset, this.fTemplate.getTemplateName().length(), this.fNewTemplateName));
            this.fChanges.put(file, tfc);
        }
    }

    private void putChangesOfTheCurrentFile() {
        for (Match match : this.fTemplate.getTemplateMatches()) {
            ReferenceEntry entry;
            if (!(match.getElement() instanceof ReferenceEntry) || !(entry = (ReferenceEntry)match.getElement()).getTemplateFile().getName().equals(this.fileName)) continue;
            IFile file = entry.getTemplateFile();
            TextFileChange tfc = null;
            MultiTextEdit edit = null;
            if (this.fChanges.containsKey(file) && this.fChanges.get(file).getEdit() instanceof MultiTextEdit) {
                tfc = this.fChanges.get(file);
                edit = (MultiTextEdit)this.fChanges.get(file).getEdit();
            } else {
                tfc = new TextFileChange(this.title, file);
                edit = new MultiTextEdit();
                tfc.setEdit((TextEdit)edit);
                tfc.setTextType("mtl");
            }
            String str = ((ReferenceEntry)match.getElement()).getMessage();
            int offset = str.lastIndexOf(this.fTemplate.getTemplateName());
            StringBuffer buf = new StringBuffer(str);
            int offsetTmp = this.computeOffset(buf);
            if (offset != 0 && offsetTmp != 0) {
                offset = offsetTmp;
            }
            edit.addChild((TextEdit)new ReplaceEdit(match.getOffset() + offset, this.fTemplate.getTemplateName().length(), this.fNewTemplateName));
            this.fChanges.put(file, tfc);
        }
    }

    private int computeOffset(StringBuffer buffer) {
        int offset = 0;
        Sequence sequence = null;
        Region region = null;
        switch (this.fTemplate.getTemplate().getVisibility().getValue()) {
            case 0: {
                sequence = new Sequence(TEMPLATE, "private", this.fTemplate.getTemplateName());
                region = sequence.search(buffer);
                if (region.e() <= -1) break;
                offset = region.e() - this.fTemplate.getTemplateName().length();
                break;
            }
            case 1: {
                sequence = new Sequence(TEMPLATE, "protected", this.fTemplate.getTemplateName());
                region = sequence.search(buffer);
                if (region.e() <= -1) break;
                offset = region.e() - this.fTemplate.getTemplateName().length();
                break;
            }
            case 2: {
                sequence = new Sequence(TEMPLATE, "public", this.fTemplate.getTemplateName());
                region = sequence.search(buffer);
                if (region.e() <= -1) break;
                offset = region.e() - this.fTemplate.getTemplateName().length();
                break;
            }
        }
        return offset;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (AcceleoPositionedTemplate.getInput().length == 0) {
            status.merge(RefactoringStatus.createErrorStatus((String)AcceleoUIMessages.getString("AcceleoEditorRenameTemplateRefactoring.NoTemplateInFile")));
        }
        return status;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            CompositeChange change;
            monitor.beginTask(AcceleoUIMessages.getString("AcceleoEditorRenameRefactoring.CreatingChanges"), 1);
            Collection<TextFileChange> changes = this.fChanges.values();
            CompositeChange compositeChange = change = new CompositeChange(this.getName(), changes.toArray(new Change[changes.size()])){

                public ChangeDescriptor getDescriptor() {
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    String project = AcceleoUIMessages.getString("AcceleoEditorRenameTemplateRefactoring.RefactoringProjectName");
                    String description = String.valueOf(AcceleoUIMessages.getString("AcceleoEditorRenameTemplateRefactoring.RenamingTemplate")) + " " + AcceleoRenameTemplateRefactoring.this.fTemplate.getTemplateName();
                    String comment = AcceleoUIMessages.getString("AcceleoEditorRenameTemplateRefactoring.RenamingTemplateWithNewName", AcceleoRenameTemplateRefactoring.this.fTemplate.getTemplateName(), AcceleoRenameTemplateRefactoring.this.fNewTemplateName);
                    arguments.put(AcceleoRenameTemplateRefactoring.TEMPLATE, AcceleoRenameTemplateRefactoring.this.fTemplate.getTemplateName());
                    arguments.put(AcceleoRenameTemplateRefactoring.NEWNAME, AcceleoRenameTemplateRefactoring.this.fNewTemplateName);
                    arguments.put(AcceleoRenameTemplateRefactoring.REFERENCES, Boolean.valueOf(AcceleoRenameTemplateRefactoring.this.fUpdateReferences).toString());
                    return new RefactoringChangeDescriptor((RefactoringDescriptor)new AcceleoRenameTemplateDescriptor(project, description, comment, arguments));
                }
            };
            return compositeChange;
        }
        finally {
            monitor.done();
        }
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String getName() {
        return this.title;
    }

    public void setTemplate(AcceleoPositionedTemplate currentTemplate) {
        this.fTemplate = currentTemplate;
    }

    public AcceleoPositionedTemplate getTemplate() {
        return this.fTemplate;
    }

    public void setUpdateReferences(boolean selection) {
        this.fUpdateReferences = selection;
    }

    public RefactoringStatus setNewTemplateName(String text) {
        this.fNewTemplateName = text;
        RefactoringStatus status = this.checkTemplateName(this.fNewTemplateName);
        status.merge(this.checkOverLoading());
        return status;
    }

    private RefactoringStatus checkOverLoading() {
        AcceleoPositionedTemplate[] array;
        RefactoringStatus status = new RefactoringStatus();
        AcceleoPositionedTemplate[] acceleoPositionedTemplateArray = array = AcceleoPositionedTemplate.getInput();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            AcceleoPositionedTemplate acceleoPositionedTemplate = acceleoPositionedTemplateArray[n2];
            if (this.fNewTemplateName.equals(acceleoPositionedTemplate.getTemplateName())) {
                EList listOfParametersOfTheCurrentTemplate = this.fTemplate.getTemplate().getParameter();
                EList listOfParametersOfTheTemplateWithTheSameName = acceleoPositionedTemplate.getTemplate().getParameter();
                if (listOfParametersOfTheCurrentTemplate.size() == listOfParametersOfTheTemplateWithTheSameName.size()) {
                    boolean overloadingError = true;
                    int j = 0;
                    while (j < listOfParametersOfTheCurrentTemplate.size()) {
                        if (!((Variable)listOfParametersOfTheCurrentTemplate.get(j)).getEType().equals(((Variable)listOfParametersOfTheTemplateWithTheSameName.get(j)).getEType())) {
                            overloadingError = false;
                            break;
                        }
                        ++j;
                    }
                    if (overloadingError) {
                        status.merge(RefactoringStatus.createErrorStatus((String)AcceleoUIMessages.getString("AcceleoEditorRenameTemplateRefactoring.TemplateOverloadingError")));
                    }
                }
            }
            ++n2;
        }
        return status;
    }

    private RefactoringStatus checkTemplateName(String name) {
        RefactoringStatus status = new RefactoringStatus();
        int i = 0;
        while (i < name.length()) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                status.merge(RefactoringStatus.createErrorStatus((String)AcceleoUIMessages.getString("AcceleoEditorRenameTemplateRefactoring.InvalidTemplateName")));
            }
            ++i;
        }
        return status;
    }

    public RefactoringStatus initialize(Map<String, String> arguments) {
        RefactoringStatus status = new RefactoringStatus();
        String value = arguments.get(TEMPLATE);
        value = arguments.get(NEWNAME);
        if (value != null) {
            this.setNewTemplateName(value);
        }
        if ((value = arguments.get(REFERENCES)) != null) {
            this.setUpdateReferences(Boolean.valueOf(value));
        }
        return status;
    }
}

