/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.acceleo.query.ast.BooleanLiteral;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.EnumLiteral;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.FeatureAccess;
import org.eclipse.acceleo.query.ast.IntegerLiteral;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.NullLiteral;
import org.eclipse.acceleo.query.ast.RealLiteral;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.acceleo.query.ast.SetInExtensionLiteral;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.util.AstSwitch;
import org.eclipse.acceleo.query.runtime.impl.EvaluationServices;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class AstEvaluator
extends AstSwitch<Object> {
    private Map<String, Object> variables;
    private final EvaluationServices services;

    public AstEvaluator(EvaluationServices evalServices) {
        this.services = evalServices;
    }

    public Object eval(Map<String, Object> varDefinitions, Expression ast) {
        this.variables = varDefinitions;
        return this.doSwitch(ast);
    }

    @Override
    public Object caseBooleanLiteral(BooleanLiteral object) {
        return object.isValue();
    }

    @Override
    public Object caseIntegerLiteral(IntegerLiteral object) {
        return object.getValue();
    }

    @Override
    public Object caseRealLiteral(RealLiteral object) {
        return object.getValue();
    }

    @Override
    public Object caseStringLiteral(StringLiteral object) {
        return object.getValue();
    }

    @Override
    public Object caseTypeLiteral(TypeLiteral object) {
        return object.getValue();
    }

    @Override
    public Object caseFeatureAccess(FeatureAccess object) {
        Object target = this.doSwitch(object.getTarget());
        return this.services.featureAccess(target, object.getFeatureName());
    }

    @Override
    public Object caseCall(Call object) {
        Object result;
        EList<Expression> exprArgs = object.getArguments();
        int argc = exprArgs.size();
        Object[] args = new Object[argc];
        int i = 0;
        while (i < argc) {
            args[i] = this.doSwitch((EObject)exprArgs.get(i));
            ++i;
        }
        switch (object.getType()) {
            case CALLSERVICE: {
                result = this.services.call(object.getServiceName(), args);
                break;
            }
            case CALLORAPPLY: {
                result = this.services.callOrApply(object.getServiceName(), args);
                break;
            }
            case COLLECTIONCALL: {
                result = this.services.collectionServiceCall(object.getServiceName(), args);
                break;
            }
            default: {
                throw new UnsupportedOperationException("should never happen");
            }
        }
        return result;
    }

    @Override
    public Object caseVarRef(VarRef object) {
        return this.services.getVariableValue(this.variables, object.getVariableName());
    }

    @Override
    public Object caseLambda(Lambda object) {
        return object;
    }

    @Override
    public Object caseNullLiteral(NullLiteral object) {
        return null;
    }

    @Override
    public Object caseEnumLiteral(EnumLiteral object) {
        return object.getLiteral().getInstance();
    }

    @Override
    public Object caseSetInExtensionLiteral(SetInExtensionLiteral object) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (Expression expression : object.getValues()) {
            result.add(this.doSwitch(expression));
        }
        return result;
    }

    @Override
    public Object caseSequenceInExtensionLiteral(SequenceInExtensionLiteral object) {
        ArrayList result = Lists.newArrayList();
        for (Expression expression : object.getValues()) {
            result.add(this.doSwitch(expression));
        }
        return result;
    }
}

