/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.acceleo.query.ast.Binding;
import org.eclipse.acceleo.query.ast.BooleanLiteral;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.Conditional;
import org.eclipse.acceleo.query.ast.EnumLiteral;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.FeatureAccess;
import org.eclipse.acceleo.query.ast.IntegerLiteral;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.ast.NullLiteral;
import org.eclipse.acceleo.query.ast.RealLiteral;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.acceleo.query.ast.SetInExtensionLiteral;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.TypeSetLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.util.AstSwitch;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.EvaluationServices;
import org.eclipse.acceleo.query.runtime.impl.LambdaValue;
import org.eclipse.acceleo.query.runtime.impl.Nothing;
import org.eclipse.acceleo.query.runtime.impl.ScopedEnvironment;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class AstEvaluator
extends AstSwitch<Object> {
    private static final String BAD_PREDICATE_TYPE_MSG = "Conditional's predicate must evaluate to a boolean value.";
    private final ScopedEnvironment environment;
    private final EvaluationServices services;
    private Diagnostic diagnostic;

    public AstEvaluator(IQueryEnvironment queryEnv) {
        this.services = new EvaluationServices(queryEnv);
        this.environment = new ScopedEnvironment();
    }

    public AstEvaluator(EvaluationServices evalServices, ScopedEnvironment existingEnvironment) {
        this.environment = existingEnvironment;
        this.services = evalServices;
    }

    public EvaluationResult eval(Map<String, Object> varDefinitions, Expression ast) {
        this.environment.pushScope(varDefinitions);
        this.diagnostic = new BasicDiagnostic();
        Object result = this.doSwitch(ast);
        this.environment.popScope();
        return new EvaluationResult(result, this.diagnostic);
    }

    @Override
    public Object caseBooleanLiteral(BooleanLiteral object) {
        return object.isValue();
    }

    @Override
    public Object caseIntegerLiteral(IntegerLiteral object) {
        return object.getValue();
    }

    @Override
    public Object caseRealLiteral(RealLiteral object) {
        return object.getValue();
    }

    @Override
    public Object caseStringLiteral(StringLiteral object) {
        return object.getValue();
    }

    @Override
    public Object caseTypeLiteral(TypeLiteral object) {
        return object.getValue();
    }

    @Override
    public Object caseFeatureAccess(FeatureAccess object) {
        Object target = this.doSwitch(object.getTarget());
        return this.services.featureAccess(target, object.getFeatureName(), this.diagnostic);
    }

    @Override
    public Object caseCall(Call object) {
        EList<Expression> exprArgs = object.getArguments();
        Object result = null;
        int argc = exprArgs.size();
        Object[] args = new Object[argc];
        if (argc > 0) {
            int i = 0;
            args[i] = this.doSwitch((EObject)exprArgs.get(i));
            if (args[i] != null && args[i].getClass() == Boolean.class) {
                result = this.booleanShortcut(object.getServiceName(), (Boolean)args[i]);
            }
            if (result == null) {
                ++i;
                while (i < argc) {
                    args[i] = this.doSwitch((EObject)exprArgs.get(i));
                    ++i;
                }
            }
        }
        if (result == null) {
            switch (object.getType()) {
                case CALLSERVICE: {
                    result = this.services.call(object.getServiceName(), args, this.diagnostic);
                    break;
                }
                case CALLORAPPLY: {
                    result = this.services.callOrApply(object.getServiceName(), args, this.diagnostic);
                    break;
                }
                case COLLECTIONCALL: {
                    result = this.services.collectionServiceCall(object.getServiceName(), args, this.diagnostic);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("should never happen");
                }
            }
        }
        return result;
    }

    private Boolean booleanShortcut(String serviceName, Boolean firstArg) {
        Boolean result = "and".equals(serviceName) ? (Boolean.FALSE.equals(firstArg) ? Boolean.FALSE : null) : ("or".equals(serviceName) ? (Boolean.TRUE.equals(firstArg) ? Boolean.TRUE : null) : ("implies".equals(serviceName) ? (Boolean.FALSE.equals(firstArg) ? Boolean.TRUE : null) : null));
        return result;
    }

    @Override
    public Object caseVarRef(VarRef object) {
        return this.services.getVariableValue(this.environment, object.getVariableName(), this.diagnostic);
    }

    @Override
    public Object caseLambda(Lambda object) {
        return new LambdaValue(object, new AstEvaluator(this.services, this.environment.copy()));
    }

    @Override
    public Object caseNullLiteral(NullLiteral object) {
        return null;
    }

    @Override
    public Object caseEnumLiteral(EnumLiteral object) {
        return object.getLiteral().getInstance();
    }

    @Override
    public Object caseSetInExtensionLiteral(SetInExtensionLiteral object) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (Expression expression : object.getValues()) {
            result.add(this.doSwitch(expression));
        }
        return result;
    }

    @Override
    public Object caseSequenceInExtensionLiteral(SequenceInExtensionLiteral object) {
        ArrayList result = Lists.newArrayList();
        for (Expression expression : object.getValues()) {
            result.add(this.doSwitch(expression));
        }
        return result;
    }

    @Override
    public Object caseConditional(Conditional object) {
        Object result;
        Object selector = this.doSwitch(object.getPredicate());
        if (selector instanceof Boolean) {
            result = ((Boolean)selector).booleanValue() ? this.doSwitch(object.getTrueBranch()) : this.doSwitch(object.getFalseBranch());
        } else {
            Nothing nothing = new Nothing(BAD_PREDICATE_TYPE_MSG);
            BasicDiagnostic diag = new BasicDiagnostic(2, "org.eclipse.acceleo.query", 0, nothing.getMessage(), new Object[0]);
            ((BasicDiagnostic)this.diagnostic).add((Diagnostic)diag);
            result = nothing;
        }
        return result;
    }

    @Override
    public Object caseLet(Let object) {
        HashMap letEnv = Maps.newHashMap();
        for (Binding binding : object.getBindings()) {
            letEnv.put(binding.getName(), this.doSwitch(binding.getValue()));
        }
        this.environment.pushScope(letEnv);
        Object result = this.doSwitch(object.getBody());
        this.environment.popScope();
        return result;
    }

    @Override
    public Object caseTypeSetLiteral(TypeSetLiteral object) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>(object.getTypes().size());
        for (TypeLiteral type : object.getTypes()) {
            result.add(this.doSwitch(type));
        }
        return result;
    }
}

