/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.IEPackageProvider2;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IRootEObjectProvider;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.AbstractServiceProvider;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.runtime.lookup.basic.Service;
import org.eclipse.acceleo.query.services.EAllContentsService;
import org.eclipse.acceleo.query.services.FilterService;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierSetLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

@ServiceProvider(value="Services available for EObjects")
public class EObjectServices
extends AbstractServiceProvider {
    private static final String ONLY_E_CLASS_CAN_BE_CONTAINED_INTO_OTHER_E_CLASSES_NOT_S = "Only EClass can be contained into other EClasses not %s";
    private static final String S_CAN_T_CONTAIN_DIRECTLY_OR_INDIRECTLY_S = "%s can't contain directly or indirectly %s";
    private CrossReferenceProvider crossReferencer;
    private IRootEObjectProvider rootProvider;
    private final IReadOnlyQueryEnvironment queryEnvironment;

    public EObjectServices(IReadOnlyQueryEnvironment queryEnvironment) {
        this.queryEnvironment = queryEnvironment;
    }

    @Override
    protected IService getService(Method publicMethod) {
        Service result = "eContents".equals(publicMethod.getName()) ? new EContentsService(publicMethod, (Object)this) : ("eAllContents".equals(publicMethod.getName()) ? new EAllContentsService(publicMethod, this) : ("eContainer".equals(publicMethod.getName()) ? new EContainerService(publicMethod, (Object)this) : ("eContainerOrSelf".equals(publicMethod.getName()) ? new EContainerOrSelfService(publicMethod, (Object)this) : ("eInverse".equals(publicMethod.getName()) ? (publicMethod.getParameterTypes().length == 2 && publicMethod.getParameterTypes()[1] == String.class ? new EInverseService(publicMethod, this, 10) : new EInverseService(publicMethod, (Object)this)) : ("allInstances".equals(publicMethod.getName()) ? new AllInstancesService(publicMethod, this) : new Service(publicMethod, this))))));
        return result;
    }

    @Documentation(value="Returns a sequence of the EObjects recursively contained in the specified root eObject.", params={@Param(name="eObject", value="The root of the content tree")}, result="The recursive content of the specified eObject.", examples={@Example(expression="anEPackage.eAllContents()", result="Sequence{firstEClass, firstEAttribute, secondEClass, firstDataType}")})
    public List<EObject> eAllContents(EObject eObject) {
        return Lists.newArrayList((Iterator)eObject.eAllContents());
    }

    @Documentation(value="Returns a sequence of the EObjects recursively contained in the specified root eObject and that are instances of the specified EClass", params={@Param(name="eObject", value="The root of the content tree"), @Param(name="type", value="The type used to select elements")}, result="The recursive content of the specified eObject.", examples={@Example(expression="anEPackage.eAllContents(ecore::EClass)", result="Sequence{firstEClass, secondEClass}")})
    public List<EObject> eAllContents(EObject eObject, EClass type) {
        if (type == EcorePackage.eINSTANCE.getEObject()) {
            return this.eAllContents(eObject);
        }
        LinkedHashSet types = Sets.newLinkedHashSet();
        types.add(type);
        return this.eAllContents(eObject, types);
    }

    @Documentation(value="Returns a sequence of the EObjects recursively contained in the specified root eObject and that are instances of the specified EClass", params={@Param(name="eObject", value="The root of the content tree"), @Param(name="types", value="The set of types used to select elements")}, result="The recursive content of the specified eObject.", examples={@Example(expression="anEPackage.eAllContents({ecore::EPackage | ecore::EClass})", result="Sequence{ePackage, eClass, ...}")})
    public List<EObject> eAllContents(EObject eObject, Set<EClass> types) {
        List<EObject> result;
        if (types != null) {
            LinkedHashSet features = Sets.newLinkedHashSet();
            for (EClass type : types) {
                features.addAll(((IEPackageProvider2)this.queryEnvironment.getEPackageProvider()).getAllContainingEStructuralFeatures(type));
            }
            result = this.eAllContents(eObject, types, features);
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private List<EObject> eAllContents(EObject eObject, Set<EClass> types, Set<EStructuralFeature> features) {
        ArrayList result = Lists.newArrayList();
        if (!features.isEmpty()) {
            for (EStructuralFeature feature : eObject.eClass().getEAllStructuralFeatures()) {
                Object child;
                if (!features.contains(feature) || (child = eObject.eGet(feature)) == null) continue;
                result.addAll(this.eAllContentsVisitChild(child, types, feature.isMany(), features));
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<EObject> eAllContentsVisitChild(Object child, Set<EClass> types, boolean isMany, Set<EStructuralFeature> features) {
        ArrayList result = Lists.newArrayList();
        if (isMany) {
            if (!(child instanceof Collection)) throw new IllegalStateException("don't know what to do with " + child.getClass());
            result.addAll(this.eAllContentsVisitCollectionChild((Collection)child, types, features));
            return result;
        } else {
            if (!(child instanceof EObject)) return result;
            for (EClass type : types) {
                if (type.isSuperTypeOf(((EObject)child).eClass())) {
                    result.add((EObject)child);
                    break;
                }
                if (!type.isInstance(child)) continue;
                result.add((EObject)child);
            }
            result.addAll(this.eAllContents((EObject)child, types, features));
        }
        return result;
    }

    private List<EObject> eAllContentsVisitCollectionChild(Collection<?> child, Set<EClass> types, Set<EStructuralFeature> features) {
        ArrayList result = Lists.newArrayList();
        for (Object object : child) {
            if (!(object instanceof EObject)) continue;
            for (EClass type : types) {
                if (type.isSuperTypeOf(((EObject)object).eClass())) {
                    result.add((EObject)object);
                    break;
                }
                if (!type.isInstance(object)) continue;
                result.add((EObject)object);
            }
            result.addAll(this.eAllContents((EObject)object, types, features));
        }
        return result;
    }

    @Documentation(value="Returns the contents of the specified EObject instance.", params={@Param(name="eObject", value="The eObject which content is requested.")}, result="The content of the specified eObject.", examples={@Example(expression="anEPackage.eContents()", result="Sequence{firstEClass, secondEClass, firstDataType}")})
    public List<EObject> eContents(EObject eObject) {
        return eObject.eContents();
    }

    @Documentation(value="Returns a sequence made of the instances of the specified type in the contents of the specified eObject.", params={@Param(name="eObject", value="The eObject which content is requested."), @Param(name="type", value="The type filter.")}, result="The filtered content of the specified eObject.", examples={@Example(expression="anEPackage.eContents(ecore::EDataType)", result="Sequence{firstDataType}")})
    public List<EObject> eContents(EObject eObject, EClass type) {
        if (type == EcorePackage.eINSTANCE.getEObject()) {
            return this.eContents(eObject);
        }
        LinkedHashSet<EClass> eClasses = new LinkedHashSet<EClass>();
        eClasses.add(type);
        return this.eContents(eObject, eClasses);
    }

    @Documentation(value="Returns a sequence made of the instances of the specified types in the contents of the specified eObject.", params={@Param(name="eObject", value="The eObject which content is requested."), @Param(name="types", value="The Set of types filter.")}, result="The filtered content of the specified eObject.", examples={@Example(expression="anEPackage.eContents({ecore::EPackage | ecore::EClass})", result="Sequence{SubEPackage, eClass, ... }")})
    public List<EObject> eContents(EObject eObject, Set<EClass> types) {
        List<EObject> result;
        if (types != null) {
            LinkedHashSet features = Sets.newLinkedHashSet();
            for (EClass type : types) {
                features.addAll(((IEPackageProvider2)this.queryEnvironment.getEPackageProvider()).getContainingEStructuralFeatures(type));
            }
            result = this.eContents(eObject, types, features);
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private List<EObject> eContents(EObject eObject, Set<EClass> types, Set<EStructuralFeature> features) {
        ArrayList result = Lists.newArrayList();
        if (!features.isEmpty()) {
            for (EStructuralFeature feature : eObject.eClass().getEAllStructuralFeatures()) {
                Object child;
                if (!features.contains(feature) || (child = eObject.eGet(feature)) == null) continue;
                result.addAll(this.eContentsVisitChild(child, types, feature.isMany(), features));
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection<? extends EObject> eContentsVisitChild(Object child, Set<EClass> types, boolean isMany, Set<EStructuralFeature> features) {
        ArrayList result = Lists.newArrayList();
        if (isMany) {
            if (!(child instanceof Collection)) throw new IllegalStateException("don't know what to do with " + child.getClass());
            result.addAll(this.eContentsVisitCollectionChild((Collection)child, types, features));
            return result;
        } else {
            if (!(child instanceof EObject)) return result;
            for (EClass type : types) {
                if (type.isSuperTypeOf(((EObject)child).eClass())) {
                    result.add((EObject)child);
                    return result;
                }
                if (!type.isInstance(child)) continue;
                result.add((EObject)child);
            }
        }
        return result;
    }

    private List<EObject> eContentsVisitCollectionChild(Collection<?> child, Set<EClass> types, Set<EStructuralFeature> features) {
        ArrayList result = Lists.newArrayList();
        block0: for (Object object : child) {
            if (!(object instanceof EObject)) continue;
            for (EClass type : types) {
                if (type.isSuperTypeOf(((EObject)object).eClass())) {
                    result.add((EObject)object);
                    continue block0;
                }
                if (!type.isInstance(child)) continue;
                result.add((EObject)child);
            }
        }
        return result;
    }

    @Documentation(value="Returns the container of the specified EObject", params={@Param(name="eObject", value="The eObject which container is requested.")}, result="The container of the specified eObject.", examples={@Example(expression="firstEAttribute.eContainer()", result="firstEClass")})
    public EObject eContainer(EObject eObject) {
        return eObject.eContainer();
    }

    @Documentation(value="Returns the first container of the specified EObject that matches the given type", params={@Param(name="eObject", value="The eObject which container is requested."), @Param(name="type", value="The type filter.")}, result="The first container of the specified eObject that matches the given type.", examples={@Example(expression="firstEAttribute.eContainer(ecore::EPackage)", result="anEPackage")})
    public EObject eContainer(EObject eObject, EClass type) {
        EObject current = eObject.eContainer();
        while (current != null && !type.isSuperTypeOf(current.eClass()) && !type.isInstance((Object)current)) {
            current = current.eContainer();
        }
        EObject result = current != null && (type.isSuperTypeOf(current.eClass()) || type.isInstance((Object)current)) ? current : null;
        return result;
    }

    @Documentation(value="Returns self or the first container of the specified EObject that matches the given type", params={@Param(name="eObject", value="The eObject which container is requested."), @Param(name="type", value="The type filter.")}, result="Self or the first container of the specified eObject that matches the given type.", examples={@Example(expression="firstEAttribute.eContainerOrSelf(ecore::EAttribute)", result="firstEAttribute")})
    public EObject eContainerOrSelf(EObject eObject, EClass type) {
        EObject result = type.isSuperTypeOf(eObject.eClass()) || type.isInstance((Object)eObject) ? eObject : this.eContainer(eObject, type);
        return result;
    }

    @Documentation(value="Returns the EClass of the specified EObject", params={@Param(name="eObject", value="The eObject which EClass is requested.")}, result="The EClass of the specified EObject")
    public EClass eClass(EObject eObject) {
        return eObject.eClass();
    }

    @Documentation(value="Returns the containing feature of the specified EObject", params={@Param(name="eObject", value="The eObject which containing feature is requested.")}, result="The containing feature of the specified EObject")
    public EStructuralFeature eContainingFeature(EObject eObject) {
        return eObject.eContainingFeature();
    }

    @Documentation(value="Returns the containment feature of the specified EObject", params={@Param(name="eObject", value="The eObject which containment feature is requested.")}, result="The containment feature of the specified EObject")
    public EReference eContainmentFeature(EObject eObject) {
        return eObject.eContainmentFeature();
    }

    public void setCrossReferencer(CrossReferenceProvider crossReferencer) {
        this.crossReferencer = crossReferencer;
    }

    public void setRootProvider(IRootEObjectProvider rootProvider) {
        this.rootProvider = rootProvider;
    }

    @Documentation(value="Returns the set containing the inverse references.", params={@Param(name="eObject", value="The eObject which inverse references are requested.")}, result="The set of the inverse references")
    public Set<EObject> eInverse(EObject self) {
        LinkedHashSet result;
        Collection<EStructuralFeature.Setting> settings = this.crossReferencer.getInverseReferences(self);
        if (settings == null) {
            result = Collections.emptySet();
        } else {
            result = Sets.newLinkedHashSet();
            for (EStructuralFeature.Setting setting : settings) {
                result.add(setting.getEObject());
            }
        }
        return result;
    }

    @Documentation(value="Returns the elements of the given type from the set of the inverse references of the receiver.", params={@Param(name="eObject", value="The eObject which inverse references are requested."), @Param(name="type", value="The type filter.")}, result="The set of the inverse references")
    public Set<EObject> eInverse(EObject self, EClassifier type) {
        LinkedHashSet result;
        Collection<EStructuralFeature.Setting> settings = this.crossReferencer.getInverseReferences(self);
        if (settings == null || type == null) {
            result = Collections.emptySet();
        } else {
            result = Sets.newLinkedHashSet();
            for (EStructuralFeature.Setting setting : settings) {
                if (!type.isInstance((Object)setting.getEObject())) continue;
                result.add(setting.getEObject());
            }
        }
        return result;
    }

    @Documentation(value="Returns the elements from the set of the inverse references of the receiver that are referencing the receiver using a feature with the given name.", params={@Param(name="eObject", value="The eObject which inverse references are requested."), @Param(name="featureName", value="The feature name.")}, result="The set of the inverse references")
    public Set<EObject> eInverse(EObject self, String featureName) {
        LinkedHashSet result;
        Collection<EStructuralFeature.Setting> settings = this.crossReferencer.getInverseReferences(self);
        if (settings == null) {
            result = Collections.emptySet();
        } else {
            result = Sets.newLinkedHashSet();
            for (EStructuralFeature.Setting setting : settings) {
                if (!setting.getEStructuralFeature().getName().equals(featureName)) continue;
                result.add(setting.getEObject());
            }
        }
        return result;
    }

    @Documentation(value="Handles calls to the operation \"eGet\". This will fetch the value of the feature named \"featureName\" on \"source\"", params={@Param(name="eObject", value="The eObject we seek to retrieve a feature value of."), @Param(name="featureName", value="The name of the feature which value we need to retrieve.")}, result="The value of the given feature on the given EObject")
    public Object eGet(EObject eObject, String featureName) {
        for (EStructuralFeature feature : eObject.eClass().getEAllStructuralFeatures()) {
            if (!feature.getName().equals(featureName)) continue;
            return eObject.eGet(feature);
        }
        return null;
    }

    @Documentation(value="Returns all instances of the EClass", params={@Param(name="type", value="The EClass")}, result="all instances of the EClass")
    public List<EObject> allInstances(EClass type) {
        List<EObject> result;
        if (type != null) {
            LinkedHashSet types = Sets.newLinkedHashSet();
            types.add(type);
            result = this.allInstances(types);
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    @Documentation(value="Returns all instances of any EClass from the OrderedSet", params={@Param(name="types", value="The OrderedSet of EClass")}, result="all instances of any EClass from the OrderedSet")
    public List<EObject> allInstances(Set<EClass> types) {
        ArrayList result = Lists.newArrayList();
        if (this.rootProvider != null) {
            for (EObject root : this.rootProvider.getRoots()) {
                result.addAll(this.eAllContents(root, types));
            }
        }
        return result;
    }

    private final class AllInstancesService
    extends EAllContentsService {
        private AllInstancesService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnv, List<IType> argTypes) {
            Set<Object> result;
            if (EObjectServices.this.rootProvider == null) {
                result = Sets.newLinkedHashSet();
                result.add(new SequenceType(queryEnv, services.nothing("No IRootEObjectProvider registered", new Object[0])));
            } else {
                ArrayList newArgTypes = Lists.newArrayList(argTypes);
                newArgTypes.add(0, new EClassifierType(queryEnv, queryEnv.getEPackageProvider().getType("ecore", "EObject")));
                result = super.getType(call, services, validationResult, queryEnv, newArgTypes);
            }
            return result;
        }
    }

    private static final class EContainerOrSelfService
    extends FilterService {
        private EContainerOrSelfService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    result.add(new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType()));
                } else {
                    result.addAll(this.getTypeForSpecificType(services, queryEnvironment, argTypes, eCls));
                }
            } else {
                result.add(services.nothing(EObjectServices.ONLY_E_CLASS_CAN_BE_CONTAINED_INTO_OTHER_E_CLASSES_NOT_S, argTypes.get(0)));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            IType lowerSelfType = services.lower(argTypes.get(0), argTypes.get(1));
            if (lowerSelfType != null) {
                result.add(lowerSelfType);
            }
            IType filterType = argTypes.get(1);
            for (EClass containingEClass : queryEnvironment.getEPackageProvider().getAllContainingEClasses(receiverEClass)) {
                IType lowerType = services.lower(new EClassifierType(queryEnvironment, (EClassifier)containingEClass), filterType);
                if (lowerType == null) continue;
                result.add(lowerType);
            }
            if (result.isEmpty()) {
                result.add(services.nothing(EObjectServices.S_CAN_T_CONTAIN_DIRECTLY_OR_INDIRECTLY_S, filterType, argTypes.get(0)));
            }
            return result;
        }
    }

    private static final class EContainerService
    extends FilterService {
        private EContainerService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1) {
                        result.add(argTypes.get(0));
                    } else if (argTypes.size() == 2) {
                        result.add(new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType()));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, queryEnvironment, argTypes, eCls));
                }
            } else {
                result.add(services.nothing(EObjectServices.ONLY_E_CLASS_CAN_BE_CONTAINED_INTO_OTHER_E_CLASSES_NOT_S, argTypes.get(0)));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.size() == 1) {
                for (EClass containingEClass : queryEnvironment.getEPackageProvider().getContainingEClasses(receiverEClass)) {
                    result.add(new EClassifierType(queryEnvironment, (EClassifier)containingEClass));
                }
                if (result.isEmpty()) {
                    result.add(services.nothing("%s can't be contained", argTypes.get(0)));
                }
            } else if (argTypes.size() == 2) {
                IType filterType = argTypes.get(1);
                for (EClass containingEClass : queryEnvironment.getEPackageProvider().getAllContainingEClasses(receiverEClass)) {
                    IType lowerType = services.lower(new EClassifierType(queryEnvironment, (EClassifier)containingEClass), filterType);
                    if (lowerType == null) continue;
                    result.add(lowerType);
                }
                if (result.isEmpty()) {
                    result.add(services.nothing(EObjectServices.S_CAN_T_CONTAIN_DIRECTLY_OR_INDIRECTLY_S, filterType, argTypes.get(0)));
                }
            }
            return result;
        }
    }

    private static final class EContentsService
    extends FilterService {
        private EContentsService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1) {
                        result.add(new SequenceType(queryEnvironment, argTypes.get(0)));
                    } else if (argTypes.size() == 2 && argTypes.get(1) instanceof EClassifierLiteralType) {
                        result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType())));
                    } else if (argTypes.size() == 2 && argTypes.get(1) instanceof EClassifierSetLiteralType) {
                        for (EClassifier eClsFilter : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                            result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, eClsFilter)));
                        }
                    } else if (argTypes.size() == 2) {
                        result.addAll(super.getType(call, services, validationResult, queryEnvironment, argTypes));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, queryEnvironment, argTypes, eCls));
                }
            } else {
                result.add(new SequenceType(queryEnvironment, services.nothing("Only EClass can contain other EClasses not %s", argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.size() == 1) {
                LinkedHashSet<SequenceType> containedTypes = new LinkedHashSet<SequenceType>();
                for (EClass contained : queryEnvironment.getEPackageProvider().getContainedEClasses(receiverEClass)) {
                    containedTypes.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)contained)));
                }
                result.addAll(containedTypes);
                if (result.isEmpty()) {
                    result.add(new SequenceType(queryEnvironment, services.nothing("%s doesn't contain any other EClass", argTypes.get(0))));
                }
            } else if (argTypes.size() == 2) {
                LinkedHashSet filterTypes = Sets.newLinkedHashSet();
                if (argTypes.get(1) instanceof EClassifierSetLiteralType) {
                    for (EClassifier eClassifier : ((EClassifierSetLiteralType)argTypes.get(1)).getEClassifiers()) {
                        filterTypes.add(new EClassifierType(queryEnvironment, eClassifier));
                    }
                } else if (argTypes.get(1) instanceof EClassifierLiteralType) {
                    filterTypes.add(argTypes.get(1));
                } else {
                    EClassifier eObjectEClass = queryEnvironment.getEPackageProvider().getType("ecore", "EObject");
                    if (eObjectEClass != null) {
                        filterTypes.add(new EClassifierType(queryEnvironment, eObjectEClass));
                    }
                }
                for (IType filterType : filterTypes) {
                    for (EClass containedEClass : queryEnvironment.getEPackageProvider().getContainedEClasses(receiverEClass)) {
                        IType lowerType = services.lower(new EClassifierType(queryEnvironment, (EClassifier)containedEClass), filterType);
                        if (lowerType == null) continue;
                        result.add(new SequenceType(queryEnvironment, lowerType));
                    }
                }
                if (result.isEmpty()) {
                    result.add(new SequenceType(queryEnvironment, services.nothing("%s can't contain %s direclty", argTypes.get(0), argTypes.get(1))));
                }
            }
            return result;
        }
    }

    private static final class EInverseService
    extends FilterService {
        private EInverseService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        private EInverseService(Method serviceMethod, Object serviceInstance, int filterIndex) {
            super(serviceMethod, serviceInstance, filterIndex);
        }

        @Override
        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() instanceof EClass) {
                EClass eCls = (EClass)argTypes.get(0).getType();
                if (eCls == EcorePackage.eINSTANCE.getEObject()) {
                    if (argTypes.size() == 1 || !(argTypes.get(1).getType() instanceof EClass)) {
                        result.add(new SetType(queryEnvironment, argTypes.get(0)));
                    } else if (argTypes.size() == 2) {
                        result.add(new SetType(queryEnvironment, new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType())));
                    }
                } else {
                    result.addAll(this.getTypeForSpecificType(services, queryEnvironment, argTypes, eCls));
                }
            } else {
                result.add(new SetType(queryEnvironment, services.nothing("Only EClass can have inverse not %s", argTypes.get(0))));
            }
            return result;
        }

        private Set<IType> getTypeForSpecificType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes, EClass receiverEClass) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            Set<EClass> inverseEClasses = queryEnvironment.getEPackageProvider().getInverseEClasses(receiverEClass);
            if (argTypes.size() == 1 || !(argTypes.get(1).getType() instanceof EClass)) {
                for (EClass inverseEClass : inverseEClasses) {
                    result.add(new SetType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)inverseEClass)));
                }
                if (result.isEmpty()) {
                    result.add(new SetType(queryEnvironment, services.nothing("%s don't have inverse", argTypes.get(0))));
                }
            } else if (argTypes.size() == 2) {
                IType filterType = argTypes.get(1);
                for (EClass inverseEClass : inverseEClasses) {
                    IType lowerType = services.lower(new EClassifierType(queryEnvironment, (EClassifier)inverseEClass), filterType);
                    if (lowerType == null) continue;
                    result.add(new SetType(queryEnvironment, lowerType));
                }
                if (result.isEmpty()) {
                    result.add(new SetType(queryEnvironment, services.nothing("%s don't have inverse to %s", argTypes.get(0), filterType)));
                }
            }
            return result;
        }
    }
}

