/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.eventemitter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import org.apache.axis.types.URI;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.alf.eventemitter.EventEmitter;

public class ContinuousEmitter {
    static Properties loadRunnerProp = null;
    private static Logger logger = Logger.getLogger(EventEmitter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContinuousEmitter() {
        File file = new File(".//loadRunner.properties");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            loadRunnerProp = new Properties();
            loadRunnerProp.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        float f = Float.valueOf(loadRunnerProp.getProperty("hours")).floatValue();
        float f2 = Float.valueOf(loadRunnerProp.getProperty("mins")).floatValue();
        float f3 = Float.valueOf(loadRunnerProp.getProperty("secs")).floatValue();
        long l = new Float(f * 60.0f * 60.0f * 1000.0f + f2 * 60.0f * 1000.0f + f3 * 1000.0f).longValue();
        int n = Integer.valueOf(loadRunnerProp.getProperty("totalThreads"));
        for (int i = 0; i < n; ++i) {
            NewThread newThread = new NewThread(l, String.valueOf(i));
            newThread.start();
        }
    }

    public static void main(String[] stringArray) {
        String string = "log4j.properties";
        PropertyConfigurator.configure((String)string);
        ContinuousEmitter continuousEmitter = new ContinuousEmitter();
    }

    private static String getTimeFormatted(String string) {
        String string2 = "dd/MMM/yyyy hh:mm:ss";
        StringBuffer stringBuffer = null;
        Date date = new Date(Long.parseLong(string));
        try {
            stringBuffer = new SimpleDateFormat(string2).format(date, new StringBuffer(), new FieldPosition(0));
        }
        catch (Exception exception) {
            logger.error((Object)("Error Running ContinousEmitter " + exception.getMessage()));
        }
        return stringBuffer.toString();
    }

    class NewThread
    extends Thread {
        private long totalTimetoRun;
        private long socketTimeoutException;
        private long otherFailures;
        private long successes;
        private long totalEventsRaised;

        public NewThread() {
            this.totalTimetoRun = 0L;
            this.socketTimeoutException = 0L;
            this.otherFailures = 0L;
            this.successes = 0L;
            this.totalEventsRaised = 0L;
        }

        public NewThread(long l, String string) {
            super(string);
            this.totalTimetoRun = 0L;
            this.socketTimeoutException = 0L;
            this.otherFailures = 0L;
            this.successes = 0L;
            this.totalEventsRaised = 0L;
            this.totalTimetoRun = l;
        }

        public void run() {
            EventEmitter eventEmitter = new EventEmitter();
            eventEmitter.setFileName(loadRunnerProp.getProperty("eventEmitterClientXML"));
            eventEmitter.setServerURL(loadRunnerProp.getProperty("serverURL"));
            eventEmitter.setEventTimeout(new Float(Float.parseFloat(loadRunnerProp.getProperty("timeout_duration")) * 1000.0f).intValue());
            long l = Calendar.getInstance().getTimeInMillis();
            long l2 = l + this.totalTimetoRun;
            long l3 = l;
            int n = Integer.parseInt(loadRunnerProp.getProperty("pause_between_events"));
            while (l2 >= l3) {
                try {
                    eventEmitter.constructEvent();
                }
                catch (URI.MalformedURIException malformedURIException) {
                    malformedURIException.printStackTrace();
                }
                try {
                    ++this.totalEventsRaised;
                    eventEmitter.raiseEvent();
                    ++this.successes;
                    try {
                        Thread.sleep(n);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (RemoteException remoteException) {
                    if (remoteException.getMessage().contains("SocketTimeoutException")) {
                        ++this.socketTimeoutException;
                    }
                    ++this.otherFailures;
                }
                l3 = Calendar.getInstance().getTimeInMillis();
            }
            String string = this.getName();
            logger.info((Object)("Thread " + string + " Start Time = " + ContinuousEmitter.getTimeFormatted(String.valueOf(l))));
            logger.info((Object)("Thread " + string + " Expected End Time = " + ContinuousEmitter.getTimeFormatted(String.valueOf(l2))));
            logger.info((Object)("Thread " + string + " Actual Time = " + ContinuousEmitter.getTimeFormatted(String.valueOf(l3))));
            logger.info((Object)("Thread " + string + " Total Events Fired = " + this.totalEventsRaised));
            logger.info((Object)("Thread " + string + " Timeouts = " + this.socketTimeoutException));
            logger.info((Object)("Thread " + string + " OtherFailures = " + this.otherFailures));
            logger.info((Object)("Thread " + string + " Successes = " + this.successes));
        }
    }
}

