/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.eventemitter;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.rpc.ServiceException;
import org.apache.axis.components.uuid.SimpleUUIDGen;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.URI;
import org.apache.log4j.Logger;
import org.eclipse.alf.eventManager.util.EventSchemaParser;
import org.eclipse.alf.eventemitter.proxy.ALFEventManagerSOAPStub;
import org.eclipse.alf.eventemitter.proxy.ALFEventManager_ServiceLocator;
import org.eclipse.alf.eventemitter.proxy.ALFEventResponseType;
import org.eclipse.alf.eventemitter.proxy.ALFEventType;
import org.eclipse.alf.eventemitter.proxy.ALFSchemaVersionType;
import org.eclipse.alf.eventemitter.proxy.BaseExtensionType;
import org.eclipse.alf.eventemitter.proxy.CredentialsType;
import org.eclipse.alf.eventemitter.proxy.CustomExtensionType;
import org.eclipse.alf.eventemitter.proxy.DetailExtensionType;
import org.eclipse.alf.eventemitter.proxy.EmBaseType;
import org.eclipse.alf.eventemitter.proxy.EmExtensionType;
import org.eclipse.alf.eventemitter.proxy.EventBaseType;
import org.eclipse.alf.eventemitter.proxy.SourceType;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EventEmitter
extends Thread {
    private static Logger logger = Logger.getLogger(EventEmitter.class);
    private String fileName;
    private String serverURL;
    private String eventType;
    private String eventID;
    private String emEventID;
    private String objectID;
    private String objectType;
    private String serviceFlowID;
    private String predecedingEmEventId;
    private String callback;
    private String eventDetailsURI;
    private HashMap eventDetailsTable = new HashMap();
    private String toolExtensionDataURI;
    private HashMap toolExtensionDataTable = new HashMap();
    private HashMap emExtensionDataTable;
    private HashMap baseExtensionDataTable;
    private HashMap userCredentialsTable = new HashMap();
    private HashMap emUserCredentialsTable = new HashMap();
    private int waitTime = 0;
    private ALFEventManagerSOAPStub binding = null;
    private ALFEventType alfEvent;
    private int eventTimeout = 30000;

    public EventEmitter() {
        this.emExtensionDataTable = new HashMap();
        this.baseExtensionDataTable = new HashMap();
    }

    public void constructEvent() throws URI.MalformedURIException {
        Serializable serializable;
        Object object;
        Object[] objectArray;
        MessageElement[] messageElementArray;
        Object object2;
        Serializable serializable2;
        EventSchemaParser eventSchemaParser = this.loadEventFile();
        try {
            serializable2 = new ALFEventManager_ServiceLocator();
            if (this.serverURL != null && this.serverURL.length() > 0) {
                serializable2.setALFEventManagerSOAPEndpointAddress(this.serverURL);
            }
            this.binding = (ALFEventManagerSOAPStub)serializable2.getALFEventManagerSOAP();
        }
        catch (ServiceException serviceException) {
            serviceException.printStackTrace();
        }
        this.alfEvent = new ALFEventType();
        if (eventSchemaParser.getVersion() != null) {
            serializable2 = new ALFSchemaVersionType("1.0");
            this.alfEvent.setVersion((ALFSchemaVersionType)serializable2);
        }
        serializable2 = this.createEventBaseType(eventSchemaParser);
        this.alfEvent.setBase((EventBaseType)serializable2);
        DetailExtensionType detailExtensionType = new DetailExtensionType();
        HashMap hashMap = eventSchemaParser.getEventDetailsTable();
        hashMap.putAll(this.eventDetailsTable);
        int n = hashMap.size();
        if (n > 0) {
            object2 = hashMap.keySet();
            messageElementArray = new MessageElement[n];
            objectArray = object2.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                object = new QName(string);
                messageElementArray[i] = serializable = new MessageElement((QName)object, hashMap.get(string));
            }
            if (this.eventDetailsURI == null || this.eventDetailsURI.length() < 1) {
                this.eventDetailsURI = eventSchemaParser.getEventDetailsURI();
            }
            if (this.eventDetailsURI != null && this.eventDetailsURI.length() > 0) {
                URI uRI = new URI(this.eventDetailsURI);
            }
            detailExtensionType.set_any(messageElementArray);
        }
        this.alfEvent.setDetail(detailExtensionType);
        object2 = new CustomExtensionType();
        hashMap = eventSchemaParser.getToolExtensionDataTable();
        hashMap.putAll(this.toolExtensionDataTable);
        n = hashMap.size();
        if (n > 0) {
            messageElementArray = hashMap.keySet();
            objectArray = new MessageElement[n];
            Object[] objectArray2 = messageElementArray.toArray();
            for (int i = 0; i < objectArray2.length; ++i) {
                object = (String)objectArray2[i];
                serializable = new QName((String)object);
                MessageElement messageElement = new MessageElement((QName)serializable, hashMap.get(object));
                objectArray[i] = messageElement;
            }
            ((CustomExtensionType)object2).set_any((MessageElement[])objectArray);
        }
        this.alfEvent.setExtension((CustomExtensionType)object2);
    }

    private EventSchemaParser loadEventFile() {
        EventSchemaParser eventSchemaParser = new EventSchemaParser();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = null;
        try {
            sAXParser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.fileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        sAXParserFactory.setValidating(true);
        try {
            sAXParser.parse((InputStream)fileInputStream, (DefaultHandler)eventSchemaParser);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.eventType != null && this.eventType.length() > 0) {
            eventSchemaParser.setEventType(this.eventType);
        }
        if (this.eventID != null && this.eventID.length() > 0) {
            eventSchemaParser.setEventID(this.eventID);
        }
        if (this.objectID != null && this.objectID.length() > 0) {
            eventSchemaParser.setObjectID(this.objectID);
        }
        if (this.objectType != null && this.objectType.length() > 0) {
            eventSchemaParser.setObjectType(this.objectType);
        }
        return eventSchemaParser;
    }

    private EventBaseType createEventBaseType(EventSchemaParser eventSchemaParser) {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        CredentialsType credentialsType = null;
        CredentialsType credentialsType2 = null;
        EventBaseType eventBaseType = new EventBaseType();
        this.eventID = eventSchemaParser.getEventID();
        if (this.eventID == null || this.eventID.length() < 1) {
            object7 = new SimpleUUIDGen();
            eventBaseType.setEventId(((SimpleUUIDGen)object7).nextUUID());
        } else {
            eventBaseType.setEventId(this.eventID);
        }
        eventBaseType.setTimestamp(Calendar.getInstance());
        eventBaseType.setEventType(eventSchemaParser.getEventType());
        eventBaseType.setObjectId(eventSchemaParser.getObjectID());
        eventBaseType.setObjectType(eventSchemaParser.getObjectType());
        object7 = new SourceType();
        ((SourceType)object7).setProduct(eventSchemaParser.getProduct());
        String string = eventSchemaParser.getProductCallbackURI().trim();
        URI uRI = null;
        try {
            uRI = new URI(string, true);
            ((SourceType)object7).setProductCallbackURI(uRI);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((SourceType)object7).setProductInstance(eventSchemaParser.getProductInstance());
        ((SourceType)object7).setProductVersion(eventSchemaParser.getProductVersion());
        eventBaseType.setSource((SourceType)object7);
        credentialsType = new CredentialsType();
        HashMap hashMap = eventSchemaParser.getCredentialsTable();
        hashMap.putAll(this.userCredentialsTable);
        int n = hashMap.size();
        if (n > 0) {
            object6 = hashMap.keySet();
            object5 = new MessageElement[n];
            object4 = object6.toArray();
            for (int i = 0; i < ((Object[])object4).length; ++i) {
                String string2 = (String)object4[i];
                object3 = new QName(string2);
                object5[i] = object2 = new MessageElement((QName)object3, hashMap.get(string2));
            }
            credentialsType.set_any((MessageElement[])object5);
        }
        eventBaseType.setUser(credentialsType);
        object6 = new EmBaseType();
        ((EmBaseType)object6).setApplicationName(eventSchemaParser.getApplicationname());
        this.emEventID = eventSchemaParser.getEmEventID();
        if (this.emEventID == null || this.emEventID.length() < 1) {
            object5 = new SimpleUUIDGen();
            ((EmBaseType)object6).setEmEventId(((SimpleUUIDGen)object5).nextUUID());
        } else {
            ((EmBaseType)object6).setEmEventId(this.emEventID);
        }
        ((EmBaseType)object6).setEmTimestamp(Calendar.getInstance());
        credentialsType2 = new CredentialsType();
        hashMap = eventSchemaParser.getEmCredentialsTable();
        hashMap.putAll(this.emUserCredentialsTable);
        n = hashMap.size();
        if (n > 0) {
            object5 = hashMap.keySet();
            object4 = new MessageElement[n];
            Object[] objectArray = object5.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                object3 = (String)objectArray[i];
                object2 = new QName((String)object3);
                object4[i] = object = new MessageElement((QName)object2, hashMap.get(object3));
            }
            credentialsType2.set_any((MessageElement[])object4);
        }
        ((EmBaseType)object6).setEmUser(credentialsType2);
        ((EmBaseType)object6).setEnvironment(eventSchemaParser.getEnvironment());
        this.predecedingEmEventId = eventSchemaParser.getPredecedingEvent();
        if (this.predecedingEmEventId == null || this.predecedingEmEventId.length() < 1) {
            object5 = new SimpleUUIDGen();
            ((EmBaseType)object6).setPredecedingEmEventId(((SimpleUUIDGen)object5).nextUUID());
        } else {
            ((EmBaseType)object6).setPredecedingEmEventId(this.predecedingEmEventId);
        }
        this.serviceFlowID = eventSchemaParser.getServiceFlowId();
        if (this.serviceFlowID == null || this.serviceFlowID.length() < 1) {
            object5 = new SimpleUUIDGen();
            ((EmBaseType)object6).setServiceFlowId(((SimpleUUIDGen)object5).nextUUID());
        } else {
            ((EmBaseType)object6).setServiceFlowId(this.serviceFlowID);
        }
        this.callback = eventSchemaParser.getCallback();
        if (this.callback == null || this.callback.length() < 1) {
            ((EmBaseType)object6).setCallback(false);
        } else if (this.callback.equals("true") || this.callback.equals("1")) {
            ((EmBaseType)object6).setCallback(true);
        } else if (this.callback.equals("false") || this.callback.equals("0")) {
            ((EmBaseType)object6).setCallback(false);
        } else {
            ((EmBaseType)object6).setCallback(false);
        }
        object5 = new EmExtensionType();
        hashMap = eventSchemaParser.getEmExtensionDataTable();
        hashMap.putAll(this.emExtensionDataTable);
        n = hashMap.size();
        if (n > 0) {
            object4 = hashMap.keySet();
            MessageElement[] messageElementArray = new MessageElement[n];
            Object[] objectArray = object4.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                object2 = (String)objectArray[i];
                object = new QName((String)object2);
                messageElementArray[i] = serializable = new MessageElement((QName)object, hashMap.get(object2));
            }
            ((EmExtensionType)object5).set_any(messageElementArray);
        }
        ((EmBaseType)object6).setEmExtension((EmExtensionType)object5);
        this.callback = eventSchemaParser.getCallback();
        if (this.callback == null || this.callback.length() < 1) {
            ((EmBaseType)object6).setCallback(false);
        } else if (this.callback.equals("true") || this.callback.equals("1")) {
            ((EmBaseType)object6).setCallback(true);
        } else if (this.callback.equals("false") || this.callback.equals("0")) {
            ((EmBaseType)object6).setCallback(false);
        } else {
            ((EmBaseType)object6).setCallback(false);
        }
        ((EmBaseType)object6).setServiceFlowName("");
        ((EmBaseType)object6).setEventMatchName("");
        eventBaseType.setEventControl((EmBaseType)object6);
        object4 = new BaseExtensionType();
        hashMap = eventSchemaParser.getBaseExtensionDataTable();
        hashMap.putAll(this.baseExtensionDataTable);
        n = hashMap.size();
        if (n > 0) {
            Set set = hashMap.keySet();
            MessageElement[] messageElementArray = new MessageElement[n];
            Object[] objectArray = set.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                MessageElement messageElement;
                object = (String)objectArray[i];
                serializable = new QName((String)object);
                messageElementArray[i] = messageElement = new MessageElement((QName)serializable, hashMap.get(object));
            }
            ((BaseExtensionType)object4).set_any(messageElementArray);
        }
        eventBaseType.setBaseExtension((BaseExtensionType)object4);
        return eventBaseType;
    }

    public synchronized void run() {
        try {
            if (this.waitTime > 0) {
                EventEmitter.sleep(this.waitTime * 1000);
            }
            try {
                this.raiseEvent();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public synchronized void raiseEvent() throws RemoteException {
        this.binding.setTimeout(this.eventTimeout);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Event Raised for : ");
        stringBuffer.append("\n\n");
        stringBuffer.append("Event Type: " + this.alfEvent.getBase().getEventType() + "\n");
        stringBuffer.append("Event ID: " + this.alfEvent.getBase().getEventId() + "\n");
        stringBuffer.append("Timestamp: " + this.alfEvent.getBase().getTimestamp().getTime().toString() + "\n");
        stringBuffer.append("Object Type: " + this.alfEvent.getBase().getObjectType() + "\n");
        stringBuffer.append("Object ID: " + this.alfEvent.getBase().getObjectId() + "\n");
        stringBuffer.append("ApplicationName :" + this.alfEvent.getBase().getEventControl().getApplicationName() + "\n");
        stringBuffer.append("Product: " + this.alfEvent.getBase().getSource().getProduct() + "\n");
        stringBuffer.append("Version: " + this.alfEvent.getBase().getSource().getProductVersion() + "\n");
        stringBuffer.append("Instance: " + this.alfEvent.getBase().getSource().getProductInstance() + "\n");
        logger.debug((Object)stringBuffer.toString());
        ALFEventResponseType aLFEventResponseType = this.binding.eventNotice(this.alfEvent);
        logger.info((Object)"Event emitted Successfully");
    }

    public void setWaitTime(int n) {
        this.waitTime = n;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setServerURL(String string) {
        this.serverURL = string;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setEventType(String string) {
        this.eventType = string;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventID(String string) {
        this.eventID = string;
    }

    public String getEventID() {
        return this.eventID;
    }

    public void setEventDetailsURI(String string) {
        this.eventDetailsURI = string;
    }

    public String getEventDetailsURI() {
        return this.eventDetailsURI;
    }

    public void setEventDetails(String string, String string2) {
        this.eventDetailsTable.put(string, string2);
    }

    public void setToolExtensionDataURI(String string) {
        this.toolExtensionDataURI = string;
    }

    public String getToolExtensionDataURI() {
        return this.toolExtensionDataURI;
    }

    public void setToolExtensionData(String string, String string2) {
        this.toolExtensionDataTable.put(string, string2);
    }

    public String getObjectID() {
        return this.objectID;
    }

    public void setObjectID(String string) {
        this.objectID = string;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String string) {
        this.objectType = string;
    }

    public int getEventTimeout() {
        return this.eventTimeout;
    }

    public void setEventTimeout(int n) {
        this.eventTimeout = n;
    }
}

