/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.editors.eventactionmap;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.alf.editors.eventactionmap.EventMapEditor;
import org.eclipse.alf.editors.eventactionmap.EventMapEditorScreen;
import org.eclipse.alf.models.EventMap;
import org.eclipse.alf.models.RegisteredServiceFlow;
import org.eclipse.alf.models.ServiceFlow;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;

public class ServiceFlowSelectionDialog
extends Dialog {
    private List selecteditems;
    private List unselecteditems;
    private EventMapEditorScreen eventMapScreen = null;
    private String[] items;
    private String[] selectedItems;
    private Shell shell;
    private HashMap URLMap = new HashMap();
    private RegisteredServiceFlow[] serviceRegistryArray;
    private EventMap[] mapOfEvent = null;
    private HashSet selected = null;
    private HashSet unSelected = null;
    private int rowToBeEdited = -1;
    private static final int DIALOG_WIDTH = 645;
    private static final int DIALOG_HEIGHT = 480;

    public ServiceFlowSelectionDialog(Shell shell, int n) {
        super(shell, n);
    }

    public ServiceFlowSelectionDialog(Shell shell) {
        this(shell, 0);
    }

    public void open(EventMapEditorScreen eventMapEditorScreen, int n) {
        this.eventMapScreen = eventMapEditorScreen;
        this.mapOfEvent = this.eventMapScreen.getEventmapregArray();
        this.rowToBeEdited = n;
        this.shell = new Shell(this.getParent(), 67680);
        GridLayout gridLayout = new GridLayout();
        this.shell.setLayout((Layout)gridLayout);
        this.shell.setSize(645, 480);
        String string = this.mapOfEvent[n].getProduct() + "/" + this.mapOfEvent[n].getObjectType() + "/" + this.mapOfEvent[n].getEventType();
        this.shell.setText("Select ALF Service Flows for Event: " + string);
        if (this.mapOfEvent[n].getServiceFlows() != null && this.mapOfEvent[n].getServiceFlows().length != 0) {
            this.selectRegisterServiceFlows(this.mapOfEvent[n].getServiceFlows());
        } else {
            this.selectRegisterServiceFlows(null);
        }
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void createContents() {
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText("Available ALF Service Flows");
        new Label(composite, 0);
        Label label2 = new Label(composite, 0);
        label2.setText("ALF Service Flows");
        this.unselecteditems = new List(composite, 2834);
        this.unselecteditems.setLayoutData((Object)new GridData(218, 249));
        MouseTrackListener mouseTrackListener = new MouseTrackListener(){

            public void mouseHover(MouseEvent mouseEvent) {
                int n = ServiceFlowSelectionDialog.this.unselecteditems.getFocusIndex();
                String string = ServiceFlowSelectionDialog.this.unselecteditems.getItem(n);
                ServiceFlowSelectionDialog.this.unselecteditems.setToolTipText(string);
            }

            public void mouseEnter(MouseEvent mouseEvent) {
            }

            public void mouseExit(MouseEvent mouseEvent) {
            }
        };
        this.unselecteditems.addMouseTrackListener(mouseTrackListener);
        if (null != this.items) {
            this.unselecteditems.setItems(this.items);
        }
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(2, 2, false, false));
        composite2.setLayout((Layout)new GridLayout());
        Button button = new Button(composite2, 0);
        button.setLayoutData((Object)new GridData(60, -1));
        button.setText(">");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int[] nArray;
                if (ServiceFlowSelectionDialog.this.unselecteditems != null && (nArray = ServiceFlowSelectionDialog.this.unselecteditems.getSelectionIndices()) != null && nArray.length > 0) {
                    for (int i = 0; i < nArray.length; ++i) {
                        String string = ServiceFlowSelectionDialog.this.unselecteditems.getItem(nArray[i]);
                        ServiceFlowSelectionDialog.this.selecteditems.add(string);
                        ServiceFlowSelectionDialog.this.unselecteditems.remove(nArray[i]);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        Button button2 = new Button(composite2, 0);
        button2.setLayoutData((Object)new GridData(60, -1));
        button2.setText(">>");
        button2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ServiceFlowSelectionDialog.this.unselecteditems != null) {
                    int n = ServiceFlowSelectionDialog.this.unselecteditems.getItemCount();
                    if (n > 0) {
                        for (int i = 0; i < n; ++i) {
                            ServiceFlowSelectionDialog.this.selecteditems.add(ServiceFlowSelectionDialog.this.unselecteditems.getItem(i));
                        }
                    }
                    ServiceFlowSelectionDialog.this.unselecteditems.removeAll();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        Button button3 = new Button(composite2, 0);
        button3.setLayoutData((Object)new GridData(60, -1));
        button3.setText("<");
        button3.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int[] nArray;
                if (ServiceFlowSelectionDialog.this.selecteditems != null && (nArray = ServiceFlowSelectionDialog.this.selecteditems.getSelectionIndices()) != null && nArray.length > 0) {
                    for (int i = 0; i < nArray.length; ++i) {
                        String string = ServiceFlowSelectionDialog.this.selecteditems.getItem(nArray[i]);
                        ServiceFlowSelectionDialog.this.unselecteditems.add(string);
                        ServiceFlowSelectionDialog.this.selecteditems.remove(nArray[i]);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        Button button4 = new Button(composite2, 0);
        button4.setLayoutData((Object)new GridData(60, -1));
        button4.setText("<<");
        button4.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ServiceFlowSelectionDialog.this.selecteditems != null) {
                    int n = ServiceFlowSelectionDialog.this.selecteditems.getItemCount();
                    if (n > 0) {
                        for (int i = 0; i < n; ++i) {
                            ServiceFlowSelectionDialog.this.unselecteditems.add(ServiceFlowSelectionDialog.this.selecteditems.getItem(i));
                        }
                    }
                    ServiceFlowSelectionDialog.this.selecteditems.removeAll();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.selecteditems = new List(composite, 2834);
        this.selecteditems.setLayoutData((Object)new GridData(219, 249));
        MouseTrackListener mouseTrackListener2 = new MouseTrackListener(){

            public void mouseHover(MouseEvent mouseEvent) {
                int n = ServiceFlowSelectionDialog.this.selecteditems.getFocusIndex();
                String string = ServiceFlowSelectionDialog.this.selecteditems.getItem(n);
                ServiceFlowSelectionDialog.this.selecteditems.setToolTipText(string);
            }

            public void mouseEnter(MouseEvent mouseEvent) {
            }

            public void mouseExit(MouseEvent mouseEvent) {
            }
        };
        this.selecteditems.addMouseTrackListener(mouseTrackListener2);
        if (null != this.selectedItems) {
            this.selecteditems.setItems(this.selectedItems);
        }
        new Label(composite, 0);
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayoutData((Object)new GridData(2, 2, false, false));
        composite3.setLayout((Layout)new GridLayout(2, true));
        Button button5 = new Button(composite3, 0);
        button5.setLayoutData((Object)new GridData(50, -1));
        button5.setText("&Ok");
        Button button6 = new Button(composite3, 0);
        button6.setLayoutData((Object)new GridData(55, -1));
        button6.setText("&Cancel");
        button6.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ((Button)selectionEvent.getSource()).getShell().dispose();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        new Label(composite, 0);
        Composite composite4 = new Composite((Composite)this.shell, 0);
        composite4.setLayout((Layout)new GridLayout(2, false));
        Label label3 = new Label(composite4, 0);
        label3.setText("Edit Event Match Name");
        final Text text = new Text(composite4, 2049);
        text.setLayoutData((Object)new GridData(200, 20));
        text.setEditable(true);
        text.setText(this.mapOfEvent[this.rowToBeEdited].getEventMatchName());
        button5.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EventMap[] eventMapArray = ServiceFlowSelectionDialog.this.eventMapScreen.getEventmapregArray();
                String[] stringArray = ServiceFlowSelectionDialog.this.selecteditems.getItems();
                String string = "";
                ArrayList<ServiceFlow> arrayList = new ArrayList<ServiceFlow>();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i].substring(0, stringArray[i].indexOf("--"));
                    string = stringArray[i].substring(stringArray[i].indexOf("--") + 2, stringArray[i].length());
                    ServiceFlow serviceFlow = new ServiceFlow(string, string2, false);
                    arrayList.add(serviceFlow);
                }
                ServiceFlow[] serviceFlowArray = arrayList.toArray(new ServiceFlow[arrayList.size()]);
                eventMapArray[ServiceFlowSelectionDialog.this.rowToBeEdited].setServiceFlows(serviceFlowArray);
                eventMapArray[ServiceFlowSelectionDialog.this.rowToBeEdited].setServiceFlowName(string);
                if (serviceFlowArray != null && serviceFlowArray.length > 0) {
                    serviceFlowArray = new ServiceFlow[serviceFlowArray.length];
                    for (int i = 0; i < serviceFlowArray.length; ++i) {
                        serviceFlowArray[i] = (ServiceFlow)ServiceFlowSelectionDialog.this.URLMap.get(serviceFlowArray[i]);
                    }
                }
                boolean bl = false;
                if (eventMapArray.length > 0) {
                    for (int i = 0; i < eventMapArray.length; ++i) {
                        if (i != ServiceFlowSelectionDialog.this.rowToBeEdited) {
                            if (!eventMapArray[i].getEventMatchName().equalsIgnoreCase(text.getText().trim())) {
                                bl = true;
                                continue;
                            }
                            bl = false;
                            i = eventMapArray.length;
                            continue;
                        }
                        bl = true;
                    }
                } else {
                    bl = true;
                }
                Shell shell = ((Button)selectionEvent.getSource()).getShell();
                MessageBox messageBox = new MessageBox(ServiceFlowSelectionDialog.this.shell, 2);
                messageBox.setText("ALF Event-Action Map");
                if (bl && !text.getText().trim().equals("")) {
                    eventMapArray[ServiceFlowSelectionDialog.this.rowToBeEdited].setEventMatchName(text.getText().trim());
                    ServiceFlowSelectionDialog.this.eventMapScreen.setEventmapregArray(eventMapArray);
                    ServiceFlowSelectionDialog.this.eventMapScreen.saveEventmapValues();
                    shell.dispose();
                } else if (!bl) {
                    messageBox.setMessage("Event Match Name already exists");
                    if (messageBox.open() == 32) {
                        shell.forceFocus();
                    } else {
                        shell.dispose();
                    }
                } else {
                    messageBox.setMessage("Event Match Name is mandatory");
                    if (messageBox.open() == 32) {
                        shell.forceFocus();
                    } else {
                        shell.dispose();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        final Text text2 = new Text((Composite)this.shell, 2819);
        text2.setLayoutData((Object)new GridData(4, 4, true, true));
        text2.setEditable(false);
        this.unselecteditems.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                text2.setText("");
                String[] stringArray = ServiceFlowSelectionDialog.this.unselecteditems.getSelection();
                for (int i = 0; i < stringArray.length; ++i) {
                    text2.append(stringArray[i] + "\n");
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.selecteditems.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                text2.setText("");
                String[] stringArray = ServiceFlowSelectionDialog.this.selecteditems.getSelection();
                for (int i = 0; i < stringArray.length; ++i) {
                    text2.append(stringArray[i] + "\n");
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
    }

    private void selectRegisterServiceFlows(ServiceFlow[] serviceFlowArray) {
        Object object;
        try {
            this.selected = new HashSet();
            this.unSelected = new HashSet();
            object = null;
            object = (IFileEditorInput)this.eventMapScreen.getEditor().getEditorInput();
            IFile iFile = object.getFile();
            IProject iProject = iFile.getProject();
            String string = iProject.getLocation().toString();
            File file = new File(string);
            EventMapEditor eventMapEditor = new EventMapEditor();
            String string2 = eventMapEditor.getCurrentProject() + ".svc";
            File file2 = new File(file, string2);
            this.serviceRegistryArray = RegisteredServiceFlow.loadServiceRegistryXML((Composite)this.shell, file2);
            for (int i = 0; i < this.serviceRegistryArray.length; ++i) {
                String string3 = this.serviceRegistryArray[i].getServiceURL() + "?" + this.serviceRegistryArray[i].getEventOperation();
                String string4 = this.serviceRegistryArray[i].getServiceName();
                String string5 = string3.substring(string3.indexOf("/") + 2);
                String string6 = string5.substring(0, string5.indexOf("/"));
                String string7 = string3.substring(string3.lastIndexOf("/") + 1, string3.length());
                String string8 = string6 + "...." + string7;
                int n = serviceFlowArray != null ? this.serviceURLExists(serviceFlowArray, string3) : -1;
                this.URLMap.put(string8, string3);
                if (serviceFlowArray != null && serviceFlowArray.length > 0) {
                    for (int j = 0; j < serviceFlowArray.length; ++j) {
                        this.selected.add(serviceFlowArray[j].getEndPoint() + "--" + serviceFlowArray[j].getServiceFlowName());
                    }
                }
                if (n == 0) {
                    this.selected.add(string3 + "--" + string4);
                    continue;
                }
                this.unSelected.add(string3 + "--" + string4);
            }
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.unSelected != null) {
            this.items = new String[this.unSelected.size()];
            object = this.unSelected.iterator();
            int n = 0;
            while (object.hasNext()) {
                this.items[n++] = object.next().toString();
            }
        }
        if (this.selected != null) {
            this.selectedItems = new String[this.selected.size()];
            object = this.selected.iterator();
            int n = 0;
            while (object.hasNext()) {
                this.selectedItems[n++] = object.next().toString();
            }
        }
    }

    private int serviceURLExists(ServiceFlow[] serviceFlowArray, String string) {
        for (int i = 0; i < serviceFlowArray.length; ++i) {
            if (!string.equals(serviceFlowArray[i].getEndPoint())) continue;
            return 0;
        }
        return -1;
    }
}

