/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.editors.eventregistry;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.alf.editors.eventregistry.RegisterEventScreen;
import org.eclipse.alf.models.RegisteredEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditEventRegistration
extends Dialog {
    private Text evenTypeCombo;
    private Text objectTypeCombo;
    private Text productInstanceText;
    private Text productVersionText;
    private Text productText;
    private Text eventmatchNameText;
    private Button okButton = null;
    private RegisterEventScreen regEventScreen = null;
    private Shell shell;

    public EditEventRegistration(Shell shell, int n) {
        super(shell, n);
    }

    public EditEventRegistration(Shell shell) {
        this(shell, 0);
    }

    protected Shell getShell() {
        return this.shell;
    }

    public void open(RegisterEventScreen registerEventScreen, int n) {
        this.regEventScreen = registerEventScreen;
        this.createContents(n);
        this.getShell().open();
        this.getShell().layout();
        Display display = this.getParent().getDisplay();
        while (!this.getShell().isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void dialogChanged() {
        this.okButton.setEnabled(false);
        if (this.evenTypeCombo.getText().trim().length() > 0 && this.objectTypeCombo.getText().trim().length() > 0 && this.productText.getText().trim().length() > 0 && this.productVersionText.getText().trim().length() > 0 && this.productInstanceText.getText().trim().length() > 0 && this.eventmatchNameText.getText().trim().length() > 0) {
            this.okButton.setEnabled(true);
        }
    }

    private void createContents(final int n) {
        this.shell = new Shell(this.getParent(), 67680);
        this.getShell().setSize(500, 375);
        Label label = new Label((Composite)this.getShell(), 0);
        label.setText("Product");
        label.setBounds(34, 41, 135, 25);
        Label label2 = new Label((Composite)this.getShell(), 0);
        label2.setText("Product Version");
        label2.setBounds(34, 83, 75, 25);
        Label label3 = new Label((Composite)this.getShell(), 0);
        label3.setText("Product Instance");
        label3.setBounds(34, 123, 105, 30);
        Label label4 = new Label((Composite)this.getShell(), 0);
        label4.setText("Object Type");
        label4.setBounds(34, 163, 85, 35);
        Label label5 = new Label((Composite)this.getShell(), 0);
        label5.setText("Event Type");
        label5.setBounds(34, 209, 133, 25);
        Label label6 = new Label((Composite)this.getShell(), 0);
        label6.setText("Default Event Match Name");
        label6.setBounds(34, 249, 133, 25);
        this.productText = new Text((Composite)this.getShell(), 2048);
        this.productText.setBounds(182, 39, 245, 20);
        this.productVersionText = new Text((Composite)this.getShell(), 2048);
        this.productVersionText.setBounds(182, 78, 245, 20);
        this.productInstanceText = new Text((Composite)this.getShell(), 2048);
        this.productInstanceText.setBounds(182, 119, 245, 20);
        this.objectTypeCombo = new Text((Composite)this.getShell(), 2048);
        this.objectTypeCombo.setBounds(182, 161, 245, 20);
        this.evenTypeCombo = new Text((Composite)this.getShell(), 2048);
        this.evenTypeCombo.setBounds(182, 200, 245, 21);
        this.eventmatchNameText = new Text((Composite)this.getShell(), 2048);
        this.eventmatchNameText.setBounds(182, 240, 245, 21);
        RegisteredEvent[] registeredEventArray = this.regEventScreen.getEventReg();
        if (n >= 0 && n < registeredEventArray.length) {
            this.getShell().setText("Edit Event");
            this.productText.setText(registeredEventArray[n].getProduct() == null ? "" : registeredEventArray[n].getProduct());
            this.productInstanceText.setText(registeredEventArray[n].getProductInstance() == null ? "" : registeredEventArray[n].getProductInstance());
            this.productVersionText.setText(registeredEventArray[n].getProductVersion() == null ? "" : registeredEventArray[n].getProductVersion());
            this.objectTypeCombo.setText(registeredEventArray[n].getObjectType() == null ? "" : registeredEventArray[n].getObjectType());
            this.evenTypeCombo.setText(registeredEventArray[n].getEventType() == null ? "" : registeredEventArray[n].getEventType());
            this.eventmatchNameText.setText(registeredEventArray[n].getEventMatchName() == null ? "" : registeredEventArray[n].getEventMatchName());
        } else {
            this.getShell().setText("New Event");
        }
        this.okButton = new Button((Composite)this.getShell(), 0);
        this.okButton.setText("&Ok");
        if (this.evenTypeCombo.getText().trim().length() > 0 && this.objectTypeCombo.getText().trim().length() > 0 && this.productText.getText().trim().length() > 0 && this.productVersionText.getText().trim().length() > 0 && this.productInstanceText.getText().trim().length() > 0 && this.eventmatchNameText.getText().trim().length() > 0) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
        this.productText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EditEventRegistration.this.dialogChanged();
            }
        });
        this.productInstanceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EditEventRegistration.this.dialogChanged();
            }
        });
        this.productVersionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EditEventRegistration.this.dialogChanged();
            }
        });
        this.objectTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EditEventRegistration.this.dialogChanged();
            }
        });
        this.evenTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EditEventRegistration.this.dialogChanged();
            }
        });
        this.eventmatchNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EditEventRegistration.this.dialogChanged();
            }
        });
        Button button = new Button((Composite)this.getShell(), 0);
        button.setText("&Cancel");
        button.setBounds(275, 280, 92, 24);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Composite composite = ((Button)selectionEvent.getSource()).getParent();
                composite.dispose();
            }
        });
        if (n == -1) {
            this.registeredEvents(this.okButton);
        } else {
            this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    RegisteredEvent[] registeredEventArray = EditEventRegistration.this.regEventScreen.getEventReg();
                    boolean bl = false;
                    Pattern pattern = Pattern.compile("^[A-Za-z0-9\\.\\s_-]+$");
                    Matcher matcher = pattern.matcher(EditEventRegistration.this.evenTypeCombo.getText() + EditEventRegistration.this.objectTypeCombo.getText() + EditEventRegistration.this.productText.getText() + EditEventRegistration.this.productInstanceText.getText() + EditEventRegistration.this.productVersionText.getText() + EditEventRegistration.this.eventmatchNameText.getText());
                    bl = matcher.matches();
                    if (!bl && EditEventRegistration.this.evenTypeCombo.getText().trim().length() > 0 && EditEventRegistration.this.objectTypeCombo.getText().trim().length() > 0 && EditEventRegistration.this.productText.getText().trim().length() > 0 && EditEventRegistration.this.productVersionText.getText().trim().length() > 0 && EditEventRegistration.this.productInstanceText.getText().trim().length() > 0 && EditEventRegistration.this.eventmatchNameText.getText().trim().length() > 0) {
                        Composite composite = ((Button)selectionEvent.getSource()).getParent();
                        MessageBox messageBox = new MessageBox(EditEventRegistration.this.getShell(), 34);
                        messageBox.setText("ALFEvent Registry ");
                        messageBox.setMessage("Invalid text. Special characters not allowed !");
                        if (messageBox.open() == 32) {
                            composite.forceFocus();
                        } else {
                            composite = ((Button)selectionEvent.getSource()).getParent();
                            composite.dispose();
                        }
                    }
                    boolean bl2 = EditEventRegistration.this.eventExist(registeredEventArray, n);
                    boolean bl3 = EditEventRegistration.this.eventMatchExist(registeredEventArray, n);
                    if (!(registeredEventArray[n].getEventType().equalsIgnoreCase(EditEventRegistration.this.evenTypeCombo.getText().trim()) && registeredEventArray[n].getObjectType().equalsIgnoreCase(EditEventRegistration.this.objectTypeCombo.getText().trim()) && registeredEventArray[n].getProduct().equalsIgnoreCase(EditEventRegistration.this.productText.getText().trim()) && registeredEventArray[n].getProductInstance().equalsIgnoreCase(EditEventRegistration.this.productInstanceText.getText().trim()) && registeredEventArray[n].getProductVersion().equalsIgnoreCase(EditEventRegistration.this.productVersionText.getText().trim()) && registeredEventArray[n].getEventMatchName().equalsIgnoreCase(EditEventRegistration.this.eventmatchNameText.getText().trim()))) {
                        if (bl2 && bl && bl3) {
                            registeredEventArray[n].setEventType(EditEventRegistration.this.evenTypeCombo.getText().trim());
                            registeredEventArray[n].setObjectType(EditEventRegistration.this.objectTypeCombo.getText().trim());
                            registeredEventArray[n].setProduct(EditEventRegistration.this.productText.getText().trim());
                            registeredEventArray[n].setProductInstance(EditEventRegistration.this.productInstanceText.getText().trim());
                            registeredEventArray[n].setProductVersion(EditEventRegistration.this.productVersionText.getText().trim());
                            registeredEventArray[n].setEventMatchName(EditEventRegistration.this.eventmatchNameText.getText().trim());
                            EditEventRegistration.this.regEventScreen.setEventReg(registeredEventArray);
                            EditEventRegistration.this.regEventScreen.saveEventRegistryXML();
                            Composite composite = ((Button)selectionEvent.getSource()).getParent();
                            composite.dispose();
                        } else if (!bl2) {
                            Composite composite = ((Button)selectionEvent.getSource()).getParent();
                            MessageBox messageBox = new MessageBox(EditEventRegistration.this.getShell(), 34);
                            messageBox.setMessage("Event already registered");
                            messageBox.setText("ALFEvent Registry ");
                            if (messageBox.open() == 32) {
                                composite.forceFocus();
                            } else {
                                composite = ((Button)selectionEvent.getSource()).getParent();
                                composite.dispose();
                            }
                        } else if (!bl3) {
                            Composite composite = ((Button)selectionEvent.getSource()).getParent();
                            MessageBox messageBox = new MessageBox(EditEventRegistration.this.getShell(), 34);
                            messageBox.setMessage("Event Match Name already exists");
                            messageBox.setText("ALF Events Registry ");
                            if (messageBox.open() == 32) {
                                composite.forceFocus();
                            } else {
                                composite = ((Button)selectionEvent.getSource()).getParent();
                                composite.dispose();
                            }
                        }
                    } else if (bl) {
                        registeredEventArray[n].setEventType(EditEventRegistration.this.evenTypeCombo.getText().trim());
                        registeredEventArray[n].setObjectType(EditEventRegistration.this.objectTypeCombo.getText().trim());
                        registeredEventArray[n].setProduct(EditEventRegistration.this.productText.getText().trim());
                        registeredEventArray[n].setProductInstance(EditEventRegistration.this.productInstanceText.getText().trim());
                        registeredEventArray[n].setProductVersion(EditEventRegistration.this.productVersionText.getText().trim());
                        registeredEventArray[n].setEventMatchName(EditEventRegistration.this.eventmatchNameText.getText().trim());
                        EditEventRegistration.this.regEventScreen.setEventReg(registeredEventArray);
                        EditEventRegistration.this.regEventScreen.saveEventRegistryXML();
                        Composite composite = ((Button)selectionEvent.getSource()).getParent();
                        composite.dispose();
                    }
                }
            });
        }
        this.okButton.setBounds(165, 280, 92, 24);
    }

    private void registeredEvents(Button button) {
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n;
                RegisteredEvent[] registeredEventArray = EditEventRegistration.this.regEventScreen.getEventReg();
                RegisteredEvent[] registeredEventArray2 = new RegisteredEvent[EditEventRegistration.this.regEventScreen.getEventReg().length + 1];
                for (n = 0; n < registeredEventArray2.length - 1; ++n) {
                    registeredEventArray2[n] = registeredEventArray[n];
                }
                n = 0;
                Pattern pattern = Pattern.compile("^[A-Za-z0-9\\.\\s_-]+$");
                Matcher matcher = pattern.matcher(EditEventRegistration.this.evenTypeCombo.getText() + EditEventRegistration.this.objectTypeCombo.getText() + EditEventRegistration.this.productText.getText() + EditEventRegistration.this.productInstanceText.getText() + EditEventRegistration.this.productVersionText.getText() + EditEventRegistration.this.eventmatchNameText.getText());
                n = matcher.matches() ? 1 : 0;
                if (n == 0 && EditEventRegistration.this.evenTypeCombo.getText().trim().length() > 0 && EditEventRegistration.this.objectTypeCombo.getText().trim().length() > 0 && EditEventRegistration.this.productText.getText().trim().length() > 0 && EditEventRegistration.this.productVersionText.getText().trim().length() > 0 && EditEventRegistration.this.productInstanceText.getText().trim().length() > 0 && EditEventRegistration.this.eventmatchNameText.getText().trim().length() > 0) {
                    Composite composite = ((Button)selectionEvent.getSource()).getParent();
                    MessageBox messageBox = new MessageBox(EditEventRegistration.this.getShell(), 34);
                    messageBox.setText("ALFEvent Registry ");
                    messageBox.setMessage("Invalid text. Special characters not allowed !");
                    if (messageBox.open() == 32) {
                        composite.forceFocus();
                    } else {
                        composite = ((Button)selectionEvent.getSource()).getParent();
                        composite.dispose();
                    }
                }
                registeredEventArray2[registeredEventArray2.length - 1] = new RegisteredEvent();
                registeredEventArray2[registeredEventArray2.length - 1].setEventType(EditEventRegistration.this.evenTypeCombo.getText().trim());
                registeredEventArray2[registeredEventArray2.length - 1].setObjectType(EditEventRegistration.this.objectTypeCombo.getText().trim());
                registeredEventArray2[registeredEventArray2.length - 1].setProduct(EditEventRegistration.this.productText.getText().trim());
                registeredEventArray2[registeredEventArray2.length - 1].setProductInstance(EditEventRegistration.this.productInstanceText.getText().trim());
                registeredEventArray2[registeredEventArray2.length - 1].setProductVersion(EditEventRegistration.this.productVersionText.getText().trim());
                registeredEventArray2[registeredEventArray2.length - 1].setEventMatchName(EditEventRegistration.this.eventmatchNameText.getText().trim());
                boolean bl = EditEventRegistration.this.eventExist(registeredEventArray, -1);
                boolean bl2 = EditEventRegistration.this.eventMatchExist(registeredEventArray, -1);
                if (registeredEventArray.length > 0) {
                    if (bl && n != 0 && bl2) {
                        EditEventRegistration.this.regEventScreen.setEventReg(registeredEventArray2);
                        EditEventRegistration.this.regEventScreen.saveEventRegistryXML();
                        Composite composite = ((Button)selectionEvent.getSource()).getParent();
                        composite.dispose();
                    } else if (!bl) {
                        Composite composite = ((Button)selectionEvent.getSource()).getParent();
                        MessageBox messageBox = new MessageBox(EditEventRegistration.this.getShell(), 34);
                        messageBox.setMessage("Event already registered");
                        messageBox.setText("ALF Events Registry ");
                        if (messageBox.open() == 32) {
                            composite.forceFocus();
                        } else {
                            composite = ((Button)selectionEvent.getSource()).getParent();
                            composite.dispose();
                        }
                    } else if (!bl2) {
                        Composite composite = ((Button)selectionEvent.getSource()).getParent();
                        MessageBox messageBox = new MessageBox(EditEventRegistration.this.getShell(), 34);
                        messageBox.setMessage("Event Match Name already exists");
                        messageBox.setText("ALF Events Registry ");
                        if (messageBox.open() == 32) {
                            composite.forceFocus();
                        } else {
                            composite = ((Button)selectionEvent.getSource()).getParent();
                            composite.dispose();
                        }
                    }
                } else if (n != 0) {
                    EditEventRegistration.this.regEventScreen.setEventReg(registeredEventArray2);
                    EditEventRegistration.this.regEventScreen.saveEventRegistryXML();
                    Composite composite = ((Button)selectionEvent.getSource()).getParent();
                    composite.dispose();
                }
            }
        });
    }

    public boolean eventExist(RegisteredEvent[] registeredEventArray, int n) {
        boolean bl = false;
        if (registeredEventArray.length > 0) {
            for (int i = 0; i < registeredEventArray.length; ++i) {
                if (i != n) {
                    if (!(registeredEventArray[i].getProduct().equalsIgnoreCase(this.productText.getText().trim()) && registeredEventArray[i].getProductVersion().equalsIgnoreCase(this.productVersionText.getText().trim()) && registeredEventArray[i].getProductInstance().equalsIgnoreCase(this.productInstanceText.getText().trim()) && registeredEventArray[i].getObjectType().equalsIgnoreCase(this.objectTypeCombo.getText().trim()) && registeredEventArray[i].getEventType().equalsIgnoreCase(this.evenTypeCombo.getText().trim()))) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                    i = registeredEventArray.length;
                    continue;
                }
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public boolean eventMatchExist(RegisteredEvent[] registeredEventArray, int n) {
        boolean bl = false;
        if (registeredEventArray.length > 0) {
            for (int i = 0; i < registeredEventArray.length; ++i) {
                if (i != n) {
                    if (!registeredEventArray[i].getEventMatchName().equalsIgnoreCase(this.eventmatchNameText.getText().trim())) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                    i = registeredEventArray.length;
                    continue;
                }
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }
}

