/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.editors.eventregistry;

import java.io.File;
import java.io.IOException;
import org.eclipse.alf.editors.eventregistry.RegisterEventScreen;
import org.eclipse.alf.editors.xml.ALFXMLEditor;
import org.eclipse.alf.editors.xml.ALFXMLEditorInput;
import org.eclipse.alf.models.RegisteredEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class EventEditor
extends MultiPageEditorPart
implements IResourceChangeListener {
    private String eventRegistryLocation;
    private TextEditor editor = new TextEditor();
    private ALFXMLEditor registeredEventEditor;
    private RegisterEventScreen regEventScreen;
    private boolean saving = false;

    public EventEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public File findFileName(String string) {
        IFileEditorInput iFileEditorInput = null;
        iFileEditorInput = (IFileEditorInput)this.getEditorInput();
        IFile iFile = iFileEditorInput.getFile();
        IProject iProject = iFile.getProject();
        String string2 = iProject.getLocation().toString();
        File file = new File(string2);
        File file2 = new File(file, string);
        return file2;
    }

    public RegisteredEvent[] loadEventRegistryXML(String string, IFileEditorInput iFileEditorInput) throws IOException {
        IFile iFile = iFileEditorInput.getFile();
        IProject iProject = iFile.getProject();
        String string2 = iProject.getLocation().toString();
        File file = new File(string2);
        File file2 = new File(file, string);
        RegisteredEvent[] registeredEventArray = RegisteredEvent.loadEventRegistryXML(this.getContainer(), file2);
        return registeredEventArray;
    }

    private void registerEventPageSource() {
        this.registeredEventEditor = new ALFXMLEditor();
        try {
            String string = this.getEventRegistryLocation();
            File file = this.findFileName(string);
            IFileEditorInput iFileEditorInput = null;
            iFileEditorInput = (IFileEditorInput)this.getEditorInput();
            IFile iFile = iFileEditorInput.getFile();
            IProject iProject = iFile.getProject();
            iFile = iProject.getFile(string);
            ALFXMLEditorInput aLFXMLEditorInput = new ALFXMLEditorInput(file, iFile);
            this.addPage(1, (IEditorPart)this.registeredEventEditor, (IEditorInput)aLFXMLEditorInput);
            this.setPageText(1, "Source");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void createPages() {
        try {
            this.setPartName(this.getTitle());
            this.registerEventPageScreen();
            this.registerEventPageSource();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        try {
            int n = this.getActivePage();
            this.getEditor(n).doSave(iProgressMonitor);
            RegisteredEvent[] registeredEventArray = this.loadEventRegistryXML(this.getEventRegistryLocation());
            this.regEventScreen.setEventReg(registeredEventArray);
            this.regEventScreen.refresh();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doSaveAs() {
        int n = this.getActivePage();
        IEditorPart iEditorPart = this.getEditor(n);
        if (iEditorPart.isDirty()) {
            iEditorPart.doSaveAs();
            this.setPageText(n, iEditorPart.getTitle());
            this.setInput(iEditorPart.getEditorInput());
        }
    }

    public boolean isDirty() {
        IEditorPart iEditorPart = this.getActiveEditor();
        return iEditorPart != null ? iEditorPart.isDirty() : false;
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        if (!(iEditorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(iEditorSite, iEditorInput);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int n) {
        if (this.saving) {
            return;
        }
        switch (n) {
            case 0: {
                try {
                    if (this.registeredEventEditor.isDirty()) {
                        this.saving = true;
                        this.setActivePage(1);
                        MessageBox messageBox = new MessageBox(this.getContainer().getShell(), 194);
                        messageBox.setMessage("Do you wish to save the file, overwriting the previous version ?");
                        messageBox.setText("ALF Events Registry ");
                        if (messageBox.open() == 64) {
                            this.doSave(null);
                        } else {
                            String string = this.getEventRegistryLocation();
                            File file = this.findFileName(string);
                            IFileEditorInput iFileEditorInput = null;
                            iFileEditorInput = (IFileEditorInput)this.getEditorInput();
                            IFile iFile = iFileEditorInput.getFile();
                            IProject iProject = iFile.getProject();
                            iFile = iProject.getFile(string);
                            ALFXMLEditorInput aLFXMLEditorInput = new ALFXMLEditorInput(file, iFile);
                            this.registeredEventEditor.setInput((IEditorInput)aLFXMLEditorInput);
                        }
                        this.saving = false;
                        this.setActivePage(0);
                        break;
                    }
                    String string = this.getEventRegistryLocation();
                    RegisteredEvent[] registeredEventArray = this.loadEventRegistryXML(string);
                    this.regEventScreen.setEventReg(registeredEventArray);
                    this.regEventScreen.refresh();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 1: {
                try {
                    String string = this.getEventRegistryLocation();
                    File file = this.findFileName(string);
                    IFileEditorInput iFileEditorInput = null;
                    iFileEditorInput = (IFileEditorInput)this.getEditorInput();
                    IFile iFile = iFileEditorInput.getFile();
                    IProject iProject = iFile.getProject();
                    iFile = iProject.getFile(string);
                    ALFXMLEditorInput aLFXMLEditorInput = new ALFXMLEditorInput(file, iFile);
                    this.registeredEventEditor.setInput((IEditorInput)aLFXMLEditorInput);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
        }
        super.pageChange(n);
    }

    public void resourceChanged(final IResourceChangeEvent iResourceChangeEvent) {
        if (iResourceChangeEvent.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] iWorkbenchPageArray = EventEditor.this.getSite().getWorkbenchWindow().getPages();
                    for (int i = 0; i < iWorkbenchPageArray.length; ++i) {
                        if (!((FileEditorInput)EventEditor.this.editor.getEditorInput()).getFile().getProject().equals(iResourceChangeEvent.getResource())) continue;
                        IEditorPart iEditorPart = iWorkbenchPageArray[i].findEditor(EventEditor.this.editor.getEditorInput());
                        iWorkbenchPageArray[i].closeEditor(iEditorPart, true);
                    }
                }
            });
        }
    }

    private void registerEventPageScreen() {
        ScrolledComposite scrolledComposite = new ScrolledComposite(this.getContainer(), 768);
        scrolledComposite.setAlwaysShowScrollBars(true);
        scrolledComposite.setLayout((Layout)new GridLayout());
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 1;
        gridLayout.verticalSpacing = 1;
        Composite composite = new Composite((Composite)scrolledComposite, 20);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 0));
        try {
            String string = this.getEventRegistryLocation();
            RegisteredEvent[] registeredEventArray = this.loadEventRegistryXML(string);
            this.regEventScreen = new RegisterEventScreen(this);
            this.regEventScreen.createContents(composite, registeredEventArray);
            composite.pack();
            composite.redraw();
            composite.update();
            scrolledComposite.setContent((Control)composite);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.addPage(0, (Control)scrolledComposite);
        this.setPageText(0, "Designer");
    }

    private RegisteredEvent[] loadEventRegistryXML(String string) throws IOException {
        File file = this.findFileName(string);
        RegisteredEvent[] registeredEventArray = RegisteredEvent.loadEventRegistryXML(this.getContainer(), file);
        return registeredEventArray;
    }

    public String getEventRegistryLocation() {
        IFileEditorInput iFileEditorInput = null;
        iFileEditorInput = (IFileEditorInput)this.getEditorInput();
        IFile iFile = iFileEditorInput.getFile();
        this.eventRegistryLocation = iFile.getName();
        return this.eventRegistryLocation;
    }

    public void setEventRegistryLocation(String string) {
        this.eventRegistryLocation = string;
    }
}

