/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.editors.serviceflowregistry;

import java.io.File;
import org.eclipse.alf.editors.serviceflowregistry.EditServiceFlowRegistration;
import org.eclipse.alf.editors.serviceflowregistry.ServiceFlowEditor;
import org.eclipse.alf.editors.serviceflowregistry.ServiceFlowSelectionAdapter;
import org.eclipse.alf.models.RegisteredServiceFlow;
import org.eclipse.alf.util.ArrayManager;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RegisterServiceFlowScreen
extends ApplicationWindow {
    private Group composite;
    private Composite container;
    private Text txtServiceURL;
    private Text txtOperations;
    private Text txtDescription;
    private Text txtService;
    private int noOfRows = 0;
    private RegisteredServiceFlow[] serviceReg = null;
    private ServiceFlowEditor serviceFlowEditor;
    private static final int TXT_LIMIT = 30;
    private static final String BLANK_STRING = "                                                                                                    ";

    public RegisterServiceFlowScreen() {
        super(null);
        this.createActions();
        this.addCoolBar(0x800000);
        this.addMenuBar();
        this.addStatusLine();
    }

    public RegisterServiceFlowScreen(ServiceFlowEditor serviceFlowEditor) {
        super(null);
        this.serviceFlowEditor = serviceFlowEditor;
        this.createActions();
        this.addCoolBar(0x800000);
        this.addMenuBar();
        this.addStatusLine();
    }

    public Composite getComposite() {
        return this.composite;
    }

    public RegisteredServiceFlow[] getServiceReg() {
        return this.serviceReg;
    }

    public void setServiceReg(RegisteredServiceFlow[] registeredServiceFlowArray) {
        this.serviceReg = registeredServiceFlowArray;
    }

    protected ServiceFlowEditor getServiceFlowEditor() {
        return this.serviceFlowEditor;
    }

    public Control createContents(Composite composite, RegisteredServiceFlow[] registeredServiceFlowArray) {
        this.serviceReg = registeredServiceFlowArray;
        Group group = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 6;
        gridLayout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)gridLayout);
        Button button = new Button((Composite)group, 0);
        button.setText("         &New Service Flow         ");
        button.addSelectionListener((SelectionListener)new ServiceFlowSelectionAdapter(this){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Shell shell = ((Button)selectionEvent.getSource()).getParent().getParent().getParent().getShell();
                EditServiceFlowRegistration editServiceFlowRegistration = new EditServiceFlowRegistration(shell, 1);
                editServiceFlowRegistration.open(this.getPage(), -1);
            }
        });
        Label label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(4, 2, true, true, 0, 0));
        label.setText("label                                   ");
        label.setVisible(false);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.numColumns = 6;
        gridLayout2.makeColumnsEqualWidth = false;
        gridLayout2.horizontalSpacing = 1;
        gridLayout2.verticalSpacing = 1;
        this.composite = new Group(composite, 20);
        this.composite.setLayout((Layout)gridLayout2);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 0));
        this.composite.setText("Registered Service Flows");
        if (null != registeredServiceFlowArray && registeredServiceFlowArray.length > 0) {
            this.createRow((Composite)this.composite, registeredServiceFlowArray);
            this.composite.pack();
            this.composite.redraw();
            composite.update();
        } else {
            this.composite.setSize(800, 400);
            composite.pack();
            composite.redraw();
            this.composite.update();
            composite.update();
        }
        this.setContainer(composite);
        composite.update();
        return composite;
    }

    public void refresh() {
        this.noOfRows = 0;
        this.composite.dispose();
        this.getContainer().pack();
        this.getContainer().redraw();
        this.getContainer().update();
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 6;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.horizontalSpacing = 1;
        gridLayout.verticalSpacing = 1;
        this.composite = new Group(this.getContainer(), 20);
        this.composite.setLayout((Layout)gridLayout);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
        this.composite.setText("Registered Service Flows");
        if (null != this.serviceReg && this.serviceReg.length > 0) {
            this.createRow((Composite)this.composite, this.serviceReg);
            this.composite.pack();
            this.composite.redraw();
            this.getContainer().pack();
            this.getContainer().redraw();
        } else {
            this.composite.setSize(800, 400);
            this.getContainer().pack();
            this.getContainer().redraw();
            this.composite.update();
            this.getContainer().update();
        }
        this.composite.update();
        this.getContainer().update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveServiceFlowRegistryXML() {
        try {
            String string = this.serviceFlowEditor.getServiceFlowRegistryLocation();
            File file = this.getServiceFlowEditor().findFileName(string);
            RegisteredServiceFlow.saveServiceFlowRegistryXML(this.serviceReg, file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.refresh();
        }
    }

    protected MenuManager createMenuManager() {
        MenuManager menuManager = new MenuManager("menu");
        return menuManager;
    }

    protected CoolBarManager createCoolBarManager(int n) {
        CoolBarManager coolBarManager = new CoolBarManager(n);
        return coolBarManager;
    }

    protected StatusLineManager createStatusLineManager() {
        StatusLineManager statusLineManager = new StatusLineManager();
        statusLineManager.setMessage(null, "");
        return statusLineManager;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("New Application");
    }

    private void createRow(final Composite composite, RegisteredServiceFlow[] registeredServiceFlowArray) {
        Button button = new Button(composite, 2048);
        button.setLayoutData((Object)new GridData(4, 2, true, true, 0, 0));
        button.setText("          Edit           ");
        button.setVisible(false);
        Button button2 = new Button(composite, 0);
        button2.setLayoutData((Object)new GridData(4, 2, true, true, 0, 0));
        button2.setText("          Edit           ");
        button2.setVisible(false);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(2, 2, true, true, 0, 0));
        label.setText("Service Flow Name              ");
        Label label2 = new Label(composite, 0);
        label2.setLayoutData((Object)new GridData(2, 2, true, true, 0, 0));
        label2.setText("Description              ");
        Label label3 = new Label(composite, 0);
        label3.setLayoutData((Object)new GridData(2, 2, true, true, 0, 0));
        label3.setText("Operations               ");
        Label label4 = new Label(composite, 0);
        label4.setLayoutData((Object)new GridData(2, 2, true, true, 0, 0));
        label4.setText("Service URL              ");
        for (int i = 0; i < registeredServiceFlowArray.length; ++i) {
            Button button3 = new Button(composite, 2048);
            button3.setLayoutData((Object)new GridData(4, 2, true, true, 0, 0));
            button3.setText("          Edit          ");
            button3.setData((Object)("" + this.noOfRows));
            button3.setBackground(Display.getCurrent().getSystemColor(1));
            button3.addSelectionListener((SelectionListener)new ServiceFlowSelectionAdapter(this){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Button button = (Button)selectionEvent.getSource();
                    String string = button.getData().toString();
                    if (string != null) {
                        int n = 0;
                        try {
                            n = Integer.parseInt(string);
                            Button button2 = (Button)selectionEvent.getSource();
                            Shell shell = button2.getShell();
                            EditServiceFlowRegistration editServiceFlowRegistration = new EditServiceFlowRegistration(shell, 1);
                            editServiceFlowRegistration.open(this.getPage(), n);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
            Button button4 = new Button(composite, 2048);
            button4.setLayoutData((Object)new GridData(4, 2, true, true, 0, 0));
            button4.setText("         Delete         ");
            button4.setBackground(Display.getCurrent().getSystemColor(1));
            button4.setData((Object)("" + this.noOfRows));
            button4.addSelectionListener((SelectionListener)new ServiceFlowSelectionAdapter(this){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Button button;
                    String string;
                    MessageBox messageBox = new MessageBox(composite.getShell(), 196);
                    messageBox.setMessage("Are you sure to delete the service flow ?");
                    messageBox.setText("Delete Service Flow ");
                    if (messageBox.open() == 64 && (string = (button = (Button)selectionEvent.getSource()).getData().toString()) != null) {
                        int n = 0;
                        try {
                            n = Integer.parseInt(string);
                            Object[] objectArray = this.getPage().getServiceReg();
                            Object[] objectArray2 = ArrayManager.deleteAndAdjust(objectArray, n);
                            objectArray = new RegisteredServiceFlow[objectArray2.length];
                            for (int i = 0; i < objectArray2.length; ++i) {
                                objectArray[i] = (RegisteredServiceFlow)objectArray2[i];
                            }
                            this.getPage().setServiceReg((RegisteredServiceFlow[])objectArray);
                            this.getPage().saveServiceFlowRegistryXML();
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                }
            });
            this.txtService = new Text(composite, 2120);
            this.txtService.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
            this.txtService.setTextLimit(30);
            this.txtService.setBackground(Display.getCurrent().getSystemColor(22));
            this.txtService.setTabs(8);
            String string = this.getSubString(registeredServiceFlowArray[i].getServiceName());
            this.txtService.setText(string);
            this.txtService.setToolTipText(registeredServiceFlowArray[i].getServiceName());
            this.txtDescription = new Text(composite, 2120);
            this.txtDescription.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
            this.txtDescription.setBackground(Display.getCurrent().getSystemColor(22));
            string = this.getSubString(registeredServiceFlowArray[i].getDescriptions());
            this.txtDescription.setText(string);
            this.txtDescription.setToolTipText(registeredServiceFlowArray[i].getDescriptions());
            this.txtOperations = new Text(composite, 2120);
            this.txtOperations.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
            this.txtOperations.setBackground(Display.getCurrent().getSystemColor(22));
            string = this.getSubString(registeredServiceFlowArray[i].getEventOperation());
            this.txtOperations.setText(string);
            this.txtOperations.setToolTipText(registeredServiceFlowArray[i].getEventOperation());
            this.txtServiceURL = new Text(composite, 2376);
            this.txtServiceURL.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
            this.txtServiceURL.setBackground(Display.getCurrent().getSystemColor(22));
            string = this.getSubString(registeredServiceFlowArray[i].getServiceURL());
            this.txtServiceURL.setText(string);
            this.txtServiceURL.setToolTipText(registeredServiceFlowArray[i].getServiceURL());
            ++this.noOfRows;
        }
    }

    private String getSubString(String string) {
        int n = 30 - (string == null ? 0 : string.length());
        String string2 = "";
        if (string == null) {
            string = "";
        }
        string2 = n > 0 ? (n > 16 ? string + BLANK_STRING.substring(0, n * 2) : string + BLANK_STRING.substring(0, Math.abs(n * 3))) : string.substring(0, string.length() + n);
        return string2;
    }

    private void createActions() {
    }

    public Composite getContainer() {
        return this.container;
    }

    public void setContainer(Composite composite) {
        this.container = composite;
    }
}

