/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.models;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.alf.editors.eventactionmap.EventMapEditorScreen;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class RegisteredServiceFlow {
    private String serviceName;
    private String descriptions;
    private String eventOperation;
    private String serviceURL;

    public static RegisteredServiceFlow[] loadServiceRegistryXML(Composite composite, File file) throws IOException {
        RegisteredServiceFlow[] registeredServiceFlowArray = null;
        try {
            int n;
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = null;
            document = file.exists() ? sAXBuilder.build(file) : new Document(new Element("ALFServiceFlowRegistry"));
            if (document.getRootElement() == null) {
                throw new JDOMException();
            }
            Element element = document.getRootElement();
            Namespace namespace = element.getNamespace();
            List list = element.getChildren("ServiceFlows", element.getNamespace());
            ArrayList<RegisteredServiceFlow> arrayList = new ArrayList<RegisteredServiceFlow>();
            registeredServiceFlowArray = new RegisteredServiceFlow[list.size()];
            for (n = 0; n < list.size(); ++n) {
                Element element2 = (Element)list.get(n);
                String string = element2.getChildText("ServiceName", namespace);
                String string2 = element2.getChildText("ServiceDescription", namespace);
                String string3 = element2.getChildText("ServiceURL", namespace);
                Element element3 = element2.getChild("Operations", namespace);
                List list2 = element3.getChildren("Operation", namespace);
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    RegisteredServiceFlow registeredServiceFlow = new RegisteredServiceFlow();
                    Element element4 = (Element)iterator.next();
                    registeredServiceFlow.serviceName = string;
                    registeredServiceFlow.descriptions = string2;
                    registeredServiceFlow.serviceURL = string3;
                    registeredServiceFlow.eventOperation = element4.getText();
                    arrayList.add(registeredServiceFlow);
                }
            }
            registeredServiceFlowArray = new RegisteredServiceFlow[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                registeredServiceFlowArray[n] = new RegisteredServiceFlow();
                registeredServiceFlowArray[n] = (RegisteredServiceFlow)arrayList.get(n);
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (JDOMException jDOMException) {
            MessageBox messageBox = new MessageBox(composite.getShell(), 1);
            messageBox.setMessage("ALF Service Flow Registry is not valid : " + jDOMException.getMessage());
            messageBox.setText("ALF Service Flow Registry ");
            messageBox.open();
            EventMapEditorScreen.consolePrint("ALF ServiceFlow Registry XML is not Valid " + jDOMException.getMessage());
        }
        return registeredServiceFlowArray;
    }

    public static void saveServiceFlowRegistryXML(RegisteredServiceFlow[] registeredServiceFlowArray, File file) {
        try {
            RegisteredServiceFlow registeredServiceFlow;
            int n;
            Namespace namespace = Namespace.getNamespace((String)"p", (String)"http://www.eclipse.org/ALF/XMLSchema/EventRule");
            Namespace namespace2 = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
            String string = "xsi:schemaLocation=http://www.eclipse.org/ALF/XMLSchema/EventRule EventActionMap.xsd";
            Namespace.getNamespace((String)string);
            Element element = new Element("ALFServiceFlowRegistry");
            Document document = new Document(element);
            ArrayList<RegisteredServiceFlow> arrayList = new ArrayList<RegisteredServiceFlow>();
            for (n = 0; n < registeredServiceFlowArray.length; ++n) {
                registeredServiceFlow = new RegisteredServiceFlow();
                registeredServiceFlow.serviceName = registeredServiceFlowArray[n].serviceName;
                registeredServiceFlow.descriptions = registeredServiceFlowArray[n].descriptions;
                registeredServiceFlow.serviceURL = registeredServiceFlowArray[n].serviceURL;
                registeredServiceFlow.eventOperation = registeredServiceFlowArray[n].eventOperation;
                arrayList.add(registeredServiceFlow);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                registeredServiceFlow = (RegisteredServiceFlow)arrayList.get(n);
                Element element2 = new Element("ServiceFlows");
                element.addNamespaceDeclaration(namespace);
                element.addNamespaceDeclaration(namespace2);
                element2.addContent((Content)new Element("ServiceName").addContent(registeredServiceFlow.serviceName));
                element2.addContent((Content)new Element("ServiceDescription").addContent(registeredServiceFlow.descriptions));
                element2.addContent((Content)new Element("ServiceURL").addContent(registeredServiceFlow.serviceURL));
                Element element3 = new Element("Operations");
                element2.addContent((Content)element3);
                element3.addContent((Content)new Element("Operation").addContent(registeredServiceFlow.eventOperation));
                element.addContent((Content)element2);
            }
            XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
            xMLOutputter.output(document, (OutputStream)new FileOutputStream(file));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(String string) {
        this.descriptions = string;
    }

    public String getEventOperation() {
        return this.eventOperation;
    }

    public void setEventOperation(String string) {
        this.eventOperation = string;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public void setServiceURL(String string) {
        this.serviceURL = string;
    }
}

