/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.eventManager.core.impl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.components.uuid.SimpleUUIDGen;
import org.apache.log4j.Logger;
import org.eclipse.alf.eventManager.admin.core.impl.ApplicationStatus;
import org.eclipse.alf.eventManager.admin.util.ApplicationStatusBuilder;
import org.eclipse.alf.eventManager.core.impl.ApplicationEventMatchStatus;
import org.eclipse.alf.eventManager.core.impl.EventAction;
import org.eclipse.alf.eventManager.core.impl.EventCondition;
import org.eclipse.alf.eventManager.core.impl.EventMatch;
import org.eclipse.alf.eventManager.core.impl.ServiceFlow;
import org.eclipse.alf.eventManager.core.inf.IALFEventManager;
import org.eclipse.alf.eventManager.util.EventActionMapSchemaParser;
import org.eclipse.alf.logging.impl.LoggerWrapper;
import org.eclipse.alf.logging.inf.IMatchData;
import org.eclipse.alf.util.AlfUtilityManager;
import org.eclipse.alf.util.XMLUtilityManager;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ALFEventManagerImpl
implements IALFEventManager {
    private static Map eventTable;
    private static Map eventStatus;
    private static Logger logger;

    public ALFEventManagerImpl() {
        if (null == eventTable) {
            this.parseEventMap();
        }
    }

    public void processMessage(SOAPMessage sOAPMessage) throws SOAPException {
        List list;
        String string;
        SOAPElement sOAPElement;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        SOAPElement sOAPElement2;
        SOAPEnvelope sOAPEnvelope;
        SOAPBody sOAPBody = sOAPMessage.getSOAPBody();
        if (sOAPBody == null) {
            this.logAndThrowException("Unable to fetch Body from SOAPMessage");
        }
        if ((sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope()) == null) {
            this.logAndThrowException("Invalid SOAP Envelope");
        }
        if ((sOAPElement2 = (SOAPElement)sOAPBody.getElementsByTagName("EventType").item(0)) == null) {
            this.logAndThrowException("Invalid EventType element.");
        }
        if (null == (string6 = sOAPElement2.getValue())) {
            this.logAndThrowException("Invalid EventType element.");
        }
        if ((sOAPElement2 = (SOAPElement)sOAPBody.getElementsByTagName("Product").item(0)) == null) {
            this.logAndThrowException("Invalid Product element.");
        }
        if (null == (string5 = sOAPElement2.getValue())) {
            this.logAndThrowException("Invalid Product element.");
        }
        if ((sOAPElement2 = (SOAPElement)sOAPBody.getElementsByTagName("ProductVersion").item(0)) == null) {
            this.logAndThrowException("Invalid ProductVersion element.");
        }
        if (null == (string4 = sOAPElement2.getValue())) {
            this.logAndThrowException("Invalid ProductVersion element.");
        }
        if ((sOAPElement2 = (SOAPElement)sOAPBody.getElementsByTagName("ProductInstance").item(0)) == null) {
            this.logAndThrowException("Invalid ProductInstance element.");
        }
        if (null == (string3 = sOAPElement2.getValue())) {
            this.logAndThrowException("Invalid ProductInstance element.");
        }
        if (null == (string2 = (sOAPElement = (SOAPElement)sOAPBody.getElementsByTagName("ObjectType").item(0)).getValue())) {
            this.logAndThrowException("Invalid ObjectType element.");
        }
        if (null == (string = (sOAPElement2 = (SOAPElement)sOAPBody.getElementsByTagName("EventId").item(0)).getValue())) {
            this.logAndThrowException("Invalid EventId element.");
        }
        if (null == eventTable) {
            this.parseEventMap();
        }
        if ((list = this.getEventCondition(string6, string2, string5, string4, string3)) != null) {
            ArrayList<MatchData> arrayList = new ArrayList<MatchData>();
            SOAPElement sOAPElement3 = (SOAPElement)sOAPBody.getElementsByTagName("EmEventId").item(0);
            String string7 = this.getNextUUID();
            sOAPElement3.setValue(string7);
            sOAPMessage.saveChanges();
            for (int i = 0; i < list.size(); ++i) {
                sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
                sOAPBody = sOAPEnvelope.getBody();
                MatchData matchData = new MatchData();
                EventCondition eventCondition = (EventCondition)list.get(i);
                String string8 = this.constuctMatchActionString(eventCondition);
                logger.info((Object)("Application Name = " + eventCondition.getApplicationName() + "--> " + "Match found for eventType=" + string6 + " objectType=" + string2 + " product=" + string5 + " productVersion=" + string4));
                if (this.isApplicationRunning(eventCondition.getApplicationName())) {
                    SOAPElement sOAPElement4 = (SOAPElement)sOAPBody.getElementsByTagName("ApplicationName").item(0);
                    sOAPElement4.setValue(eventCondition.getApplicationName());
                    SOAPElement sOAPElement5 = (SOAPElement)sOAPBody.getElementsByTagName("EventMatchName").item(0);
                    String string9 = eventCondition.getEventMatch().getEventMatchName();
                    sOAPElement5.setValue(string9);
                    sOAPMessage.saveChanges();
                    this.processEvent(eventCondition, sOAPMessage, matchData);
                    matchData.setApplicationName(eventCondition.getApplicationName());
                    matchData.setMatchRecord(string8);
                    arrayList.add(matchData);
                    continue;
                }
                logger.info((Object)(" Match found for the Event but Application \"" + eventCondition.getApplicationName() + "\" paused ."));
            }
            LoggerWrapper.logEvent(string7, sOAPBody.toString(), arrayList.toArray(new MatchData[arrayList.size()]));
        }
    }

    private void processEvent(EventCondition eventCondition, SOAPMessage sOAPMessage, MatchData matchData) throws SOAPException {
        EventAction eventAction = eventCondition.getEventAction();
        if (null != eventAction) {
            this.invokeService(sOAPMessage, eventAction, matchData);
        }
    }

    private void invokeService(SOAPMessage sOAPMessage, EventAction eventAction, MatchData matchData) throws SOAPException {
        HashSet hashSet = eventAction.getServiceFlows();
        SOAPEnvelope sOAPEnvelope = null;
        if (!hashSet.isEmpty()) {
            Iterator iterator = hashSet.iterator();
            SOAPBody sOAPBody = null;
            while (iterator.hasNext()) {
                sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
                ServiceFlow serviceFlow = (ServiceFlow)iterator.next();
                serviceFlow.getServiceFlowName();
                sOAPBody = sOAPEnvelope.getBody();
                SOAPElement sOAPElement = (SOAPElement)sOAPBody.getElementsByTagName("ServiceFlowName").item(0);
                String string = serviceFlow.getServiceFlowName();
                sOAPElement.setValue(string);
                SOAPElement sOAPElement2 = (SOAPElement)sOAPBody.getElementsByTagName("ServiceFlowId").item(0);
                String string2 = this.getNextUUID();
                sOAPElement2.setValue(string2);
                sOAPMessage.saveChanges();
                serviceFlow.setSOAPEnvelope(sOAPMessage.getSOAPPart().getEnvelope());
                matchData.addServiceFlowId(string2);
                matchData.addServiceFlowName(serviceFlow.getServiceFlowName());
                serviceFlow.invoke();
            }
        }
    }

    private synchronized List getEventCondition(String string, String string2, String string3, String string4, String string5) {
        List list = null;
        if (eventTable != null && eventTable.size() > 0) {
            Integer n = EventCondition.getHashToken(string, string2, string3, string4, string5);
            list = (List)eventTable.get(n.toString());
        }
        if (list == null) {
            logger.info((Object)("No match found for eventType=" + string + " objectType=" + string2 + " product=" + string3 + " productVersion=" + string4 + " productInstance=" + string5));
        }
        return list;
    }

    public synchronized void parseEventMap() {
        String[] stringArray = this.getApplicationNames();
        boolean bl = false;
        if (null != stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    this.parseEventMapFile(stringArray[i]);
                    bl = true;
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    logger.error((Object)("Error while trying to parse Application File " + stringArray[i] + " " + fileNotFoundException.getMessage()));
                    continue;
                }
                catch (SAXException sAXException) {
                    logger.error((Object)("Error while trying to parse Application File " + stringArray[i] + " " + sAXException.getMessage()));
                    continue;
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    logger.error((Object)("Error while trying to parse Application File " + stringArray[i] + " " + parserConfigurationException.getMessage()));
                    continue;
                }
                catch (IOException iOException) {
                    logger.error((Object)("Error while trying to parse Application File " + stringArray[i] + " " + iOException.getMessage()));
                }
            }
            if (bl) {
                this.constructEventMatchFromEventTable();
                logger.info((Object)"Event action mapping file loaded.");
            }
        }
    }

    public synchronized void parseEventMapFile(String string) throws FileNotFoundException, SAXException, ParserConfigurationException, IOException {
        FileInputStream fileInputStream = new FileInputStream(AlfUtilityManager.getALF_HOME() + "//" + AlfUtilityManager.getALFProperty("deploy_location") + "//" + string + "." + AlfUtilityManager.getALFProperty("deployed_file_extn"));
        EventActionMapSchemaParser eventActionMapSchemaParser = new EventActionMapSchemaParser();
        SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
        sAXParser.parse((InputStream)fileInputStream, (DefaultHandler)eventActionMapSchemaParser);
        this.addToEventTable(eventActionMapSchemaParser.getEventTable());
        this.constructEventMatchForApplication(string);
    }

    private void addToEventTable(Map map) {
        if (null != map) {
            Set set = map.keySet();
            for (String string : set) {
                List<EventCondition> list;
                EventCondition eventCondition = (EventCondition)map.get(string);
                if (null == eventTable) {
                    eventTable = new HashMap();
                }
                if (null != eventTable.get(string)) {
                    list = (List)eventTable.get(string);
                    if (null == list) continue;
                    list.add(eventCondition);
                    continue;
                }
                list = new ArrayList();
                list.add(eventCondition);
                eventTable.put(string, list);
            }
        }
    }

    private void logAndThrowException(String string) throws SOAPException {
        logger.error((Object)string);
        throw new SOAPException(string);
    }

    private String[] getApplicationNames() {
        String[] stringArray = null;
        ApplicationStatus[] applicationStatusArray = this.parseApplicationStatus();
        ApplicationStatus applicationStatus = null;
        if (null != applicationStatusArray && applicationStatusArray.length > 0) {
            stringArray = new String[applicationStatusArray.length];
            for (int i = 0; i < applicationStatusArray.length; ++i) {
                applicationStatus = applicationStatusArray[i];
                stringArray[i] = applicationStatus.getApplicationName();
            }
        }
        return stringArray;
    }

    private void constructEventMatchFromEventTable() {
        if (null != eventTable) {
            Collection collection = eventTable.values();
            EventCondition eventCondition = null;
            ArrayList arrayList2 = null;
            if (null != collection) {
                for (ArrayList arrayList2 : collection) {
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        ApplicationEventMatchStatus applicationEventMatchStatus;
                        eventCondition = (EventCondition)arrayList2.get(i);
                        EventMatch eventMatch = eventCondition.getEventMatch();
                        String string = eventCondition.getApplicationName();
                        if (eventStatus == null) {
                            eventStatus = new HashMap();
                        }
                        if (null == (applicationEventMatchStatus = (ApplicationEventMatchStatus)eventStatus.get(string))) {
                            applicationEventMatchStatus = new ApplicationEventMatchStatus();
                        }
                        applicationEventMatchStatus.addEventMatch(eventMatch);
                        eventStatus.put(string, applicationEventMatchStatus);
                    }
                }
            }
            ApplicationStatus[] applicationStatusArray = this.parseApplicationStatus();
            this.setApplicationStatus(eventStatus, applicationStatusArray);
        }
    }

    private void constructEventMatchForApplication(String string) {
        if (null != eventTable) {
            Collection collection = eventTable.values();
            EventCondition eventCondition = null;
            if (null != collection) {
                block0: for (List list : collection) {
                    if (null == list || list.size() <= 0) continue;
                    for (int i = 0; i < list.size(); ++i) {
                        ApplicationEventMatchStatus applicationEventMatchStatus;
                        eventCondition = (EventCondition)list.get(i);
                        EventMatch eventMatch = eventCondition.getEventMatch();
                        String string2 = eventCondition.getApplicationName();
                        if (!string2.equals(string)) continue;
                        if (eventStatus == null) {
                            eventStatus = new HashMap();
                        }
                        if (null == (applicationEventMatchStatus = (ApplicationEventMatchStatus)eventStatus.get(string))) {
                            applicationEventMatchStatus = new ApplicationEventMatchStatus();
                        }
                        applicationEventMatchStatus.addEventMatch(eventMatch);
                        eventStatus.put(string, applicationEventMatchStatus);
                        ApplicationStatus[] applicationStatusArray = this.parseApplicationStatus();
                        this.setApplicationStatus(eventStatus, applicationStatusArray);
                        continue block0;
                    }
                }
            }
        }
    }

    private boolean isApplicationRunning(String string) {
        ApplicationEventMatchStatus applicationEventMatchStatus;
        boolean bl = false;
        if (null != eventStatus && null != (applicationEventMatchStatus = (ApplicationEventMatchStatus)eventStatus.get(string)) && applicationEventMatchStatus.getApplStatus().getStatus() == 1) {
            bl = true;
        }
        return bl;
    }

    private ApplicationStatus[] parseApplicationStatus() {
        ApplicationStatusBuilder applicationStatusBuilder = new ApplicationStatusBuilder();
        List list = applicationStatusBuilder.getApplicationStatus(AlfUtilityManager.getALF_HOME() + "//" + AlfUtilityManager.getALFProperty("deploy_location") + "//ApplicationStatus.xml");
        return list.toArray(new ApplicationStatus[list.size()]);
    }

    private void setApplicationStatus(Map map, ApplicationStatus[] applicationStatusArray) {
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            ApplicationEventMatchStatus applicationEventMatchStatus = (ApplicationEventMatchStatus)map.get(string);
            ApplicationStatus applicationStatus = this.getApplicationStatus(string, applicationStatusArray);
            applicationEventMatchStatus.setApplStatus(applicationStatus);
        }
    }

    private ApplicationStatus getApplicationStatus(String string, ApplicationStatus[] applicationStatusArray) {
        ApplicationStatus applicationStatus = null;
        if (null != applicationStatusArray) {
            for (int i = 0; i < applicationStatusArray.length && !(applicationStatus = applicationStatusArray[i]).getApplicationName().equals(string); ++i) {
            }
        }
        return applicationStatus;
    }

    private String constuctMatchActionString(EventCondition eventCondition) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != eventCondition) {
            stringBuffer.append(XMLUtilityManager.constructStartEndTag("EventAction", true));
            stringBuffer.append(XMLUtilityManager.constructStartEndTag("EventMatch", true));
            stringBuffer.append(XMLUtilityManager.constructValueTag("EventMatchName", eventCondition.getEventMatch().getEventMatchName()));
            stringBuffer.append(XMLUtilityManager.constructValueTag("EventType", eventCondition.getEventMatch().getEventType()));
            stringBuffer.append(XMLUtilityManager.constructValueTag("ObjectType", eventCondition.getEventMatch().getObjectType()));
            stringBuffer.append(XMLUtilityManager.constructValueTag("Product", eventCondition.getEventMatch().getProduct()));
            stringBuffer.append(XMLUtilityManager.constructValueTag("ProductVersion", eventCondition.getEventMatch().getProductVers()));
            stringBuffer.append(XMLUtilityManager.constructValueTag("ProductInstance", eventCondition.getEventMatch().getProductInstance()));
            stringBuffer.append(XMLUtilityManager.constructStartEndTag("EventMatch", false));
            stringBuffer.append(XMLUtilityManager.constructStartEndTag("Action", true));
            HashSet hashSet = eventCondition.getEventAction().getServiceFlows();
            if (null != hashSet && hashSet.size() > 0) {
                for (ServiceFlow serviceFlow : hashSet) {
                    stringBuffer.append(XMLUtilityManager.constructStartEndTag("ServiceFlow", true));
                    stringBuffer.append(XMLUtilityManager.constructValueTag("ServiceFlowName", serviceFlow.getServiceFlowName()));
                    stringBuffer.append(XMLUtilityManager.constructValueTag("Endpoint", serviceFlow.getEndPointAddress()));
                    stringBuffer.append(XMLUtilityManager.constructStartEndTag("ServiceFlow", false));
                }
            }
            stringBuffer.append(XMLUtilityManager.constructStartEndTag("Action", false));
            stringBuffer.append(XMLUtilityManager.constructStartEndTag("EventAction", false));
        }
        return stringBuffer.toString();
    }

    private String getNextUUID() {
        SimpleUUIDGen simpleUUIDGen = new SimpleUUIDGen();
        return simpleUUIDGen.nextUUID();
    }

    public static Map getEventStatus() {
        return eventStatus;
    }

    public static void setEventStatus(Map map) {
        eventStatus = map;
    }

    public static Map getEventTable() {
        return eventTable;
    }

    public static void setEventTable(Map map) {
        eventTable = map;
    }

    static {
        logger = Logger.getLogger(ALFEventManagerImpl.class);
    }

    static class MatchData
    implements IMatchData {
        String applicationName;
        String matchRecord;
        List serviceFlowIds;
        List serviceFlowNames;

        MatchData() {
        }

        public String getApplicationName() {
            return this.applicationName;
        }

        public void setApplicationName(String string) {
            this.applicationName = string;
        }

        public String getMatchRecord() {
            return this.matchRecord;
        }

        public void setMatchRecord(String string) {
            this.matchRecord = string;
        }

        public String[] getServiceFlowIds() {
            return this.serviceFlowIds.toArray(new String[this.serviceFlowIds.size()]);
        }

        public void setServiceFlowIds(String[] stringArray) {
            if (null != stringArray && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.addServiceFlowId(stringArray[i]);
                }
            }
        }

        public void addServiceFlowId(String string) {
            if (null == this.serviceFlowIds) {
                this.serviceFlowIds = new ArrayList();
            }
            this.serviceFlowIds.add(string);
        }

        public String[] getServiceFlowName() {
            return this.serviceFlowNames.toArray(new String[this.serviceFlowNames.size()]);
        }

        public void setServiceFlowName(String[] stringArray) {
            if (null != stringArray && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.addServiceFlowName(stringArray[i]);
                }
            }
        }

        public void addServiceFlowName(String string) {
            if (null == this.serviceFlowNames) {
                this.serviceFlowNames = new ArrayList();
            }
            this.serviceFlowNames.add(string);
        }
    }
}

