/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.eventManager.core.impl;

public class TokenGenerator {
    public static final int POLYNOMIAL = -306674912;
    private int[] nCrcTable = new int[256];

    public TokenGenerator() {
        for (int i = 0; i < this.nCrcTable.length; ++i) {
            this.nCrcTable[i] = -1;
        }
    }

    public void initCrcTable() {
        for (int i = 0; i < this.nCrcTable.length; ++i) {
            int n = i;
            for (int j = 8; j > 0; --j) {
                if ((n & 1) != 0) {
                    n = n >> 1 ^ 0xEDB88320;
                    continue;
                }
                n >>= 1;
            }
            this.nCrcTable[i] = n;
        }
    }

    public int calculate(StringBuffer stringBuffer) {
        int n = this.init();
        n = this.update(n, stringBuffer);
        n = this.finish(n);
        return n;
    }

    public int init() {
        return -1;
    }

    public int update(int n, StringBuffer stringBuffer) {
        if (this.nCrcTable[0] == -1) {
            this.initCrcTable();
        }
        for (int i = 0; i < stringBuffer.length(); ++i) {
            n = n >> 8 ^ this.nCrcTable[(n ^ stringBuffer.charAt(i)) & 0xFF];
        }
        return n;
    }

    public int finish(int n) {
        return (n ^= 0xFFFFFFFF) & Integer.MAX_VALUE;
    }
}

