/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class AlfUtilityManager {
    private static String ALF_HOME = null;
    private static Logger logger = Logger.getLogger(AlfUtilityManager.class);
    private static final String environment_seperator = "=";
    private static Properties alfProperties = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadALFHome() {
        Object object;
        Process process = null;
        Properties properties = new Properties();
        Runtime runtime = Runtime.getRuntime();
        String string = System.getProperty("os.name").toLowerCase(Locale.getDefault());
        BufferedReader bufferedReader = null;
        try {
            process = string.indexOf("windows 9") > -1 ? runtime.exec("command.com /c set") : (string.indexOf("nt") > -1 || string.indexOf("windows 20") > -1 || string.indexOf("windows xp") > -1 ? runtime.exec("cmd.exe /c set") : runtime.exec("/bin/env"));
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((object = bufferedReader.readLine()) != null) {
                int n = ((String)object).indexOf(environment_seperator);
                String string2 = ((String)object).substring(0, n).toLowerCase(Locale.getDefault());
                String string3 = ((String)object).substring(n + 1);
                properties.setProperty(string2, string3);
            }
        }
        catch (IOException iOException) {
            logger.fatal((Object)"Please ensure the Environmental Variable \"ALF_HOME\" is set before starting the Application.");
        }
        finally {
            if (null != bufferedReader) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        ALF_HOME = (String)properties.get("alf_home");
        if (ALF_HOME == null) {
            logger.fatal((Object)"Please ensure the Environmental Variable \"ALF_HOME\" is set before starting the Application.");
        }
        if (((File)(object = new File(ALF_HOME, "alf_log4j.properties"))).canRead()) {
            PropertyConfigurator.configure((String)((File)object).getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadALFProperties() {
        File file = new File(ALF_HOME, "alf.properties");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            alfProperties = new Properties();
            alfProperties.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.error((Object)"Unable to find ALF Properties File in ALF_HOME");
        }
        catch (IOException iOException) {
            logger.error((Object)"Error Loading ALF Properties from alf.properties File.");
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getALFProperty(String string) {
        if (null != alfProperties.get(string)) {
            return (String)alfProperties.get(string);
        }
        return null;
    }

    public static String getALF_HOME() {
        return ALF_HOME;
    }

    public static void setALF_HOME(String string) {
        ALF_HOME = string;
    }

    static {
        AlfUtilityManager.loadALFHome();
        AlfUtilityManager.loadALFProperties();
    }
}

