/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.editors.eventactionmap;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.rpc.ServiceException;
import org.eclipse.alf.editors.eventactionmap.AdminCall;
import org.eclipse.alf.editors.eventactionmap.EventMapEditor;
import org.eclipse.alf.editors.eventactionmap.EventMapSelectionAdapter;
import org.eclipse.alf.editors.eventactionmap.EventSelectionDialog;
import org.eclipse.alf.editors.eventactionmap.ServiceFlowSelectionDialog;
import org.eclipse.alf.eventManager.admin.ALFAdminServiceLocator;
import org.eclipse.alf.eventManager.admin.ALFAdminSoapBindingStub;
import org.eclipse.alf.models.EventMap;
import org.eclipse.alf.models.ServerRegistry;
import org.eclipse.alf.util.ArrayManager;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class EventMapEditorScreen
extends ApplicationWindow {
    private EventMapEditor editor;
    private Group composite;
    private Composite scrolledComposite;
    private Composite container;
    private Text txtServiceFlow;
    private Text txtEvtType;
    private Text txtObjType;
    private Text txtInstanceType;
    private Text txtVersion;
    private Text txtProduct;
    private Text txtEvtMatch;
    private Text serviceNameText;
    private String serverLocation;
    private int noOfRows = 0;
    private List serverNameList = new ArrayList();
    private List serverURLList = new ArrayList();
    private boolean isFirst = true;
    private Combo serverCombo;
    private EventMap[] eventMapRegArray = new EventMap[0];
    private static final int TXT_LIMIT = 25;
    private ALFAdminSoapBindingStub binding = null;
    private static final String BLANK_STRING = "                                                                                                    ";

    public EventMapEditorScreen() {
        super(null);
        this.addCoolBar(0x800000);
        this.addMenuBar();
        this.addStatusLine();
    }

    public EventMapEditorScreen(EventMapEditor eventMapEditor) {
        super(null);
        this.editor = eventMapEditor;
        this.addCoolBar(0x800000);
        this.addMenuBar();
        this.addStatusLine();
    }

    EventMapEditor getEditor() {
        return this.editor;
    }

    public Composite getScrolledComposite() {
        return this.scrolledComposite;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public int getNoOfRows() {
        return this.noOfRows;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public EventMap[] getEventmapregArray() {
        return this.eventMapRegArray;
    }

    public void setEventmapregArray(EventMap[] eventMapArray) {
        this.eventMapRegArray = eventMapArray;
    }

    public void saveEventmapValues() {
        EventMapEditor eventMapEditor = new EventMapEditor();
        String string = eventMapEditor.getEventMapFile();
        File file = this.getEditor().findFileName(string);
        EventMap.saveEventmapValues(this.eventMapRegArray, file);
        this.refresh();
    }

    public Control createContents(Composite composite, EventMap[] eventMapArray) {
        this.loadServerXML();
        this.eventMapRegArray = eventMapArray;
        Group group = new Group(composite, 0);
        Group group2 = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 8;
        gridLayout.makeColumnsEqualWidth = false;
        group2.setLayout((Layout)gridLayout);
        group.setLayout((Layout)new GridLayout());
        group.setText("Server(s)");
        this.serverCombo = new Combo((Composite)group, 8);
        for (int i = 0; i < this.serverNameList.size(); ++i) {
            this.serverCombo.add((String)this.serverNameList.get(i));
            this.serverCombo.setText((String)this.serverNameList.get(i));
        }
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.numColumns = 10;
        gridLayout2.makeColumnsEqualWidth = false;
        gridLayout2.horizontalSpacing = 1;
        gridLayout2.verticalSpacing = 1;
        Group group3 = new Group((Composite)group, 0);
        group3.setLayout((Layout)gridLayout2);
        Button button = new Button((Composite)group3, 2048);
        button.setText("        &Deploy        ");
        Button button2 = new Button((Composite)group3, 2048);
        button2.setText("        &UnDeploy        ");
        Button button3 = new Button((Composite)group3, 2048);
        button3.setText("        &Pause        ");
        Button button4 = new Button((Composite)group3, 2048);
        button4.setText("        &Resume        ");
        Button button5 = new Button((Composite)group3, 2048);
        button5.setText("        &Get Status        ");
        new Label((Composite)group3, 0);
        Button button6 = new Button((Composite)group2, 0);
        button6.setLayoutData((Object)new GridData());
        button6.setText("        &Select Event        ");
        button6.addSelectionListener((SelectionListener)new EventMapSelectionAdapter(this){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EventSelectionDialog eventSelectionDialog = new EventSelectionDialog(((Button)selectionEvent.getSource()).getShell(), 0);
                eventSelectionDialog.open(this.getPage());
            }
        });
        Label label = new Label((Composite)group2, 0);
        label.setLayoutData((Object)new GridData(4, 2, true, true, 5, 0));
        label.setText("label                                   ");
        label.setVisible(false);
        this.scrolledComposite = new Composite(composite, 0);
        this.scrolledComposite.setLayout((Layout)new GridLayout());
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        this.scrolledComposite.setSize(1500, 400);
        this.composite = new Group(this.scrolledComposite, 0);
        this.composite.setLayout((Layout)gridLayout2);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 0));
        this.composite.setText("Event-Action Map");
        if (null != eventMapArray && eventMapArray.length > 0) {
            this.createRow((Composite)this.composite, eventMapArray);
            this.composite.pack();
            this.composite.redraw();
        } else {
            this.composite.setSize(1500, 400);
            this.composite.update();
        }
        this.adminOperationCall(composite, button, button2, button3, button4, button5);
        this.setContainer(composite);
        composite.update();
        return composite;
    }

    private void adminOperationCall(final Composite composite, Button button, Button button2, Button button3, Button button4, Button button5) {
        final ALFAdminServiceLocator aLFAdminServiceLocator = new ALFAdminServiceLocator();
        final AdminCall adminCall = new AdminCall();
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                aLFAdminServiceLocator.setALFAdmin_serverName(EventMapEditorScreen.this.getServerName());
                aLFAdminServiceLocator.setALFAdminEndpointAddress(EventMapEditorScreen.this.getServerLocation());
                try {
                    EventMapEditorScreen.this.binding = (ALFAdminSoapBindingStub)aLFAdminServiceLocator.getALFAdmin();
                    String string = EventMapEditorScreen.this.editor.getEventMapLocation();
                    File file = EventMapEditorScreen.this.getEditor().findFileName(string);
                    EventMap[] eventMapArray = EventMapEditorScreen.this.getEventmapregArray();
                    if (!EventMapEditorScreen.this.isEventMapEmpty(eventMapArray)) {
                        String string2 = eventMapArray[0].getApplicationName();
                        if (null == string2 || string2.length() == 0) {
                            MessageBox messageBox = new MessageBox(composite.getShell(), 2);
                            messageBox.setMessage("Unable to fetch the application name from EventMap, to deploy in \"" + EventMapEditorScreen.this.getServerName() + "\" .");
                            messageBox.setText("ALF Event-Action Map Deploy");
                            messageBox.open();
                        } else {
                            adminCall.deploy(composite, file, EventMapEditorScreen.this.binding, EventMapEditorScreen.this.getServerName(), string2);
                        }
                    } else {
                        MessageBox messageBox = new MessageBox(composite.getShell(), 2);
                        messageBox.setMessage("Unable to deploy the application in \"" + EventMapEditorScreen.this.getServerName() + "\" because the EventMap is either empty or invalid.");
                        messageBox.setText("ALF Event-Action Map Deploy");
                        messageBox.open();
                    }
                }
                catch (ServiceException serviceException) {
                    MessageBox messageBox = new MessageBox(composite.getShell(), 2);
                    messageBox.setMessage("Please configure the Server in serverconfig.xml to perform Admin Operations.");
                    messageBox.setText("ALF Event-Action Map Deploy");
                    messageBox.open();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        button2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                aLFAdminServiceLocator.setALFAdminEndpointAddress(EventMapEditorScreen.this.getServerLocation());
                try {
                    EventMapEditorScreen.this.binding = (ALFAdminSoapBindingStub)aLFAdminServiceLocator.getALFAdmin();
                    EventMap[] eventMapArray = EventMapEditorScreen.this.getEventmapregArray();
                    if (!EventMapEditorScreen.this.isEventMapEmpty(eventMapArray)) {
                        String string = eventMapArray[0].getApplicationName();
                        if (null == string || string.length() == 0) {
                            MessageBox messageBox = new MessageBox(composite.getShell(), 2);
                            messageBox.setMessage("Unable to fetch the application name from EventMap, to undeploy from \"" + EventMapEditorScreen.this.getServerName() + "\" .");
                            messageBox.setText("ALF Application Undeploy");
                            messageBox.open();
                        } else {
                            adminCall.unDeploy(composite, string, EventMapEditorScreen.this.binding, EventMapEditorScreen.this.getServerName());
                        }
                    } else {
                        MessageBox messageBox = new MessageBox(composite.getShell(), 2);
                        messageBox.setMessage("Unable to undeploy the application from server \"" + EventMapEditorScreen.this.getServerName() + "\" because the EventMap is either empty or invalid.");
                        messageBox.setText("ALF Application Undeploy");
                        messageBox.open();
                    }
                }
                catch (ServiceException serviceException) {
                    MessageBox messageBox = new MessageBox(composite.getShell(), 2);
                    messageBox.setMessage("Please configure the Server in serverconfig.xml to perform Admin Operations.");
                    messageBox.setText("AALF Application Undeploy");
                    messageBox.open();
                    serviceException.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        button3.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                aLFAdminServiceLocator.setALFAdminEndpointAddress(EventMapEditorScreen.this.getServerLocation());
                try {
                    EventMapEditorScreen.this.binding = (ALFAdminSoapBindingStub)aLFAdminServiceLocator.getALFAdmin();
                    EventMap[] eventMapArray = EventMapEditorScreen.this.getEventmapregArray();
                    if (!EventMapEditorScreen.this.isEventMapEmpty(eventMapArray)) {
                        String string = eventMapArray[0].getApplicationName();
                        if (null == string || string.length() == 0) {
                            MessageBox messageBox = new MessageBox(composite.getShell(), 2);
                            messageBox.setMessage("Unable to fetch the application name from EventMap, to pause in \"" + EventMapEditorScreen.this.getServerName() + "\" .");
                            messageBox.setText("ALF Application Pause");
                            messageBox.open();
                        } else {
                            adminCall.pause(composite, string, EventMapEditorScreen.this.binding, EventMapEditorScreen.this.getServerName());
                        }
                    } else {
                        MessageBox messageBox = new MessageBox(composite.getShell(), 2);
                        messageBox.setMessage("Unable to pause the application in \"" + EventMapEditorScreen.this.getServerName() + "\" because the " + "EventMap is either empty or invalid.");
                        messageBox.setText("ALF Application Pause");
                        messageBox.open();
                    }
                }
                catch (ServiceException serviceException) {
                    MessageBox messageBox = new MessageBox(composite.getShell(), 2);
                    messageBox.setMessage("Please configure the Server in serverconfig.xml to perform Admin Operations.");
                    messageBox.setText("ALF Application Pause");
                    messageBox.open();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        button4.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                aLFAdminServiceLocator.setALFAdminEndpointAddress(EventMapEditorScreen.this.getServerLocation());
                try {
                    EventMapEditorScreen.this.binding = (ALFAdminSoapBindingStub)aLFAdminServiceLocator.getALFAdmin();
                    EventMap[] eventMapArray = EventMapEditorScreen.this.getEventmapregArray();
                    if (!EventMapEditorScreen.this.isEventMapEmpty(eventMapArray)) {
                        String string = eventMapArray[0].getApplicationName();
                        if (null == string || string.length() == 0) {
                            MessageBox messageBox = new MessageBox(composite.getShell(), 2);
                            messageBox.setMessage("Unable to fetch the application name from EventMap, to resume in \"" + EventMapEditorScreen.this.getServerName() + "\" .");
                            messageBox.setText("ALF Application Resume");
                            messageBox.open();
                        } else {
                            adminCall.resume(composite, string, EventMapEditorScreen.this.binding, EventMapEditorScreen.this.getServerName());
                        }
                    } else {
                        MessageBox messageBox = new MessageBox(composite.getShell(), 2);
                        messageBox.setMessage("Unable to resume the application in \"" + EventMapEditorScreen.this.getServerName() + "\" because the EventMap is either empty or invalid.");
                        messageBox.setText("ALF Application Resume");
                        messageBox.open();
                    }
                }
                catch (ServiceException serviceException) {
                    MessageBox messageBox = new MessageBox(composite.getShell(), 2);
                    messageBox.setMessage("Please configure the Server in serverconfig.xml to perform Admin Operations.");
                    messageBox.setText("ALF Application Resume");
                    messageBox.open();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        button5.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EventMap[] eventMapArray = EventMapEditorScreen.this.getEventmapregArray();
                aLFAdminServiceLocator.setALFAdminEndpointAddress(EventMapEditorScreen.this.getServerLocation());
                try {
                    EventMapEditorScreen.this.binding = (ALFAdminSoapBindingStub)aLFAdminServiceLocator.getALFAdmin();
                    if (!EventMapEditorScreen.this.isEventMapEmpty(eventMapArray)) {
                        String string = eventMapArray[0].getApplicationName();
                        if (null == string || string.length() == 0) {
                            MessageBox messageBox = new MessageBox(composite.getShell(), 2);
                            messageBox.setMessage("Unable to fetch the application name from EventMap, to get the status from \"" + EventMapEditorScreen.this.getServerName() + "\" .");
                            messageBox.setText("ALF Application Status");
                            messageBox.open();
                        } else {
                            adminCall.getApplnStatus(string, composite, EventMapEditorScreen.this.binding, EventMapEditorScreen.this.getServerName());
                        }
                    } else {
                        MessageBox messageBox = new MessageBox(composite.getShell(), 2);
                        messageBox.setMessage("Unable to fetch the status of the application from \"" + EventMapEditorScreen.this.getServerName() + "\" because the EventMap is either empty or invalid.");
                        messageBox.setText("ALF Application Status");
                        messageBox.open();
                    }
                }
                catch (ServiceException serviceException) {
                    MessageBox messageBox = new MessageBox(composite.getShell(), 2);
                    messageBox.setMessage("Please configure the Server in serverconfig.xml to perform Admin Operations.");
                    messageBox.setText("ALF Application Status");
                    messageBox.open();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
    }

    public static void consolePrint(Object object) {
        MessageConsole messageConsole = new MessageConsole("ALF Console", null);
        messageConsole.activate();
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{messageConsole});
        MessageConsoleStream messageConsoleStream = messageConsole.newMessageStream();
        messageConsoleStream.println(object.toString());
    }

    private void loadServerXML() {
        try {
            File file = this.getEditor().findFileName("serverconfig.xml");
            ServerRegistry.loadServerXML(file, this.serverNameList, this.serverURLList);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void refresh() {
        this.noOfRows = 0;
        this.composite.dispose();
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 10;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.horizontalSpacing = 1;
        gridLayout.verticalSpacing = 1;
        this.composite = new Group(this.scrolledComposite, 0);
        this.composite.setLayout((Layout)gridLayout);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
        this.composite.setText("Event-Action Mapping");
        if (null != this.eventMapRegArray && this.eventMapRegArray.length > 0) {
            this.createRow((Composite)this.composite, this.eventMapRegArray);
            this.composite.pack();
            this.composite.redraw();
            this.getContainer().pack();
            this.getContainer().redraw();
        } else {
            this.composite.setSize(800, 400);
            this.getContainer().pack();
            this.getContainer().redraw();
            this.composite.update();
            this.getContainer().update();
        }
        this.composite.update();
        this.getContainer().update();
    }

    public void refreshServerCombo() {
        this.serverCombo.removeAll();
        this.serverNameList.clear();
        this.serverURLList.clear();
        this.serverLocation = null;
        this.loadServerXML();
        for (int i = 0; i < this.serverNameList.size(); ++i) {
            this.serverCombo.add((String)this.serverNameList.get(i));
            this.serverCombo.setText((String)this.serverNameList.get(i));
            this.serverCombo.pack();
            this.serverCombo.redraw();
        }
    }

    protected MenuManager createMenuManager() {
        MenuManager menuManager = new MenuManager("menu");
        return menuManager;
    }

    protected CoolBarManager createCoolBarManager(int n) {
        CoolBarManager coolBarManager = new CoolBarManager(n);
        return coolBarManager;
    }

    protected StatusLineManager createStatusLineManager() {
        StatusLineManager statusLineManager = new StatusLineManager();
        statusLineManager.setMessage(null, "");
        return statusLineManager;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("New Application");
    }

    private void createRow(final Composite composite, EventMap[] eventMapArray) {
        Button button = new Button(composite, 2048);
        button.setLayoutData((Object)new GridData(4, 2, true, true, 0, 0));
        button.setText("       Select Service Flows       ");
        button.setVisible(false);
        Button button2 = new Button(composite, 0);
        button2.setLayoutData((Object)new GridData(4, 2, true, true, 0, 0));
        button2.setText("       Delete             ");
        button2.setVisible(false);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(2, 2, true, true, 0, 0));
        label.setText("Product                   ");
        Label label2 = new Label(composite, 0);
        label2.setLayoutData((Object)new GridData(2, 2, true, true, 0, 0));
        label2.setText("Product Version                  ");
        Label label3 = new Label(composite, 0);
        label3.setLayoutData((Object)new GridData(2, 2, true, true, 0, 0));
        label3.setText("Product Instance             ");
        Label label4 = new Label(composite, 0);
        label4.setLayoutData((Object)new GridData(2, 2, true, true, 0, 0));
        label4.setText("Object Type              ");
        Label label5 = new Label(composite, 0);
        label5.setLayoutData((Object)new GridData(2, 2, true, true, 0, 0));
        label5.setText("Event Type               ");
        Label label6 = new Label(composite, 0);
        label6.setLayoutData((Object)new GridData(2, 2, true, true, 0, 0));
        label6.setText("Event Match Name                   ");
        Label label7 = new Label(composite, 0);
        label7.setLayoutData((Object)new GridData(2, 2, true, true, 0, 0));
        label7.setText("Service Flow Name                   ");
        Label label8 = new Label(composite, 0);
        label8.setLayoutData((Object)new GridData(2, 2, true, true, 0, 0));
        label8.setText("Service Flows             ");
        for (int i = 0; i < eventMapArray.length; ++i) {
            int n;
            Object object;
            Button button3 = new Button(composite, 2048);
            button3.setLayoutData((Object)new GridData(4, 2, true, true, 0, 0));
            button3.setText("       Select Service Flows       ");
            button3.setData((Object)("" + this.noOfRows));
            button3.setBackground(Display.getCurrent().getSystemColor(1));
            button3.addSelectionListener((SelectionListener)new EventMapSelectionAdapter(this){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Button button = (Button)selectionEvent.getSource();
                    String string = button.getData().toString();
                    if (string != null) {
                        int n = 0;
                        n = Integer.parseInt(string);
                        Button button2 = (Button)selectionEvent.getSource();
                        Shell shell = button2.getShell();
                        ServiceFlowSelectionDialog serviceFlowSelectionDialog = new ServiceFlowSelectionDialog(shell, 1);
                        serviceFlowSelectionDialog.open(this.getPage(), n);
                    }
                }
            });
            Button button4 = new Button(composite, 2048);
            button4.setLayoutData((Object)new GridData(4, 2, true, true, 0, 0));
            button4.setText("         Delete         ");
            button4.setBackground(Display.getCurrent().getSystemColor(1));
            button4.setData((Object)("" + this.noOfRows));
            button4.addSelectionListener((SelectionListener)new EventMapSelectionAdapter(this){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Button button;
                    String string;
                    MessageBox messageBox = new MessageBox(composite.getShell(), 196);
                    messageBox.setMessage("Are you sure to delete the event-action ?");
                    messageBox.setText("Delete Event-Action Map");
                    if (messageBox.open() == 64 && (string = (button = (Button)selectionEvent.getSource()).getData().toString()) != null) {
                        int n = 0;
                        try {
                            n = Integer.parseInt(string);
                            Object[] objectArray = this.getPage().getEventmapregArray();
                            Object[] objectArray2 = ArrayManager.deleteAndAdjust(objectArray, n);
                            objectArray = new EventMap[objectArray2.length];
                            for (int i = 0; i < objectArray2.length; ++i) {
                                objectArray[i] = (EventMap)objectArray2[i];
                            }
                            this.getPage().setEventmapregArray((EventMap[])objectArray);
                            this.getPage().saveEventmapValues();
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                }
            });
            this.txtProduct = new Text(composite, 2120);
            this.txtProduct.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
            this.txtProduct.setTextLimit(25);
            this.txtProduct.setBackground(Display.getCurrent().getSystemColor(22));
            this.txtProduct.setTabs(8);
            String string = this.getSubString(eventMapArray[i].getProduct());
            this.txtProduct.setText(string);
            this.txtProduct.setToolTipText(eventMapArray[i].getProduct());
            this.txtVersion = new Text(composite, 2120);
            this.txtVersion.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
            this.txtVersion.setBackground(Display.getCurrent().getSystemColor(22));
            string = this.getSubString(eventMapArray[i].getProductVersion());
            this.txtVersion.setText(string);
            this.txtVersion.setToolTipText(eventMapArray[i].getProductVersion());
            this.txtInstanceType = new Text(composite, 2120);
            this.txtInstanceType.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
            this.txtInstanceType.setBackground(Display.getCurrent().getSystemColor(22));
            string = this.getSubString(eventMapArray[i].getProductInstance());
            this.txtInstanceType.setText(string);
            this.txtInstanceType.setToolTipText(eventMapArray[i].getProductInstance());
            this.txtObjType = new Text(composite, 2120);
            this.txtObjType.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
            this.txtObjType.setBackground(Display.getCurrent().getSystemColor(22));
            string = this.getSubString(eventMapArray[i].getObjectType());
            this.txtObjType.setText(string);
            this.txtObjType.setToolTipText(eventMapArray[i].getObjectType());
            this.txtEvtType = new Text(composite, 2120);
            this.txtEvtType.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
            this.txtEvtType.setBackground(Display.getCurrent().getSystemColor(22));
            string = this.getSubString(eventMapArray[i].getEventType());
            this.txtEvtType.setText(string);
            this.txtEvtType.setToolTipText(eventMapArray[i].getEventType());
            this.txtEvtMatch = new Text(composite, 2120);
            this.txtEvtMatch.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
            this.txtEvtMatch.setBackground(Display.getCurrent().getSystemColor(22));
            string = this.getSubString(eventMapArray[i].getEventMatchName());
            this.txtEvtMatch.setText(string);
            this.txtEvtMatch.setToolTipText(eventMapArray[i].getEventMatchName());
            this.serviceNameText = new Text(composite, 2120);
            this.serviceNameText.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
            this.serviceNameText.setBackground(Display.getCurrent().getSystemColor(22));
            String string2 = "";
            ArrayList<String> arrayList = new ArrayList<String>();
            if (eventMapArray[i].getServiceFlows() != null) {
                for (int j = 0; j < eventMapArray[i].getServiceFlows().length; ++j) {
                    object = eventMapArray[i].getServiceFlows()[j].getServiceFlowName();
                    n = this.serviceURLExists(arrayList, (String)object);
                    if (n != 0) continue;
                    string2 = string2 + eventMapArray[i].getServiceFlows()[j].getServiceFlowName() + ", ";
                    arrayList.add(eventMapArray[i].getServiceFlows()[j].getServiceFlowName());
                }
                string2 = string2.trim().substring(0, string2.trim().length() - 1);
                string = this.getSubString(string2);
                this.serviceNameText.setText(string);
                this.serviceNameText.setToolTipText(string2);
            }
            this.txtServiceFlow = new Text(composite, 2120);
            this.txtServiceFlow.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
            this.txtServiceFlow.setBackground(Display.getCurrent().getSystemColor(22));
            this.txtServiceFlow.setText("                         ");
            String string3 = "";
            object = new ArrayList();
            if (eventMapArray[i].getServiceFlows() != null) {
                for (n = 0; n < eventMapArray[i].getServiceFlows().length; ++n) {
                    String string4 = eventMapArray[i].getServiceFlows()[n].getEndPoint();
                    int n2 = this.serviceURLExists((ArrayList)object, string4);
                    if (n2 != 0) continue;
                    string3 = string3 + eventMapArray[i].getServiceFlows()[n].getEndPoint() + ", ";
                    ((ArrayList)object).add(eventMapArray[i].getServiceFlows()[n].getEndPoint());
                }
                string = this.getSubString(string3);
                this.txtServiceFlow.setText(string);
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                int n3 = stringTokenizer.countTokens();
                if (n3 > 1) {
                    this.txtServiceFlow.setToolTipText(string3 + " number of flows : " + --n3);
                } else {
                    this.txtServiceFlow.setToolTipText(string3 + " number of flows : " + n3);
                }
            }
            ++this.noOfRows;
        }
    }

    private int serviceURLExists(ArrayList arrayList, String string) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!string.equals(arrayList.get(i))) continue;
            return 1;
        }
        return 0;
    }

    private String getSubString(String string) {
        String string2 = "";
        if (string != null) {
            int n = 25 - string.length();
            string2 = n > 0 ? (n > 16 ? string + BLANK_STRING.substring(0, n * 2) : string + BLANK_STRING.substring(0, (int)Math.abs((double)n * 2.25))) : string.substring(0, string.length() + n);
        }
        return string2;
    }

    private boolean isEventMapEmpty(EventMap[] eventMapArray) {
        return null == eventMapArray || eventMapArray.length == 0;
    }

    public String getServerLocation() {
        this.serverLocation = null;
        int n = this.serverCombo.getSelectionIndex();
        String string = (String)this.serverURLList.get(n);
        if (string != null && string.length() > 0) {
            this.serverLocation = string;
        }
        return this.serverLocation;
    }

    private String getServerName() {
        int n = this.serverCombo.getSelectionIndex();
        String string = (String)this.serverNameList.get(n);
        return string;
    }

    public void setServerLocation(String string) {
        this.serverLocation = string;
    }

    public Composite getContainer() {
        return this.container;
    }

    public void setContainer(Composite composite) {
        this.container = composite;
    }
}

