/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.eventMapEditor.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.alf.eventMapEditor.wizards.EventMapWizardPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.ide.IDE;

public class EventMapWizard
extends Wizard
implements INewWizard {
    private EventMapWizardPage page;
    private ISelection selection;
    private String containerName = "";
    private String fileName = "";
    private static String newLine = "\n";
    private static String XMLHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static String eventMaptDoc = "<ALFEventActionMap/>";

    public EventMapWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("New Event-Action Map File");
    }

    public void addPages() {
        this.page = new EventMapWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.containerName = this.page.getContainerName();
        this.fileName = this.page.getFileName();
        if (this.fileName.lastIndexOf(".") < 0) {
            this.fileName = this.fileName + ".alf";
        }
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    EventMapWizard.this.doFinish(EventMapWizard.this.containerName, EventMapWizard.this.fileName, iProgressMonitor);
                }
                catch (CoreException coreException) {
                    throw new InvocationTargetException(coreException);
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)throwable.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String string, String string2, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.beginTask("Creating " + string2, 2);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource iResource = iWorkspaceRoot.findMember((IPath)new Path(string));
        if (!iResource.exists() || !(iResource instanceof IContainer)) {
            this.throwCoreException("Container \"" + string + "\" does not exist.");
        }
        IContainer iContainer = (IContainer)iResource;
        final IFile iFile = iContainer.getFile((IPath)new Path(string2));
        try {
            InputStream inputStream = this.openContentStream();
            if (iFile.exists()) {
                MessageConsole messageConsole = new MessageConsole("My Console", null);
                messageConsole.activate();
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{messageConsole});
                MessageConsoleStream messageConsoleStream = messageConsole.newMessageStream();
                messageConsoleStream.println(" File already exists!");
            } else {
                iFile.create(inputStream, true, iProgressMonitor);
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        iProgressMonitor.worked(1);
        iProgressMonitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
        iProgressMonitor.worked(1);
    }

    private InputStream openContentStream() {
        String string = XMLHeader + newLine + eventMaptDoc;
        return new ByteArrayInputStream(string.getBytes());
    }

    private void throwCoreException(String string) throws CoreException {
        Status status = new Status(4, "ALFPlugin", 0, string, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.selection = iStructuredSelection;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String string) {
        this.containerName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public EventMapWizardPage getPage() {
        return this.page;
    }

    public void setPage(EventMapWizardPage eventMapWizardPage) {
        this.page = eventMapWizardPage;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection iSelection) {
        this.selection = iSelection;
    }
}

