/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.eventManager.core.impl;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.log4j.Logger;
import org.eclipse.alf.eventManager.core.impl.ServiceFlow;

public class ServiceFlowThread
extends Thread {
    private static Logger logger = Logger.getLogger(ServiceFlowThread.class);
    private ServiceFlow serviceFlow;
    private javax.xml.soap.SOAPEnvelope soapEnv;
    private Message message;

    ServiceFlowThread(ServiceFlow serviceFlow, javax.xml.soap.SOAPEnvelope sOAPEnvelope) {
        this.setServiceFlow(serviceFlow);
        this.setSOAPEnvelope(sOAPEnvelope);
    }

    ServiceFlowThread(ServiceFlow serviceFlow, Message message) {
        this.setServiceFlow(serviceFlow);
        this.setAxisMessage(message);
    }

    public void setServiceFlow(ServiceFlow serviceFlow) {
        this.serviceFlow = serviceFlow;
    }

    public ServiceFlow getServiceFlow() {
        return this.serviceFlow;
    }

    public void setSOAPEnvelope(javax.xml.soap.SOAPEnvelope sOAPEnvelope) {
        this.soapEnv = sOAPEnvelope;
    }

    public javax.xml.soap.SOAPEnvelope getSOAPEnvelope() {
        return this.soapEnv;
    }

    public void setAxisMessage(Message message) {
        this.message = message;
    }

    public Message getAxisMessage() {
        return this.message;
    }

    public synchronized void run() {
        ServiceFlowThread.yield();
        this.invoke();
    }

    public synchronized void invoke() {
        try {
            Service service = new Service();
            Call call = (Call)service.createCall();
            call.setTargetEndpointAddress(new URL(this.serviceFlow.getEndPointAddress()));
            call.setRequestMessage(this.message);
            call.invoke();
            logger.info((Object)("Service flow invoked with a target end point address of " + this.serviceFlow.getEndPointAddress()));
        }
        catch (AxisFault axisFault) {
            logger.error((Object)("Error while invoking service " + this.serviceFlow.getEndPointAddress() + " " + axisFault.toString()));
        }
        catch (ServiceException serviceException) {
            logger.error((Object)("Error while invoking service " + this.serviceFlow.getEndPointAddress() + " " + serviceException.toString()));
        }
        catch (MalformedURLException malformedURLException) {
            logger.error((Object)("Error while invoking service " + this.serviceFlow.getEndPointAddress() + " " + malformedURLException.toString()));
        }
    }

    public javax.xml.soap.SOAPEnvelope invokeWithAck(javax.xml.soap.SOAPEnvelope sOAPEnvelope) {
        SOAPEnvelope sOAPEnvelope2 = null;
        try {
            Service service = new Service();
            Call call = (Call)service.createCall();
            call.setTargetEndpointAddress(new URL(this.serviceFlow.getEndPointAddress()));
            Message message = new Message((Object)sOAPEnvelope);
            sOAPEnvelope2 = call.invoke(message);
        }
        catch (AxisFault axisFault) {
            logger.error((Object)("Error while invoking service " + this.serviceFlow.getEndPointAddress() + " " + axisFault.toString()));
        }
        catch (ServiceException serviceException) {
            logger.error((Object)("Error while invoking service " + this.serviceFlow.getEndPointAddress() + " " + serviceException.toString()));
        }
        catch (MalformedURLException malformedURLException) {
            logger.error((Object)("Error while invoking service " + this.serviceFlow.getEndPointAddress() + " " + malformedURLException.toString()));
        }
        return sOAPEnvelope2;
    }
}

