/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.eventManager.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.eclipse.alf.eventManager.core.impl.ALFEventManagerImpl;
import org.eclipse.alf.eventManager.util.ALFEventManagerUtils;

public class ALFEventManager
extends HttpServlet {
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        MessageFactory messageFactory = null;
        SOAPMessage sOAPMessage = null;
        try {
            messageFactory = MessageFactory.newInstance();
            MimeHeaders mimeHeaders = new MimeHeaders();
            mimeHeaders.addHeader("Content-type", "text/xml");
            httpServletResponse.addHeader("Content-type", "text/xml");
            sOAPMessage = messageFactory.createMessage(mimeHeaders, (InputStream)httpServletRequest.getInputStream());
            SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
            ALFEventManagerImpl aLFEventManagerImpl = new ALFEventManagerImpl();
            aLFEventManagerImpl.processMessage(sOAPMessage);
            ALFEventManagerUtils.createResponse(httpServletResponse, sOAPMessage, sOAPEnvelope);
        }
        catch (SOAPException sOAPException) {
            ALFEventManagerUtils.createFault(httpServletResponse, sOAPMessage, "SOAPException: " + sOAPException.getMessage());
        }
        catch (IOException iOException) {
            ALFEventManagerUtils.createFault(httpServletResponse, sOAPMessage, "IOException: " + iOException.getMessage());
        }
    }
}

