/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.editors.eventactionmap;

import java.io.File;
import java.io.IOException;
import org.eclipse.alf.editors.eventactionmap.EventMapEditorScreen;
import org.eclipse.alf.editors.xml.ALFXMLEditor;
import org.eclipse.alf.editors.xml.ALFXMLEditorInput;
import org.eclipse.alf.models.EventMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class EventMapEditor
extends MultiPageEditorPart
implements IResourceChangeListener {
    private TextEditor editor;
    private ALFXMLEditor eventMapEditor;
    private EventMapEditorScreen eventMapScreen;
    private String eventMapLocation;
    private static String eventMapFile;
    private static String currentProject;
    private boolean saving = false;

    public EventMapEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        if (!(iEditorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(iEditorSite, iEditorInput);
    }

    protected void pageChange(int n) {
        if (this.saving) {
            return;
        }
        switch (n) {
            case 0: {
                try {
                    if (this.eventMapEditor.isDirty()) {
                        this.saving = true;
                        this.setActivePage(1);
                        MessageBox messageBox = new MessageBox(this.getContainer().getShell(), 290);
                        messageBox.setMessage("Do you wish to save the file, overwriting the previous version ?");
                        messageBox.setText("ALF Event Map");
                        if (messageBox.open() == 32) {
                            this.doSave(null);
                        } else {
                            String string = this.getEventMapLocation();
                            File file = this.findFileName(string);
                            IFileEditorInput iFileEditorInput = null;
                            iFileEditorInput = (IFileEditorInput)this.getEditorInput();
                            IFile iFile = iFileEditorInput.getFile();
                            IProject iProject = iFile.getProject();
                            iFile = iProject.getFile(string);
                            ALFXMLEditorInput aLFXMLEditorInput = new ALFXMLEditorInput(file, iFile);
                            this.eventMapEditor.setInput((IEditorInput)aLFXMLEditorInput);
                        }
                        this.saving = false;
                        this.setActivePage(0);
                        break;
                    }
                    String string = this.getEventMapLocation();
                    EventMap[] eventMapArray = this.loadEventmapValues(string);
                    this.eventMapScreen.setEventmapregArray(eventMapArray);
                    this.eventMapScreen.refresh();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                break;
            }
            case 1: {
                String string = this.getEventMapLocation();
                File file = this.findFileName(string);
                IFileEditorInput iFileEditorInput = null;
                iFileEditorInput = (IFileEditorInput)this.getEditorInput();
                IFile iFile = iFileEditorInput.getFile();
                IProject iProject = iFile.getProject();
                iFile = iProject.getFile(string);
                ALFXMLEditorInput aLFXMLEditorInput = new ALFXMLEditorInput(file, iFile);
                this.eventMapEditor.setInput((IEditorInput)aLFXMLEditorInput);
                break;
            }
        }
        super.pageChange(n);
    }

    public boolean isDirty() {
        IEditorPart iEditorPart = this.getActiveEditor();
        return iEditorPart != null ? iEditorPart.isDirty() : false;
    }

    protected void createPages() {
        String string = this.getEventMapLocation();
        String string2 = string.substring(0, string.indexOf("."));
        this.setPartName(string2);
        this.eventMapScreen();
        this.eventMapSource();
    }

    public void doSaveAs() {
        int n = this.getActivePage();
        IEditorPart iEditorPart = this.getEditor(n);
        if (iEditorPart.isDirty()) {
            iEditorPart.doSaveAs();
            this.setPageText(n, iEditorPart.getTitle());
            this.setInput(iEditorPart.getEditorInput());
        }
    }

    public void addPropertyListener(IPropertyListener iPropertyListener) {
        super.addPropertyListener(iPropertyListener);
        IFileEditorInput iFileEditorInput = null;
        iFileEditorInput = (IFileEditorInput)this.getEditorInput();
        if (iFileEditorInput != null) {
            IFile iFile = iFileEditorInput.getFile();
            IProject iProject = iFile.getProject();
            this.setCurrentProject(iProject.getName());
            this.setEventMapFile(iFile.getName());
            this.eventMapScreen.refreshServerCombo();
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        try {
            int n = this.getActivePage();
            this.getEditor(n).doSave(iProgressMonitor);
            String string = this.getEventMapLocation();
            EventMap[] eventMapArray = this.loadEventmapValues(string);
            this.eventMapScreen.setEventmapregArray(eventMapArray);
            this.eventMapScreen.refresh();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void resourceChanged(final IResourceChangeEvent iResourceChangeEvent) {
        if (iResourceChangeEvent.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] iWorkbenchPageArray = EventMapEditor.this.getSite().getWorkbenchWindow().getPages();
                    for (int i = 0; i < iWorkbenchPageArray.length; ++i) {
                        if (!((FileEditorInput)EventMapEditor.this.editor.getEditorInput()).getFile().getProject().equals(iResourceChangeEvent.getResource())) continue;
                        IEditorPart iEditorPart = iWorkbenchPageArray[i].findEditor(EventMapEditor.this.editor.getEditorInput());
                        iWorkbenchPageArray[i].closeEditor(iEditorPart, true);
                    }
                }
            });
        }
    }

    public File findFileName(String string) {
        IFileEditorInput iFileEditorInput = null;
        iFileEditorInput = (IFileEditorInput)this.getEditorInput();
        IFile iFile = iFileEditorInput.getFile();
        IProject iProject = iFile.getProject();
        String string2 = iProject.getLocation().toString();
        File file = new File(string2);
        File file2 = new File(file, string);
        return file2;
    }

    public EventMap[] loadEventmapValues(String string) throws IOException {
        EventMap[] eventMapArray = null;
        File file = this.findFileName(string);
        eventMapArray = EventMap.loadEventmapValues(this.getContainer(), file);
        return eventMapArray;
    }

    private void eventMapSource() {
        this.eventMapEditor = new ALFXMLEditor();
        try {
            String string = this.getEventMapLocation();
            File file = this.findFileName(string);
            IFileEditorInput iFileEditorInput = null;
            iFileEditorInput = (IFileEditorInput)this.getEditorInput();
            IFile iFile = iFileEditorInput.getFile();
            IProject iProject = iFile.getProject();
            this.setCurrentProject(iProject.getName());
            this.setEventMapFile(iFile.getName());
            iFile = iProject.getFile(string);
            ALFXMLEditorInput aLFXMLEditorInput = new ALFXMLEditorInput(file, iFile);
            this.addPage(1, (IEditorPart)this.eventMapEditor, (IEditorInput)aLFXMLEditorInput);
            this.setPageText(1, "Source");
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
    }

    private void eventMapScreen() {
        ScrolledComposite scrolledComposite = new ScrolledComposite(this.getContainer(), 768);
        scrolledComposite.setAlwaysShowScrollBars(true);
        scrolledComposite.setLayout((Layout)new GridLayout());
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 1;
        gridLayout.verticalSpacing = 1;
        Composite composite = new Composite((Composite)scrolledComposite, 20);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 0));
        try {
            String string = this.getEventMapLocation();
            EventMap[] eventMapArray = this.loadEventmapValues(string);
            this.eventMapScreen = new EventMapEditorScreen(this);
            this.eventMapScreen.createContents(composite, eventMapArray);
            composite.pack();
            composite.redraw();
            composite.update();
            scrolledComposite.setContent((Control)composite);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.addPage(0, (Control)scrolledComposite);
        this.setPageText(0, "Designer");
    }

    public String getEventMapLocation() {
        IFileEditorInput iFileEditorInput = null;
        iFileEditorInput = (IFileEditorInput)this.getEditorInput();
        IFile iFile = iFileEditorInput.getFile();
        this.eventMapLocation = iFile.getName();
        return this.eventMapLocation;
    }

    public void setEventMapLocation(String string) {
        this.eventMapLocation = string;
    }

    public String getCurrentProject() {
        return currentProject;
    }

    public void setCurrentProject(String string) {
        currentProject = string;
    }

    public String getEventMapFile() {
        return eventMapFile;
    }

    public void setEventMapFile(String string) {
        eventMapFile = string;
    }

    public TextEditor getEditor() {
        return this.editor;
    }

    public void setEditor(TextEditor textEditor) {
        this.editor = textEditor;
    }

    public ALFXMLEditor getEventMapEditor() {
        return this.eventMapEditor;
    }

    public void setEventMapEditor(ALFXMLEditor aLFXMLEditor) {
        this.eventMapEditor = aLFXMLEditor;
    }

    public EventMapEditorScreen getEventMapScreen() {
        return this.eventMapScreen;
    }

    public void setEventMapScreen(EventMapEditorScreen eventMapEditorScreen) {
        this.eventMapScreen = eventMapEditorScreen;
    }
}

