/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.editors.serviceflowregistry;

import java.io.File;
import java.io.IOException;
import org.eclipse.alf.editors.serviceflowregistry.RegisterServiceFlowScreen;
import org.eclipse.alf.editors.xml.ALFXMLEditor;
import org.eclipse.alf.editors.xml.ALFXMLEditorInput;
import org.eclipse.alf.models.RegisteredServiceFlow;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class ServiceFlowEditor
extends MultiPageEditorPart
implements IResourceChangeListener {
    private String serviceFlowRegistryLocation;
    private TextEditor editor;
    private ALFXMLEditor registeredservicefloweditor;
    private RegisterServiceFlowScreen newServiceScreen;
    private boolean saving = false;

    public ServiceFlowEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public File findFileName(String string) {
        IFileEditorInput iFileEditorInput = null;
        iFileEditorInput = (IFileEditorInput)this.getEditorInput();
        IFile iFile = iFileEditorInput.getFile();
        IProject iProject = iFile.getProject();
        String string2 = iProject.getLocation().toString();
        File file = new File(string2);
        File file2 = new File(file, string);
        return file2;
    }

    private void registerServiceFlowPage() {
        ScrolledComposite scrolledComposite = new ScrolledComposite(this.getContainer(), 768);
        scrolledComposite.setAlwaysShowScrollBars(true);
        scrolledComposite.setLayout((Layout)new GridLayout());
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 1;
        gridLayout.verticalSpacing = 1;
        Composite composite = new Composite((Composite)scrolledComposite, 20);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 0));
        try {
            String string = this.getServiceFlowRegistryLocation();
            RegisteredServiceFlow[] registeredServiceFlowArray = this.loadServiceRegistryXML(string);
            this.newServiceScreen = new RegisterServiceFlowScreen(this);
            this.newServiceScreen.createContents(composite, registeredServiceFlowArray);
            composite.pack();
            composite.redraw();
            composite.update();
            scrolledComposite.setContent((Control)composite);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.addPage(0, (Control)scrolledComposite);
        this.setPageText(0, "Designer");
    }

    private RegisteredServiceFlow[] loadServiceRegistryXML(String string) throws IOException {
        RegisteredServiceFlow[] registeredServiceFlowArray = null;
        try {
            File file = this.findFileName(string);
            registeredServiceFlowArray = RegisteredServiceFlow.loadServiceRegistryXML(this.getContainer(), file);
        }
        catch (Exception exception) {
            MessageBox messageBox = new MessageBox(this.getContainer().getShell(), 34);
            messageBox.setMessage("XML is not Wellformed : " + exception.getMessage());
            messageBox.setText("ALF Service Flow Registry ");
            messageBox.open();
        }
        return registeredServiceFlowArray;
    }

    private void registerserviceFlowSource() {
        this.registeredservicefloweditor = new ALFXMLEditor();
        ALFXMLEditorInput aLFXMLEditorInput = null;
        try {
            String string = this.getServiceFlowRegistryLocation();
            File file = this.findFileName(string);
            IFileEditorInput iFileEditorInput = null;
            iFileEditorInput = (IFileEditorInput)this.getEditorInput();
            IFile iFile = iFileEditorInput.getFile();
            IProject iProject = iFile.getProject();
            iFile = iProject.getFile(string);
            aLFXMLEditorInput = new ALFXMLEditorInput(file, iFile);
            this.addPage(1, (IEditorPart)this.registeredservicefloweditor, (IEditorInput)aLFXMLEditorInput);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setPageText(1, "Source");
    }

    protected void createPages() {
        try {
            this.registerServiceFlowPage();
            this.registerserviceFlowSource();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        try {
            int n = this.getActivePage();
            this.getEditor(n).doSave(iProgressMonitor);
            String string = this.getServiceFlowRegistryLocation();
            RegisteredServiceFlow[] registeredServiceFlowArray = this.loadServiceRegistryXML(string);
            this.newServiceScreen.setServiceReg(registeredServiceFlowArray);
            this.newServiceScreen.refresh();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doSaveAs() {
        int n = this.getActivePage();
        IEditorPart iEditorPart = this.getEditor(n);
        if (iEditorPart.isDirty()) {
            iEditorPart.doSaveAs();
            this.setPageText(n, iEditorPart.getTitle());
            this.setInput(iEditorPart.getEditorInput());
        }
    }

    public boolean isDirty() {
        IEditorPart iEditorPart = this.getActiveEditor();
        return iEditorPart != null ? iEditorPart.isDirty() : false;
    }

    public void gotoMarker(IMarker iMarker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)iMarker);
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        if (!(iEditorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(iEditorSite, iEditorInput);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int n) {
        if (this.saving) {
            return;
        }
        switch (n) {
            case 0: {
                try {
                    if (this.registeredservicefloweditor.isDirty()) {
                        this.saving = true;
                        this.setActivePage(1);
                        MessageBox messageBox = new MessageBox(this.getContainer().getShell(), 290);
                        messageBox.setMessage("Do you wish to save the file, overwriting the previous version ?");
                        messageBox.setText("ALF Service Flow Registry ");
                        if (messageBox.open() == 32) {
                            this.doSave(null);
                        } else {
                            String string = this.getServiceFlowRegistryLocation();
                            File file = this.findFileName(string);
                            IFileEditorInput iFileEditorInput = null;
                            iFileEditorInput = (IFileEditorInput)this.getEditorInput();
                            IFile iFile = iFileEditorInput.getFile();
                            IProject iProject = iFile.getProject();
                            iFile = iProject.getFile(string);
                            ALFXMLEditorInput aLFXMLEditorInput = new ALFXMLEditorInput(file, iFile);
                            this.registeredservicefloweditor.setInput((IEditorInput)aLFXMLEditorInput);
                        }
                        this.saving = false;
                        this.setActivePage(0);
                        break;
                    }
                    String string = this.getServiceFlowRegistryLocation();
                    RegisteredServiceFlow[] registeredServiceFlowArray = this.loadServiceRegistryXML(string);
                    this.newServiceScreen.setServiceReg(registeredServiceFlowArray);
                    this.newServiceScreen.refresh();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                break;
            }
            case 1: {
                try {
                    String string = this.getServiceFlowRegistryLocation();
                    File file = this.findFileName(string);
                    IFileEditorInput iFileEditorInput = null;
                    iFileEditorInput = (IFileEditorInput)this.getEditorInput();
                    IFile iFile = iFileEditorInput.getFile();
                    IProject iProject = iFile.getProject();
                    iFile = iProject.getFile(string);
                    ALFXMLEditorInput aLFXMLEditorInput = new ALFXMLEditorInput(file, iFile);
                    this.registeredservicefloweditor.setInput((IEditorInput)aLFXMLEditorInput);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
        }
        super.pageChange(n);
    }

    public void resourceChanged(final IResourceChangeEvent iResourceChangeEvent) {
        if (iResourceChangeEvent.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] iWorkbenchPageArray = ServiceFlowEditor.this.getSite().getWorkbenchWindow().getPages();
                    for (int i = 0; i < iWorkbenchPageArray.length; ++i) {
                        if (!((FileEditorInput)ServiceFlowEditor.this.editor.getEditorInput()).getFile().getProject().equals(iResourceChangeEvent.getResource())) continue;
                        IEditorPart iEditorPart = iWorkbenchPageArray[i].findEditor(ServiceFlowEditor.this.editor.getEditorInput());
                        iWorkbenchPageArray[i].closeEditor(iEditorPart, true);
                    }
                }
            });
        }
    }

    public String getServiceFlowRegistryLocation() {
        IFileEditorInput iFileEditorInput = null;
        iFileEditorInput = (IFileEditorInput)this.getEditorInput();
        IFile iFile = iFileEditorInput.getFile();
        this.serviceFlowRegistryLocation = iFile.getName();
        return this.serviceFlowRegistryLocation;
    }

    public void setServiceFlowRegistryLocation(String string) {
        this.serviceFlowRegistryLocation = string;
    }
}

