/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.eventMapEditor.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.alf.eventMapEditor.wizards.ALFNewWizardPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class ALFWizard
extends Wizard
implements INewWizard {
    private ALFNewWizardPage page;
    private String fileName = "";
    private String fileNameEvent = "";
    private String fileNameServiceflow = "";
    private String serverConfigFile = "serverconfig.xml";
    private static String newLine = "\n";
    private static String XMLHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static String ROOT_ELEMENT = "<ServerConfig xmlns:p=\"http://www.eclipse.org/ALF/XMLSchema/EventRule\"";
    private static String NAMESPACE = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
    private static String SERVER = "<Server>";
    private static String SERVERNAME = " <ServerName/>";
    private static String SERVERURL = " <URL/>";
    private static String SERVER_END = " </Server>";
    private static String ROOT_ELEMENT_END = "</ServerConfig>";
    private static String eventDoc = "<ALFEventRegistry/>";
    private static String serviceDoc = "<ALFServiceFlowRegistry/>";
    private IStructuredSelection selection;

    public ALFWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.page = new ALFNewWizardPage("New ALF Project");
        this.page.setTitle("Create ALF Project");
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String string = this.page.getContainerName();
        this.fileNameEvent = this.page.getContainerName() + ".evt";
        this.fileNameServiceflow = this.page.getContainerName() + ".svc";
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgressMonitor iProgressMonitor) {
                try {
                    IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    ALFWizard.this.configNewProject(iWorkspaceRoot, iProgressMonitor, string.trim());
                    ALFWizard.this.doFinish(iWorkspaceRoot, string.trim(), ALFWizard.this.fileNameEvent);
                    ALFWizard.this.doFinish(iWorkspaceRoot, string.trim(), ALFWizard.this.fileNameServiceflow);
                    ALFWizard.this.doFinish(iWorkspaceRoot, string.trim(), ALFWizard.this.serverConfigFile);
                    iProgressMonitor.worked(1);
                    iProgressMonitor.done();
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)throwable.getMessage());
            return false;
        }
        return true;
    }

    private void configNewProject(IWorkspaceRoot iWorkspaceRoot, IProgressMonitor iProgressMonitor, String string) throws CoreException {
        IProject iProject = iWorkspaceRoot.getProject(string);
        if (iProject.exists()) {
            this.doFinish(iWorkspaceRoot, string, this.fileName);
        }
        iProject.create(iProgressMonitor);
        iProject.refreshLocal(0, iProgressMonitor);
        if (!iProject.isOpen()) {
            iProject.open(iProgressMonitor);
        }
    }

    private void doFinish(IWorkspaceRoot iWorkspaceRoot, String string, String string2) throws CoreException {
        IResource iResource = iWorkspaceRoot.findMember((IPath)new Path(string));
        if (!iResource.exists() || !(iResource instanceof IContainer)) {
            this.throwCoreException("Container \"" + string + "\" does not exist.");
        }
        IContainer iContainer = (IContainer)iResource;
        final IFile iFile = iContainer.getFile((IPath)new Path(string2));
        try {
            if (string2.endsWith(".evt")) {
                InputStream inputStream = this.openContentStreamEvent();
                if (iFile.exists()) {
                    iFile.setContents(inputStream, true, true, null);
                } else {
                    iFile.create(inputStream, true, null);
                }
                inputStream.close();
            } else if (string2.endsWith(".svc")) {
                InputStream inputStream = this.openContentStreamService();
                if (iFile.exists()) {
                    iFile.setContents(inputStream, true, true, null);
                } else {
                    iFile.create(inputStream, true, null);
                }
                inputStream.close();
            } else if (string2.endsWith(".xml")) {
                InputStream inputStream = this.openServerConfigStream();
                if (iFile.exists()) {
                    iFile.setContents(inputStream, true, true, null);
                } else {
                    iFile.create(inputStream, true, null);
                }
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
    }

    private InputStream openServerConfigStream() {
        String string = XMLHeader + newLine + ROOT_ELEMENT + newLine + NAMESPACE + newLine + SERVER + newLine + SERVERNAME + newLine + SERVERURL + newLine + SERVER_END + newLine + ROOT_ELEMENT_END;
        return new ByteArrayInputStream(string.getBytes());
    }

    private InputStream openContentStreamEvent() {
        String string = XMLHeader + newLine + eventDoc;
        return new ByteArrayInputStream(string.getBytes());
    }

    private InputStream openContentStreamService() {
        String string = XMLHeader + newLine + serviceDoc;
        return new ByteArrayInputStream(string.getBytes());
    }

    private void throwCoreException(String string) throws CoreException {
        Status status = new Status(4, "ALFPlugin", 0, string, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.selection = iStructuredSelection;
    }
}

