/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.models;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.alf.editors.eventactionmap.EventMapEditorScreen;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ServerRegistry {
    public static void loadServerXML(File file, List list, List list2) throws IOException {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = sAXBuilder.build(file);
            Element element = document.getRootElement();
            Namespace namespace = element.getNamespace();
            List list3 = element.getChildren("Server", element.getNamespace());
            for (int i = 0; i < list3.size(); ++i) {
                Element element2 = (Element)list3.get(i);
                if (list.contains(element2.getChildText("ServerName", namespace)) || element2.getChildText("ServerName", namespace).equals("")) continue;
                list.add(element2.getChildText("ServerName", namespace));
                list2.add(element2.getChildText("URL", namespace));
            }
        }
        catch (JDOMException jDOMException) {
            EventMapEditorScreen.consolePrint("***SERENA LOG***:ALF Server Registry XML is not Valid " + jDOMException.getMessage());
        }
    }

    public static void createServerXML(File file) {
        try {
            boolean bl = file.createNewFile();
            if (bl) {
                Namespace namespace = Namespace.getNamespace((String)"p", (String)"http://www.eclipse.org/ALF/XMLSchema/EventRule");
                Namespace namespace2 = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
                String string = "xsi:schemaLocation=http://www.eclipse.org/ALF/XMLSchema/EventRule EventActionMap.xsd";
                Namespace.getNamespace((String)string);
                Element element = new Element("ServerConfig");
                Document document = new Document(element);
                element.addNamespaceDeclaration(namespace);
                element.addNamespaceDeclaration(namespace2);
                Element element2 = new Element("Server");
                element2.addContent((Content)new Element("ServerName"));
                element2.addContent((Content)new Element("URL"));
                element.addContent((Content)element2);
                XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
                xMLOutputter.output(document, (OutputStream)new FileOutputStream(file));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

