/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.eventManager.admin.core.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Date;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.eclipse.alf.eventManager.admin.core.impl.ApplicationStatus;
import org.eclipse.alf.eventManager.admin.core.impl.EventMap;
import org.eclipse.alf.eventManager.admin.core.impl.ServiceFlow;
import org.eclipse.alf.eventManager.admin.core.inf.IALFAdmin;
import org.eclipse.alf.eventManager.admin.util.ApplicationStatusBuilder;
import org.eclipse.alf.eventManager.core.impl.ALFEventManagerImpl;
import org.eclipse.alf.eventManager.core.impl.ApplicationEventMatchStatus;
import org.eclipse.alf.eventManager.core.impl.EventCondition;
import org.eclipse.alf.eventManager.core.impl.EventMatch;
import org.eclipse.alf.exception.InvalidApplicationNameException;
import org.eclipse.alf.exception.InvalidEventMapException;
import org.eclipse.alf.util.AlfUtilityManager;
import org.jdom.JDOMException;
import org.xml.sax.SAXException;

public class ALFAdminImpl
implements IALFAdmin {
    private static String appStatusFileName = ALFAdminImpl.getStatusFileName();
    private static String ALF_FILE_EXT = AlfUtilityManager.getALFProperty("deployed_file_extn");
    private static final String NEWLINE = "\n";
    private static Logger logger;

    public String deploy(String string, boolean bl) throws InvalidEventMapException, InvalidApplicationNameException {
        String string2 = null;
        EventMap[] eventMapArray = null;
        EventMap eventMap = null;
        if (null == string) {
            throw new InvalidEventMapException("Unable to deploy the application because the event map is either empty or invalid.");
        }
        eventMap = new EventMap();
        try {
            eventMapArray = eventMap.getEventMap(string);
        }
        catch (IOException iOException) {
            logger.error((Object)("Error Parsing the Deployment String " + iOException.getMessage()));
            throw new InvalidEventMapException(iOException.getMessage());
        }
        catch (JDOMException jDOMException) {
            throw new InvalidEventMapException("Unable to deploy the application because the event map is either empty or invalid. " + jDOMException.getMessage());
        }
        this.checkEventMapValidity(eventMapArray);
        string2 = eventMapArray[0].getApplicationName();
        if (this.isApplicationDeployed(string2)) {
            throw new InvalidApplicationNameException("\"" + string2 + "\" " + " application already deployed");
        }
        ApplicationStatusBuilder applicationStatusBuilder = new ApplicationStatusBuilder();
        List list = applicationStatusBuilder.getApplicationStatus(appStatusFileName);
        ApplicationStatus applicationStatus = new ApplicationStatus();
        applicationStatus.setApplicationName(string2);
        this.setTime(applicationStatus, -1);
        applicationStatus.setLastPausedTimestamp(null);
        applicationStatus.setLastResumedTimestamp(null);
        applicationStatus.setStatus(bl ? 1 : 0);
        list.add(applicationStatus);
        ALFEventManagerImpl aLFEventManagerImpl = new ALFEventManagerImpl();
        File file = new File(AlfUtilityManager.getALF_HOME() + "//" + AlfUtilityManager.getALFProperty("deploy_location"), string2 + "." + ALF_FILE_EXT);
        eventMap.saveEventmapValues(eventMapArray, file);
        applicationStatusBuilder.saveApplicationStatus(list, appStatusFileName);
        try {
            aLFEventManagerImpl.parseEventMapFile(string2);
        }
        catch (SAXException sAXException) {
            logger.error((Object)("Error while trying to parse Application File " + string2 + " " + sAXException.getMessage()));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.error((Object)("Error while trying to parse Application File " + string2 + " " + parserConfigurationException.getMessage()));
        }
        catch (IOException iOException) {
            logger.error((Object)("Error while trying to parse Application File " + string2 + " " + iOException.getMessage()));
        }
        logger.info((Object)("Application \"" + string2 + "\" deployed successfully."));
        return string2;
    }

    public void unDeploy(String string) throws InvalidApplicationNameException {
        if (!this.isApplicationDeployed(string)) {
            logger.error((Object)("Unable to undeploy Application \"" + string + "\" ," + " application is not yet deployed" + "."));
            throw new InvalidApplicationNameException("\"" + string + "\"" + " application is not yet deployed");
        }
        ApplicationStatusBuilder applicationStatusBuilder = new ApplicationStatusBuilder();
        List list = applicationStatusBuilder.getApplicationStatus(appStatusFileName);
        File file = new File(AlfUtilityManager.getALF_HOME() + "\\" + AlfUtilityManager.getALFProperty("deploy_location"), string + "." + ALF_FILE_EXT);
        file.delete();
        this.removeApplication(list, string);
        Map map = ALFEventManagerImpl.getEventStatus();
        Map map2 = ALFEventManagerImpl.getEventTable();
        ApplicationEventMatchStatus applicationEventMatchStatus = (ApplicationEventMatchStatus)map.get(string);
        List list2 = applicationEventMatchStatus.getEventMatches();
        map.remove(string);
        if (null != list2) {
            int n = 0;
            for (n = 0; n < list2.size(); ++n) {
                EventMatch eventMatch = (EventMatch)list2.get(n);
                Integer n2 = EventCondition.getHashToken(eventMatch.getEventType(), eventMatch.getObjectType(), eventMatch.getProduct(), eventMatch.getProductVers(), eventMatch.getProductInstance());
                List list3 = (List)map2.get(n2.toString());
                if (null == list3) continue;
                ArrayList<EventCondition> arrayList = new ArrayList<EventCondition>();
                for (int i = 0; i < list3.size(); ++i) {
                    EventCondition eventCondition = (EventCondition)list3.get(i);
                    if (eventCondition.getApplicationName().equalsIgnoreCase(string)) continue;
                    arrayList.add(eventCondition);
                }
                if (arrayList.size() > 0) {
                    map2.put(n2.toString(), arrayList);
                    continue;
                }
                map2.remove(n2.toString());
            }
        }
        applicationStatusBuilder.saveApplicationStatus(list, appStatusFileName);
        logger.info((Object)("Application \"" + string + "\" undeployed successfully."));
    }

    public void pause(String string) throws InvalidApplicationNameException {
        if (!this.isApplicationDeployed(string)) {
            logger.error((Object)("Unable to pause Application \"" + string + "\" ," + " application is not yet deployed" + "."));
            throw new InvalidApplicationNameException("\"" + string + "\"" + " application is not yet deployed");
        }
        if (!this.isApplicationRunning(string)) {
            logger.error((Object)("Unable to pause Application \"" + string + "\" ," + " application is already paused" + "."));
            throw new InvalidApplicationNameException("\"" + string + "\"" + " application is already paused");
        }
        ApplicationStatusBuilder applicationStatusBuilder = new ApplicationStatusBuilder();
        List list = applicationStatusBuilder.getApplicationStatus(appStatusFileName);
        this.setApplicationStatus(list, 0, string);
        applicationStatusBuilder.saveApplicationStatus(list, appStatusFileName);
        this.setApplicationStatus(string, 0);
        logger.info((Object)("Application \"" + string + "\" paused successfully."));
    }

    public void pauseAll() {
        ApplicationStatusBuilder applicationStatusBuilder = new ApplicationStatusBuilder();
        List list = applicationStatusBuilder.getApplicationStatus(appStatusFileName);
        try {
            this.setApplicationStatus(list, 0, null);
        }
        catch (InvalidApplicationNameException invalidApplicationNameException) {
            // empty catch block
        }
        applicationStatusBuilder.saveApplicationStatus(list, appStatusFileName);
        this.setAllApplicationStatus(0);
        logger.info((Object)"All Applications paused successfully.");
    }

    public void resume(String string) throws InvalidApplicationNameException {
        if (!this.isApplicationDeployed(string)) {
            logger.error((Object)("Unable to resume Application \"" + string + "\" ," + " application is not yet deployed" + "."));
            throw new InvalidApplicationNameException("\"" + string + "\"" + " application is not yet deployed");
        }
        if (this.isApplicationRunning(string)) {
            logger.error((Object)("Unable to resume Application \"" + string + "\" " + " application is already running" + "."));
            throw new InvalidApplicationNameException("\"" + string + "\"" + " application is already running");
        }
        ApplicationStatusBuilder applicationStatusBuilder = new ApplicationStatusBuilder();
        List list = applicationStatusBuilder.getApplicationStatus(appStatusFileName);
        this.setApplicationStatus(list, 1, string);
        applicationStatusBuilder.saveApplicationStatus(list, appStatusFileName);
        this.setApplicationStatus(string, 1);
        logger.info((Object)("Application \"" + string + "\" resumed successfully."));
    }

    public void resumeAll() {
        ApplicationStatusBuilder applicationStatusBuilder = new ApplicationStatusBuilder();
        List list = applicationStatusBuilder.getApplicationStatus(appStatusFileName);
        try {
            this.setApplicationStatus(list, 1, null);
        }
        catch (InvalidApplicationNameException invalidApplicationNameException) {
            // empty catch block
        }
        applicationStatusBuilder.saveApplicationStatus(list, appStatusFileName);
        this.setAllApplicationStatus(1);
        logger.info((Object)"All Application resumed successfully.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEventMap(String string) throws InvalidApplicationNameException {
        if (!this.isApplicationDeployed(string)) {
            logger.error((Object)("Unable to fetch EventAction Map for Application \"" + string + "\" ," + " application is not yet deployed" + "."));
            throw new InvalidApplicationNameException("\"" + string + "\" " + " application is not yet deployed");
        }
        File file = new File(AlfUtilityManager.getALF_HOME() + "\\" + AlfUtilityManager.getALFProperty("deploy_location"), string + "." + ALF_FILE_EXT);
        String string2 = "";
        String string3 = null;
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            while ((string3 = bufferedReader.readLine()) != null) {
                string2 = string2 + NEWLINE + string3;
            }
        }
        catch (IOException iOException) {
            logger.error((Object)("Error reading Application File " + string));
        }
        finally {
            try {
                if (null != bufferedReader) {
                    bufferedReader.close();
                }
                if (null != fileReader) {
                    fileReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        logger.info((Object)("Successfully retrieved eventMap for Application \"" + string + "\"."));
        return string2;
    }

    public String getEventMapAll() {
        return null;
    }

    public ApplicationStatus[] getApplicationStatus() {
        ApplicationStatus[] applicationStatusArray = null;
        Map map = ALFEventManagerImpl.getEventStatus();
        if (null != map) {
            ArrayList<ApplicationStatus> arrayList = new ArrayList<ApplicationStatus>();
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                ApplicationEventMatchStatus applicationEventMatchStatus = (ApplicationEventMatchStatus)entry.getValue();
                ApplicationStatus applicationStatus = new ApplicationStatus(applicationEventMatchStatus.getApplStatus());
                try {
                    this.convertTimeToDisplayFormat(applicationStatus);
                }
                catch (InvalidApplicationNameException invalidApplicationNameException) {
                    invalidApplicationNameException.printStackTrace();
                }
                applicationStatus.setStatusString(applicationStatus.getStatus() == 0 ? "Paused" : "Running");
                arrayList.add(applicationEventMatchStatus.getApplStatus());
            }
            applicationStatusArray = arrayList.toArray(new ApplicationStatus[arrayList.size()]);
        }
        logger.info((Object)"Successfully retrieved the Application Status of  All Applications.");
        return applicationStatusArray;
    }

    public ApplicationStatus getApplicationStatus(String string) throws InvalidApplicationNameException {
        ApplicationStatus applicationStatus = null;
        Map map = ALFEventManagerImpl.getEventStatus();
        boolean bl = false;
        if (null != map) {
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                String string2 = (String)entry.getKey();
                if (!string2.equals(string)) continue;
                ApplicationEventMatchStatus applicationEventMatchStatus = (ApplicationEventMatchStatus)map.get(string);
                applicationStatus = new ApplicationStatus(applicationEventMatchStatus.getApplStatus());
                this.convertTimeToDisplayFormat(applicationStatus);
                applicationStatus.setStatusString(applicationStatus.getStatus() == 0 ? "Paused" : "Running");
                bl = true;
                break;
            }
            if (!bl) {
                logger.error((Object)("Unable to fetch the Application Status for Application \"" + string + "\" ," + " application is not yet deployed" + "."));
                throw new InvalidApplicationNameException("\"" + string + "\"" + " application is not yet deployed");
            }
        }
        logger.info((Object)("Successfully retrieved the Application Status of Application \"" + string + "\"."));
        return applicationStatus;
    }

    private void removeApplication(List list, String string) {
        ApplicationStatus applicationStatus = null;
        if (null != list) {
            for (int i = 0; i < list.size(); ++i) {
                applicationStatus = (ApplicationStatus)list.get(i);
                if (!applicationStatus.getApplicationName().equals(string)) continue;
                list.remove(i);
            }
        }
    }

    private void convertTimeToDisplayFormat(ApplicationStatus applicationStatus) throws InvalidApplicationNameException {
        String string = null;
        string = applicationStatus.getDeploymentTimestamp();
        if (null != string) {
            applicationStatus.setDeploymentTimestamp(this.getTimeFormatted(string));
        }
        if (null != (string = applicationStatus.getLastPausedTimestamp()) && string.length() > 0) {
            applicationStatus.setLastPausedTimestamp(this.getTimeFormatted(string));
        }
        if (null != (string = applicationStatus.getLastResumedTimestamp()) && string.length() > 0) {
            applicationStatus.setLastResumedTimestamp(this.getTimeFormatted(string));
        }
    }

    private String getTimeFormatted(String string) throws InvalidApplicationNameException {
        String string2 = AlfUtilityManager.getALFProperty("date_time_format");
        StringBuffer stringBuffer = null;
        if (null != string2) {
            Date date = new Date(Long.parseLong(string));
            try {
                stringBuffer = new SimpleDateFormat(string2).format((java.util.Date)date, new StringBuffer(), new FieldPosition(0));
            }
            catch (Exception exception) {
                throw new InvalidApplicationNameException("Invalid Date Format configured");
            }
        } else {
            throw new InvalidApplicationNameException("Date format unconfigured");
        }
        return stringBuffer.toString();
    }

    private void setApplicationStatus(List list, int n, String string) throws InvalidApplicationNameException {
        ApplicationStatus applicationStatus = null;
        if (list != null) {
            boolean bl = false;
            for (int i = 0; i < list.size(); ++i) {
                applicationStatus = (ApplicationStatus)list.get(i);
                if (null != string) {
                    if (!applicationStatus.getApplicationName().equals(string)) continue;
                    applicationStatus.setStatus(n);
                    bl = true;
                    this.setTime(applicationStatus, n);
                    continue;
                }
                applicationStatus.setStatus(n);
                this.setTime(applicationStatus, n);
            }
            if (!bl) {
                throw new InvalidApplicationNameException("\"" + string + "\"" + " application is not yet deployed");
            }
        }
    }

    private void setAllApplicationStatus(int n) {
        Map map = ALFEventManagerImpl.getEventStatus();
        if (null != map) {
            Set set = map.keySet();
            for (String string : set) {
                this.setApplicationStatus(string, n);
            }
        }
    }

    private void setApplicationStatus(String string, int n) {
        Map map = ALFEventManagerImpl.getEventStatus();
        ApplicationEventMatchStatus applicationEventMatchStatus = (ApplicationEventMatchStatus)map.get(string);
        ApplicationStatus applicationStatus = applicationEventMatchStatus.getApplStatus();
        applicationStatus.setStatus(n);
        this.setTime(applicationStatus, n);
    }

    private void setTime(ApplicationStatus applicationStatus, int n) {
        String string = null;
        Calendar calendar = Calendar.getInstance();
        string = String.valueOf(calendar.getTimeInMillis());
        if (n == 0) {
            applicationStatus.setLastPausedTimestamp(string);
        } else if (n == 1) {
            applicationStatus.setLastResumedTimestamp(string);
        } else {
            applicationStatus.setDeploymentTimestamp(string);
        }
    }

    private boolean isApplicationDeployed(String string) {
        ApplicationEventMatchStatus applicationEventMatchStatus;
        boolean bl = false;
        Map map = ALFEventManagerImpl.getEventStatus();
        if (map != null && map.size() > 0 && null != (applicationEventMatchStatus = (ApplicationEventMatchStatus)map.get(string))) {
            bl = true;
        }
        return bl;
    }

    private boolean isApplicationRunning(String string) {
        ApplicationEventMatchStatus applicationEventMatchStatus;
        boolean bl = false;
        Map map = ALFEventManagerImpl.getEventStatus();
        if (null != map && map.size() > 0 && null != (applicationEventMatchStatus = (ApplicationEventMatchStatus)map.get(string)) && applicationEventMatchStatus.getApplStatus().getStatus() == 1) {
            bl = true;
        }
        return bl;
    }

    private void checkEventMapValidity(EventMap[] eventMapArray) throws InvalidEventMapException {
        if (null != eventMapArray && eventMapArray.length > 0) {
            for (int i = 0; i < eventMapArray.length; ++i) {
                EventMap eventMap = eventMapArray[i];
                if (eventMap.isEventTypeEmpty() || eventMap.isObjectTypeEmpty() || eventMap.isProductEmpty() || eventMap.isProductInstanceEmpty() || eventMap.isProductVersionEmpty() || eventMap.isServiceFlowsEmpty()) {
                    throw new InvalidEventMapException("Unable to deploy the application because the event map is either empty or invalid.");
                }
                ServiceFlow[] serviceFlowArray = eventMap.getServiceFlows();
                for (int j = 0; j < serviceFlowArray.length; ++j) {
                    ServiceFlow serviceFlow = serviceFlowArray[j];
                    if (serviceFlow.isServiceFlowValid()) continue;
                    throw new InvalidEventMapException("Unable to deploy the application because the event map is either empty or invalid.");
                }
                if (!EventMap.isServiceFlowRepeated(serviceFlowArray)) continue;
            }
            if (EventMap.isEventsRepeated(eventMapArray)) {
                throw new InvalidEventMapException("The EventMap contains duplicate events.");
            }
            if (EventMap.isEventMatchNamesRepeated(eventMapArray)) {
                throw new InvalidEventMapException("EventMatchName duplicates in Event-Action Map.");
            }
        } else {
            throw new InvalidEventMapException("Unable to deploy the application because the event map is either empty or invalid.");
        }
    }

    private static String getStatusFileName() {
        return AlfUtilityManager.getALF_HOME() + "//" + AlfUtilityManager.getALFProperty("deploy_location") + "//" + AlfUtilityManager.getALFProperty("application_status");
    }

    static {
        ALFEventManagerImpl aLFEventManagerImpl = new ALFEventManagerImpl();
        logger = Logger.getLogger(ALFAdminImpl.class);
    }
}

