/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.eventManager.admin.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.alf.eventManager.admin.core.impl.ApplicationStatus;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ApplicationStatusBuilder {
    private static Logger logger = Logger.getLogger(ApplicationStatusBuilder.class);

    public List getApplicationStatus(String string) {
        List list = null;
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = null;
        try {
            File file = new File(string);
            document = file.exists() ? sAXBuilder.build(file) : new Document(new Element("ApplicationStatus"));
            list = this.getApplicationStatusValues(document);
        }
        catch (JDOMException jDOMException) {
            logger.error((Object)("JDOM Exception while parsing " + string + " while trying to fetch " + "ApplicationStatus " + jDOMException.getMessage()));
        }
        catch (IOException iOException) {
            logger.error((Object)("Error Fetching ApplicationStatus from File " + string + " " + iOException.getMessage()));
        }
        return list;
    }

    private List getApplicationStatusValues(Document document) {
        ArrayList<ApplicationStatus> arrayList = null;
        try {
            if (document.getRootElement() == null) {
                throw new JDOMException();
            }
            Element element = document.getRootElement();
            List list = element.getChildren("Application", element.getNamespace());
            arrayList = new ArrayList<ApplicationStatus>(list.size());
            Iterator iterator = list.iterator();
            for (int i = 0; i < list.size(); ++i) {
                ApplicationStatus applicationStatus = new ApplicationStatus();
                Element element2 = (Element)iterator.next();
                Element element3 = element2.getChild("Name");
                applicationStatus.setApplicationName(element3.getText());
                Element element4 = element2.getChild("Status");
                applicationStatus.setStatus(new Integer(element4.getText()));
                Element element5 = element2.getChild("DeploymentTimeStamp");
                applicationStatus.setDeploymentTimestamp(element5.getText());
                Element element6 = element2.getChild("LastResumedTimeStamp");
                applicationStatus.setLastResumedTimestamp(element6.getText());
                Element element7 = element2.getChild("LastPausedTimeStamp");
                applicationStatus.setLastPausedTimestamp(element7.getText());
                arrayList.add(applicationStatus);
            }
        }
        catch (JDOMException jDOMException) {
            logger.error((Object)("JDOMException while fetching ApplicationStatus Value from the Document Object " + jDOMException.getMessage()));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveApplicationStatus(List list, String string) {
        Serializable serializable;
        Element element = new Element("ApplicationStatus");
        Document document = new Document(element);
        Element element2 = null;
        for (int i = 0; i < list.size(); ++i) {
            element2 = new Element("Application");
            serializable = (ApplicationStatus)list.get(i);
            element2.addContent((Content)new Element("Name").addContent(((ApplicationStatus)serializable).getApplicationName()));
            element2.addContent((Content)new Element("Status").addContent(Integer.toString(((ApplicationStatus)serializable).getStatus())));
            element2.addContent((Content)new Element("DeploymentTimeStamp").addContent(((ApplicationStatus)serializable).getDeploymentTimestamp()));
            element2.addContent((Content)new Element("LastResumedTimeStamp").addContent(null == ((ApplicationStatus)serializable).getLastResumedTimestamp() ? " " : ((ApplicationStatus)serializable).getLastResumedTimestamp()));
            element2.addContent((Content)new Element("LastPausedTimeStamp").addContent(null == ((ApplicationStatus)serializable).getLastPausedTimestamp() ? " " : ((ApplicationStatus)serializable).getLastPausedTimestamp()));
            element.addContent((Content)element2);
        }
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
        serializable = new File(string);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream((File)serializable);
            xMLOutputter.output(document, (OutputStream)fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.error((Object)("File " + string + " not found in ALF_HOME to save ApplicationStatus"));
        }
        catch (IOException iOException) {
            logger.error((Object)("Error while saving ApplicationStatus to " + string + " " + iOException.getMessage()));
        }
        finally {
            try {
                if (null != fileOutputStream) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

