/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.eventManager.core.impl;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.log4j.Logger;

public class ServiceFlow {
    private StringBuffer serviceFlowName;
    private StringBuffer endPointAddress;
    private boolean isSynchronous;
    private javax.xml.soap.SOAPEnvelope soapEnv;
    private static Logger logger = Logger.getLogger(ServiceFlow.class);

    public ServiceFlow() {
        this.init();
    }

    public ServiceFlow(boolean bl) {
        this.init();
        this.isSynchronous = bl;
    }

    public ServiceFlow(String string, String string2, boolean bl) {
        this.init();
        this.endPointAddress.append(string);
        this.serviceFlowName.append(string2);
        this.isSynchronous = bl;
    }

    public void init() {
        this.endPointAddress = new StringBuffer();
        this.serviceFlowName = new StringBuffer();
    }

    public void invoke() {
        try {
            Message message = new Message((Object)this.soapEnv);
            Service service = new Service();
            Call call = (Call)service.createCall();
            call.setTargetEndpointAddress(new URL(this.getEndPointAddress()));
            call.setRequestMessage(message);
            call.invoke();
            logger.info((Object)("Service flow invoked with a target end point address of " + this.endPointAddress));
        }
        catch (AxisFault axisFault) {
            logger.error((Object)("Error while invoking service " + this.getEndPointAddress() + " " + axisFault.toString()));
        }
        catch (ServiceException serviceException) {
            logger.error((Object)("Error while invoking service " + this.getEndPointAddress() + " " + serviceException.toString()));
        }
        catch (MalformedURLException malformedURLException) {
            logger.error((Object)("Error while invoking service " + this.getEndPointAddress() + " " + malformedURLException.toString()));
        }
    }

    public javax.xml.soap.SOAPEnvelope invokeWithAck(javax.xml.soap.SOAPEnvelope sOAPEnvelope) {
        SOAPEnvelope sOAPEnvelope2 = null;
        try {
            Service service = new Service();
            Call call = (Call)service.createCall();
            call.setTargetEndpointAddress(new URL(this.getEndPointAddress()));
            Message message = new Message((Object)sOAPEnvelope);
            sOAPEnvelope2 = call.invoke(message);
        }
        catch (AxisFault axisFault) {
            logger.error((Object)("Error while invoking service " + this.getEndPointAddress() + " " + axisFault.toString()));
        }
        catch (ServiceException serviceException) {
            logger.error((Object)("Error while invoking service " + this.getEndPointAddress() + " " + serviceException.toString()));
        }
        catch (MalformedURLException malformedURLException) {
            logger.error((Object)("Error while invoking service " + this.getEndPointAddress() + " " + malformedURLException.toString()));
        }
        return sOAPEnvelope2;
    }

    public void setSOAPEnvelope(javax.xml.soap.SOAPEnvelope sOAPEnvelope) {
        this.soapEnv = sOAPEnvelope;
    }

    public javax.xml.soap.SOAPEnvelope getSOAPEnvelope() {
        return this.soapEnv;
    }

    public String getEndPointAddress() {
        return this.endPointAddress.toString();
    }

    public void setEndPointAddress(String string) {
        if (string != null && string.length() > 0) {
            this.endPointAddress.append(string);
        }
    }

    public String getServiceFlowName() {
        return this.serviceFlowName.toString();
    }

    public void setServiceFlowName(String string) {
        this.serviceFlowName.append(string);
    }

    public boolean isSynchronous() {
        return this.isSynchronous;
    }

    public void setSynchronous(boolean bl) {
        this.isSynchronous = bl;
    }
}

