/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.eventManager.util;

import java.util.HashMap;
import org.eclipse.alf.eventManager.core.impl.EventAction;
import org.eclipse.alf.eventManager.core.impl.EventCondition;
import org.eclipse.alf.eventManager.core.impl.EventMatch;
import org.eclipse.alf.eventManager.core.impl.ServiceFlow;
import org.eclipse.alf.eventManager.util.EventDefaultHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EventActionMapSchemaParser
extends EventDefaultHandler {
    private HashMap eventTable;
    private int curElement;
    private EventCondition eventCondition;
    private EventMatch eventMatch;
    private EventAction eventAction;
    private ServiceFlow serviceFlow;
    private StringBuffer applicationName;
    private static final int ELEMENT_NONE = -1;
    private static final int ELEMENT_APPNAME = 1;
    private static final int ELEMENT_EVENTACTIONS = 2;
    private static final int ELEMENT_EVENTACTION = 3;
    private static final int ELEMENT_EVENTMATCH = 4;
    private static final int ELEMENT_EVENTMATCHNAME = 5;
    private static final int ELEMENT_EVENTTYPE = 6;
    private static final int ELEMENT_OBJECTTYPE = 7;
    private static final int ELEMENT_PRODUCT = 8;
    private static final int ELEMENT_PRODUCTVERS = 9;
    private static final int ELEMENT_PRODUCTINSTANCE = 10;
    private static final int ELEMENT_ACTION = 11;
    private static final int ELEMENT_SERVICEFLOW = 12;
    private static final int ELEMENT_SERVICEFLOWNAME = 13;
    private static final int ELEMENT_ENDPOINT = 14;
    private static final int ELEMENT_ASYNC_SERVICEFLOW = 15;

    public void startDocument() throws SAXException {
        this.eventTable = new HashMap();
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.curElement = -1;
        if (string2 == null || string2.length() == 0) {
            string2 = this.getLocalNameFromQualified(string3);
        }
        if (string2.equals("EventAction")) {
            this.eventCondition = new EventCondition();
        } else if (string2.equals("EventMatch")) {
            this.eventMatch = new EventMatch();
        } else if (string2.equals("EventMatchName")) {
            this.curElement = 5;
        } else if (string2.equals("EventType")) {
            this.curElement = 6;
        } else if (string2.equals("ObjectType")) {
            this.curElement = 7;
        } else if (string2.equals("Product")) {
            this.curElement = 8;
        } else if (string2.equals("ProductVersion")) {
            this.curElement = 9;
        } else if (string2.equals("ProductInstance")) {
            this.curElement = 10;
        } else if (string2.equals("Action")) {
            this.eventAction = new EventAction();
        } else if (string2.equals("ServiceFlow")) {
            this.serviceFlow = new ServiceFlow(false);
        } else if (string2.equals("SynchronousServiceFlow")) {
            this.serviceFlow = new ServiceFlow(true);
        } else if (string2.equals("ServiceFlowName")) {
            this.curElement = 13;
        } else if (string2.equals("Endpoint")) {
            this.curElement = 14;
        } else if (string2.equals("ApplicationName")) {
            this.curElement = 1;
            this.applicationName = new StringBuffer();
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.curElement = -1;
        if (string2 == null || string2.length() == 0) {
            string2 = this.getLocalNameFromQualified(string3);
        }
        if (string2.equals("ServiceFlow")) {
            this.eventAction.addServiceFlow(this.serviceFlow);
        } else if (string2.equals("Action")) {
            this.eventCondition.setEventAction(this.eventAction);
        } else if (string2.equals("EventAction")) {
            this.eventCondition.setApplicationName(this.applicationName.toString());
            int n = this.eventCondition.getHashToken();
            Integer n2 = n;
            this.eventTable.put(n2.toString(), this.eventCondition);
        } else if (string2.equals("EventMatch")) {
            this.eventCondition.setEventMatch(this.eventMatch);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.curElement > -1) {
            String string = new String(cArray, n, n2);
            if (this.curElement == 1) {
                this.applicationName.append(string);
            } else if (this.curElement == 5) {
                this.eventMatch.setEventMatchName(string);
            } else if (this.curElement == 6) {
                this.eventMatch.setEventType(string);
            } else if (this.curElement == 7) {
                this.eventMatch.setObjectType(string);
            } else if (this.curElement == 8) {
                this.eventMatch.setProduct(string);
            } else if (this.curElement == 9) {
                this.eventMatch.setProductVers(string);
            } else if (this.curElement == 10) {
                this.eventMatch.setProductInstance(string);
            } else if (this.curElement == 13) {
                this.serviceFlow.setServiceFlowName(string);
            } else if (this.curElement == 14) {
                this.serviceFlow.setEndPointAddress(string);
            }
        }
    }

    public HashMap getEventTable() {
        return this.eventTable;
    }
}

