/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.logging.impl;

import org.eclipse.alf.logging.impl.DefaultLoggerImpl;
import org.eclipse.alf.logging.inf.ILogData;
import org.eclipse.alf.logging.inf.ILogger;
import org.eclipse.alf.logging.inf.IMatchData;
import org.eclipse.alf.util.AlfUtilityManager;

public class LoggerWrapper {
    private static ILogger ALFlogger = LoggerWrapper.loadLogger();

    private LoggerWrapper() {
    }

    public static void logEvent(String string, String string2, IMatchData[] iMatchDataArray) {
        ALFlogger.logEvent(string, string2, iMatchDataArray);
    }

    public static void logStringWrapper(String string, String string2, String string3, String string4) {
        ALFlogger.logString(string, string2, string3, string4);
    }

    public static void logWithNamedTemplateWrapper(String string, String string2, String string3, ILogData[] iLogDataArray, String string4) {
        ALFlogger.logWithNamedTemplate(string, string2, string3, iLogDataArray, string4);
    }

    private static ILogger loadLogger() {
        ILogger iLogger = null;
        try {
            String string = AlfUtilityManager.getALFProperty("logger_impl_class");
            Class<?> clazz = Class.forName(string);
            iLogger = (ILogger)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            iLogger = new DefaultLoggerImpl();
        }
        catch (IllegalAccessException illegalAccessException) {
            iLogger = new DefaultLoggerImpl();
        }
        catch (InstantiationException instantiationException) {
            iLogger = new DefaultLoggerImpl();
        }
        return iLogger;
    }
}

