/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.eventemitter;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.rpc.ServiceException;
import org.apache.axis.components.uuid.SimpleUUIDGen;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.URI;
import org.eclipse.alf.eventManager.util.EventSchemaParser;
import org.eclipse.alf.eventemitter.proxy.ALFEventManagerSOAPStub;
import org.eclipse.alf.eventemitter.proxy.ALFEventManager_ServiceLocator;
import org.eclipse.alf.eventemitter.proxy.ALFEventType;
import org.eclipse.alf.eventemitter.proxy.ALFSchemaVersionType;
import org.eclipse.alf.eventemitter.proxy.BaseExtensionType;
import org.eclipse.alf.eventemitter.proxy.CredentialsType;
import org.eclipse.alf.eventemitter.proxy.CustomExtensionType;
import org.eclipse.alf.eventemitter.proxy.DetailExtensionType;
import org.eclipse.alf.eventemitter.proxy.EmBaseType;
import org.eclipse.alf.eventemitter.proxy.EmExtensionType;
import org.eclipse.alf.eventemitter.proxy.EventBaseType;
import org.eclipse.alf.eventemitter.proxy.SourceType;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EventEmitter
extends Thread {
    private String fileName;
    private String serverURL;
    private String eventType;
    private String eventID;
    private String emEventID;
    private String objectID;
    private String objectType;
    private String serviceFlowID;
    private String predecedingEmEventId;
    private String callback;
    private String eventDetailsURI;
    private HashMap eventDetailsTable = new HashMap();
    private String toolExtensionDataURI;
    private HashMap toolExtensionDataTable = new HashMap();
    private HashMap emExtensionDataTable;
    private HashMap baseExtensionDataTable;
    private HashMap userCredentialsTable = new HashMap();
    private HashMap emUserCredentialsTable = new HashMap();
    private int waitTime = 0;
    private ALFEventManagerSOAPStub binding = null;
    private ALFEventType alfEvent;
    private static final int TIMEOUT_DURATION = 180000;

    public EventEmitter() {
        this.emExtensionDataTable = new HashMap();
        this.baseExtensionDataTable = new HashMap();
    }

    public void constructEvent() throws URI.MalformedURIException {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Serializable serializable2;
        CredentialsType credentialsType = null;
        CredentialsType credentialsType2 = null;
        EventSchemaParser eventSchemaParser = new EventSchemaParser();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = null;
        try {
            sAXParser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.fileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        sAXParserFactory.setValidating(true);
        try {
            sAXParser.parse((InputStream)fileInputStream, (DefaultHandler)eventSchemaParser);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.eventType != null && this.eventType.length() > 0) {
            eventSchemaParser.setEventType(this.eventType);
        }
        if (this.eventID != null && this.eventID.length() > 0) {
            eventSchemaParser.setEventID(this.eventID);
        }
        if (this.objectID != null && this.objectID.length() > 0) {
            eventSchemaParser.setObjectID(this.objectID);
        }
        if (this.objectType != null && this.objectType.length() > 0) {
            eventSchemaParser.setObjectType(this.objectType);
        }
        try {
            serializable2 = new ALFEventManager_ServiceLocator();
            if (this.serverURL != null && this.serverURL.length() > 0) {
                ((ALFEventManager_ServiceLocator)serializable2).setALFEventManagerSOAPEndpointAddress(this.serverURL);
            }
            this.binding = (ALFEventManagerSOAPStub)((ALFEventManager_ServiceLocator)serializable2).getALFEventManagerSOAP();
        }
        catch (ServiceException serviceException) {
            serviceException.printStackTrace();
        }
        this.alfEvent = new ALFEventType();
        if (eventSchemaParser.getVersion() != null) {
            serializable2 = new ALFSchemaVersionType("1.0");
            this.alfEvent.setVersion((ALFSchemaVersionType)serializable2);
        }
        serializable2 = new EventBaseType();
        this.eventID = eventSchemaParser.getEventID();
        if (this.eventID == null || this.eventID.length() < 1) {
            object9 = new SimpleUUIDGen();
            ((EventBaseType)serializable2).setEventId(((SimpleUUIDGen)object9).nextUUID());
        } else {
            ((EventBaseType)serializable2).setEventId(this.eventID);
        }
        ((EventBaseType)serializable2).setTimestamp(Calendar.getInstance());
        ((EventBaseType)serializable2).setEventType(eventSchemaParser.getEventType());
        ((EventBaseType)serializable2).setObjectId(eventSchemaParser.getObjectID());
        ((EventBaseType)serializable2).setObjectType(eventSchemaParser.getObjectType());
        object9 = new SourceType();
        ((SourceType)object9).setProduct(eventSchemaParser.getProduct());
        String string = eventSchemaParser.getProductCallbackURI().trim();
        URI uRI = null;
        try {
            uRI = new URI(string, true);
            ((SourceType)object9).setProductCallbackURI(uRI);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((SourceType)object9).setProductInstance(eventSchemaParser.getProductInstance());
        ((SourceType)object9).setProductVersion(eventSchemaParser.getProductVersion());
        ((EventBaseType)serializable2).setSource((SourceType)object9);
        credentialsType = new CredentialsType();
        HashMap hashMap = eventSchemaParser.getCredentialsTable();
        hashMap.putAll(this.userCredentialsTable);
        int n = hashMap.size();
        if (n > 0) {
            object8 = hashMap.keySet();
            object7 = new MessageElement[n];
            object6 = object8.toArray();
            for (int i = 0; i < ((Object[])object6).length; ++i) {
                String string2 = (String)object6[i];
                object5 = new QName(string2);
                object7[i] = object4 = new MessageElement((QName)object5, hashMap.get(string2));
            }
            credentialsType.set_any((MessageElement[])object7);
        }
        ((EventBaseType)serializable2).setUser(credentialsType);
        object8 = new EmBaseType();
        ((EmBaseType)object8).setApplicationName(eventSchemaParser.getApplicationname());
        this.emEventID = eventSchemaParser.getEmEventID();
        if (this.emEventID == null || this.emEventID.length() < 1) {
            object7 = new SimpleUUIDGen();
            ((EmBaseType)object8).setEmEventId(((SimpleUUIDGen)object7).nextUUID());
        } else {
            ((EmBaseType)object8).setEmEventId(this.emEventID);
        }
        ((EmBaseType)object8).setEmTimestamp(Calendar.getInstance());
        credentialsType2 = new CredentialsType();
        hashMap = eventSchemaParser.getEmCredentialsTable();
        hashMap.putAll(this.emUserCredentialsTable);
        n = hashMap.size();
        if (n > 0) {
            object7 = hashMap.keySet();
            object6 = new MessageElement[n];
            Object[] objectArray = object7.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                object5 = (String)objectArray[i];
                object4 = new QName((String)object5);
                object6[i] = object3 = new MessageElement((QName)object4, hashMap.get(object5));
            }
            credentialsType2.set_any((MessageElement[])object6);
        }
        ((EmBaseType)object8).setEmUser(credentialsType2);
        ((EmBaseType)object8).setEnvironment(eventSchemaParser.getEnvironment());
        this.predecedingEmEventId = eventSchemaParser.getPredecedingEvent();
        if (this.predecedingEmEventId == null || this.predecedingEmEventId.length() < 1) {
            object7 = new SimpleUUIDGen();
            ((EmBaseType)object8).setPredecedingEmEventId(((SimpleUUIDGen)object7).nextUUID());
        } else {
            ((EmBaseType)object8).setPredecedingEmEventId(this.predecedingEmEventId);
        }
        this.serviceFlowID = eventSchemaParser.getServiceFlowId();
        if (this.serviceFlowID == null || this.serviceFlowID.length() < 1) {
            object7 = new SimpleUUIDGen();
            ((EmBaseType)object8).setServiceFlowId(((SimpleUUIDGen)object7).nextUUID());
        } else {
            ((EmBaseType)object8).setServiceFlowId(this.serviceFlowID);
        }
        this.callback = eventSchemaParser.getCallback();
        if (this.callback == null || this.callback.length() < 1) {
            ((EmBaseType)object8).setCallback(false);
        } else if (this.callback.equals("true") || this.callback.equals("1")) {
            ((EmBaseType)object8).setCallback(true);
        } else if (this.callback.equals("false") || this.callback.equals("0")) {
            ((EmBaseType)object8).setCallback(false);
        } else {
            ((EmBaseType)object8).setCallback(false);
        }
        object7 = new EmExtensionType();
        hashMap = eventSchemaParser.getEmExtensionDataTable();
        hashMap.putAll(this.emExtensionDataTable);
        n = hashMap.size();
        if (n > 0) {
            object6 = hashMap.keySet();
            MessageElement[] messageElementArray = new MessageElement[n];
            Object[] objectArray = object6.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                object4 = (String)objectArray[i];
                object3 = new QName((String)object4);
                object2 = new MessageElement((QName)object3, hashMap.get(object4));
                messageElementArray[i] = object2;
            }
            ((EmExtensionType)object7).set_any(messageElementArray);
        }
        ((EmBaseType)object8).setEmExtension((EmExtensionType)object7);
        this.callback = eventSchemaParser.getCallback();
        if (this.callback == null || this.callback.length() < 1) {
            ((EmBaseType)object8).setCallback(false);
        } else if (this.callback.equals("true") || this.callback.equals("1")) {
            ((EmBaseType)object8).setCallback(true);
        } else if (this.callback.equals("false") || this.callback.equals("0")) {
            ((EmBaseType)object8).setCallback(false);
        } else {
            ((EmBaseType)object8).setCallback(false);
        }
        ((EmBaseType)object8).setServiceFlowName("");
        ((EmBaseType)object8).setEventMatchName("");
        ((EventBaseType)serializable2).setEventControl((EmBaseType)object8);
        object6 = new BaseExtensionType();
        hashMap = eventSchemaParser.getBaseExtensionDataTable();
        hashMap.putAll(this.baseExtensionDataTable);
        n = hashMap.size();
        if (n > 0) {
            Set set = hashMap.keySet();
            MessageElement[] messageElementArray = new MessageElement[n];
            Object[] objectArray = set.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                object3 = (String)objectArray[i];
                object2 = new QName((String)object3);
                object = new MessageElement((QName)object2, hashMap.get(object3));
                messageElementArray[i] = object;
            }
            ((BaseExtensionType)object6).set_any(messageElementArray);
        }
        ((EventBaseType)serializable2).setBaseExtension((BaseExtensionType)object6);
        this.alfEvent.setBase((EventBaseType)serializable2);
        DetailExtensionType detailExtensionType = new DetailExtensionType();
        hashMap = eventSchemaParser.getEventDetailsTable();
        hashMap.putAll(this.eventDetailsTable);
        n = hashMap.size();
        if (n > 0) {
            Set set = hashMap.keySet();
            MessageElement[] messageElementArray = new MessageElement[n];
            Object[] objectArray = set.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                object2 = (String)objectArray[i];
                object = new QName((String)object2);
                messageElementArray[i] = serializable = new MessageElement((QName)object, hashMap.get(object2));
            }
            if (this.eventDetailsURI == null || this.eventDetailsURI.length() < 1) {
                this.eventDetailsURI = eventSchemaParser.getEventDetailsURI();
            }
            if (this.eventDetailsURI != null && this.eventDetailsURI.length() > 0) {
                URI uRI2 = new URI(this.eventDetailsURI);
            }
            detailExtensionType.set_any(messageElementArray);
        }
        this.alfEvent.setDetail(detailExtensionType);
        CustomExtensionType customExtensionType = new CustomExtensionType();
        hashMap = eventSchemaParser.getToolExtensionDataTable();
        hashMap.putAll(this.toolExtensionDataTable);
        n = hashMap.size();
        if (n > 0) {
            Set set = hashMap.keySet();
            MessageElement[] messageElementArray = new MessageElement[n];
            Object[] objectArray = set.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                MessageElement messageElement;
                object = (String)objectArray[i];
                serializable = new QName((String)object);
                messageElementArray[i] = messageElement = new MessageElement((QName)serializable, hashMap.get(object));
            }
            customExtensionType.set_any(messageElementArray);
        }
        this.alfEvent.setExtension(customExtensionType);
    }

    public synchronized void run() {
        try {
            if (this.waitTime > 0) {
                EventEmitter.sleep(this.waitTime * 1000);
            }
            this.raiseEvent();
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException.toString());
        }
    }

    public synchronized void raiseEvent() {
        this.binding.setTimeout(180000);
        try {
            StringBuffer stringBuffer = new StringBuffer();
            System.out.println(" ");
            System.out.println("*******************************  ");
            stringBuffer.append("Event Raised for : ");
            stringBuffer.append("\n\n");
            stringBuffer.append("Event Type: " + this.alfEvent.getBase().getEventType() + "\n");
            stringBuffer.append("Event ID: " + this.alfEvent.getBase().getEventId() + "\n");
            stringBuffer.append("Timestamp: " + this.alfEvent.getBase().getTimestamp().getTime().toString() + "\n");
            stringBuffer.append("Object Type: " + this.alfEvent.getBase().getObjectType() + "\n");
            stringBuffer.append("Object ID: " + this.alfEvent.getBase().getObjectId() + "\n");
            stringBuffer.append("ApplicationName :" + this.alfEvent.getBase().getEventControl().getApplicationName() + "\n");
            stringBuffer.append("Product: " + this.alfEvent.getBase().getSource().getProduct() + "\n");
            stringBuffer.append("Version: " + this.alfEvent.getBase().getSource().getProductVersion() + "\n");
            stringBuffer.append("Instance: " + this.alfEvent.getBase().getSource().getProductInstance() + "\n");
            System.out.println(stringBuffer.toString());
            System.out.println(" ");
            System.out.println("*******************************  ");
            this.binding.eventNotice(this.alfEvent);
            System.out.println("Event emitted Successfully");
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void setWaitTime(int n) {
        this.waitTime = n;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setServerURL(String string) {
        this.serverURL = string;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setEventType(String string) {
        this.eventType = string;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventID(String string) {
        this.eventID = string;
    }

    public String getEventID() {
        return this.eventID;
    }

    public void setEventDetailsURI(String string) {
        this.eventDetailsURI = string;
    }

    public String getEventDetailsURI() {
        return this.eventDetailsURI;
    }

    public void setEventDetails(String string, String string2) {
        this.eventDetailsTable.put(string, string2);
    }

    public void setToolExtensionDataURI(String string) {
        this.toolExtensionDataURI = string;
    }

    public String getToolExtensionDataURI() {
        return this.toolExtensionDataURI;
    }

    public void setToolExtensionData(String string, String string2) {
        this.toolExtensionDataTable.put(string, string2);
    }

    public String getObjectID() {
        return this.objectID;
    }

    public void setObjectID(String string) {
        this.objectID = string;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String string) {
        this.objectType = string;
    }
}

