/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.http.cookie.CookieData;
import org.eclipse.alf.security.sso.common.http.cookie.CookieHTTPHelper;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.token.SSOTokenFactory;
import org.eclipse.alf.security.sso.common.token.SSOTokenPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.RSTCallProxy;
import org.eclipse.alf.security.sso.common.ws.model.addressing.element.Address;
import org.eclipse.alf.security.sso.common.ws.model.addressing.element.EndpointReference;
import org.eclipse.alf.security.sso.common.ws.model.policy.element.AppliesTo;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityToken;
import org.eclipse.alf.security.sso.server.federationserver.LogonContext;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvConfig;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvRPConfig;

public class FedSrvHelper {
    private static Logger log = Logger.getLogger(FedSrvHelper.class);
    private static CoreConfig coreconf = FedSrvConfig.getInstance().getRPConfig("uri:org:eclipse:alf:sso:relyingparty:anonymous:anonymous:anonymous").getCoreConfig();
    private static FedSrvRPConfig conf = FedSrvConfig.getInstance().getRPConfig("uri:org:eclipse:alf:sso:relyingparty:anonymous:anonymous:anonymous");

    public static RSTCallProxy getCallProxy() {
        String axis2repo = coreconf.getParameter("axis2repo", "${APPROOT_DIR}/WEB-INF");
        String axis2xml = coreconf.getParameter("axis2xml", "${CONFIG_DIR}/axis2.xml");
        if (log.isDebugEnabled()) {
            log.debug((Object)("axis2repo=\"" + axis2repo + "\""));
            log.debug((Object)("axis2xml=\"" + axis2xml + "\""));
        }
        try {
            RSTCallProxy stsClient = new RSTCallProxy(axis2repo, axis2xml);
            return stsClient;
        }
        catch (SSOException e) {
            log.error((Object)"FedSrvHelper.getCallProxy. Error initializing call proxy", (Throwable)e);
            return null;
        }
    }

    public static CookieData extractALFSSOCookieData(HttpServletRequest req, String rpType, String rpRealm, ArrayList cookieObjects) {
        CookieData cookieData = null;
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            log.debug((Object)"Cookies were found.");
            String remoteUserIP = req.getRemoteAddr();
            try {
                cookieData = coreconf.getCookieManager().getBindCookiesToUserIP() ? coreconf.getCookieManager().getCookie(cookies, rpType, rpRealm, remoteUserIP, cookieObjects) : coreconf.getCookieManager().getCookie(cookies, rpType, rpRealm, null, cookieObjects);
            }
            catch (SSOException e) {
                log.debug((Object)("Error while finding cookie for:" + rpType + ":" + rpRealm));
                return null;
            }
        }
        if (cookieData != null) {
            SSOToken token = cookieData.getToken();
            SAML1Policy tokenProfilePolicy = conf.getTokenPolicy();
            token.setValidationPolicy((SSOTokenPolicy)tokenProfilePolicy);
        }
        return cookieData;
    }

    public static SSOToken extractTokenFromHTTPHeader(HttpServletRequest req) {
        SSOToken token;
        block6: {
            String tokenString = null;
            token = null;
            if (req.getHeader("ALFSSOAuthNToken") != null) {
                tokenString = req.getHeader("ALFSSOAuthNToken");
            }
            if (StringHelper.isNotBlank(tokenString)) {
                tokenString = tokenString.trim();
                try {
                    token = SSOTokenFactory.createSSOToken((String)tokenString);
                    if (token == null) {
                        log.debug((Object)"Error creating SSO token object from header content");
                        break block6;
                    }
                    token.setValidationPolicy((SSOTokenPolicy)conf.getTokenPolicy());
                }
                catch (SSOException e) {
                    log.info((Object)"Error processing security token", (Throwable)e);
                }
            } else {
                log.warn((Object)"ALF SSO header found on request but no content in it");
            }
        }
        return token;
    }

    public static String extractAppliesToStringFromRST(RequestSecurityToken rst) {
        String retVal = null;
        if (rst == null) {
            return null;
        }
        AppliesTo appliesToObj = rst.getAppliesTo();
        if (appliesToObj != null) {
            List knownObjList = appliesToObj.getKnownObjectsList();
            if (knownObjList != null && knownObjList.size() == 1) {
                EndpointReference eprObj = null;
                Address addr = null;
                if (knownObjList.get(0) instanceof EndpointReference) {
                    eprObj = (EndpointReference)knownObjList.get(0);
                    if (eprObj != null) {
                        addr = eprObj.getAddress();
                    }
                } else if (knownObjList.get(0) instanceof Address) {
                    addr = (Address)knownObjList.get(0);
                }
                if (addr != null) {
                    retVal = addr.getAddress();
                }
            }
        } else if (rst.getCancelTarget() != null && rst.getCancelTarget().getSecurityToken() != null) {
            try {
                SSOToken token = SSOTokenFactory.createSSOToken((Object)rst.getCancelTarget().getSecurityToken().getNativeObject());
                String[] tokenTargetRelyingParties = token.getTargetRelyingParties();
                retVal = tokenTargetRelyingParties.length == 0 ? null : tokenTargetRelyingParties[0];
            }
            catch (SSOException sSOException) {
                // empty catch block
            }
        }
        return retVal;
    }

    public static void extractSSOTokenFromCookies(HttpServletRequest req, HttpServletResponse resp, LogonContext logonContext) {
        boolean cookieTokenQueried = false;
        cookieTokenQueried = logonContext == null ? true : logonContext.getCookieTokenQueried();
        if (!cookieTokenQueried) {
            CookieData cookieData;
            ArrayList cookiesToClear = new ArrayList();
            String rpType = "anonymous";
            String rpRealm = "anonymous";
            if (logonContext.getRSTObject() != null) {
                String appliesTo = FedSrvHelper.extractAppliesToStringFromRST(logonContext.getRSTObject());
                log.debug((Object)("appliesTo = " + appliesTo));
                if (StringHelper.isNotBlank((String)appliesTo)) {
                    RPURI rpURI = null;
                    try {
                        rpURI = new RPURI(appliesTo);
                    }
                    catch (SSOException e) {
                        log.error((Object)("Invalid appliesTo in RST: " + appliesTo));
                    }
                    if (rpURI != null) {
                        CookieData workData = new CookieData(rpURI.getType(), rpURI.getRealm(), rpURI.getInstance(), null, null);
                        if (workData != null) {
                            if (StringHelper.isNotBlank((String)workData.getRPURI().getType())) {
                                rpType = workData.getRPURI().getType();
                            }
                            if (StringHelper.isNotBlank((String)workData.getRPURI().getRealm())) {
                                rpRealm = workData.getRPURI().getRealm();
                            }
                            log.debug((Object)(" rpType=" + rpType + " rpRealm" + rpRealm));
                        }
                        logonContext.setAppliesToURI(appliesTo);
                    }
                }
            }
            if ((cookieData = FedSrvHelper.extractALFSSOCookieData(req, rpType, rpRealm, cookiesToClear)) != null) {
                SSOToken token = cookieData.getToken();
                ExtendedResult validationResult = token.validateToken();
                if (validationResult.isSuccess()) {
                    logonContext.setCookieData(cookieData);
                } else {
                    if (validationResult.getCode() == 10) {
                        logonContext.setCookieData(cookieData);
                    }
                    CookieHTTPHelper.deleteCookies((HttpServletResponse)resp, cookiesToClear);
                }
            }
            logonContext.setCookieTokenQueried(true);
        }
    }
}

