/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.util.FileIOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvConfig;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvRPConfig;
import org.eclipse.alf.security.sso.server.federationserver.config.builder.FedSrvConfigBuilder;
import org.eclipse.alf.security.sso.server.federationserver.handler.FedSrvRequestHandler;

public class FedSrvServlet
extends HttpServlet {
    static final Logger log = Logger.getLogger(FedSrvServlet.class);
    private boolean isDebugEnabled = log.isDebugEnabled();
    private static final long serialVersionUID = -391484377137870342L;

    public void init(ServletConfig servletConfig) throws ServletException {
        File f;
        String newssoConfigDir;
        File d;
        String servletBasePath = FileIOHelper.normalizePath((String)(servletConfig.getServletContext().getRealPath("") + "/"));
        if (StringHelper.isBlank((String)servletBasePath)) {
            log.warn((Object)"ServletConfig.getServletContext().getRealPath() failed to return the real path. Trying servlet init params");
            servletBasePath = servletConfig.getServletContext().getInitParameter("ROOT_PATH");
        }
        if (StringHelper.isBlank((String)servletBasePath)) {
            log.fatal((Object)"Failed to resolve root real path - neither the servlet container returned it or the context params have it");
            throw new ServletException("Failed to resolve servlet real path");
        }
        File filterBasePathFile = new File(servletBasePath);
        if (!filterBasePathFile.isDirectory()) {
            log.error((Object)("Filter root real path: \"" + servletBasePath + "\" does not exist"));
            throw new ServletException("Failed to resolve root path");
        }
        log.debug((Object)("Federation server: using filter base path: \"" + servletBasePath + "\""));
        String ssoConfigDir = System.getProperty("org.eclipse.alf.security.sso.server.fedsrv.conf-dir");
        if (StringHelper.isBlank((String)ssoConfigDir)) {
            ssoConfigDir = servletConfig.getInitParameter("LogonUIConfigDir");
        }
        if (StringHelper.isBlank((String)ssoConfigDir)) {
            ssoConfigDir = servletBasePath;
        }
        if (!(d = new File(ssoConfigDir)).isDirectory() && !(d = new File(newssoConfigDir = FileIOHelper.normalizePath((String)(servletBasePath + "/" + ssoConfigDir)))).isDirectory()) {
            String errorMessage = "Failed to load configuration settings. Tried both \"" + ssoConfigDir + "\" and \"" + newssoConfigDir + "\"";
            log.fatal((Object)errorMessage);
            throw new ServletException(errorMessage);
        }
        ssoConfigDir = FileIOHelper.normalizePath((String)(d.getAbsolutePath() + "/"));
        log.debug((Object)("Federation server: using configuration base path: \"" + ssoConfigDir + "\""));
        String ssoConfigName = System.getProperty("org.eclipse.alf.security.sso.server.fedsrv.conf-name");
        if (StringHelper.isBlank((String)ssoConfigName)) {
            ssoConfigName = servletConfig.getInitParameter("LogonUIConfigName");
        }
        if (StringHelper.isBlank((String)ssoConfigName)) {
            ssoConfigName = "fedsvr-services-config.xml";
        }
        if ((f = new File(FileIOHelper.normalizePath((String)ssoConfigName))).isFile()) {
            ssoConfigDir = FileIOHelper.normalizePath((String)(f.getParent() + "/"));
            ssoConfigName = f.getName();
        } else {
            f = new File(FileIOHelper.normalizePath((String)(ssoConfigDir + "/" + ssoConfigName)));
            if (f.isFile()) {
                ssoConfigDir = FileIOHelper.normalizePath((String)(f.getParent() + "/"));
                ssoConfigName = f.getName();
            } else {
                String fullpath = FileIOHelper.normalizePath((String)(ssoConfigDir + "/" + ssoConfigName));
                String errorMessage = "Federation server: Failed to find configuration in \"" + fullpath + "\"";
                log.fatal((Object)errorMessage);
                throw new ServletException(errorMessage);
            }
        }
        FedSrvConfigBuilder configBuilder = new FedSrvConfigBuilder(ssoConfigDir);
        FedSrvConfig config = null;
        try {
            config = configBuilder.build(ssoConfigName);
        }
        catch (Exception e) {
            String fullpath = FileIOHelper.normalizePath((String)(ssoConfigDir + "/" + ssoConfigName));
            String errorMessage = "Federation server: Failed to load configuration from \"" + fullpath + "\"";
            log.fatal((Object)errorMessage);
            throw new ServletException(errorMessage, (Throwable)e);
        }
        if (config == null) {
            String fullpath = FileIOHelper.normalizePath((String)(ssoConfigDir + "/" + ssoConfigName));
            String errorMessage = "Federation server: Failed to load configuration from \"" + fullpath + "\"";
            log.fatal((Object)errorMessage);
            throw new ServletException(errorMessage);
        }
        Iterator it = config.getRPConfigIterartor();
        if (it != null) {
            while (it.hasNext()) {
                FedSrvRPConfig rpConfig = (FedSrvRPConfig)it.next();
                rpConfig.getCoreConfig().setProperty("ApplicationRootAbsolutePath", servletBasePath);
                rpConfig.getCoreConfig().setProperty("ConfigBaseAbsolutePath", ssoConfigDir);
                rpConfig.getCoreConfig().registerSubstitutionVariable("${APPROOT_DIR}", servletBasePath);
                rpConfig.getCoreConfig().registerSubstitutionVariable("${CONFIG_DIR}", ssoConfigDir);
                rpConfig.getCoreConfig().expandSubstitutionVariables();
            }
        }
        FedSrvConfig.setInstance(config);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        if (this.isDebugEnabled) {
            log.debug((Object)"FedSrvServlet.doGet  Handling a GET request");
        }
        FedSrvRequestHandler requestHandler = new FedSrvRequestHandler();
        try {
            requestHandler.processRequest(req, resp);
        }
        catch (ServletException e) {
            log.error((Object)"Unhandled exception in FedSrv servlet", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            log.fatal((Object)"Unhandled exception in FedSrv servlet", e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.isDebugEnabled) {
            log.debug((Object)"FedSrvServlet.doPost  Handling a POST request");
        }
        FedSrvRequestHandler requestHandler = new FedSrvRequestHandler();
        try {
            requestHandler.processRequest(req, resp);
        }
        catch (ServletException e) {
            log.error((Object)"Unhandled exception in FedSrv servlet", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            log.fatal((Object)"Unhandled exception in FedSrv servlet", e);
        }
    }
}

