/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.handler;

import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.token.SSOTokenHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedHelper;
import org.eclipse.alf.security.sso.common.ws.model.WSAbstractFactory;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SignedSecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustObjectFactory;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityTokenResponse;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestedTokenCancelled;
import org.eclipse.alf.security.sso.server.federationserver.LogonContext;
import org.eclipse.alf.security.sso.server.federationserver.PageRedirector;
import org.eclipse.alf.security.sso.server.federationserver.ProcessingException;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvConfig;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvRPConfig;
import org.eclipse.alf.security.sso.server.federationserver.handler.AbstractRequestHandler;
import org.eclipse.alf.security.sso.server.federationserver.processor.CancelRequestProcessor;
import org.eclipse.alf.security.sso.server.federationserver.processor.RequestProcessorResult;

public class FedSrvCancelRequestHandler
implements AbstractRequestHandler {
    static final Logger log = Logger.getLogger(FedSrvCancelRequestHandler.class);

    public void handle(HttpServletRequest req, HttpServletResponse resp, LogonContext logonContext, RequestSecurityToken rst, OMElement payloadElement) throws ServletException {
        FedSrvRPConfig rpConfig;
        if (logonContext.getCookieData() != null) {
            SignedSecurityToken securityToken = rst.getCancelTarget().getSecurityToken();
            if (securityToken == null) {
                PageRedirector redirector = new PageRedirector(FedSrvConfig.getInstance().getRPConfig("uri:org:eclipse:alf:sso:relyingparty:anonymous:anonymous:anonymous"));
                redirector.redirectAppError(req, resp, "Unsuppored RST - incompatible profile - missing security token in <wst:CancelTarget>:[" + payloadElement.toString() + "]");
                return;
            }
            SSOToken ssotoken = null;
            try {
                ssotoken = SSOTokenHelper.convertSecurityTokenToSSOToken((SecurityToken)securityToken);
            }
            catch (SSOException e) {
                log.error((Object)"Error converting SecurityToken into SSOToken", (Throwable)e);
                PageRedirector redirector = new PageRedirector(FedSrvConfig.getInstance().getRPConfig("uri:org:eclipse:alf:sso:relyingparty:anonymous:anonymous:anonymous"));
                redirector.redirectAppError(req, resp, "Error converting SecurityToken into SSOToken");
                return;
            }
            if (ssotoken.compareTo(logonContext.getCookieData().getToken())) {
                WSTrustObjectFactory fac = WSAbstractFactory.getWSTObjectFactory();
                RequestSecurityTokenResponse rstr = fac.createRequestSecurityTokenResponse();
                RequestedTokenCancelled cancelConfirmation = fac.createRequestedTokenCancelled();
                rstr.setRequestedTokenCancelled(cancelConfirmation);
                logonContext.rstr = rstr;
            }
        }
        if ((rpConfig = FedSrvConfig.getInstance().getRPConfig(logonContext.getAppliesToURI())) == null) {
            rpConfig = FedSrvConfig.getInstance().getRPConfig("uri:org:eclipse:alf:sso:relyingparty:anonymous:anonymous:anonymous");
        }
        PageRedirector redirector = new PageRedirector(rpConfig);
        CancelRequestProcessor cancelProcessor = new CancelRequestProcessor();
        RequestProcessorResult result = null;
        try {
            result = cancelProcessor.process(req, resp, logonContext);
        }
        catch (ProcessingException e) {
            log.error((Object)"Cancel Request failed", (Throwable)((Object)e));
            redirector.redirectAppError(req, resp, "Logout request failed: " + e.getMessage());
            return;
        }
        if (!result.isSuccess()) {
            log.error((Object)("Error processing issue request: " + result.getMessage()));
            redirector.redirectAppError(req, resp, "Error processing issue request: " + result.getMessage());
            return;
        }
        resp.addCookie(new Cookie("ALF1", null));
        WSFedHelper.putWSFDataResponseAsAttributes((HttpServletRequest)req, (WSFedData)result.getWsfData());
        redirector.redrectBack(req, resp, result.getWsfData());
    }
}

