/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.processor;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.AxisFault;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.http.configuration.PrincipalEndorsmentConfig;
import org.eclipse.alf.security.sso.common.http.cookie.CookieData;
import org.eclipse.alf.security.sso.common.http.cookie.CookieHTTPHelper;
import org.eclipse.alf.security.sso.common.http.cookie.CookieManager;
import org.eclipse.alf.security.sso.common.http.cookie.MasterCookieData;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.token.SSOTokenFactory;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.remotedata.RemoteDataStorage;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.RSTCallProxy;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.secctx.SecurityContext;
import org.eclipse.alf.security.sso.common.ws.message.trust.RSTRequest;
import org.eclipse.alf.security.sso.common.ws.message.trust.issue.RSTIssueRequest;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityTokenResponse;
import org.eclipse.alf.security.sso.server.federationserver.FedSrvHelper;
import org.eclipse.alf.security.sso.server.federationserver.LogonContext;
import org.eclipse.alf.security.sso.server.federationserver.ProcessingException;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvConfig;
import org.eclipse.alf.security.sso.server.federationserver.processor.AbstractRequestProcessor;
import org.eclipse.alf.security.sso.server.federationserver.processor.RequestProcessorResult;
import org.eclipse.alf.security.sso.server.federationserver.secctx.SecCtxLogonAppToSTS;
import org.eclipse.alf.security.sso.server.federationserver.secctx.SecCtxLogonAppToSTSWithUsername;

public class IssueRequestProcessor
extends AbstractRequestProcessor {
    static final Logger log = Logger.getLogger(IssueRequestProcessor.class);
    private static CoreConfig coreconf = FedSrvConfig.getInstance().getRPConfig("uri:org:eclipse:alf:sso:relyingparty:anonymous:anonymous:anonymous").getCoreConfig();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RequestProcessorResult process(HttpServletRequest req, HttpServletResponse resp, LogonContext logonContext) throws ProcessingException {
        RequestProcessorResult retVal = new RequestProcessorResult();
        RequestSecurityTokenResponse rstr = null;
        RSTCallProxy callProxy = FedSrvHelper.getCallProxy();
        if (callProxy == null) {
            retVal.setCode(2);
            retVal.setMessage("Failed to create SOAP call proxy");
            return retVal;
        }
        RSTIssueRequest request = new RSTIssueRequest();
        request.setSSOTokenType("http://www.eclipse.org/ALF/1.0/claims/TicketType#TGT");
        request.setEpr(coreconf.getParameter("SecurityTokenService"));
        request.setRawRST(logonContext.getRSTElement());
        super.processJSSEEnablement(coreconf);
        try {
            SecurityContext securityContext;
            if (logonContext.getAuthCredentialsInRST()) {
                if (logonContext.getPrincipalPassword() != null) {
                    log.debug((Object)"Token issueance: Full principal credentials in RST");
                    securityContext = new SecCtxLogonAppToSTS();
                    request.setSecurityContext(securityContext);
                    log.debug((Object)"====> Before sending WS-Trust RST to STS. Full authentication credentials are with the RST.");
                    rstr = callProxy.invoke((RSTRequest)request);
                    log.debug((Object)"<==== After receiving WS-Trust RSTR or Fault back from STS.");
                } else {
                    log.debug((Object)"Token issueance: partial principal credentials in RST");
                    PrincipalEndorsmentConfig endorsmentConfig = coreconf.getPrincipalEndorsmentConfig();
                    if (endorsmentConfig == null) throw new SSOException("Incomplete credentials and endorsment method has not been properly set");
                    if (endorsmentConfig.getType() == 1) {
                        if (StringHelper.isBlank((String)endorsmentConfig.getUsername())) {
                            log.error((Object)"Undefined endorsing user when endorsing method is set to UsernameToken");
                            retVal.setCode(4);
                            retVal.setMessage("Insufficent endorsing credentials");
                            return retVal;
                        }
                        securityContext = new SecCtxLogonAppToSTSWithUsername();
                        securityContext.setOfcUsername(endorsmentConfig.getUsername());
                        securityContext.setOfcPassword(endorsmentConfig.getPassword());
                    } else {
                        if (endorsmentConfig.getType() != 2) throw new SSOException("Incomplete credentials and endorsment method has not been properly set");
                        securityContext = new SecCtxLogonAppToSTS();
                    }
                    request.setSecurityContext(securityContext);
                    log.debug((Object)"====> Before sending WS-Trust RST to STS - NTLM or similar flavor.");
                    rstr = callProxy.invoke((RSTRequest)request);
                    log.debug((Object)"<==== After receiving WS-Trust RSTR or Fault back from STS.");
                }
            } else {
                log.debug((Object)"Case is: Full authentication credentials supplied by logon page.");
                securityContext = new SecCtxLogonAppToSTSWithUsername();
                securityContext.setOfcUsername(logonContext.getPrincipalUsername());
                securityContext.setOfcPassword(logonContext.getPrincipalPassword());
                request.setSecurityContext(securityContext);
                log.debug((Object)"====> Before sending WS-Trust RST to STS using credentials from logon page.");
                rstr = callProxy.invoke((RSTRequest)request);
                log.debug((Object)"<==== After receiving WS-Trust RSTR or Fault back from STS.");
            }
        }
        catch (AxisFault e) {
            log.error((Object)"Axis fault caught while issuing a SOAP call to STS.", (Throwable)e);
            retVal.setCode(1);
            retVal.setMessage(e.getMessage() + " : " + e.getDetail());
            return retVal;
        }
        catch (SSOException e) {
            log.error((Object)"SSO exception while issuing a SOAP call to STS.", (Throwable)e);
            retVal.setCode(2);
            retVal.setMessage(e.getMessage());
            return retVal;
        }
        String wresult = rstr.toString();
        log.debug((Object)("wresult = " + wresult));
        boolean forceRemoteData = coreconf.getBooleanParameter("ForceRemoteDataInWSFederation", false);
        if (forceRemoteData) {
            logonContext.getWSFedData().setWresult(wresult);
            long remoteDataTTL = coreconf.getLongParameter("RemoteDataTTL", 60L);
            String remoteDataURI = coreconf.getParameter("RemoteDataServerEPR", "");
            RemoteDataStorage rd = RemoteDataStorage.getInstance();
            String rdKey = rd.addData((Object)logonContext.getWSFedData().getWresult(), remoteDataTTL);
            String remoteDataURL = req.getRequestURL().toString();
            if (StringHelper.isNotBlank((String)remoteDataURI)) {
                if (remoteDataURI.charAt(0) != '/') {
                    remoteDataURI = remoteDataURI + "/" + remoteDataURI;
                }
                String requestURL = req.getRequestURL().toString();
                String requestURI = req.getRequestURI();
                if (requestURI.substring(1).indexOf(47) > 0) {
                    int to = requestURI.substring(1).indexOf(47);
                    String appname = requestURI.substring(0, to + 1);
                    remoteDataURI = appname + remoteDataURI;
                } else {
                    String appname = requestURI;
                    remoteDataURI = appname + remoteDataURI;
                }
                remoteDataURL = StringHelper.simpleStringReplace((String)requestURL, (String)requestURI, (String)remoteDataURI);
            }
            remoteDataURL = coreconf.getRemoteDataURL(remoteDataURL, req.getServerPort());
            logonContext.setWSFedData(WSFedHelper.convertWresultToWresultptr((String)remoteDataURL, (String)rdKey, (WSFedData)logonContext.getWSFedData()));
        } else {
            wresult = XMLHelper.escapeXMLString((String)wresult);
            logonContext.getWSFedData().setWresult(wresult);
        }
        try {
            CookieManager cookieManager = coreconf.getCookieManager();
            String remoteUserIP = cookieManager.getBindCookiesToUserIP() ? req.getRemoteAddr() : null;
            SSOToken token = SSOTokenFactory.createSSOToken((SecurityToken)rstr.getRequestedSecurityToken().getSecurityToken());
            MasterCookieData masterCookieData = new MasterCookieData(logonContext.getAppliesToURI(), token, remoteUserIP);
            ArrayList cookies = cookieManager.createCookie((CookieData)masterCookieData);
            CookieHTTPHelper.addCokiesToResponse((HttpServletResponse)resp, (ArrayList)cookies);
        }
        catch (SSOException e) {
            log.error((Object)"IssueRequestProcessor.process. Error creating security token");
            retVal.setCode(2);
            retVal.setMessage(e.getMessage());
            return retVal;
        }
        retVal.setWsfData(logonContext.getWSFedData());
        return retVal;
    }

    public static WSFedData getTrustParams(HttpServletRequest req) {
        return WSFedHelper.extractWSFDataFromRequest((HttpServletRequest)req);
    }
}

