/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.config;

import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvRPConfig;
import org.opensaml.SAMLConfig;

public class FedSrvConfig {
    public static final String DEFAULT_CONFIG_FILENAME = "fedsvr-services-config.xml";
    public static final String PROPNAME_ROOT_PATH = "ROOT_PATH";
    public static final String PROPNAME_CFG_DIR = "LogonUIConfigDir";
    public static final String PROPNAME_CFG_NAME = "LogonUIConfigName";
    public static final String SYSPROP_CFG_DIR = "org.eclipse.alf.security.sso.server.fedsrv.conf-dir";
    public static final String SYSPROP_CFG_NAME = "org.eclipse.alf.security.sso.server.fedsrv.conf-name";
    protected Hashtable rpConfigs;

    public FedSrvConfig() {
        this.reset();
        SAMLConfig.instance();
    }

    public void reset() {
        this.rpConfigs = new Hashtable();
    }

    public static synchronized FedSrvConfig getInstance() {
        return LogonUIConfigHolder.instance;
    }

    public static synchronized void setInstance(FedSrvConfig newInstance) {
        LogonUIConfigHolder.instance = newInstance;
    }

    public void addRPConfig(String rpuri, FedSrvRPConfig rpConfig) {
        this.rpConfigs.put(rpuri, rpConfig);
    }

    public FedSrvRPConfig getRPConfig(String rpuri) {
        if (rpuri == null) {
            return null;
        }
        return (FedSrvRPConfig)this.rpConfigs.get(rpuri);
    }

    public Iterator getRPConfigIterartor() {
        return this.rpConfigs.values().iterator();
    }

    private static class LogonUIConfigHolder {
        private static FedSrvConfig instance = new FedSrvConfig();

        private LogonUIConfigHolder() {
        }
    }
}

